/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class LanguageEncodingInfo {
    private String countryCode = "us";
    private String languageCode = "en";
    private String encoding = "ISO-8859-1";
    private static final Map<String, String> countryCodeToLanguageCode = Maps.newHashMap();
    private static final Map<String, String> languageCodeToEncoding = Maps.newHashMap();

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setLanguageFromCountry() {
        this.languageCode = countryCodeToLanguageCode.get(this.countryCode);
    }

    public void setEncodingFromLanguage() {
        this.encoding = languageCodeToEncoding.get(this.languageCode);
    }

    private static boolean is_between(int x, int min, int max) {
        return x >= min & x <= max;
    }

    public static String guessCJKLanguageFromUTF8Text(String UTF8_text_string) {
        return LanguageEncodingInfo.guessLanguageFromUTF8Text(UTF8_text_string, false);
    }

    public static String guessLanguageFromUTF8Text(String UTF8_text_string) {
        return LanguageEncodingInfo.guessLanguageFromUTF8Text(UTF8_text_string, true);
    }

    public static String guessLanguageFromUTF8Bytes(byte[] UTF8_bytes) {
        if (null == UTF8_bytes) {
            return "";
        }
        return LanguageEncodingInfo.guessLanguageFromUTF8Bytes(UTF8_bytes, true);
    }

    private static String guessLanguageFromUTF8Text(String text, boolean detectNonCjk) {
        if (null == text) {
            return "";
        }
        return LanguageEncodingInfo.guessLanguageFromUTF8Bytes(text.getBytes(StandardCharsets.UTF_8), detectNonCjk);
    }

    private static String guessLanguageFromUTF8Bytes(byte[] UTF8_text, boolean detectNonCjk) {
        int chinese_count = 0;
        int japanese_count = 0;
        int korean_count = 0;
        int thai_count = 0;
        int hindi_count = 0;
        int next_char = 0;
        int len = 0;
        len = UTF8_text.length;
        while (next_char < len) {
            int two_byte_char;
            char simple_char = (char)UTF8_text[next_char];
            if ((simple_char & 0x80) == 0) {
                ++next_char;
                continue;
            }
            if ((simple_char & 0xF0) == 224) {
                two_byte_char = 4096 * (simple_char & 0xF) + 64 * (UTF8_text[next_char + 1] & 0x3F) + (UTF8_text[next_char + 2] & 0x3F);
                next_char += 3;
            } else {
                two_byte_char = 64 * (simple_char & 0x1F) + (UTF8_text[next_char + 1] & 0x3F);
                next_char += 2;
            }
            if (LanguageEncodingInfo.is_between(two_byte_char, 19968, 40959) || LanguageEncodingInfo.is_between(two_byte_char, 64012, 64255) || LanguageEncodingInfo.is_between(two_byte_char, 13312, 19903) || LanguageEncodingInfo.is_between(two_byte_char, 131072, 173791) || LanguageEncodingInfo.is_between(two_byte_char, 194560, 195103)) {
                ++chinese_count;
            } else if (LanguageEncodingInfo.is_between(two_byte_char, 12352, 12543) || LanguageEncodingInfo.is_between(two_byte_char, 65381, 65439) || LanguageEncodingInfo.is_between(two_byte_char, 12784, 12799)) {
                ++japanese_count;
            } else if (LanguageEncodingInfo.is_between(two_byte_char, 44032, 55203) || LanguageEncodingInfo.is_between(two_byte_char, 12592, 12687) || LanguageEncodingInfo.is_between(two_byte_char, 63744, 64011) || LanguageEncodingInfo.is_between(two_byte_char, 4352, 4607) || LanguageEncodingInfo.is_between(two_byte_char, 65440, 65500)) {
                ++korean_count;
            } else if (detectNonCjk && LanguageEncodingInfo.is_between(two_byte_char, 3584, 3711)) {
                ++thai_count;
            } else if (detectNonCjk && LanguageEncodingInfo.is_between(two_byte_char, 2304, 2431)) {
                ++hindi_count;
            }
            if (japanese_count == 0 && korean_count == 0) continue;
        }
        if (japanese_count != 0) {
            return "ja";
        }
        if (korean_count != 0) {
            return "ko";
        }
        if (chinese_count != 0) {
            return "zh";
        }
        if (detectNonCjk && thai_count != 0) {
            return "th";
        }
        if (detectNonCjk && hindi_count != 0) {
            return "hi";
        }
        return "";
    }

    static {
        countryCodeToLanguageCode.put("ar", "es");
        countryCodeToLanguageCode.put("at", "de");
        countryCodeToLanguageCode.put("au", "en");
        countryCodeToLanguageCode.put("br", "pt");
        countryCodeToLanguageCode.put("ca", "en");
        countryCodeToLanguageCode.put("cn", "zh-cn");
        countryCodeToLanguageCode.put("de", "de");
        countryCodeToLanguageCode.put("dk", "dk");
        countryCodeToLanguageCode.put("es", "es");
        countryCodeToLanguageCode.put("fi", "fi");
        countryCodeToLanguageCode.put("fr", "fr");
        countryCodeToLanguageCode.put("gb", "en");
        countryCodeToLanguageCode.put("gr", "el");
        countryCodeToLanguageCode.put("hk", "zh-tw");
        countryCodeToLanguageCode.put("ie", "en");
        countryCodeToLanguageCode.put("il", "iw");
        countryCodeToLanguageCode.put("is", "is");
        countryCodeToLanguageCode.put("it", "it");
        countryCodeToLanguageCode.put("jp", "ja");
        countryCodeToLanguageCode.put("kr", "ko");
        countryCodeToLanguageCode.put("mx", "es");
        countryCodeToLanguageCode.put("nl", "nl");
        countryCodeToLanguageCode.put("no", "no");
        countryCodeToLanguageCode.put("nz", "en");
        countryCodeToLanguageCode.put("pt", "pt");
        countryCodeToLanguageCode.put("ru", "ru");
        countryCodeToLanguageCode.put("se", "sv");
        countryCodeToLanguageCode.put("tw", "zh-tw");
        countryCodeToLanguageCode.put("uk", "en");
        countryCodeToLanguageCode.put("us", "en");
        languageCodeToEncoding.put("de", "ISO-8859-1");
        languageCodeToEncoding.put("dk", "ISO-8859-1");
        languageCodeToEncoding.put("el", "ISO-8859-7");
        languageCodeToEncoding.put("en", "ISO-8859-1");
        languageCodeToEncoding.put("es", "ISO-8859-1");
        languageCodeToEncoding.put("fi", "ISO-8859-1");
        languageCodeToEncoding.put("fr", "ISO-8859-1");
        languageCodeToEncoding.put("is", "ISO-8859-1");
        languageCodeToEncoding.put("it", "ISO-8859-1");
        languageCodeToEncoding.put("iw", "ISO-8859-8");
        languageCodeToEncoding.put("ja", "SHIFT_JIS");
        languageCodeToEncoding.put("ko", "EUC-KR");
        languageCodeToEncoding.put("nl", "ISO-8859-1");
        languageCodeToEncoding.put("no", "ISO-8859-1");
        languageCodeToEncoding.put("pt", "ISO-8859-1");
        languageCodeToEncoding.put("ru", "ISO-8859-5");
        languageCodeToEncoding.put("sv", "ISO-8859-1");
        languageCodeToEncoding.put("zh-cn", "GB2312");
        languageCodeToEncoding.put("zh-tw", "BIG5");
    }
}

