/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.collect.Lists;
import com.google.i18n.LocaleResourceCache;
import com.google.i18n.Message;
import com.google.i18n.MessageBundle;
import com.google.i18n.MessageId;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class LocaleContext {
    private static MessageBundle defaultBundle;
    private final Locale locale;
    private final MessageBundle bundle;
    private static List<String> default_sources;
    private static final LocaleResourceCache<LocaleContext> cachedLocaleContexts;

    public static void setDefaultSource(String message_source) {
        if (message_source == null) {
            throw new NullPointerException();
        }
        LocaleContext.setDefaultSources(Collections.singletonList(message_source));
    }

    public static void setDefaultSources(List<String> message_sources) {
        if (message_sources == null) {
            throw new NullPointerException();
        }
        default_sources = Lists.newArrayList();
        default_sources.addAll(message_sources);
    }

    public static LocaleContext getInstance(String message_source, Locale locale) {
        return LocaleContext.getInstance(message_source, locale, null);
    }

    public static LocaleContext getInstance(String message_source, Locale locale, ClassLoader classLoader) {
        return cachedLocaleContexts.get(message_source, locale, classLoader);
    }

    public static LocaleContext getInstance(List<String> message_sources, Locale locale) {
        return LocaleContext.getInstance(message_sources, locale, null);
    }

    public static LocaleContext getInstance(List<String> message_sources, Locale locale, ClassLoader classLoader) {
        return cachedLocaleContexts.get(message_sources, locale, classLoader);
    }

    public static LocaleContext getDefaultInstance(Locale locale) {
        return LocaleContext.getInstance(default_sources, locale);
    }

    public List getMessageSources() {
        return this.bundle.getMessageSources();
    }

    public boolean allSourcesPresent() {
        return this.bundle.allSourcesPresent();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MessageBundle getMessageBundle() {
        return this.bundle;
    }

    public Message getMessage(long id) {
        return this.bundle.getMessage(id);
    }

    public Message getMessage(String text) {
        long id = MessageId.GenerateId(text, "");
        return this.bundle.getMessage(text, null, id, true, false);
    }

    public Message getMessage(String text, String meaning) {
        long id = MessageId.GenerateId(text, meaning);
        return this.bundle.getMessage(text, meaning, id, true, false);
    }

    public static String getLocalizedText(String text, LocaleContext lc) {
        if (lc == null) {
            return text;
        }
        long id = MessageId.GenerateId(text, "");
        return lc.getMessageBundle().getMessage(text, null, id, true, true).toString();
    }

    public static String getLocalizedText(String text, String meaning, LocaleContext lc) {
        if (lc == null) {
            return text;
        }
        long id = MessageId.GenerateId(text, meaning);
        return lc.getMessageBundle().getMessage(text, meaning, id, true, true).toString();
    }

    public boolean isTranslated(String text) {
        long id = MessageId.GenerateId(text, "");
        return this.bundle.isTranslated(id);
    }

    public boolean isTranslated(String text, String meaning) {
        long id = MessageId.GenerateId(text, meaning);
        return this.bundle.isTranslated(id);
    }

    public String toString() {
        String string = String.valueOf(this.locale);
        String string2 = String.valueOf(this.bundle.getMessageSources());
        return new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Requested locale: ").append(string).append(", Message sources: ").append(string2).toString();
    }

    public static void invalidateCachedContexts() {
        cachedLocaleContexts.invalidateCache();
    }

    private LocaleContext(List<String> message_sources, Locale locale, ClassLoader classLoader) {
        this.locale = locale;
        this.bundle = defaultBundle != null ? defaultBundle : MessageBundle.getInstance(message_sources, locale, classLoader);
    }

    LocaleContext(Locale locale) {
        this.locale = locale;
        this.bundle = null;
    }

    public static void setDefaultBundle(MessageBundle aBundle) {
        defaultBundle = aBundle;
    }

    static {
        default_sources = Collections.emptyList();
        cachedLocaleContexts = new LocaleResourceCache<LocaleContext>(new LocaleResourceCache.ResourceLoader<LocaleContext>(){

            @Override
            public LocaleContext create(List<String> messageSources, Locale locale, ClassLoader classLoader) {
                return new LocaleContext(messageSources, locale, classLoader);
            }
        });
    }
}

