/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.errorprone.annotations.Immutable;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.Converters;
import com.google.i18n.identifiers.JavaLocaleConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.LanguagePriorityList;
import com.google.i18n.identifiers.impl.StandardLanguageMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

@Immutable
public final class LocaleGroup {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/LocaleGroup");
    private static final JavaLocaleConverter LOCALE_CONVERTER = JavaLocaleConverter.CONVERTER;
    @Nullable
    private final Locale defaultLocale;
    @Nullable
    private final LanguageCode defaultLanguageCode;
    private final ImmutableMap<LanguageCode, Locale> languageCodeToLocaleMap;
    private final ImmutableList<Locale> supportedLocales;
    private final ImmutableMap<String, Locale> stringToLocaleMap;
    private final NullDefaultLanguageMatcher languageMatcher;
    private final ImmutableSet<Locale> invalidSupportedLocales;

    @Deprecated
    public LocaleGroup(Iterable<Locale> locales) {
        this((List<Locale>)Lists.newArrayList(locales));
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/i18n/LocaleGroup", "<init>", 89, "LocaleGroup.java")).log("Deprecated. Please use the constructor accepting list of Locales instead.");
        if (!(locales instanceof List)) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/LocaleGroup", "<init>", 92, "LocaleGroup.java")).log("Construction of LocaleGroup with an Iterable other than List is dangerous since first language from the iterable is used as the default language");
        }
    }

    public LocaleGroup(@Nullable Locale defaultLocale, Locale ... locales) {
        this(LocaleGroup.combineLocales(defaultLocale, locales));
    }

    private static List<Locale> combineLocales(@Nullable Locale defaultLocale, Locale ... locales) {
        if (defaultLocale == null) {
            Preconditions.checkArgument(locales.length == 0, "default locale may be null only if locales array is empty");
            return ImmutableList.of();
        }
        return Lists.asList(defaultLocale, locales);
    }

    public LocaleGroup(List<Locale> locales) {
        ImmutableList.Builder localeList = ImmutableList.builder();
        ImmutableList.Builder supportedLanguages = ImmutableList.builder();
        ImmutableSet.Builder<Locale> invalidLocales = ImmutableSet.builder();
        ImmutableMap.Builder<String, Locale> stringToLocaleMap = ImmutableMap.builder();
        HashMap<LanguageCode, Locale> languageCodeToLocaleMap = Maps.newHashMap();
        for (Locale locale : ImmutableSet.copyOf(locales)) {
            String str;
            LanguageCode languageCode = LocaleGroup.languageCodeFromLocale(locale, invalidLocales);
            if (languageCodeToLocaleMap.containsKey(languageCode)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/i18n/LocaleGroup", "<init>", 148, "LocaleGroup.java")).log("Usage of duplicate locale '%s' (languageCode '%s')", (Object)locale, (Object)languageCode);
                if (!locale.equals(languageCodeToLocaleMap.get(languageCode))) {
                    localeList.add(locale);
                    LanguageCode nonFoldedLanguageCode = LanguageCode.forString(locale.getLanguage(), CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS);
                    if (nonFoldedLanguageCode.isCanonical()) {
                        languageCodeToLocaleMap.put(languageCode, locale);
                    }
                }
            } else {
                languageCodeToLocaleMap.put(languageCode, locale);
                supportedLanguages.add(languageCode);
                localeList.add(locale);
            }
            if ("".equals(str = locale.toString().toLowerCase(Locale.ENGLISH).replace("-", "_"))) {
                str = Converters.STRING_JAVA_LOCALE.reverse().convert(locale);
            }
            stringToLocaleMap.put(str, locale);
        }
        this.supportedLocales = localeList.build();
        this.defaultLocale = this.supportedLocales.isEmpty() ? null : (Locale)this.supportedLocales.get(0);
        ImmutableCollection supportedLanguagesList = supportedLanguages.build();
        this.defaultLanguageCode = supportedLanguagesList.isEmpty() ? null : (LanguageCode)supportedLanguagesList.get(0);
        this.languageMatcher = new NullDefaultLanguageMatcher((List<LanguageCode>)((Object)supportedLanguagesList));
        this.invalidSupportedLocales = invalidLocales.build();
        this.languageCodeToLocaleMap = ImmutableMap.copyOf(languageCodeToLocaleMap);
        this.stringToLocaleMap = stringToLocaleMap.build();
    }

    private static LanguageCode languageCodeFromLocale(Locale locale, ImmutableSet.Builder<Locale> invalidLocales) {
        LanguageCode languageCode = LOCALE_CONVERTER.fromOther(locale);
        if (LanguageCode.UNKNOWN.equals(languageCode) && !CodeConverter.Status.isGoogleValid(LOCALE_CONVERTER.getStatusFromOther(locale))) {
            invalidLocales.add((Object)locale);
            languageCode = LanguageCode.forStringLeniently(locale.toString());
            String string = languageCode.toString();
            String string2 = locale.toString();
            String languageTag = new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-x-").append(string2).toString();
            languageCode = LanguageCode.forStringLeniently(languageTag);
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/i18n/LocaleGroup", "languageCodeFromLocale", 202, "LocaleGroup.java")).log("Usage of invalid / ill-formed locale '%s' (mapped to language tag '%s').", (Object)locale, (Object)languageCode);
        }
        return languageCode;
    }

    @Nullable
    public LanguageCode getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    @Nullable
    public LanguageCode getLanguageCode(@Nullable LanguageCode languageCode) {
        return this.getLanguageCode(languageCode, this.getDefaultLanguageCode());
    }

    @Nullable
    public LanguageCode getLanguageCode(@Nullable LanguageCode languageCode, @Nullable LanguageCode defaultLanguageCode) {
        if (languageCode == null) {
            return defaultLanguageCode;
        }
        LanguageCode bestMatch = this.languageMatcher.getBestMatch(languageCode);
        if (bestMatch == null) {
            return defaultLanguageCode;
        }
        return bestMatch;
    }

    @Nullable
    public Locale getDefault() {
        return this.defaultLocale;
    }

    @Nullable
    public Locale getLocale(String value) {
        return this.getLocale(value, this.getDefault());
    }

    @Nullable
    public Locale getLocale(@Nullable LanguageCode languageCode, @Nullable Locale defaultLocale) {
        if (null == languageCode) {
            return defaultLocale;
        }
        LanguageCode bestMatch = this.getLanguageCode(languageCode, null);
        if (null == bestMatch) {
            return defaultLocale;
        }
        return this.languageCodeToLocaleMap.get(bestMatch);
    }

    @Nullable
    public Locale getLocale(@Nullable String value, @Nullable Locale defaultLocale) {
        if (Strings.isNullOrEmpty(value)) {
            return defaultLocale;
        }
        if (this.stringToLocaleMap.containsKey(value = value.toLowerCase(Locale.ENGLISH).replace("-", "_"))) {
            Locale locale = this.stringToLocaleMap.get(value);
            if (this.invalidSupportedLocales.contains(locale)) {
                return locale;
            }
            return this.getLocale(locale, defaultLocale);
        }
        Iterator<LanguageCode> languages = LanguagePriorityList.builder().add(value, false).build().iterator();
        if (!languages.hasNext()) {
            return defaultLocale;
        }
        LanguageCode language = languages.next();
        return this.getLocale(language, defaultLocale);
    }

    @Nullable
    public Locale getLocale(@Nullable Locale locale, @Nullable Locale defaultLocale) {
        if (locale == null) {
            return defaultLocale;
        }
        if (this.invalidSupportedLocales.contains(locale)) {
            return locale;
        }
        LanguageCode languageCode = LOCALE_CONVERTER.fromOther(locale);
        return this.getLocale(languageCode, defaultLocale);
    }

    @Nullable
    public Locale getLocale(@Nullable Locale locale) {
        return this.getLocale(locale, this.getDefault());
    }

    public ImmutableList<Locale> getLocales() {
        return this.supportedLocales;
    }

    public ImmutableList<Locale> supportedLocaleFallbackChain(Locale locale, Locale defaultLocale) {
        return ImmutableList.copyOf(this.getLocales(locale, defaultLocale));
    }

    public ImmutableList<Locale> supportedLocaleFallbackChain(Locale locale) {
        return this.supportedLocaleFallbackChain(locale, this.getDefault());
    }

    public boolean contains(Locale locale) {
        if (null == locale) {
            return false;
        }
        return this.supportedLocales.contains(locale);
    }

    @Deprecated
    public List<Locale> getLocales(Locale locale) {
        return this.getLocales(locale, this.getDefault());
    }

    @Deprecated
    public List<Locale> getLocales(Locale locale, Locale defaultLocale) {
        ArrayList<Locale> list = Lists.newArrayList();
        HashSet<Locale> set = Sets.newHashSet();
        if (locale != null) {
            this.addMembers(locale, list, set);
        }
        if (defaultLocale != null && !defaultLocale.equals(locale)) {
            this.addMembers(defaultLocale, list, set);
        }
        return list;
    }

    private void addMember(String value, List<Locale> list, Set<Locale> set) {
        Locale member = this.stringToLocaleMap.get(value.toLowerCase(Locale.ENGLISH).replace("-", "_"));
        if (member != null && !set.contains(member)) {
            set.add(member);
            list.add(member);
        }
    }

    private void addMembers(Locale locale, List<Locale> list, Set<Locale> set) {
        String value = locale.toString();
        this.addMember(value, list, set);
        int pos = value.lastIndexOf(95);
        while (pos > 0) {
            this.addMember(value.substring(0, pos), list, set);
            pos = value.lastIndexOf(95, pos - 1);
        }
    }

    public String toString() {
        return this.supportedLocales.toString();
    }

    @Immutable
    private static class NullDefaultLanguageMatcher {
        private final StandardLanguageMatcher matcher;
        private final LanguageCode fallbackValue = LanguageCode.forString("und-Guru-CH");

        public NullDefaultLanguageMatcher(List<LanguageCode> languageList) {
            LanguagePriorityList.LanguagePriorityListBuilder builder = LanguagePriorityList.builder();
            builder.add(this.fallbackValue);
            for (LanguageCode language : languageList) {
                Preconditions.checkArgument(!this.fallbackValue.equals(language), "Using reserved / sentinel value: %s.", (Object)language);
                builder.add(language);
            }
            this.matcher = new StandardLanguageMatcher(builder.build());
        }

        @Nullable
        public LanguageCode getBestMatch(LanguageCode preferredLanguage) {
            LanguageCode result = this.matcher.getBestMatch(preferredLanguage);
            if (this.fallbackValue.equals(result)) {
                result = null;
            }
            return result;
        }
    }
}

