/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Objects;
import com.google.i18n.MessageBundle;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class LocaleResourceCache<T> {
    private static final ClassLoader MESSAGE_BUNDLE_CLASS_LOADER = MessageBundle.class.getClassLoader();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final Map<CacheKey, T> cache = new ConcurrentHashMap<CacheKey, T>();
    private ResourceLoader<T> resourceLoader;

    public LocaleResourceCache(ResourceLoader<T> resourceLoader) {
        this();
        this.resourceLoader = resourceLoader;
    }

    public LocaleResourceCache() {
    }

    public void put(List<String> messageSources, Locale locale, ClassLoader classLoader, T value) {
        this.cleanup();
        this.cache.put(CacheKey.createCacheKey(messageSources, locale, classLoader, this.referenceQueue), value);
    }

    public T get(List<String> messageSources, Locale locale, ClassLoader classLoader) {
        return this.get(CacheKey.createCacheKey(messageSources, locale, classLoader, this.referenceQueue));
    }

    public T get(String messageSource, Locale locale, ClassLoader classLoader) {
        return this.get(CacheKey.createCacheKey(messageSource, locale, classLoader, this.referenceQueue));
    }

    private T get(CacheKey cacheKey) {
        T resource = this.cache.get(cacheKey);
        if (resource == null && this.resourceLoader != null) {
            this.cleanup();
            resource = this.resourceLoader.create(cacheKey.getMessageSources(), cacheKey.getLocale(), cacheKey.getClassLoader());
            this.cache.put(cacheKey, resource);
        }
        return resource;
    }

    public void invalidateCache() {
        this.cache.clear();
    }

    private void cleanup() {
        ClassLoaderReference ref;
        while ((ref = (ClassLoaderReference)this.referenceQueue.poll()) != null) {
            this.cache.remove(ref.getCacheKey());
        }
    }

    private static abstract class CacheKey {
        private final Locale locale;
        private final WeakReference<ClassLoader> classLoaderRef;
        private final int hashCode;

        private CacheKey(Locale locale, ClassLoader classLoader, ReferenceQueue referenceQueue) {
            this.locale = locale;
            if (classLoader == MESSAGE_BUNDLE_CLASS_LOADER) {
                classLoader = null;
            }
            this.classLoaderRef = classLoader == null ? null : new ClassLoaderReference(classLoader, referenceQueue, this);
            int localeHash = locale == null ? 0 : locale.hashCode();
            int loaderHash = classLoader == null ? 0 : locale.hashCode();
            this.hashCode = localeHash * 31 + loaderHash;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof CacheKey) {
                CacheKey otherKey = (CacheKey)other;
                return Objects.equal(this.locale, otherKey.locale) && Objects.equal(this.getClassLoader(), otherKey.getClassLoader());
            }
            return false;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public ClassLoader getClassLoader() {
            if (this.classLoaderRef != null) {
                return (ClassLoader)this.classLoaderRef.get();
            }
            return null;
        }

        public abstract List<String> getMessageSources();

        public static CacheKey createCacheKey(String messageSource, Locale locale, ClassLoader classLoader, ReferenceQueue referenceQueue) {
            return new SingleSourceCacheKey(messageSource, locale, classLoader, referenceQueue);
        }

        public static CacheKey createCacheKey(List<String> messageSources, Locale locale, ClassLoader classLoader, ReferenceQueue referenceQueue) {
            if (messageSources.size() == 1) {
                return new SingleSourceCacheKey(messageSources.get(0), locale, classLoader, referenceQueue);
            }
            return new MultipleSourcesCacheKey(messageSources, locale, classLoader, referenceQueue);
        }

        private static class MultipleSourcesCacheKey
        extends CacheKey {
            private final List<String> messageSources;

            public MultipleSourcesCacheKey(List<String> sources, Locale locale, ClassLoader classLoader, ReferenceQueue referenceQueue) {
                super(locale, classLoader, referenceQueue);
                this.messageSources = sources;
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.messageSources.hashCode();
            }

            @Override
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (super.equals(other) && other instanceof MultipleSourcesCacheKey) {
                    MultipleSourcesCacheKey otherKey = (MultipleSourcesCacheKey)other;
                    return Objects.equal(this.messageSources, otherKey.messageSources);
                }
                return false;
            }

            @Override
            public List<String> getMessageSources() {
                return this.messageSources;
            }
        }

        private static class SingleSourceCacheKey
        extends CacheKey {
            private final String messageSource;

            public SingleSourceCacheKey(String source, Locale locale, ClassLoader classLoader, ReferenceQueue referenceQueue) {
                super(locale, classLoader, referenceQueue);
                this.messageSource = source;
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.messageSource.hashCode();
            }

            @Override
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (super.equals(other) && other instanceof SingleSourceCacheKey) {
                    SingleSourceCacheKey otherKey = (SingleSourceCacheKey)other;
                    return Objects.equal(this.messageSource, otherKey.messageSource);
                }
                return false;
            }

            @Override
            public List<String> getMessageSources() {
                return Collections.singletonList(this.messageSource);
            }
        }
    }

    private static class ClassLoaderReference
    extends WeakReference<ClassLoader> {
        private final CacheKey cacheKey;

        public ClassLoaderReference(ClassLoader classLoader, ReferenceQueue referenceQueue, CacheKey cacheKey) {
            super(classLoader, referenceQueue);
            this.cacheKey = cacheKey;
        }

        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    public static interface ResourceLoader<T> {
        public T create(List<String> var1, Locale var2, ClassLoader var3);
    }
}

