/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.Immutable;
import com.google.i18n.Message0;
import com.google.i18n.Message1;
import com.google.i18n.Message2;
import com.google.i18n.Message3;
import com.google.i18n.Message4;
import com.google.i18n.Message5;
import com.google.i18n.Message6;
import com.google.i18n.Message7;
import com.google.i18n.Message8;
import com.google.i18n.Message9;
import com.google.i18n.MessageN;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public class Message
implements Message0,
Message1,
Message2,
Message3,
Message4,
Message5,
Message6,
Message7,
Message8,
Message9,
MessageN {
    private static final Pattern PARAM_PATTERN = Pattern.compile("%[1-9%]");
    private static final String[] NO_PARAMS = new String[0];
    private static final Cache<String, Message> cachedMessages = CacheBuilder.newBuilder().softValues().concurrencyLevel(32).build();
    private final String msg;
    private final int[] paramLocations;

    @Deprecated
    public static boolean isTranslationContextEnabled() {
        return false;
    }

    @Deprecated
    public static Message getInstance(String string) {
        return Message.getInstance(string, null, 0L);
    }

    public static Message getInstance(String string, Locale locale, long id) {
        Message message = cachedMessages.getIfPresent(string);
        if (message == null) {
            message = new Message(string);
            cachedMessages.put(string, message);
        }
        return message;
    }

    @Override
    public String toString() {
        String[] p = NO_PARAMS;
        return this.toString(p);
    }

    @Override
    public String toString(String[] p) {
        if (this.paramLocations.length == 0) {
            return this.msg;
        }
        StringBuilder sb = new StringBuilder();
        try {
            this.writeTo(sb, p);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        return sb.toString();
    }

    public void writeTo(Appendable out, CharSequence ... p) throws IOException {
        int cur = 0;
        for (int pos : this.paramLocations) {
            out.append(this.msg, cur, pos);
            char ch = this.msg.charAt(pos + 1);
            if (ch == '%') {
                out.append('%');
            } else {
                int i = ch - 49;
                if (i >= p.length) {
                    String string = this.msg;
                    throw new IllegalArgumentException(new StringBuilder(44 + String.valueOf(string).length()).append("Parameter %").append(ch).append(" not supplied for translation \"").append(string).append("\"").toString());
                }
                out.append(p[i]);
            }
            cur = pos + 2;
        }
        out.append(this.msg, cur, this.msg.length());
    }

    @Override
    public String toString(String p1) {
        String[] p = new String[]{p1};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2) {
        String[] p = new String[]{p1, p2};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2, String p3) {
        String[] p = new String[]{p1, p2, p3};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2, String p3, String p4) {
        String[] p = new String[]{p1, p2, p3, p4};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2, String p3, String p4, String p5) {
        String[] p = new String[]{p1, p2, p3, p4, p5};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2, String p3, String p4, String p5, String p6) {
        String[] p = new String[]{p1, p2, p3, p4, p5, p6};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2, String p3, String p4, String p5, String p6, String p7) {
        String[] p = new String[]{p1, p2, p3, p4, p5, p6, p7};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2, String p3, String p4, String p5, String p6, String p7, String p8) {
        String[] p = new String[]{p1, p2, p3, p4, p5, p6, p7, p8};
        return this.toString(p);
    }

    @Override
    public String toString(String p1, String p2, String p3, String p4, String p5, String p6, String p7, String p8, String p9) {
        String[] p = new String[]{p1, p2, p3, p4, p5, p6, p7, p8, p9};
        return this.toString(p);
    }

    public String getMessageString() {
        return this.msg;
    }

    private Message(String msg) {
        this.msg = msg;
        this.paramLocations = Message.calculateParamLocations(msg);
    }

    private static int[] calculateParamLocations(String msg) {
        ArrayList<Integer> locs = Lists.newArrayList();
        Matcher m = PARAM_PATTERN.matcher(msg);
        int start = 0;
        while (m.find(start)) {
            locs.add(m.start());
            start = m.end();
        }
        return Ints.toArray(locs);
    }
}

