/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.UnsignedLong;
import com.google.i18n.LocaleResourceCache;
import com.google.i18n.LongObjectMap;
import com.google.i18n.Message;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageBundle {
    private static final LocaleResourceCache<MessageBundle> cached_message_bundles = new LocaleResourceCache<MessageBundle>(new LocaleResourceCache.ResourceLoader<MessageBundle>(){

        @Override
        public MessageBundle create(List<String> messageSources, Locale locale, ClassLoader classLoader) {
            return new MessageBundle(messageSources, locale, classLoader);
        }
    });
    private static final LocaleResourceCache<LongObjectMap> cached_messages = new LocaleResourceCache();
    private static final Map<LongObjectMap, LongObjectMap> canonical_messages = new ConcurrentHashMap<LongObjectMap, LongObjectMap>();
    private static ClassLoader default_class_loader = new TrivialClassLoader();
    private LongObjectMap messages;
    private LongObjectMap default_messages;
    private List<String> message_sources = Lists.newArrayList();
    private Locale requested_locale;
    private Set<Locale> message_locales_set;
    private Locale default_locale;
    private static final Logger logger = Logger.getLogger(MessageBundle.class.getName());
    private static final Pattern MESSAGE_SOURCE_PATTERN = Pattern.compile("^(.*)\\.([^.]+)$");

    public static MessageBundle getInstance(List<String> message_sources, Locale locale) {
        return MessageBundle.getInstance(message_sources, locale, null);
    }

    public static MessageBundle getInstance(List<String> message_sources, Locale locale, ClassLoader class_loader) {
        return cached_message_bundles.get(message_sources, locale, class_loader);
    }

    public static MessageBundle getInstance(String message_source, Locale locale) {
        return MessageBundle.getInstance(message_source, locale, null);
    }

    public static MessageBundle getInstance(String message_source, Locale locale, ClassLoader class_loader) {
        return cached_message_bundles.get(message_source, locale, class_loader);
    }

    public static synchronized void invalidateCaches() {
        cached_message_bundles.invalidateCache();
        cached_messages.invalidateCache();
        canonical_messages.clear();
        default_class_loader = new TrivialClassLoader();
    }

    public List<String> getMessageSources() {
        return this.message_sources;
    }

    public Locale getDefaultLocale() {
        return this.default_locale;
    }

    public Message getMessage(long id) {
        return this.getMessage(null, null, id, true, false);
    }

    public boolean isTranslated(long id) {
        return this.messages.lookup(id, null) != null;
    }

    public boolean allSourcesPresent() {
        return this.message_locales_set.size() == 1 && this.message_locales_set.contains(this.requested_locale);
    }

    private String getMessageInfo(String text, String meaning, long id) {
        StringBuilder sb = new StringBuilder();
        if (text != null) {
            sb.append(new StringBuilder(7 + String.valueOf(text).length()).append("text=\"").append(text).append("\"").toString());
            if (meaning != null) {
                sb.append(new StringBuilder(11 + String.valueOf(meaning).length()).append(" meaning=\"").append(meaning).append("\"").toString());
            }
        } else {
            sb.append("text=<unknown>");
        }
        sb.append(new StringBuilder(24).append(" id=").append(id).toString());
        return sb.toString();
    }

    protected Message getMessage(String text, String meaning, long id, boolean fallback_ok, boolean orig_text_ok) {
        Message val = (Message)this.messages.lookup(id, null);
        if (val == null && fallback_ok) {
            val = (Message)this.default_messages.lookup(id, null);
        }
        if (val == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Can't find message for ");
            sb.append(this.requested_locale.toString());
            sb.append(" in ");
            String messageSourcesString = Joiner.on(",").useForNull("null").join(this.getMessageSources());
            sb.append(messageSourcesString);
            sb.append(": ");
            sb.append(this.getMessageInfo(text, meaning, id));
            if (text != null && orig_text_ok) {
                Logger.getLogger(MessageBundle.class.getName()).logp(Level.INFO, "com.google.i18n.MessageBundle", "getMessage", sb.toString());
                return Message.getInstance(text, this.requested_locale, id);
            }
            throw new MissingResourceException(sb.toString(), messageSourcesString, String.valueOf(id));
        }
        return val;
    }

    protected MessageBundle(List<String> message_sources, Locale locale) {
        this(message_sources, locale, null);
    }

    protected MessageBundle(List<String> message_sources, Locale locale, ClassLoader class_loader) {
        this.message_sources.addAll(message_sources);
        this.requested_locale = locale;
        this.default_locale = Locale.getDefault();
        this.messages = this.loadMessages(locale, true, class_loader);
        this.default_messages = this.loadMessages(this.default_locale, false, class_loader);
    }

    private LongObjectMap loadMessages(Locale locale, boolean update_message_locale, ClassLoader class_loader) {
        LongObjectMap messages;
        if (!update_message_locale && (messages = cached_messages.get(this.message_sources, locale, class_loader)) != null) {
            return messages;
        }
        ArrayList<ResourceBundle> resource_bundles = Lists.newArrayList();
        if (update_message_locale) {
            this.message_locales_set = Sets.newHashSet();
        }
        for (String message_source : this.message_sources) {
            ResourceBundle rb = this.loadResourceBundle(message_source, locale, class_loader);
            resource_bundles.add(rb);
            if (!update_message_locale) continue;
            this.message_locales_set.add(rb.getLocale());
        }
        LongObjectMap messages2 = cached_messages.get(this.message_sources, locale, class_loader);
        if (messages2 == null) {
            messages2 = this.getMessagesFromResourceBundles(resource_bundles);
            cached_messages.put(this.message_sources, locale, class_loader, messages2);
        }
        return messages2;
    }

    private ResourceBundle loadResourceBundle(String message_source, Locale locale, ClassLoader class_loader) {
        if (message_source.startsWith("javatests.")) {
            message_source = message_source.substring("javatests.".length());
            String string = String.valueOf(message_source);
            logger.logp(Level.WARNING, "com.google.i18n.MessageBundle", "loadResourceBundle", string.length() != 0 ? "Loading message with javatests prefix: ".concat(string) : new String("Loading message with javatests prefix: "));
        } else if (message_source.startsWith("java.")) {
            message_source = message_source.substring("java.".length());
            String string = String.valueOf(message_source);
            logger.logp(Level.WARNING, "com.google.i18n.MessageBundle", "loadResourceBundle", string.length() != 0 ? "Loading message with java prefix: ".concat(string) : new String("Loading message with java prefix: "));
        }
        try {
            return ResourceBundle.getBundle(message_source, locale, class_loader == null ? default_class_loader : class_loader);
        }
        catch (MissingResourceException mrx) {
            Matcher m = MESSAGE_SOURCE_PATTERN.matcher(message_source);
            if (!m.matches()) {
                throw mrx;
            }
            try {
                String string = m.group(1);
                String string2 = message_source;
                return ResourceBundle.getBundle(new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".javatests.").append(string2).toString(), locale, class_loader == null ? default_class_loader : class_loader);
            }
            catch (MissingResourceException mrx2) {
                throw mrx;
            }
        }
    }

    private LongObjectMap getMessagesFromResourceBundles(List<ResourceBundle> resource_bundles) {
        LongObjectMap messages = new LongObjectMapWithNonIdentityEquals();
        for (ResourceBundle rb : resource_bundles) {
            Locale rbLocale = rb.getLocale();
            Enumeration<String> ids = rb.getKeys();
            while (ids.hasMoreElements()) {
                String id = ids.nextElement();
                String val = (String)rb.getObject(id);
                long lid = UnsignedLong.valueOf(id).longValue();
                messages.insert(lid, Message.getInstance(val, rbLocale, lid));
            }
        }
        LongObjectMap canonical = canonical_messages.get(messages);
        if (canonical == null) {
            canonical_messages.put(messages, messages);
        } else {
            messages = canonical;
        }
        return messages;
    }

    private static class LongObjectMapWithNonIdentityEquals
    extends LongObjectMap {
        private LongObjectMapWithNonIdentityEquals() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LongObjectMapWithNonIdentityEquals)) {
                return false;
            }
            LongObjectMapWithNonIdentityEquals i2 = (LongObjectMapWithNonIdentityEquals)obj;
            if (i2.size() != this.size()) {
                return false;
            }
            int i = -1;
            while ((i = this.next(i)) >= 0) {
                if (i2.lookup(this.keyAt(i), null) == this.valueAt(i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 0;
            int i = -1;
            while ((i = this.next(i)) >= 0) {
                hash = (int)((long)hash ^ this.keyAt(i) * 31L + (long)this.valueAt(i).hashCode());
            }
            return hash;
        }
    }

    private static class TrivialClassLoader
    extends ClassLoader {
        public TrivialClassLoader() {
            super(MessageBundle.class.getClassLoader());
        }
    }
}

