/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Optional;
import com.google.errorprone.annotations.Immutable;
import com.google.i18n.Localizable;
import com.google.i18n.Message;
import com.google.i18n.MessageBundleReference;
import java.util.Locale;

@Immutable
public abstract class MessageReference {
    private final MessageBundleReference messageBundleReference_;
    private final long id_;

    @Deprecated
    public MessageReference(String source, long id) {
        this(new MessageBundleReference(source), id);
    }

    public MessageReference(MessageBundleReference messageBundleReference, long id) {
        this.messageBundleReference_ = messageBundleReference;
        this.id_ = id;
    }

    public long getId() {
        return this.id_;
    }

    public Message getMessage(Locale locale) {
        return this.messageBundleReference_.getMessageBundle(locale).getMessage(this.id_);
    }

    protected static String localizedStringOf(Locale loc, Object o) {
        if (o instanceof Localizable) {
            return ((Localizable)o).toString(loc);
        }
        return o.toString();
    }

    protected Optional<String> toStringIfTranslated(Locale locale, String ... args) {
        return this.isTranslated(locale) ? Optional.of(this.getMessage(locale).toString(args)) : Optional.absent();
    }

    public boolean isTranslated(Locale locale) {
        return this.messageBundleReference_.getMessageBundle(locale).isTranslated(this.id_);
    }

    public abstract int getPlaceholdersCount();
}

