/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MessageSet {
    ResourceBundle resourceBundle_;
    public static final String messagesRequestKey = "com.google.i18n.MessageSet";

    public MessageSet(String messageBundle, Locale locale) {
        this.resourceBundle_ = ResourceBundle.getBundle(messageBundle, locale);
    }

    public Msg msg(String messageName) {
        return new Msg(this.resourceBundle_.getString(messageName));
    }

    public static Msg msg(HttpServletRequest req, String messageName) {
        return MessageSet.getMessagesForRequest(req).msg(messageName);
    }

    public static MessageSet getMessagesForRequest(HttpServletRequest req) {
        return (MessageSet)req.getAttribute(messagesRequestKey);
    }

    public static void setMessagesForRequest(HttpServletRequest req, MessageSet ms) {
        req.setAttribute(messagesRequestKey, ms);
    }

    public static void main(String[] args) {
        if (args.length < 3 || args.length % 2 != 1) {
            System.err.println("Args: messageBundle locale messagename [placeholder value]*");
            return;
        }
        MessageSet messages = new MessageSet(args[0], new Locale(args[1], ""));
        Msg m = messages.msg(args[2]);
        for (int i = 3; i < args.length; i += 2) {
            m.p(args[i], args[i + 1]);
        }
        String string = String.valueOf(m);
        System.out.println(new StringBuilder(8 + String.valueOf(string).length()).append("Result: ").append(string).toString());
    }

    public static class Msg {
        private final String raw_message_;
        private Map<String, String> parameters_;

        Msg(String raw_message) {
            this.raw_message_ = raw_message;
        }

        public Msg p(String placeholder, Object value) {
            if (this.parameters_ == null) {
                this.parameters_ = Maps.newHashMap();
            }
            this.parameters_.put(placeholder, value.toString());
            return this;
        }

        public Msg p(String placeholder, int value) {
            return this.p(placeholder, Integer.toString(value));
        }

        public Msg p(String placeholder, char value) {
            return this.p(placeholder, new StringBuilder(1).append(value).toString());
        }

        public final String s() {
            return this.toString();
        }

        public String toString() {
            String res = this.raw_message_;
            HashSet<String> usedParams = this.parameters_ != null ? new HashSet<String>() : null;
            int i = this.raw_message_.indexOf("%");
            if (i != -1) {
                StringBuilder buf = new StringBuilder();
                int start = 0;
                do {
                    int c;
                    buf.append(this.raw_message_.substring(start, i));
                    int n = c = i == this.raw_message_.length() ? 0 : (int)this.raw_message_.charAt(i + 1);
                    if (c == 37) {
                        buf.append('%');
                        start = i + 2;
                        continue;
                    }
                    if (c == 40) {
                        start = i + 2;
                        int end = this.raw_message_.indexOf(")s", start);
                        if (end == -1) {
                            String string = String.valueOf(this.raw_message_);
                            System.err.println(string.length() != 0 ? "Unmatched placeholder in message: ".concat(string) : new String("Unmatched placeholder in message: "));
                            continue;
                        }
                        buf.append(this.getValue(this.raw_message_.substring(start, end), usedParams));
                        start = end + 2;
                        continue;
                    }
                    buf.append('%');
                    start = i + 1;
                } while ((i = this.raw_message_.indexOf(37, start)) != -1);
                buf.append(this.raw_message_.substring(start));
                res = buf.toString();
            }
            if (usedParams != null && usedParams.size() != this.parameters_.size()) {
                HashMap<String, String> unused = Maps.newHashMap(this.parameters_);
                unused.keySet().removeAll(usedParams);
                String string = String.valueOf(unused);
                String string2 = this.raw_message_;
                System.err.println(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unused placeholder values ").append(string).append(" on message: ").append(string2).toString());
            }
            return res;
        }

        private String getValue(String ph, Set<String> usedParams) {
            String val = null;
            if (this.parameters_ != null) {
                val = this.parameters_.get(ph);
            }
            if (val == null) {
                String string = this.raw_message_;
                System.err.println(new StringBuilder(33 + String.valueOf(ph).length() + String.valueOf(string).length()).append("Unset placeholder '").append(ph).append("' on message: ").append(string).toString());
                return "";
            }
            usedParams.add(ph);
            return val;
        }
    }
}

