/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.GoogleRuntimeException;
import com.google.common.collect.ImmutableMap;
import com.google.i18n.MessageBundleReference;
import com.google.i18n.MessageReference;
import com.google.i18n.MessageReference0;
import com.google.i18n.MessageReference1;
import com.google.i18n.MessageReference2;
import com.google.i18n.MessageReference3;
import com.google.i18n.MessageReference4;
import com.google.i18n.MessageReference5;
import com.google.i18n.MessageReference6;
import com.google.i18n.MessageReference7;
import com.google.i18n.MessageReference8;
import com.google.i18n.MessageReference9;
import com.google.i18n.MessageReferenceN;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class MessagesReferenceBuilder {
    private final Map<String, MessageReference> mapBuilder;
    private final MessageBundleReference messageBundleReference;

    public MessagesReferenceBuilder(String messageSource, int expectedMessageCount) {
        this.messageBundleReference = new MessageBundleReference(messageSource);
        this.mapBuilder = new LinkedHashMap<String, MessageReference>(expectedMessageCount);
    }

    public MessagesReferenceBuilder addMessage(String name, long id, int placeholdersCount) {
        switch (placeholdersCount) {
            case 0: {
                this.mapBuilder.put(name, new MessageReference0(this.messageBundleReference, id));
                break;
            }
            case 1: {
                this.mapBuilder.put(name, new MessageReference1(this.messageBundleReference, id));
                break;
            }
            case 2: {
                this.mapBuilder.put(name, new MessageReference2(this.messageBundleReference, id));
                break;
            }
            case 3: {
                this.mapBuilder.put(name, new MessageReference3(this.messageBundleReference, id));
                break;
            }
            case 4: {
                this.mapBuilder.put(name, new MessageReference4(this.messageBundleReference, id));
                break;
            }
            case 5: {
                this.mapBuilder.put(name, new MessageReference5(this.messageBundleReference, id));
                break;
            }
            case 6: {
                this.mapBuilder.put(name, new MessageReference6(this.messageBundleReference, id));
                break;
            }
            case 7: {
                this.mapBuilder.put(name, new MessageReference7(this.messageBundleReference, id));
                break;
            }
            case 8: {
                this.mapBuilder.put(name, new MessageReference8(this.messageBundleReference, id));
                break;
            }
            case 9: {
                this.mapBuilder.put(name, new MessageReference9(this.messageBundleReference, id));
                break;
            }
            default: {
                this.mapBuilder.put(name, new MessageReferenceN(this.messageBundleReference, id, placeholdersCount));
            }
        }
        return this;
    }

    public ImmutableMap<String, MessageReference> getMap() {
        return ImmutableMap.copyOf(this.mapBuilder);
    }

    public MessagesReferenceBuilder addMessagesForClass(Class clazz) {
        Properties properties = new Properties();
        try {
            properties.load(clazz.getResourceAsStream(String.valueOf(clazz.getSimpleName()).concat(".properties")));
        }
        catch (IOException e) {
            throw new GoogleRuntimeException("Couldn't load messages reference properties file", e);
        }
        for (Object name : properties.keySet()) {
            String[] idAndPlaceholdersCount = properties.getProperty((String)name).split(";");
            this.addMessage((String)name, Long.parseLong(idAndPlaceholdersCount[0]), Integer.parseInt(idAndPlaceholdersCount[1]));
        }
        return this;
    }
}

