/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.i18n.DurationFormatter;
import com.google.i18n.Messages;
import com.ibm.icu.text.MeasureFormat;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import java.util.Locale;

public class SimpleDurationFormatter
implements DurationFormatter {
    private final Style style;
    private final Locale locale;
    private static final long MS_PER_SECOND = 1000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_WEEK = 604800000L;
    private final String hourSymbol;
    private final String minuteSymbol;
    private final String secondSymbol;

    SimpleDurationFormatter(Style durationStyle, Locale loc, String spacer, boolean repeatAfter20) {
        this.style = durationStyle;
        this.locale = loc;
        this.hourSymbol = Messages.DURATION_HOUR_SYMBOL.toString(this.locale);
        this.minuteSymbol = Messages.DURATION_MINUTE_SYMBOL.toString(this.locale);
        this.secondSymbol = Messages.DURATION_SECOND_SYMBOL.toString(this.locale);
    }

    private void addSpaceIfNonEmpty(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(" ");
        }
    }

    @Override
    public String format(long duration) {
        long weeks = 0L;
        long days = 0L;
        if (this.style == Style.WEEKS_DAYS_LONG || this.style == Style.WEEKS_DAYS_MEDIUM_WITH_ROUNDED_SECONDS) {
            weeks = duration / 604800000L;
            days = (duration -= weeks * 604800000L) / 86400000L;
            duration -= days * 86400000L;
        }
        long hours = duration / 3600000L;
        long minutes = (duration -= hours * 3600000L) / 60000L;
        long seconds = (duration -= minutes * 60000L) / 1000L;
        StringBuilder ret = new StringBuilder(50);
        switch (this.style) {
            case WEEKS_DAYS_LONG: {
                MeasureFormat format = MeasureFormat.getInstance((Locale)this.locale, (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.WIDE);
                if (weeks > 0L) {
                    ret.append(format.format((Object)new Measure((Number)weeks, (MeasureUnit)MeasureUnit.WEEK)));
                }
                if (days > 0L) {
                    this.addSpaceIfNonEmpty(ret);
                    ret.append(format.format((Object)new Measure((Number)days, (MeasureUnit)MeasureUnit.DAY)));
                }
            }
            case LONG: {
                MeasureFormat format = MeasureFormat.getInstance((Locale)this.locale, (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.WIDE);
                if (hours > 0L) {
                    this.addSpaceIfNonEmpty(ret);
                    ret.append(format.format((Object)new Measure((Number)hours, (MeasureUnit)MeasureUnit.HOUR)));
                }
                if (minutes > 0L) {
                    this.addSpaceIfNonEmpty(ret);
                    ret.append(format.format((Object)new Measure((Number)minutes, (MeasureUnit)MeasureUnit.MINUTE)));
                }
                if (seconds <= 0L && ret.length() != 0) break;
                this.addSpaceIfNonEmpty(ret);
                ret.append(format.format((Object)new Measure((Number)seconds, (MeasureUnit)MeasureUnit.SECOND)));
                break;
            }
            case LONG_WITH_TRUNCATED_MINUTES: {
                MeasureFormat format = MeasureFormat.getInstance((Locale)this.locale, (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.WIDE);
                if (seconds >= 30L && ++minutes >= 60L) {
                    ++hours;
                    minutes = 0L;
                }
                if (hours < 1L) {
                    if (minutes < 1L) {
                        minutes = 1L;
                    }
                    ret.append(format.format((Object)new Measure((Number)minutes, (MeasureUnit)MeasureUnit.MINUTE)));
                    break;
                }
                ret.append(format.format((Object)new Measure((Number)hours, (MeasureUnit)MeasureUnit.HOUR)));
                break;
            }
            case WEEKS_DAYS_MEDIUM_WITH_ROUNDED_SECONDS: {
                MeasureFormat format = MeasureFormat.getInstance((Locale)this.locale, (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.SHORT);
                if (weeks > 0L) {
                    ret.append(format.format((Object)new Measure((Number)weeks, (MeasureUnit)MeasureUnit.WEEK)));
                }
                if (days > 0L) {
                    this.addSpaceIfNonEmpty(ret);
                    ret.append(format.format((Object)new Measure((Number)days, (MeasureUnit)MeasureUnit.DAY)));
                }
            }
            case MEDIUM_WITH_ROUNDED_SECONDS: {
                MeasureFormat format = MeasureFormat.getInstance((Locale)this.locale, (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.SHORT);
                if (weeks > 0L || days > 0L || hours > 0L || minutes > 0L) {
                    if (seconds >= 30L && ++minutes >= 60L) {
                        ++hours;
                        minutes = 0L;
                    }
                    if (hours > 0L) {
                        this.addSpaceIfNonEmpty(ret);
                        ret.append(format.format((Object)new Measure((Number)hours, (MeasureUnit)MeasureUnit.HOUR)));
                    }
                    if (minutes <= 0L) break;
                    this.addSpaceIfNonEmpty(ret);
                    ret.append(format.format((Object)new Measure((Number)minutes, (MeasureUnit)MeasureUnit.MINUTE)));
                    break;
                }
                ret.append(format.format((Object)new Measure((Number)seconds, (MeasureUnit)MeasureUnit.SECOND)));
                break;
            }
            case MEDIUM: {
                MeasureFormat format = MeasureFormat.getInstance((Locale)this.locale, (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.SHORT);
                if (hours > 0L) {
                    ret.append(format.format((Object)new Measure((Number)hours, (MeasureUnit)MeasureUnit.HOUR)));
                }
                if (minutes > 0L || hours > 0L) {
                    this.addSpaceIfNonEmpty(ret);
                    ret.append(format.format((Object)new Measure((Number)minutes, (MeasureUnit)MeasureUnit.MINUTE)));
                }
                this.addSpaceIfNonEmpty(ret);
                ret.append(format.format((Object)new Measure((Number)seconds, (MeasureUnit)MeasureUnit.SECOND)));
                break;
            }
            case SHORT: {
                if (hours > 0L) {
                    ret.append(String.format("%02d%s", hours, this.hourSymbol));
                }
                ret.append(String.format("%02d%s%02d", minutes, this.minuteSymbol, seconds));
                if (this.secondSymbol.equals("\"\"")) break;
                ret.append(this.secondSymbol);
                break;
            }
            case SHORT_NO_LEADING_ZERO: {
                if (hours > 0L) {
                    ret.append(String.format("%d%s", hours, this.hourSymbol));
                    ret.append(String.format("%02d%s%02d", minutes, this.minuteSymbol, seconds));
                } else {
                    ret.append(String.format("%d%s%02d", minutes, this.minuteSymbol, seconds));
                }
                if (this.secondSymbol.equals("\"\"")) break;
                ret.append(this.secondSymbol);
                break;
            }
        }
        return ret.toString();
    }

    public static enum Style {
        WEEKS_DAYS_LONG,
        LONG,
        WEEKS_DAYS_MEDIUM_WITH_ROUNDED_SECONDS,
        MEDIUM,
        SHORT,
        SHORT_NO_LEADING_ZERO,
        MEDIUM_WITH_ROUNDED_SECONDS,
        LONG_WITH_TRUNCATED_MINUTES,
        NONE;

    }
}

