/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.i18n.CharWidth;
import java.util.Map;

public class TextWrapper {
    public static final char LINE_SEPARATOR = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char LINE_FEED = '\n';
    public static final int DEFAULT_LINE_WIDTH = 72;
    public static final String COLLAPSE_WS = "CollapseWs";
    public static final String NO_EOL_WS = "NoEolWs";

    public static String wrap(String text) {
        return TextWrapper.wrap(text, 72, null);
    }

    public static String wrap(String text, int maxLineWidth, Map<String, Boolean> options) {
        if (text == null || maxLineWidth <= 0) {
            return null;
        }
        boolean collapseWs = true;
        boolean noEolWs = true;
        if (options != null) {
            if (options.get(COLLAPSE_WS) != null) {
                collapseWs = options.get(COLLAPSE_WS);
            }
            if (options.get(NO_EOL_WS) != null) {
                noEolWs = options.get(NO_EOL_WS);
            }
        }
        return TextWrapper.wrap(text, maxLineWidth, collapseWs, noEolWs);
    }

    private static String wrap(String text, int maxLineWidth, boolean collapseWs, boolean noEolWs) {
        StringBuilder formattedSb = new StringBuilder();
        int curLineWidth = 0;
        int curLineStart = 0;
        block0: for (int i = 0; i < text.length(); ++i) {
            char uc = text.charAt(i);
            if (collapseWs && TextWrapper.isNonLineBreakWs(uc) && formattedSb.length() > 0 && Character.isWhitespace(formattedSb.charAt(formattedSb.length() - 1))) continue;
            formattedSb.append(uc);
            curLineWidth += CharWidth.of(uc);
            if (TextWrapper.isLineSeparator(uc)) {
                if (noEolWs) {
                    for (int j = formattedSb.length() - 2; j >= curLineStart && TextWrapper.isNonLineBreakWs(formattedSb.charAt(j)); --j) {
                        formattedSb.deleteCharAt(j);
                    }
                }
                curLineWidth = 0;
                curLineStart = formattedSb.length();
                continue;
            }
            if (curLineWidth <= maxLineWidth) continue;
            int newLineWidth = 0;
            for (int pos = formattedSb.length() - 1; pos > curLineStart; --pos) {
                char cur_char = formattedSb.charAt(pos);
                newLineWidth += CharWidth.of(cur_char);
                if (!TextWrapper.isCharGoodForLineStart(cur_char) || !TextWrapper.isLineWrappableAfter(formattedSb.charAt(pos - 1))) continue;
                if (noEolWs) {
                    for (int j = pos - 1; j >= curLineStart && TextWrapper.isNonLineBreakWs(formattedSb.charAt(j)); --j) {
                        formattedSb.deleteCharAt(j);
                        --pos;
                    }
                }
                formattedSb.insert(pos, '\n');
                curLineWidth = newLineWidth;
                curLineStart = pos + 1;
                continue block0;
            }
        }
        return formattedSb.toString();
    }

    private static boolean isLineWrappableAfter(char uc) {
        if (Character.isWhitespace(uc)) {
            return true;
        }
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(uc);
        return ub == Character.UnicodeBlock.CJK_COMPATIBILITY || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || ub == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || ub == Character.UnicodeBlock.HANGUL_JAMO || ub == Character.UnicodeBlock.HANGUL_SYLLABLES || ub == Character.UnicodeBlock.HIRAGANA || ub == Character.UnicodeBlock.KATAKANA;
    }

    private static boolean isCharGoodForLineStart(char uc) {
        int char_type = Character.getType(uc);
        return !Character.isWhitespace(uc) && char_type != 22 && char_type != 24;
    }

    private static boolean isLineSeparator(char uc) {
        int char_type = Character.getType(uc);
        return uc == '\n' || uc == '\r' || char_type == 13 || char_type == 14;
    }

    private static boolean isNonLineBreakWs(char uc) {
        return Character.isWhitespace(uc) && !TextWrapper.isLineSeparator(uc);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.err.println("Usage: java TextWrapper <charset>");
            System.err.println("\treads from stdin the text in the charset (max length 1 << 16)");
            System.err.println("\tand it prints to stdout the formatted text in the same charset");
            System.exit(1);
        }
        byte[] input_buf = new byte[65536];
        String charset = args[0];
        try {
            int len = System.in.read(input_buf);
            if (len <= 0) {
                return;
            }
            System.out.write(TextWrapper.wrap(new String(input_buf, 0, len, charset)).getBytes(charset));
        }
        catch (Exception e) {
            String string = String.valueOf(e);
            System.err.println(new StringBuilder(9 + String.valueOf(string).length()).append("Failure: ").append(string).toString());
            System.exit(1);
        }
    }
}

