/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.i18n.identifiers.CodeConverter;
import java.util.HashMap;
import java.util.Map;

@GwtCompatible
public abstract class BasicCodeConverter<G, O>
implements CodeConverter<G, O> {
    protected Map<O, G> mapFromString = new HashMap<O, G>();
    protected Map<G, O> mapToString = new HashMap<G, O>();

    protected void add(O otherCode, G googleCode) {
        this.mapFromString.put(otherCode, googleCode);
        this.mapToString.put(googleCode, otherCode);
    }

    protected void add(O otherCode, G foldedGoogleCode, G nonFoldedGoogleCode) {
        this.mapFromString.put(otherCode, foldedGoogleCode);
        this.mapToString.put(foldedGoogleCode, otherCode);
        this.mapToString.put(nonFoldedGoogleCode, otherCode);
    }

    @Override
    public O toOther(G googleCode) {
        O result = this.mapToString.get(googleCode);
        if (result != null) {
            return result;
        }
        return this.mapToString.get(this.getUnknown());
    }

    @Override
    public G fromOther(O otherCode) {
        if (otherCode == null) {
            return this.getUnknown();
        }
        G result = this.mapFromString.get(otherCode);
        if (result == null) {
            return this.getUnknown();
        }
        return result;
    }
}

