/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.i18n.identifiers.BasicCodeConverter;

@GwtCompatible
public abstract class CaseNormalizingStringConverter<G>
extends BasicCodeConverter<G, String> {
    protected CaseNormalizingStyle style = CaseNormalizingStyle.MIXED;

    @Override
    protected void add(String otherCode, G googleCode) {
        otherCode = this.normalize(otherCode);
        super.add(otherCode, googleCode);
    }

    @Override
    public G fromOther(String otherCode) {
        if (otherCode == null) {
            return this.getUnknown();
        }
        Object result = this.mapFromString.get(this.normalize(otherCode));
        if (result == null) {
            return this.getUnknown();
        }
        return (G)result;
    }

    protected String normalize(String otherCode) {
        switch (this.style) {
            case MIXED: {
                return otherCode;
            }
            case LOWER: {
                return Ascii.toLowerCase(otherCode);
            }
            case UPPER: {
                return Ascii.toUpperCase(otherCode);
            }
            case TITLE: {
                String string = String.valueOf(Ascii.toUpperCase(otherCode.substring(0, 1)));
                String string2 = String.valueOf(Ascii.toLowerCase(otherCode.substring(1)));
                return string2.length() != 0 ? string.concat(string2) : new String(string);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected static enum CaseNormalizingStyle {
        UPPER,
        TITLE,
        LOWER,
        MIXED;

    }
}

