/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.i18n.identifiers.CaseNormalizingStringConverter;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.RegionCode;

@GwtCompatible
public class CctldRegionConverter
extends CaseNormalizingStringConverter<RegionCode> {
    public static final CctldRegionConverter CONVERTER = new CctldRegionConverter();
    private static final ImmutableMap<String, RegionCode> INCONSISTENT_MAP_FROM_OTHER = ImmutableMap.of("UK", RegionCode.GB, "QU", RegionCode.EU);
    @VisibleForTesting
    static final ImmutableMap<RegionCode, String> INCONSISTENT_MAP_TO_OTHER = ImmutableMap.of(RegionCode.GB, "UK");
    @VisibleForTesting
    static final ImmutableSet<RegionCode> REGION_CODES_NOT_CCTLD = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().add((Object)RegionCode.BU)).add((Object)RegionCode.CS)).add((Object)RegionCode.DD)).add((Object)RegionCode.EH)).add((Object)RegionCode.FX)).add((Object)RegionCode.NT)).add((Object)RegionCode.YD)).add((Object)RegionCode.ZR)).add((Object)RegionCode.XA)).add((Object)RegionCode.XB)).add((Object)RegionCode.XC)).add((Object)RegionCode.EZ)).add((Object)RegionCode.UN)).build();

    @Override
    public RegionCode getUnknown() {
        return RegionCode.ZZ;
    }

    @Override
    public CodeConverter.Status getStatusFromOther(String otherCode) {
        String upperCaseOtherCode = CctldRegionConverter.toUpperCaseIfWellFormed(otherCode);
        if (upperCaseOtherCode == null) {
            return CodeConverter.Status.ILL_FORMED;
        }
        if (INCONSISTENT_MAP_FROM_OTHER.containsKey(upperCaseOtherCode)) {
            return CodeConverter.Status.CANONICAL;
        }
        try {
            RegionCode googleCode = RegionCode.forString(upperCaseOtherCode);
            if (REGION_CODES_NOT_CCTLD.contains((Object)googleCode) || INCONSISTENT_MAP_TO_OTHER.containsKey((Object)googleCode)) {
                return CodeConverter.Status.INVALID;
            }
            return googleCode.getStatus();
        }
        catch (IllegalArgumentException e) {
            return CodeConverter.Status.INVALID;
        }
    }

    @Override
    public CodeConverter.Status getStatus(RegionCode googleCode) {
        String otherCode = CctldRegionConverter.toUpperCaseIfWellFormed(googleCode.toString());
        if (otherCode == null) {
            return CodeConverter.Status.ILL_FORMED;
        }
        if (REGION_CODES_NOT_CCTLD.contains((Object)googleCode)) {
            return CodeConverter.Status.INVALID;
        }
        return googleCode.getStatus();
    }

    @Override
    public String toOther(RegionCode googleCode) {
        String inconsistentMapToOtherResult = INCONSISTENT_MAP_TO_OTHER.get((Object)googleCode);
        if (inconsistentMapToOtherResult != null) {
            return inconsistentMapToOtherResult;
        }
        if (REGION_CODES_NOT_CCTLD.contains((Object)googleCode)) {
            return RegionCode.ZZ.toString();
        }
        String otherCode = googleCode.toString();
        if (otherCode.length() > 2) {
            return RegionCode.ZZ.toString();
        }
        return otherCode;
    }

    @Override
    public RegionCode fromOther(String otherCode) {
        String normalizedOtherCode = CctldRegionConverter.toUpperCaseIfWellFormed(otherCode);
        if (normalizedOtherCode == null) {
            return this.getUnknown();
        }
        RegionCode inconsistentMapFromOtherResult = INCONSISTENT_MAP_FROM_OTHER.get(normalizedOtherCode);
        if (inconsistentMapFromOtherResult != null) {
            return inconsistentMapFromOtherResult;
        }
        try {
            RegionCode regionCode = RegionCode.forString(normalizedOtherCode);
            if (REGION_CODES_NOT_CCTLD.contains((Object)regionCode) || INCONSISTENT_MAP_TO_OTHER.containsKey((Object)regionCode)) {
                return this.getUnknown();
            }
            return regionCode;
        }
        catch (IllegalArgumentException e) {
            return this.getUnknown();
        }
    }

    private static String toUpperCaseIfWellFormed(String s) {
        String upperS;
        if (s.length() == 2 && 'A' <= (upperS = Ascii.toUpperCase(s)).charAt(0) && upperS.charAt(0) <= 'Z' && 'A' <= upperS.charAt(1) && upperS.charAt(1) <= 'Z') {
            return upperS;
        }
        return null;
    }

    private CctldRegionConverter() {
    }
}

