/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.Iso6392Converters;
import com.google.i18n.identifiers.JavaLocaleConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.ULocaleConverter;
import com.ibm.icu.util.ULocale;
import java.util.Locale;

public final class Converters {
    public static final Converter<Locale, LanguageCode> JAVA_LOCALE = Converters.asConverter(JavaLocaleConverter.CONVERTER);
    public static final Converter<ULocale, LanguageCode> ULOCALE = Converters.asConverter(ULocaleConverter.CONVERTER);
    public static final Converter<String, LanguageCode> LANGUAGE_CODE = new LanguageCodeConverter();
    public static final Converter<String, Locale> STRING_JAVA_LOCALE = LANGUAGE_CODE.andThen(JAVA_LOCALE.reverse());
    public static final Converter<String, RegionCode> REGION_CODE = new RegionCodeConverter();
    public static final Converter<String, LanguageCode> ISO_639_2B_LANGUAGE_CODE = Converters.asConverter(Iso6392Converters.BibliographicConverter.CONVERTER);
    public static final Converter<String, LanguageCode> ISO_639_2T_LANGUAGE_CODE = Converters.asConverter(Iso6392Converters.TerminologicalConverter.CONVERTER);

    public static <G, O> Converter<O, G> asConverter(CodeConverter<G, O> codeConverter) {
        return new IdentifierConverter<O, G>(Preconditions.checkNotNull(codeConverter));
    }

    private Converters() {
    }

    private static class RegionCodeConverter
    extends Converter<String, RegionCode> {
        private RegionCodeConverter() {
        }

        @Override
        protected RegionCode doForward(String input) {
            return RegionCode.forString(input);
        }

        @Override
        protected String doBackward(RegionCode input) {
            return input.toString();
        }

        public String toString() {
            return "RegionCodeConverter";
        }
    }

    private static class LanguageCodeConverter
    extends Converter<String, LanguageCode> {
        private LanguageCodeConverter() {
        }

        @Override
        protected LanguageCode doForward(String input) {
            return LanguageCode.forString(input);
        }

        @Override
        protected String doBackward(LanguageCode input) {
            return input.toString();
        }

        public String toString() {
            return "LanguageCodeConverter";
        }
    }

    private static class IdentifierConverter<O, G>
    extends Converter<O, G> {
        private final CodeConverter<G, O> codeConverter;

        public IdentifierConverter(CodeConverter<G, O> codeConverter) {
            this.codeConverter = codeConverter;
        }

        @Override
        protected G doForward(O other) {
            return this.codeConverter.fromOther(other);
        }

        @Override
        protected O doBackward(G googleCode) {
            return this.codeConverter.toOther(googleCode);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IdentifierConverter) {
                IdentifierConverter that = (IdentifierConverter)obj;
                return this.codeConverter.equals(that.codeConverter);
            }
            return false;
        }

        public int hashCode() {
            return this.codeConverter.hashCode();
        }

        public String toString() {
            return "CodeConverter(" + this.codeConverter + ")";
        }
    }
}

