/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.base.Preconditions;
import com.google.common.money.CurrencyCode;
import com.google.i18n.identifiers.RegionCode;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;

public interface CurrencyInfo {
    public static final DateRangeLSComparator LSCOMPARATOR = new DateRangeLSComparator();

    public Set<RegionCode> getRegionsCurrentlyUsingCurrency(CurrencyCode var1);

    public Set<RegionCode> getRegionsThatEverUsedCurrency(CurrencyCode var1);

    public Set<RegionCode> getRegionsUsingCurrencyOn(CurrencyCode var1, LocalDate var2);

    public Set<CurrencyCode> getCurrenciesInUseOn(LocalDate var1);

    public Set<CurrencyCode> getCurrenciesInUseInRegionOn(RegionCode var1, LocalDate var2);

    public Set<CurrencyCode> getCurrenciesInCurrentUse();

    public SortedSet<DateRange> getDatesInUse(CurrencyCode var1);

    public SortedSet<DateRange> getDatesInUseInRegion(CurrencyCode var1, RegionCode var2);

    public boolean inCurrentUse(CurrencyCode var1);

    public boolean inUseOn(CurrencyCode var1, LocalDate var2);

    public boolean inCurrentUseInRegion(CurrencyCode var1, RegionCode var2);

    public boolean inUseInRegionOn(CurrencyCode var1, RegionCode var2, LocalDate var3);

    public CurrencyCode getCurrency(RegionCode var1, LocalDate var2);

    public static class DateRangeLSComparator
    implements Comparator<DateRange> {
        private int compareLimits(LocalDate lhs, LocalDate rhs) {
            if (lhs == null) {
                if (rhs == null) {
                    return 0;
                }
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return -lhs.compareTo(rhs);
        }

        private int compareStarts(LocalDate lhs, LocalDate rhs) {
            if (lhs == null) {
                if (rhs == null) {
                    return 0;
                }
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            return -lhs.compareTo(rhs);
        }

        @Override
        public int compare(DateRange lhs, DateRange rhs) {
            int result = this.compareLimits(lhs.limit, rhs.limit);
            if (result == 0) {
                result = this.compareStarts(lhs.start, rhs.start);
            }
            return result;
        }
    }

    public static class DateRange {
        public final LocalDate start;
        public final LocalDate limit;

        public DateRange(@Nullable LocalDate start, @Nullable LocalDate limit) {
            if (start != null && limit != null && limit.isBefore(start)) {
                throw new IllegalArgumentException("limit before start");
            }
            this.start = start;
            this.limit = limit;
        }

        public boolean contains(LocalDate date) {
            Preconditions.checkNotNull(date);
            return !(this.limit != null && !date.isBefore(this.limit) || this.start != null && date.isBefore(this.start));
        }

        public boolean contains(DateRange range) {
            Preconditions.checkNotNull(range);
            if (this.limit == null) {
                if (this.start == null) {
                    return true;
                }
                return range.start != null && !range.start.isBefore(this.start);
            }
            if (this.start == null) {
                return range.limit != null && !this.limit.isBefore(range.limit);
            }
            return range.start != null && range.limit != null && !range.start.isBefore(this.start) && !this.limit.isBefore(range.limit);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.limit);
        }

        public boolean equals(Object rhs) {
            return rhs instanceof DateRange && this.equals((DateRange)rhs);
        }

        public boolean equals(DateRange rhs) {
            return rhs != null && Objects.equals(this.start, rhs.start) && Objects.equals(this.limit, rhs.limit);
        }

        public String toString() {
            if (this.start == null) {
                if (this.limit == null) {
                    return "always";
                }
                String string = String.valueOf(this.limit);
                return new StringBuilder(6 + String.valueOf(string).length()).append("until ").append(string).toString();
            }
            if (this.limit == null) {
                String string = String.valueOf(this.start);
                return new StringBuilder(6 + String.valueOf(string).length()).append("since ").append(string).toString();
            }
            String string = String.valueOf(this.start);
            String string2 = String.valueOf(this.limit);
            return new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length()).append("from ").append(string).append(" to ").append(string2).toString();
        }
    }
}

