/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtIncompatible;
import com.google.i18n.identifiers.CaseNormalizingStringConverter;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.RegionCode;
import java.util.regex.Pattern;

@GwtIncompatible
public final class Iso3166Alpha3RegionConverter
extends CaseNormalizingStringConverter<RegionCode> {
    static final Pattern WELL_FORMED_PATTERN = Pattern.compile("[A-Z][A-Z][A-Z]");
    public static final Iso3166Alpha3RegionConverter CONVERTER = new Iso3166Alpha3RegionConverter();

    @Override
    public RegionCode getUnknown() {
        return RegionCode.ZZ;
    }

    @Override
    public CodeConverter.Status getStatusFromOther(String otherCode) {
        if (!WELL_FORMED_PATTERN.matcher(otherCode = this.normalize(otherCode)).matches()) {
            return CodeConverter.Status.ILL_FORMED;
        }
        RegionCode result = (RegionCode)((Object)this.mapFromString.get(otherCode));
        if (result != null) {
            CodeConverter.Status googleStatus = result.getStatus();
            return googleStatus;
        }
        return CodeConverter.Status.INVALID;
    }

    @Override
    public CodeConverter.Status getStatus(RegionCode googleCode) {
        char firstChar = googleCode.toString().charAt(0);
        if (firstChar >= '0' && firstChar <= '9') {
            return CodeConverter.Status.ILL_FORMED;
        }
        CodeConverter.Status googleStatus = googleCode.getStatus();
        if (googleStatus == CodeConverter.Status.PRIVATE_USE) {
            return CodeConverter.Status.PRIVATE_USE;
        }
        String otherCode = (String)this.mapToString.get((Object)googleCode);
        if (otherCode == null) {
            return CodeConverter.Status.INVALID;
        }
        return googleStatus;
    }

    private Iso3166Alpha3RegionConverter() {
        this.style = CaseNormalizingStringConverter.CaseNormalizingStyle.UPPER;
        this.add("QUU", RegionCode.QU);
        this.add("ASC", RegionCode.AC);
        this.add("AND", RegionCode.AD);
        this.add("ARE", RegionCode.AE);
        this.add("AFG", RegionCode.AF);
        this.add("ATG", RegionCode.AG);
        this.add("AIA", RegionCode.AI);
        this.add("ALB", RegionCode.AL);
        this.add("ARM", RegionCode.AM);
        this.add("ANT", RegionCode.AN);
        this.add("AGO", RegionCode.AO);
        this.add("ATA", RegionCode.AQ);
        this.add("ARG", RegionCode.AR);
        this.add("ASM", RegionCode.AS);
        this.add("AUT", RegionCode.AT);
        this.add("AUS", RegionCode.AU);
        this.add("ABW", RegionCode.AW);
        this.add("ALA", RegionCode.AX);
        this.add("AZE", RegionCode.AZ);
        this.add("BIH", RegionCode.BA);
        this.add("BRB", RegionCode.BB);
        this.add("BGD", RegionCode.BD);
        this.add("BEL", RegionCode.BE);
        this.add("BFA", RegionCode.BF);
        this.add("BGR", RegionCode.BG);
        this.add("BHR", RegionCode.BH);
        this.add("BDI", RegionCode.BI);
        this.add("BEN", RegionCode.BJ);
        this.add("BLM", RegionCode.BL);
        this.add("BMU", RegionCode.BM);
        this.add("BRN", RegionCode.BN);
        this.add("BOL", RegionCode.BO);
        this.add("BES", RegionCode.BQ);
        this.add("BRA", RegionCode.BR);
        this.add("BHS", RegionCode.BS);
        this.add("BTN", RegionCode.BT);
        this.add("BUR", RegionCode.BU);
        this.add("BVT", RegionCode.BV);
        this.add("BWA", RegionCode.BW);
        this.add("BLR", RegionCode.BY);
        this.add("BLZ", RegionCode.BZ);
        this.add("CAN", RegionCode.CA);
        this.add("CCK", RegionCode.CC);
        this.add("COD", RegionCode.CD);
        this.add("CAF", RegionCode.CF);
        this.add("COG", RegionCode.CG);
        this.add("CHE", RegionCode.CH);
        this.add("CIV", RegionCode.CI);
        this.add("COK", RegionCode.CK);
        this.add("CHL", RegionCode.CL);
        this.add("CMR", RegionCode.CM);
        this.add("CHN", RegionCode.CN);
        this.add("COL", RegionCode.CO);
        this.add("CPT", RegionCode.CP);
        this.add("CRI", RegionCode.CR);
        this.add("SCG", RegionCode.CS);
        this.add("CUB", RegionCode.CU);
        this.add("CPV", RegionCode.CV);
        this.add("CUW", RegionCode.CW);
        this.add("CXR", RegionCode.CX);
        this.add("CYP", RegionCode.CY);
        this.add("CZE", RegionCode.CZ);
        this.add("DDR", RegionCode.DD);
        this.add("DEU", RegionCode.DE);
        this.add("DGA", RegionCode.DG);
        this.add("DJI", RegionCode.DJ);
        this.add("DNK", RegionCode.DK);
        this.add("DMA", RegionCode.DM);
        this.add("DOM", RegionCode.DO);
        this.add("DZA", RegionCode.DZ);
        this.add("ECU", RegionCode.EC);
        this.add("EST", RegionCode.EE);
        this.add("EGY", RegionCode.EG);
        this.add("ESH", RegionCode.EH);
        this.add("ERI", RegionCode.ER);
        this.add("ESP", RegionCode.ES);
        this.add("ETH", RegionCode.ET);
        this.add("QUU", RegionCode.EU);
        this.add("FIN", RegionCode.FI);
        this.add("FJI", RegionCode.FJ);
        this.add("FLK", RegionCode.FK);
        this.add("FSM", RegionCode.FM);
        this.add("FRO", RegionCode.FO);
        this.add("FRA", RegionCode.FR);
        this.add("FXX", RegionCode.FX);
        this.add("GAB", RegionCode.GA);
        this.add("GBR", RegionCode.GB);
        this.add("GRD", RegionCode.GD);
        this.add("GEO", RegionCode.GE);
        this.add("GUF", RegionCode.GF);
        this.add("GGY", RegionCode.GG);
        this.add("GHA", RegionCode.GH);
        this.add("GIB", RegionCode.GI);
        this.add("GRL", RegionCode.GL);
        this.add("GMB", RegionCode.GM);
        this.add("GIN", RegionCode.GN);
        this.add("GLP", RegionCode.GP);
        this.add("GNQ", RegionCode.GQ);
        this.add("GRC", RegionCode.GR);
        this.add("SGS", RegionCode.GS);
        this.add("GTM", RegionCode.GT);
        this.add("GUM", RegionCode.GU);
        this.add("GNB", RegionCode.GW);
        this.add("GUY", RegionCode.GY);
        this.add("HKG", RegionCode.HK);
        this.add("HMD", RegionCode.HM);
        this.add("HND", RegionCode.HN);
        this.add("HRV", RegionCode.HR);
        this.add("HTI", RegionCode.HT);
        this.add("HUN", RegionCode.HU);
        this.add("IDN", RegionCode.ID);
        this.add("IRL", RegionCode.IE);
        this.add("ISR", RegionCode.IL);
        this.add("IMN", RegionCode.IM);
        this.add("IND", RegionCode.IN);
        this.add("IOT", RegionCode.IO);
        this.add("IRQ", RegionCode.IQ);
        this.add("IRN", RegionCode.IR);
        this.add("ISL", RegionCode.IS);
        this.add("ITA", RegionCode.IT);
        this.add("JEY", RegionCode.JE);
        this.add("JAM", RegionCode.JM);
        this.add("JOR", RegionCode.JO);
        this.add("JPN", RegionCode.JP);
        this.add("KEN", RegionCode.KE);
        this.add("KGZ", RegionCode.KG);
        this.add("KHM", RegionCode.KH);
        this.add("KIR", RegionCode.KI);
        this.add("COM", RegionCode.KM);
        this.add("KNA", RegionCode.KN);
        this.add("PRK", RegionCode.KP);
        this.add("KOR", RegionCode.KR);
        this.add("KWT", RegionCode.KW);
        this.add("CYM", RegionCode.KY);
        this.add("KAZ", RegionCode.KZ);
        this.add("LAO", RegionCode.LA);
        this.add("LBN", RegionCode.LB);
        this.add("LCA", RegionCode.LC);
        this.add("LIE", RegionCode.LI);
        this.add("LKA", RegionCode.LK);
        this.add("LBR", RegionCode.LR);
        this.add("LSO", RegionCode.LS);
        this.add("LTU", RegionCode.LT);
        this.add("LUX", RegionCode.LU);
        this.add("LVA", RegionCode.LV);
        this.add("LBY", RegionCode.LY);
        this.add("MAR", RegionCode.MA);
        this.add("MCO", RegionCode.MC);
        this.add("MDA", RegionCode.MD);
        this.add("MNE", RegionCode.ME);
        this.add("MAF", RegionCode.MF);
        this.add("MDG", RegionCode.MG);
        this.add("MHL", RegionCode.MH);
        this.add("MKD", RegionCode.MK);
        this.add("MLI", RegionCode.ML);
        this.add("MMR", RegionCode.MM);
        this.add("MNG", RegionCode.MN);
        this.add("MAC", RegionCode.MO);
        this.add("MNP", RegionCode.MP);
        this.add("MTQ", RegionCode.MQ);
        this.add("MRT", RegionCode.MR);
        this.add("MSR", RegionCode.MS);
        this.add("MLT", RegionCode.MT);
        this.add("MUS", RegionCode.MU);
        this.add("MDV", RegionCode.MV);
        this.add("MWI", RegionCode.MW);
        this.add("MEX", RegionCode.MX);
        this.add("MYS", RegionCode.MY);
        this.add("MOZ", RegionCode.MZ);
        this.add("NAM", RegionCode.NA);
        this.add("NCL", RegionCode.NC);
        this.add("NER", RegionCode.NE);
        this.add("NFK", RegionCode.NF);
        this.add("NGA", RegionCode.NG);
        this.add("NIC", RegionCode.NI);
        this.add("NLD", RegionCode.NL);
        this.add("NOR", RegionCode.NO);
        this.add("NPL", RegionCode.NP);
        this.add("NRU", RegionCode.NR);
        this.add("NTZ", RegionCode.NT);
        this.add("NIU", RegionCode.NU);
        this.add("NZL", RegionCode.NZ);
        this.add("OMN", RegionCode.OM);
        this.add("PAN", RegionCode.PA);
        this.add("PER", RegionCode.PE);
        this.add("PYF", RegionCode.PF);
        this.add("PNG", RegionCode.PG);
        this.add("PHL", RegionCode.PH);
        this.add("PAK", RegionCode.PK);
        this.add("POL", RegionCode.PL);
        this.add("SPM", RegionCode.PM);
        this.add("PCN", RegionCode.PN);
        this.add("PRI", RegionCode.PR);
        this.add("PSE", RegionCode.PS);
        this.add("PRT", RegionCode.PT);
        this.add("PLW", RegionCode.PW);
        this.add("PRY", RegionCode.PY);
        this.add("QAT", RegionCode.QA);
        this.add("QOO", RegionCode.QO);
        this.add("REU", RegionCode.RE);
        this.add("ROU", RegionCode.RO);
        this.add("SRB", RegionCode.RS);
        this.add("RUS", RegionCode.RU);
        this.add("RWA", RegionCode.RW);
        this.add("SAU", RegionCode.SA);
        this.add("SLB", RegionCode.SB);
        this.add("SYC", RegionCode.SC);
        this.add("SDN", RegionCode.SD);
        this.add("SWE", RegionCode.SE);
        this.add("SGP", RegionCode.SG);
        this.add("SHN", RegionCode.SH);
        this.add("SVN", RegionCode.SI);
        this.add("SJM", RegionCode.SJ);
        this.add("SVK", RegionCode.SK);
        this.add("SLE", RegionCode.SL);
        this.add("SMR", RegionCode.SM);
        this.add("SEN", RegionCode.SN);
        this.add("SOM", RegionCode.SO);
        this.add("SUR", RegionCode.SR);
        this.add("SSD", RegionCode.SS);
        this.add("STP", RegionCode.ST);
        this.add("SUN", RegionCode.SU);
        this.add("SLV", RegionCode.SV);
        this.add("SXM", RegionCode.SX);
        this.add("SYR", RegionCode.SY);
        this.add("SWZ", RegionCode.SZ);
        this.add("TAA", RegionCode.TA);
        this.add("TCA", RegionCode.TC);
        this.add("TCD", RegionCode.TD);
        this.add("ATF", RegionCode.TF);
        this.add("TGO", RegionCode.TG);
        this.add("THA", RegionCode.TH);
        this.add("TJK", RegionCode.TJ);
        this.add("TKL", RegionCode.TK);
        this.add("TLS", RegionCode.TL);
        this.add("TKM", RegionCode.TM);
        this.add("TUN", RegionCode.TN);
        this.add("TON", RegionCode.TO);
        this.add("TMP", RegionCode.TP);
        this.add("TUR", RegionCode.TR);
        this.add("TTO", RegionCode.TT);
        this.add("TUV", RegionCode.TV);
        this.add("TWN", RegionCode.TW);
        this.add("TZA", RegionCode.TZ);
        this.add("UKR", RegionCode.UA);
        this.add("UGA", RegionCode.UG);
        this.add("UMI", RegionCode.UM);
        this.add("USA", RegionCode.US);
        this.add("URY", RegionCode.UY);
        this.add("UZB", RegionCode.UZ);
        this.add("VAT", RegionCode.VA);
        this.add("VCT", RegionCode.VC);
        this.add("VEN", RegionCode.VE);
        this.add("VGB", RegionCode.VG);
        this.add("VIR", RegionCode.VI);
        this.add("VNM", RegionCode.VN);
        this.add("VUT", RegionCode.VU);
        this.add("WLF", RegionCode.WF);
        this.add("WSM", RegionCode.WS);
        this.add("XAA", RegionCode.XA);
        this.add("XBB", RegionCode.XB);
        this.add("XCC", RegionCode.XC);
        this.add("XKK", RegionCode.XK);
        this.add("YMD", RegionCode.YD);
        this.add("YEM", RegionCode.YE);
        this.add("MYT", RegionCode.YT);
        this.add("YUG", RegionCode.YU);
        this.add("ZAF", RegionCode.ZA);
        this.add("ZMB", RegionCode.ZM);
        this.add("ZAR", RegionCode.ZR);
        this.add("ZWE", RegionCode.ZW);
        this.add("ZZZ", RegionCode.ZZ);
    }
}

