/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.ScriptCode;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@GwtCompatible(serializable=true, emulated=true)
public final class LanguageCode
implements Serializable {
    private static final long serialVersionUID = 4941694820054215767L;
    private static final ImmutableSet<String> GOOGLE_VARIANTS = ImmutableSet.of("x-bork", "x-elmer", "x-hacker", "x-klingon", "x-piglatin", "x-pirate", new String[0]);
    private static final CharMatcher ALPHA_MATCHER = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z'));
    private static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange('0', '9');
    private static final CharMatcher ALPHANUM_MATCHER = ALPHA_MATCHER.or(DIGIT_MATCHER);
    private static final CharMatcher BCP47CHARS_MATCHER = ALPHANUM_MATCHER.or(CharMatcher.anyOf("-_@=,;"));
    private static final String SPACE_SPLITTER = "\\s+";
    private static final ImmutableMap<String, String> GRANDFATHERED_TO_LANGUAGE_TAG_MAP = ImmutableMap.builder().put("art-lojban", "jbo").put("cel-gaulish", "xtg").put("en-gb-oed", "en-gb").put("i-ami", "ami").put("i-bnn", "bnn").put("i-default", "en").put("i-enochian", "und").put("i-hak", "hak").put("i-klingon", "tlh").put("i-lux", "lb").put("i-navajo", "nv").put("i-mingo", "see").put("i-pwn", "pwn").put("i-tao", "tao").put("i-tay", "tay").put("i-tsu", "tsu").put("no-bok", "nb").put("no-nyn", "nn").put("sgn-be-fr", "sfb").put("sgn-be-nl", "vgt").put("sgn-ch-de", "sgg").put("zh-hakka", "hak").put("zh-min", "nan").put("zh-min-nan", "nan").put("zh-xiang", "hsn").put("zh-guoyu", "zh").put("xx-bork", "x-bork").put("xx-elmer", "x-elmer").put("xx-hacker", "x-hacker").put("xx-klingon", "x-klingon").put("xx-piglatin", "x-piglatin").put("xx-pirate", "x-pirate").build();
    private static final long[] VALID_LANGUAGE_SUBTAGS_BITSET = new long[]{653050289651594291L, 2046904206941770596L, 4918777969281404036L, -9222241342064048496L, -4607718633263074287L, 6998669178843237997L, 4503599677849664L, -7245086770628312640L, 1153207661131743315L, 4683743613002187776L, -1161963955879279616L, -5769111407270297857L, -8702794008335614081L, -4437667315974145L, -9008753356546817L, -36507222025L, -1519344680961L, -4502725098273L, -8388625L, 5331828609745109693L, 2059264327679082609L, -18088062L, -2882303761517641729L, -8798240505857L, -4404488962049L, -288230376151777281L, -54043204118380545L, -17592186896449L, -9007201402224705L, -1152921513330999297L, -18577348496457729L, 0x7FFFFFFFFFFFEFFFL, -862444974915192833L, 293367856114702799L, -58551502439693056L, 7530944079674485577L, -4546430736122611777L, -8800040273259818127L, -288235044781128109L, -254325958146818049L, 576560807996825597L, 2305847408065511424L, -1158005681270488551L, -283277255581368251L, -1811027592342263875L, -9007271235399059L, 941261533752674812L, 8496213758287044352L, 137443081947L, -4605325182638785536L, 2243003708587362L, 91813318656L, 4504292812681547L, 432345583841181696L, 0x4440000100000001L, 4611687668902854656L, 6124895494340083712L, 5716530566808011485L, 2251800834878429L, -7966797372074229756L, 754777458955112467L, 4611686053391110144L, 4612811987590578176L, 2306857583215902724L, 0x40000000L, 0x4400020000L, 6523482751943835680L, 6936106650981892096L, 1416241843552394L, 17320579200L, 4647996562351326208L, 88721508800659456L, 0x1100800L, -1152921504606846976L, 2899471536073211903L, 4490648421891308554L, -5596749015482760960L, 327988982892589113L, -8235595812133871591L, -2305843460722655469L, -882386599604617145L, 4612816612604575701L, 9169819830981746672L, 2852944602032298547L, 1146166100871364688L, 576460752438706560L, 1165633L, 6911688972704153856L, -4593037132988940086L, -8185292597640167418L, 76561429586112593L, -8634689867801952256L, -9009239091576766L, 4399397113939L, 0xC000010000L, -9132017503719256064L, 515471311368L, 595733345443581120L, 1766818574841741828L, 1284499025727131649L, 144305357350545L, 4971973988634067026L, 8392486999132772708L, 576461302076018617L, 4503737335043072L, -6953910215982970876L, 1171147009372560451L, 112437887488L, -2377618853396725472L, 3242609358256814425L, 2649850575172142081L, -9223296857669627859L, 29273449151070240L, -175921860444159872L, 17592194441566L, 0x1000011000000L, -144997093376L, -17592320262145L, -1L, -37658273267715L, -4097L, -144115325514809345L, -561L, -4198401L, -137440002049L, -1099511627777L, -4611686018427387905L, -4586481020064374825L, -9221120237057835022L, 517456979939831808L, -5047688402502692865L, -864692066905501209L, 324259170911121199L, -6199956953028878312L, 4396947485091536280L, -4211692140469190657L, 35463544963077L, -4521348718657374L, -281474976710657L, -524289L, -144115190223339521L, -72057594172145673L, -1073742881L, -36028799166457859L, -1099515822081L, 9150188534185852927L, -1L, -34359738385L, -8796629905409L, 2882154227934690281L, -180143985095849952L, -109794825976414210L, -3436687917185L, -585468089013895169L, -730425931396212112L, -741450993268434326L, 1544736055234658303L, -2040657455067L, 4612284154301666349L, 6922037095116637847L, 6198378054331400192L, 144133192578764864L, 7257128428550230400L, -5056188063098574512L, 297607028596033591L, -4537940020312408064L, 863389323914392L, 0x900000002L, 1125968643137536L, -848926659846657L, -6494196134049659861L, 8246445873408516167L, 2305847402898071263L, -4620697891647910800L, -2350931782056026241L, -270198312307571586L, -549344598185508873L, 3458764530393775966L, 3463268130628052756L, -68711087724L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, 8925852986471612415L, 1444547816125818238L, 34360885154L, 615778051157760L, 4274760471313121282L, 99713678730854670L, 360316798832222224L, 19345715216L, -8651121721924911617L, 8724153645L, 2377902321777574912L, 3409230303492L, 4503608219746320L, -145258680135183328L, -2522598584029806593L, 289558586197736443L, -4611686568736858351L, -576716117788066305L, -4612813020011169793L, -757739502654586883L, -9150402198497537L, -759419487437979649L, -28443336638735L, 1719363304848748889L, -34636621526L, -40567581054083073L, -126118203443904523L, 575897793758981951L, -1143510217436699L, -1152930302847352961L, -575617427463766593L, -1688849860264869L, -1123650323234160641L, 7484127013533382001L, 565054600555409L, 294243024931L, 4611756387175787844L, 36034296188960768L, -4539628149473804288L, 8004287699032561036L, 4400809317953L, -4612319337124954108L, 20829440611549694L, 281484170699520L, 0x1000000000L, 1155515235105310720L, 0L, 186380L, 3181911883993055392L, 437537176813568L, 166637548288803104L, 0xA00000L, 40532607099994112L, 2304576372867074L, 0x100000L, -1152921504606846976L, 72369751942234111L, 427592187557519360L, 1226474714755498000L, 70745157754944L, 1871203268161439755L, 5077104154713230535L, 8268608915852230673L, 24347817501916607L, 216172782577486001L, 2382458078949032512L, 9043227360270221328L, 1513587326916692941L, -5764607505341068736L, -6268150313329024106L, -281543159314138L, -7552536579407529897L, 5187536834629258361L, -5048134112128794623L, 1943949614591234943L, 37336003871081536L, 162693670645203589L, -9196315362092646416L, -2111818720318586712L, 2618448462936539155L, 65953485295648L, -843891335835598592L, 4414096474089521117L, -4611685984003486324L, 2307257978879811396L, 144115728100357378L, 1196685335930945L, -9008298748534496L, -9223372002207719341L, 549519360L, 229692662706538544L, -5887137098833444292L, 7493989775939765283L, -69866094587887L, 1158411383344206079L, 3495188508295897536L, 0x1000000100L, 577587349104361472L};
    private static final ImmutableSet<String> VALID_VARIANT_SUBTAGS = ImmutableSet.copyOf("polytoni posix revised saaho pseudo psaccent psbidi pscrack 1606nict 1694acad 1901 1959acad 1994 1996 abl1943 akuapem alalc97 aluku ao1990 aranes arevela arevmda asante auvern baku1926 balanka barla basiceng bauddha biscayan biske bohoric boont cisaup colb1945 cornu creiss dajnko ekavsk emodeng fonipa fonkirsh fonnapa fonupa fonxsamp gascon grclass grital grmistr hepburn heploc hognorsk hsistemo ijekavsk itihasa ivanchov jauer jyutping kkcor kociewie kscor laukika lemosin lengadoc lipaw luna1918 metelko monoton ndyuka nedis newfound nicard njiva nulik osojs oxendict pahawh2 pahawh3 pahawh4 pamaka petr1708 pinyin polyton provenc puter rigik rozaj rumgr scotland scouse simple solba sotav spanglis surmiran sursilv sutsilv tarask uccor ucrcor ulster unifon vaidika valencia vallader vivaraup wadegile xsistemo".split("\\s+"));
    private static final String COMMA_SPACE_SPLITTER = ",\\s*";
    private static final Map<String, String> ALIAS_MAP = LanguageCode.mapFromString("x-klingon:tlh, aju:jrb, als:sq, arb:ar, art_lojban:jbo, ayr:ay, az_AZ:az_Latn_AZ, azj:az, bcc:bal, bcl:bik, bh:bho, bs_BA:bs_Latn_BA, bxk:luy, bxr:bua, cld:syr, cmn:zh, cnr:sr_ME, cwd:cr, dgo:doi, dhd:mwr, dik:din, diq:zza, ekk:et, emk:man, esk:ik, fat:ak, fuc:ff, gaz:om, gbo:grb, gno:gon, gug:gn, gya:gba, ha_Latn_GH:ha_GH, ha_Latn_NE:ha_NE, ha_Latn_NG:ha_NG, hdn:hai, he:iw, hea:hmn, him:srx, i_ami:ami, i_bnn:bnn, i_hak:hak, i_klingon:tlh, i_lux:lb, i_navajo:nv, i_pwn:pwn, i_tao:tao, i_tay:tay, i_tsu:tsu, ike:iu, in:id, ji:yi, jw:jv, khk:mn, kk_Cyrl_KZ:kk_KZ, kmr:ku, knc:kr, kng:kg, knn:kok, kpv:kv, ks_Arab_IN:ks_IN, ky_Cyrl_KG:ky_KG, lbk:bnc, lvs:lv, mhr:chm, mn_Cyrl_MN:mn_MN, mnk:man, mo:ro_MD, ms_Latn_BN:ms_BN, ms_Latn_MY:ms_MY, ms_Latn_SG:ms_SG, mup:raj, nb:no, no_bok:nb, no_nyn:nn, npi:ne, ojg:oj, ory:or, pa_IN:pa_Guru_IN, pa_PK:pa_Arab_PK, pbu:ps, pes:fa, plt:mg, pnb:lah, quz:qu, rmy:rom, scc:sr, scr:hr, sgn_BE_FR:sfb, sgn_BE_NL:vgt, sgn_CH_DE:sgg, sh:sr_Latn, shi_MA:shi_Tfng_MA, spy:kln, sr_BA:sr_Cyrl_BA, sr_ME:sr_Latn_ME, sr_RS:sr_Cyrl_RS, sr_XK:sr_Cyrl_XK, src:sc, swh:sw, tl:fil, ttq:tmh, tw:ak, tzm_Latn_MA:tzm_MA, ug_Arab_CN:ug_CN, umu:del, uz_AF:uz_Arab_AF, uz_UZ:uz_Latn_UZ, uzn:uz, vai_LR:vai_Vaii_LR, xpe:kpe, xsl:den, ydd:yi, yue_CN:yue_Hans_CN, yue_HK:yue_Hant_HK, zai:zap, zh_CN:zh_Hans_CN, zh_HK:zh_Hant_HK, zh_MO:zh_Hant_MO, zh_SG:zh_Hans_SG, zh_TW:zh_Hant_TW, zh_guoyu:zh, zh_hakka:hak, zh_min_nan:nan, zh_xiang:hsn, zsm:ms, zyb:za");
    private static final Map<String, ImmutableSet<String>> VALID_EXTLANG_PREFIX_MAP = LanguageCode.setMapFromString("ar, aao, abh, abv, acm, acq, acw, acx, acy, adf, aeb, aec, afb, ajp, apc, apd, arb, arq,ars, ary, arz, auz, avl, ayh, ayl, ayn, ayp, bbz, pga, shu, ssh;kok, gom, knn;lv, ltg,lvs;ms, bjn, btj, bve, bvu, coa, dup, hji, jak, jax, kvb, kvr, kxd, lce, lcf, liw, max,meo, mfa, mfb, min, mqg, msi, mui, orn, ors, pel, pse, tmw, urk, vkk, vkt, xmm, zlm,zmi, zsm;sgn, ads, aed, aen, afg, ase, asf, asp, asq, asw, bfi, bfk, bog, bqn, bqy, bvl,bzs, cds, csc, csd, cse, csf, csg, csl, csn, csq, csr, doq, dse, dsl, ecs, esl, esn,eso, eth, fcs, fse, fsl, fss, gds, gse, gsg, gsm, gss, gus, hab, haf, hds, hks, hos,hps, hsh, hsl, icl, iks, ils, inl, ins, ise, isg, isr, jcs, jhs, jls, jos, jsl, jus,kgi, kvk, lbs, lls, lsg, lsl, lso, lsp, lst, lsy, lws, mdl, mfs, mre, msd, msr, mzc,mzg, mzy, nbs, ncs, nsi, nsl, nsp, nsr, nzs, okl, pgz, pks, prl, prz, psc, psd, psg,psl, pso, psp, psr, pys, rms, rsi, rsl, rsm, sdl, sfb, sfs, sgg, sgx, slf, sls, sqk,sqs, ssp, ssr, svk, swl, syy, szs, tse, tsm, tsq, tss, tsy, tza, ugn, ugy, ukl, uks,vgt, vsi, vsl, vsv, wbs, xki, xml, xms, yds, ygs, yhs, ysl, zib, zsl;sw, swc, swh;uz,uzn, uzs;zh, cdo, cjy, cmn, cpx, czh, czo, gan, hak, hsn, lzh, mnp, nan, wuu, yue");
    private static final Map<String, String> BCP47_EXT_MAP = LanguageCode.mapFromString("africa/abidjan:ciabj, africa/accra:ghacc, africa/addis_ababa:etadd, africa/algiers:dzalg, africa/asmara:erasm, africa/asmera:erasm, africa/bamako:mlbko, africa/bangui:cfbgf, africa/banjul:gmbjl, africa/bissau:gwoxb, africa/blantyre:mwblz, africa/brazzaville:cgbzv, africa/bujumbura:bibjm, africa/cairo:egcai, africa/casablanca:macas, africa/ceuta:esceu, africa/conakry:gncky, africa/dakar:sndkr, africa/dar_es_salaam:tzdar, africa/djibouti:djjib, africa/douala:cmdla, africa/el_aaiun:eheai, africa/freetown:slfna, africa/gaborone:bwgbe, africa/harare:zwhre, africa/johannesburg:zajnb, africa/juba:ssjub, africa/kampala:ugkla, africa/khartoum:sdkrt, africa/kigali:rwkgl, africa/kinshasa:cdfih, africa/lagos:nglos, africa/libreville:galbv, africa/lome:tglfw, africa/luanda:aolad, africa/lubumbashi:cdfbm, africa/lusaka:zmlun, africa/malabo:gqssg, africa/maputo:mzmpm, africa/maseru:lsmsu, africa/mbabane:szqmn, africa/mogadishu:somgq, africa/monrovia:lrmlw, africa/nairobi:kenbo, africa/ndjamena:tdndj, africa/niamey:nenim, africa/nouakchott:mrnkc, africa/ouagadougou:bfoua, africa/porto-novo:bjptn, africa/sao_tome:sttms, africa/timbuktu:mlbko, africa/tripoli:lytip, africa/tunis:tntun, africa/windhoek:nawdh, america/adak:usadk, america/anchorage:usanc, america/anguilla:aiaxa, america/antigua:aganu, america/araguaina:braux, america/argentina/buenos_aires:arbue, america/argentina/catamarca:arctc, america/argentina/comodrivadavia:arctc, america/argentina/cordoba:arcor, america/argentina/jujuy:arjuj, america/argentina/la_rioja:arirj, america/argentina/mendoza:armdz, america/argentina/rio_gallegos:arrgl, america/argentina/salta:arsla, america/argentina/san_juan:aruaq, america/argentina/san_luis:arluq, america/argentina/tucuman:artuc, america/argentina/ushuaia:arush, america/aruba:awaua, america/asuncion:pyasu, america/atikokan:cayzs, america/atka:usadk, america/bahia:brssa, america/bahia_banderas:mxpvr, america/barbados:bbbgi, america/belem:brbel, america/belize:bzbze, america/blanc-sablon:caybx, america/boa_vista:brbvb, america/bogota:cobog, america/boise:usboi, america/buenos_aires:arbue, america/cambridge_bay:caycb, america/campo_grande:brcgr, america/cancun:mxcun, america/caracas:veccs, america/catamarca:arctc, america/cayenne:gfcay, america/cayman:kygec, america/chicago:uschi, america/chihuahua:mxchi, america/coral_harbour:cayzs, america/cordoba:arcor, america/costa_rica:crsjo, america/creston:cacfq, america/cuiaba:brcgb, america/curacao:ancur, america/danmarkshavn:gldkshvn, america/dawson:cayda, america/dawson_creek:caydq, america/denver:usden, america/detroit:usdet, america/dominica:dmdom, america/edmonton:caedm, america/eirunepe:brern, america/el_salvador:svsal, america/ensenada:mxtij, america/fort_nelson:cafne, america/fort_wayne:usind, america/fortaleza:brfor, america/glace_bay:caglb, america/godthab:glgoh, america/goose_bay:cagoo, america/grand_turk:tcgdt, america/grenada:gdgnd, america/guadeloupe:gpbbr, america/guatemala:gtgua, america/guayaquil:ecgye, america/guyana:gygeo, america/halifax:cahal, america/havana:cuhav, america/hermosillo:mxhmo, america/indiana/indianapolis:usind, america/indiana/knox:usknx, america/indiana/marengo:usaeg, america/indiana/petersburg:uswsq, america/indiana/tell_city:ustel, america/indiana/vevay:usinvev, america/indiana/vincennes:usoea, america/indiana/winamac:uswlz, america/indianapolis:usind, america/inuvik:cayev, america/iqaluit:caiql, america/jamaica:jmkin, america/jujuy:arjuj, america/juneau:usjnu, america/kentucky/louisville:uslui, america/kentucky/monticello:usmoc, america/knox_in:usknx, america/kralendijk:bqkra, america/la_paz:bolpb, america/lima:pelim, america/los_angeles:uslax, america/louisville:uslui, america/lower_princes:sxphi, america/maceio:brmcz, america/managua:nimga, america/manaus:brmao, america/marigot:gpmsb, america/martinique:mqfdf, america/matamoros:mxmam, america/mazatlan:mxmzt, america/mendoza:armdz, america/menominee:usmnm, america/merida:mxmid, america/metlakatla:usmtm, america/mexico_city:mxmex, america/miquelon:pmmqc, america/moncton:camon, america/monterrey:mxmty, america/montevideo:uymvd, america/montreal:camtr, america/montserrat:msmni, america/nassau:bsnas, america/new_york:usnyc, america/nipigon:canpg, america/nome:usome, america/noronha:brfen, america/north_dakota/beulah:usxul, america/north_dakota/center:usndcnt, america/north_dakota/new_salem:usndnsl, america/ojinaga:mxoji, america/panama:papty, america/pangnirtung:capnt, america/paramaribo:srpbm, america/phoenix:usphx, america/port-au-prince:htpap, america/port_of_spain:ttpos, america/porto_acre:brrbr, america/porto_velho:brpvh, america/puerto_rico:prsju, america/punta_arenas:clpuq, america/rainy_river:caffs, america/rankin_inlet:cayek, america/recife:brrec, america/regina:careg, america/resolute:careb, america/rio_branco:brrbr, america/rosario:arcor, america/santa_isabel:mxstis, america/santarem:brstm, america/santiago:clscl, america/santo_domingo:dosdq, america/sao_paulo:brsao, america/scoresbysund:globy, america/shiprock:usden, america/sitka:ussit, america/st_barthelemy:gpsbh, america/st_johns:casjf, america/st_kitts:knbas, america/st_lucia:lccas, america/st_thomas:vistt, america/st_vincent:vcsvd, america/swift_current:cayyn, america/tegucigalpa:hntgu, america/thule:glthu, america/thunder_bay:cathu, america/tijuana:mxtij, america/toronto:cator, america/tortola:vgtov, america/vancouver:cavan, america/virgin:vistt, america/whitehorse:cayxy, america/winnipeg:cawnp, america/yakutat:usyak, america/yellowknife:cayzf, antarctica/casey:aqcas, antarctica/davis:aqdav, antarctica/dumontdurville:aqddu, antarctica/macquarie:aumqi, antarctica/mawson:aqmaw, antarctica/mcmurdo:aqmcm, antarctica/palmer:aqplm, antarctica/rothera:aqrot, antarctica/south_pole:nzakl, antarctica/syowa:aqsyw, antarctica/troll:aqtrl, antarctica/vostok:aqvos, arctic/longyearbyen:sjlyr, asia/aden:yeade, asia/almaty:kzala, asia/amman:joamm, asia/anadyr:rudyr, asia/aqtau:kzaau, asia/aqtobe:kzakx, asia/ashgabat:tmasb, asia/ashkhabad:tmasb, asia/atyrau:kzguw, asia/baghdad:iqbgw, asia/bahrain:bhbah, asia/baku:azbak, asia/bangkok:thbkk, asia/barnaul:rubax, asia/beirut:lbbey, asia/bishkek:kgfru, asia/brunei:bnbwn, asia/calcutta:inccu, asia/chita:ruchita, asia/choibalsan:mncoq, asia/chongqing:cnsha, asia/chungking:cnsha, asia/colombo:lkcmb, asia/dacca:bddac, asia/damascus:sydam, asia/dhaka:bddac, asia/dili:tldil, asia/dubai:aedxb, asia/dushanbe:tjdyu, asia/famagusta:cyfmg, asia/gaza:gaza, asia/harbin:cnsha, asia/hebron:hebron, asia/ho_chi_minh:vnsgn, asia/hong_kong:hkhkg, asia/hovd:mnhvd, asia/irkutsk:ruikt, asia/istanbul:trist, asia/jakarta:idjkt, asia/jayapura:iddjj, asia/jerusalem:jeruslm, asia/kabul:afkbl, asia/kamchatka:rupkc, asia/karachi:pkkhi, asia/kashgar:cnurc, asia/kathmandu:npktm, asia/katmandu:npktm, asia/khandyga:rukhndg, asia/kolkata:inccu, asia/krasnoyarsk:rukra, asia/kuala_lumpur:mykul, asia/kuching:mykch, asia/kuwait:kwkwi, asia/macao:momfm, asia/macau:momfm, asia/magadan:rugdx, asia/makassar:idmak, asia/manila:phmnl, asia/muscat:ommct, asia/nicosia:cynic, asia/novokuznetsk:runoz, asia/novosibirsk:ruovb, asia/omsk:ruoms, asia/oral:kzura, asia/phnom_penh:khpnh, asia/pontianak:idpnk, asia/pyongyang:kpfnj, asia/qatar:qadoh, asia/qyzylorda:kzkzo, asia/rangoon:mmrgn, asia/riyadh:saruh, asia/saigon:vnsgn, asia/sakhalin:ruuus, asia/samarkand:uzskd, asia/seoul:krsel, asia/shanghai:cnsha, asia/singapore:sgsin, asia/srednekolymsk:rusred, asia/taipei:twtpe, asia/tashkent:uztas, asia/tbilisi:getbs, asia/tehran:irthr, asia/tel_aviv:jeruslm, asia/thimbu:btthi, asia/thimphu:btthi, asia/tokyo:jptyo, asia/tomsk:rutof, asia/ujung_pandang:idmak, asia/ulaanbaatar:mnuln, asia/ulan_bator:mnuln, asia/urumqi:cnurc, asia/ust-nera:ruunera, asia/vientiane:lavte, asia/vladivostok:ruvvo, asia/yakutsk:ruyks, asia/yangon:mmrgn, asia/yekaterinburg:ruyek, asia/yerevan:amevn, atlantic/azores:ptpdl, atlantic/bermuda:bmbda, atlantic/canary:eslpa, atlantic/cape_verde:cvrai, atlantic/faeroe:fotho, atlantic/faroe:fotho, atlantic/jan_mayen:sjlyr, atlantic/madeira:ptfnc, atlantic/reykjavik:isrey, atlantic/south_georgia:gsgrv, atlantic/st_helena:shshn, atlantic/stanley:fkpsy, australia/act:ausyd, australia/adelaide:auadl, australia/brisbane:aubne, australia/broken_hill:aubhq, australia/canberra:ausyd, australia/currie:aukns, australia/darwin:audrw, australia/eucla:aueuc, australia/hobart:auhba, australia/lhi:auldh, australia/lindeman:auldc, australia/lord_howe:auldh, australia/melbourne:aumel, australia/north:audrw, australia/nsw:ausyd, australia/perth:auper, australia/queensland:aubne, australia/south:auadl, australia/sydney:ausyd, australia/tasmania:auhba, australia/victoria:aumel, australia/west:auper, australia/yancowinna:aubhq, brazil/acre:brrbr, brazil/denoronha:brfen, brazil/east:brsao, brazil/west:brmao, calendar:ca, canada/atlantic:cahal, canada/central:cawnp, canada/east-saskatchewan:careg, canada/eastern:cator, canada/mountain:caedm, canada/newfoundland:casjf, canada/pacific:cavan, canada/saskatchewan:careg, canada/yukon:cayxy, cf:cf, chile/continental:clscl, chile/easterisland:clipc, colalternate:ka, colbackwards:kb, colcasefirst:kf, colcaselevel:kc, colhiraganaquaternary:kh, collation:co, colnormalization:kk, colnumeric:kn, colreorder:kr, colstrength:ks, cst6cdt:cst6cdt, cuba:cuhav, currency:cu, dictionary:dict, egypt:egcai, eire:iedub, est:utcw05, est5edt:est5edt, etc/gmt:gmt, etc/gmt+0:gmt, etc/gmt+1:utcw01, etc/gmt+10:utcw10, etc/gmt+11:utcw11, etc/gmt+12:utcw12, etc/gmt+2:utcw02, etc/gmt+3:utcw03, etc/gmt+4:utcw04, etc/gmt+5:utcw05, etc/gmt+6:utcw06, etc/gmt+7:utcw07, etc/gmt+8:utcw08, etc/gmt+9:utcw09, etc/gmt-0:gmt, etc/gmt-1:utce01, etc/gmt-10:utce10, etc/gmt-11:utce11, etc/gmt-12:utce12, etc/gmt-13:utce13, etc/gmt-14:utce14, etc/gmt-2:utce02, etc/gmt-3:utce03, etc/gmt-4:utce04, etc/gmt-5:utce05, etc/gmt-6:utce06, etc/gmt-7:utce07, etc/gmt-8:utce08, etc/gmt-9:utce09, etc/gmt0:gmt, etc/greenwich:gmt, etc/uct:utc, etc/universal:utc, etc/unknown:unk, etc/utc:utc, etc/zulu:utc, ethiopic-amete-alem:ethioaa, europe/amsterdam:nlams, europe/andorra:adalv, europe/astrakhan:ruasf, europe/athens:grath, europe/belfast:gblon, europe/belgrade:rsbeg, europe/berlin:deber, europe/bratislava:skbts, europe/brussels:bebru, europe/bucharest:robuh, europe/budapest:hubud, europe/busingen:debsngn, europe/chisinau:mdkiv, europe/copenhagen:dkcph, europe/dublin:iedub, europe/gibraltar:gigib, europe/guernsey:gggci, europe/helsinki:fihel, europe/isle_of_man:imdgs, europe/istanbul:trist, europe/jersey:jesth, europe/kaliningrad:rukgd, europe/kiev:uaiev, europe/kirov:rukvx, europe/lisbon:ptlis, europe/ljubljana:silju, europe/london:gblon, europe/luxembourg:lulux, europe/madrid:esmad, europe/malta:mtmla, europe/mariehamn:fimhq, europe/minsk:bymsq, europe/monaco:mcmon, europe/moscow:rumow, europe/nicosia:cynic, europe/oslo:noosl, europe/paris:frpar, europe/podgorica:metgd, europe/prague:czprg, europe/riga:lvrix, europe/rome:itrom, europe/samara:rukuf, europe/san_marino:smsai, europe/sarajevo:basjj, europe/saratov:rurtw, europe/simferopol:uasip, europe/skopje:mkskp, europe/sofia:bgsof, europe/stockholm:sesto, europe/tallinn:eetll, europe/tirane:altia, europe/tiraspol:mdkiv, europe/ulyanovsk:ruuly, europe/uzhgorod:uauzh, europe/vaduz:livdz, europe/vatican:vavat, europe/vienna:atvie, europe/vilnius:ltvno, europe/volgograd:ruvog, europe/warsaw:plwaw, europe/zagreb:hrzag, europe/zaporozhye:uaozh, europe/zurich:chzrh, fw:fw, gb:gblon, gb-eire:gblon, gb2312han:gb2312, gmt:gmt, gmt+0:gmt, gmt-0:gmt, gmt0:gmt, greenwich:gmt, gregorian:gregory, hongkong:hkhkg, hours:hc, hst:utcw10, iceland:isrey, identical:identic, indian/antananarivo:mgtnr, indian/chagos:iodga, indian/christmas:cxxch, indian/cocos:cccck, indian/comoro:kmyva, indian/kerguelen:tfpfr, indian/mahe:scmaw, indian/maldives:mvmle, indian/mauritius:muplu, indian/mayotte:ytmam, indian/reunion:rereu, iran:irthr, islamic-civil:islamicc, israel:jeruslm, jamaica:jmkin, japan:jptyo, kv:kv, kwajalein:mhkwa, libya:lytip, mexico/bajanorte:mxtij, mexico/bajasur:mxmzt, mexico/general:mxmex, mst:utcw07, mst7mdt:mst7mdt, navajo:usden, no:false, non-ignorable:noignore, numbers:nu, nz:nzakl, nz-chat:nzcht, pacific/apia:wsapw, pacific/auckland:nzakl, pacific/bougainville:pgraw, pacific/chatham:nzcht, pacific/chuuk:fmtkk, pacific/easter:clipc, pacific/efate:vuvli, pacific/enderbury:kipho, pacific/fakaofo:tkfko, pacific/fiji:fjsuv, pacific/funafuti:tvfun, pacific/galapagos:ecgps, pacific/gambier:pfgmr, pacific/guadalcanal:sbhir, pacific/guam:gugum, pacific/honolulu:ushnl, pacific/johnston:umjon, pacific/kiritimati:kicxi, pacific/kosrae:fmksa, pacific/kwajalein:mhkwa, pacific/majuro:mhmaj, pacific/marquesas:pfnhv, pacific/midway:ummdy, pacific/nauru:nrinu, pacific/niue:nuiue, pacific/norfolk:nfnlk, pacific/noumea:ncnou, pacific/pago_pago:asppg, pacific/palau:pwror, pacific/pitcairn:pnpcn, pacific/pohnpei:fmpni, pacific/ponape:fmpni, pacific/port_moresby:pgpom, pacific/rarotonga:ckrar, pacific/saipan:mpspn, pacific/samoa:asppg, pacific/tahiti:pfppt, pacific/tarawa:kitrw, pacific/tongatapu:totbu, pacific/truk:fmtkk, pacific/wake:umawk, pacific/wallis:wfmau, pacific/yap:fmtkk, phonebook:phonebk, poland:plwaw, portugal:ptlis, prc:cnsha, primary:level1, pst8pdt:pst8pdt, quarternary:level4, quaternary:level4, roc:twtpe, rok:krsel, secondary:level2, singapore:sgsin, tertiary:level3, timezone:tz, turkey:trist, uct:utc, universal:utc, us/alaska:usanc, us/aleutian:usadk, us/arizona:usphx, us/central:uschi, us/east-indiana:usind, us/eastern:usnyc, us/hawaii:ushnl, us/indiana-starke:usknx, us/michigan:usdet, us/mountain:usden, us/pacific:uslax, us/pacific-new:uslax, us/samoa:asppg, utc:utc, variabletop:vt, w-su:rumow, yes:, zulu:utc");
    public static final char SEPARATOR = '-';
    public static final char ALTERNATE_SEPARATOR = '_';
    private static final Splitter SEPARATOR_SPLITTER = Splitter.on('-');
    private static final int BCP_47_EXTENSION_SINGLETON_LENGTH = 3;
    private static final char OLD_LDML_LOCALE_EXTENSION_SEPARATOR = ';';
    private static final Splitter OLD_LDML_LOCALE_EXTENSION_SPLITTER = Splitter.on(';');
    private static final char ALTERNATE_OLD_LDML_LOCALE_EXTENSION_SEPARATOR = ',';
    private static Map<String, LanguageCodeSupplier> frozenStrictCache = ImmutableMap.of();
    private static Map<String, LanguageCode> frozenNonStrictCache = ImmutableMap.of();
    public static final LanguageCode ROOT = LanguageCode.forString("root");
    private static final String UNKNOWN_LANGUAGE_TAG = "und";
    public static final LanguageCode UNKNOWN = LanguageCode.forString("und");
    private static final String COMMON_LANGUAGE_CODES = "en,en-US,en-us,fr,es,zh-CN,de,ja,ko,ru,ko-KR,it,pl,tr,en-GB,pt-BR,ja-JP,nl,de-DE,th,es-ES,en-gb,zh,fr-FR,pt-br,pt,de-de,zh-TW,ar,fr-fr,sv,es-es,id,zh-cn,vi,it-IT,hu,ru-RU,fi,ro,cs,tr-TR,el,pl-PL,da,nl-NL,no,it-it,en-AU,pt-PT,bg,sk,sv-SE,fa,es-mx,hr,iw,ca,lo,lt,es-MX,en-au,sr,en-CA,uk,tl,sl,es-419,da-DK,ru-ru,zh-tw,es-ar,lv,cy,en-ca,eo,tr-tr,de-CH,gl,et,ar-sa,uz,hu-hu,pt-pt,fi-FI,is-IS,he,th-TH,nl-BE,hi,es-AR,cs-CZ,fi-fi,en-IE,es-pe,sv-se,eu,ja-jp,de-AT,bg-BG,es-CO,fr-BE,fr-CA,sk-SK,el-GR,en-IN,hu-HU,ar-SA,nl-be,fr-ca,ar-eg,no-NO,mk,vi-VN,el-gr,es-co,ka,nb,nn,es-ve,es-CL,ro-RO,is,he-IL,hr-HR,fil,ms,sq,te,vi-vn,ml-IN,de-ch,de-at,es-cl,ro-ro,id-ID,ml,en-NZ,fr-be,br,nl-nl,en-nz,es-PE,nb-NO,lt-LT,th-th,ta,bs,az,sw,mr,be,af,uk-UA,en-ie,oc,es-VE,hr-hr,kr,tg-IN,ga,kn,gu-IN,gbk,lb,io,kn-IN,zh-Hans,en-ZA,my,jv,win,en-za,ar-EG,zh-HK,mn,be-TARASK,et-EE,zh-hk,sl-SI,la,sr-RS,fr-ch,*,fr-CH,en-in,hy,hi-IN,qu,en-SG,si,ht,new,lv-LV,ps,ur,mt,es-us,vo,gu,fo,es-EC,bn,en-us.,ak,us,mi-NZ,fa-IR,es-cr,ne,ab,en-sg,tt,es-US,en-MY,es-ec,da-dk,ar-ae,mi,su,ar-jo,ca-ES,kk,ar-kw,en-UK,km,ko-kr,sh,war,sr-rs,sr-cs,ar-AE,gl-ES,gd,nb-no,en-my,yo,fil-PH,en-BE,ar-iq,an,es-sv,am,et-ee,fy,zh-hant,sah,ar-KW,it-CH,ar-sy,kis,es-ES_tradnl,nds,es-gt,yue,es-pa,es-CR,scn,ast,ms-MY,pms,es-uy,ceb,ar-qa,es-do,lah,ar-JO,en-securid,pl-pl,pa,eng,en-ph,ar-IQ,zh_TW,co,ar-om,en-PH,es-GT,hk,ar-bh,dv,lmo,ar-ma,ia,iso,ar-dz,it-ch,es-DO,gsw,bo,q=0.5,zh-hans,es-PA,ar-QA,es-pr,ug,se,es-bo,rup,ksh,ee,bpy,es-SV,es-hn,ku,nan,vec,chrome://global/locale/intl.properties,nap,arz,fa-ir,ar-SY,es-HN,zh_CN,mk-MK,es-PR,yi,ar-OM,US,ar-ye,cv,map,lb-lu,li,bar,wa,es-UY,bat,sa,mo,ka-GE,pam,os,he-il,English,ar-BH,de-US,sr-Latn-RS,iw-IL,com,jw,ckb,ky,hsb,sr-SP,en-ID,ba,EN,ar-ly,sd,gv,nah,to,fr-MA,fr-LU,undefined,bn-IN,tk,vls,en-zw,ar-lb,bik,ir,zh-sg,sco,rm,fr-lu,*/*,nds-NL,bs-ba,arc,zza,en-DE,en-TV,es-ni,mg,xal,Chinese,ar-LB,es-py,hif,al,ang,chm,fiu,kw,es-BO,pi,glk,all,JA,ca-es,en-tt,wuu,sv-fi,es-PY,szl,nn-no,cs-cz,frp,ar-LY,bh,hy-AM,chr,sc,null,sq-AL,fur,en-HK,en_US,krc,nov,ilo,haw,nn-NO,or,lij,et-ET,ar-DZ,nrm,ar-MA,hy-LB,es-NI,kk-KZ,iu,lad,esl-ES,gn,en-TH,en-LV,roa,csb,so,ga-IE,tn,en-AE,dsb,en-029,stq,bs-Latn-BA,ua,ar-YE,be-BY,dz,en-TT,gd-GB,crh-Latn,wo,mwl,sv-FI,nv,zh-mo,eu-ES,zh-SG,hr-BA,sk-sk,ln,de-lu,ga-ie,ext,hr-ba,mt-MT,as,ace,es-LA,hak,ca-US,de-LU,cbk,en-ZW,mzn,ay,vn,tg,ce,fi-MH,pdc,kv,en-ES,kk-Arab,en-NO,------defaultChoice,pl-US,FR,pag,sr-Latn-CS,gh,zu,tpi,ar-tn,ch,jbo,gal-ES,es-xl,bjn,ie,mm,gae-IE,no-no,en-jm,myv,kl,zh-CH,en-IT,cu,az-AZ,zh-Cn,xx-elmer,kab,af-za,ig,sr-LT,sr-ba,hl,zh-Hant,us-EN,gl-gl,lt-lt,zea,x-ns2H8e0NniiOc6,x-ns1A54hMPT6Nhv,pap,fr-mc,xx-bork,bg-bg,pcd,sjd,tum,fj,udm,eN,GB,sv-US,sr-YU,lb-LU,fr-US,se-SE,frr,kaa,DE,ti,koi,ty,in,cr,kg,en-bz,cn,bs-BA,sl-si,CA,de-li,sr-Cyrl-RS,x-ns2Ud00Nnym7b6,ru-UA,ta-IN,xx-hacker,pt-US,en-RO,na,mdf,ar-TN,xh,za,tet,ha,x-ns1QWkLoWvlNhL,de-LI,f,sm,bm,rom,sr-ME,ny,zh-US,cdo,uk-ua,en-BR,en-DK,ks,srn,ss,en-FI,fr-DZ,ru-KZ,fr-MC,af-ZA,sg,ng,iu-CA,xx-pirate,cy-GB,gl-GL";
    public static final LanguageCode AFRIKAANS;
    public static final LanguageCode AKAN;
    public static final LanguageCode ALBANIAN;
    public static final LanguageCode AMHARIC;
    public static final LanguageCode ARABIC;
    public static final LanguageCode ARMENIAN;
    public static final LanguageCode AZERBAIJANI;
    public static final LanguageCode BASQUE;
    public static final LanguageCode BELARUSIAN;
    public static final LanguageCode BENGALI;
    public static final LanguageCode BOSNIAN;
    public static final LanguageCode BRAZILIAN_PORTUGUESE;
    public static final LanguageCode BRITISH_ENGLISH;
    public static final LanguageCode BULGARIAN;
    public static final LanguageCode BURMESE;
    public static final LanguageCode CANADA;
    public static final LanguageCode CANADA_FRENCH;
    public static final LanguageCode CANTONESE;
    public static final LanguageCode CATALAN;
    public static final LanguageCode CEBUANO;
    public static final LanguageCode CHEROKEE;
    public static final LanguageCode CHINA;
    public static final LanguageCode CHINA_CHINESE;
    public static final LanguageCode CHINA_CHINESE_SIMPLIFIED;
    public static final LanguageCode CHINESE;
    public static final LanguageCode CHINESE_SIMPLIFIED;
    public static final LanguageCode CHINESE_TRADITIONAL;
    public static final LanguageCode CROATIAN;
    public static final LanguageCode CZECH;
    public static final LanguageCode DANISH;
    public static final LanguageCode DUTCH;
    public static final LanguageCode ENGLISH;
    public static final LanguageCode ENGLISH_CANADA;
    public static final LanguageCode ENGLISH_GB;
    public static final LanguageCode ENGLISH_US;
    public static final LanguageCode ESPERANTO;
    public static final LanguageCode ESTONIAN;
    public static final LanguageCode FILIPINO;
    public static final LanguageCode FINNISH;
    public static final LanguageCode FRANCE;
    public static final LanguageCode FRENCH;
    public static final LanguageCode FRENCH_CANADA;
    public static final LanguageCode FRENCH_FRANCE;
    public static final LanguageCode GALICIAN;
    public static final LanguageCode GEORGIAN;
    public static final LanguageCode GERMAN;
    public static final LanguageCode GERMANY;
    public static final LanguageCode GERMAN_GERMANY;
    public static final LanguageCode GREEK;
    public static final LanguageCode GUJARATI;
    public static final LanguageCode HAITIAN_CREOLE;
    public static final LanguageCode HAUSA;
    public static final LanguageCode HAWAIIAN;
    public static final LanguageCode HEBREW;
    public static final LanguageCode HINDI;
    public static final LanguageCode HMONG;
    public static final LanguageCode HONGKONG_CHINESE;
    public static final LanguageCode HONGKONG_CHINESE_TRADITIONAL;
    public static final LanguageCode HUNGARIAN;
    public static final LanguageCode ICELANDIC;
    public static final LanguageCode IGBO;
    public static final LanguageCode INDONESIAN;
    public static final LanguageCode IRISH;
    public static final LanguageCode ITALIAN;
    public static final LanguageCode ITALIAN_ITALY;
    public static final LanguageCode ITALY;
    public static final LanguageCode JAPAN;
    public static final LanguageCode JAPANESE;
    public static final LanguageCode JAPANESE_JAPAN;
    public static final LanguageCode JAVANESE;
    public static final LanguageCode KANNADA;
    public static final LanguageCode KAZAKH;
    public static final LanguageCode KHMER;
    public static final LanguageCode KOREA;
    public static final LanguageCode KOREAN;
    public static final LanguageCode KOREAN_KOREA;
    public static final LanguageCode LAO;
    public static final LanguageCode LATIN;
    public static final LanguageCode LATVIAN;
    public static final LanguageCode LITHUANIAN;
    public static final LanguageCode LUXEMBOURGISH;
    public static final LanguageCode MACEDONIAN;
    public static final LanguageCode MALAGASY;
    public static final LanguageCode MALAY;
    public static final LanguageCode MALAYALAM;
    public static final LanguageCode MALTESE;
    public static final LanguageCode MAORI;
    public static final LanguageCode MARATHI;
    public static final LanguageCode MAURITIAN_CREOLE;
    public static final LanguageCode MONGOLIAN;
    public static final LanguageCode MONTENEGRIN;
    public static final LanguageCode NEPALI;
    public static final LanguageCode NORWEGIAN;
    public static final LanguageCode NO_LANGUAGE;
    public static final LanguageCode NYANJA;
    public static final LanguageCode ORIYA;
    public static final LanguageCode PERSIAN;
    public static final LanguageCode POLISH;
    public static final LanguageCode PORTUGAL_PORTUGUESE;
    public static final LanguageCode PORTUGUESE;
    public static final LanguageCode PUNJABI;
    public static final LanguageCode ROMANIAN;
    public static final LanguageCode RUSSIAN;
    public static final LanguageCode SCOTTISH_GAELIC;
    public static final LanguageCode SERBIAN;
    public static final LanguageCode SESOTHO;
    public static final LanguageCode SINHALESE;
    public static final LanguageCode SLOVAK;
    public static final LanguageCode SLOVENIAN;
    public static final LanguageCode SOMALI;
    public static final LanguageCode SPANISH;
    public static final LanguageCode SPANISH_LATIN_AMERICAN;
    public static final LanguageCode SUNDANESE;
    public static final LanguageCode SWAHILI;
    public static final LanguageCode SWEDISH;
    public static final LanguageCode TAIWAN_CHINESE;
    public static final LanguageCode TAIWAN_CHINESE_TRADITIONAL;
    public static final LanguageCode TAJIK;
    public static final LanguageCode TAMIL;
    public static final LanguageCode TELUGU;
    public static final LanguageCode THAI;
    public static final LanguageCode TURKISH;
    public static final LanguageCode UK;
    public static final LanguageCode UKRAINIAN;
    public static final LanguageCode UNDEFINED;
    public static final LanguageCode URDU;
    public static final LanguageCode US;
    public static final LanguageCode UZBEK;
    public static final LanguageCode VIETNAMESE;
    public static final LanguageCode WELSH;
    public static final LanguageCode YIDDISH;
    public static final LanguageCode YORUBA;
    public static final LanguageCode ZULU;
    private transient String canonicalized;
    private transient String languageSubtag;
    private transient ScriptCode scriptSubtag;
    private transient RegionCode regionSubtag;
    private transient List<String> variants = new ArrayList<String>();
    private transient LanguageCode transformLanguage;
    private transient Map<String, String> transformOptions;
    private transient Map<String, String> options;
    private transient String privateUse;
    private transient LanguageCode parent;
    private static final int T_EXTENSION_FSEP_LENGTH = 2;
    private static final int U_EXTENSION_KEY_LENGTH = 2;

    private static Map<String, String> mapFromString(String value) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (String pair : value.split(COMMA_SPACE_SPLITTER)) {
            String[] parts = pair.split(":", 2);
            builder.put(parts[0], parts[1]);
        }
        return builder.build();
    }

    private static Map<String, ImmutableSet<String>> setMapFromString(String value) {
        ImmutableMap.Builder<String, ImmutableSet<String>> builder = ImmutableMap.builder();
        for (String group : value.split(";")) {
            String[] parts = group.split(COMMA_SPACE_SPLITTER, 2);
            builder.put(parts[0], ImmutableSet.copyOf(parts[1].split(COMMA_SPACE_SPLITTER)));
        }
        return builder.build();
    }

    private static int indexOfExtensions(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '@') {
                return i;
            }
            if (ch != '-' || i + 3 > len || ((ch = str.charAt(i + 1)) < '0' || ch > '9') && (ch < 'a' || ch > 'z') || str.charAt(i + 2) != '-') continue;
            return i;
        }
        return -1;
    }

    public static LanguageCode forString(String languageOrLocale) {
        return LanguageCode.forStringFolded(LanguageCode.getCacheKeyOfString(languageOrLocale), Leniency.NOT_LENIENT);
    }

    public static LanguageCode forStringLeniently(String languageOrLocale) {
        if (!BCP47CHARS_MATCHER.matchesAllOf(languageOrLocale)) {
            return UNKNOWN;
        }
        return LanguageCode.forStringFolded(LanguageCode.getCacheKeyOfString(languageOrLocale), Leniency.LENIENT);
    }

    public static LanguageCode forString(String languageOrLocale, CodeConverter.SynonymConversion synonymConversion) {
        languageOrLocale = LanguageCode.getCacheKeyOfString(languageOrLocale);
        if (synonymConversion == CodeConverter.SynonymConversion.FOLD_SYNONYMS) {
            return LanguageCode.forStringFolded(languageOrLocale, Leniency.NOT_LENIENT);
        }
        return LanguageCode.forStringNonFolded(languageOrLocale);
    }

    public LanguageCode getParent() {
        return this.parent;
    }

    public int getParentageLevel(LanguageCode possibleDescendant) {
        int result = 0;
        while (!LanguageCode.equals(possibleDescendant, this)) {
            if (ROOT.equals(possibleDescendant)) {
                return -1;
            }
            ++result;
            possibleDescendant = possibleDescendant.parent;
        }
        return result;
    }

    public LanguageCode getLanguageSubtag() {
        return LanguageCode.forString(this.languageSubtag, CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS);
    }

    public LanguageCode getWrittenLanguage() {
        if (this.scriptSubtag != null) {
            String string = this.languageSubtag;
            String string2 = String.valueOf((Object)this.scriptSubtag);
            return LanguageCode.forString(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('-').append(string2).toString(), CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS);
        }
        return LanguageCode.forString(this.languageSubtag, CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS);
    }

    public ScriptCode getScriptSubtag() {
        return this.scriptSubtag;
    }

    public RegionCode getRegionSubtag() {
        return this.regionSubtag;
    }

    public List<String> getVariantSubtags() {
        return this.variants;
    }

    public boolean hasRegionSubtag() {
        return this.regionSubtag != null;
    }

    public boolean hasScriptSubtag() {
        return this.scriptSubtag != null;
    }

    @VisibleForTesting
    LanguageCode getTransformLanguage() {
        return this.transformLanguage;
    }

    @VisibleForTesting
    Map<String, String> getTransformOptions() {
        return this.transformOptions;
    }

    @VisibleForTesting
    Map<String, String> getOptions() {
        return this.options;
    }

    @VisibleForTesting
    String getPrivateUse() {
        return this.privateUse;
    }

    public static boolean equals(LanguageCode a, LanguageCode b) {
        return a == b || a != null && a.equals(b);
    }

    public boolean equals(Object other) {
        return other instanceof LanguageCode && ((LanguageCode)other).canonicalized.equals(this.canonicalized);
    }

    public int hashCode() {
        return this.canonicalized.hashCode();
    }

    public String toString() {
        return this.canonicalized;
    }

    public CodeConverter.Status getStatus() {
        CodeConverter.Status regionStatus;
        CodeConverter.Status status = regionStatus = null == this.regionSubtag ? CodeConverter.Status.CANONICAL : this.regionSubtag.getStatus();
        if (GOOGLE_VARIANTS.contains(this.languageSubtag) || regionStatus == CodeConverter.Status.PRIVATE_USE) {
            return CodeConverter.Status.PRIVATE_USE;
        }
        if (!this.isCanonical()) {
            return CodeConverter.Status.NON_CANONICAL;
        }
        return CodeConverter.Status.CANONICAL;
    }

    public boolean isCanonical() {
        if (ALIAS_MAP.containsKey(this.languageSubtag)) {
            return false;
        }
        if (this.scriptSubtag != null && !this.scriptSubtag.isCanonical()) {
            return false;
        }
        return this.regionSubtag == null || this.regionSubtag.isCanonical();
    }

    private static LanguageCode forStringFolded(String name, Leniency leniency) {
        LanguageCode obj = LanguageCode.getFromFrozenCache(name, leniency);
        if (obj != null) {
            return obj;
        }
        String normalizedLanguageTag = LanguageCode.getCacheKeyOfString(name);
        if (!normalizedLanguageTag.equals(name) && (obj = LanguageCode.getFromFrozenCache(normalizedLanguageTag, leniency)) != null) {
            return obj;
        }
        return new LanguageCode(name, CodeConverter.SynonymConversion.FOLD_SYNONYMS, leniency);
    }

    private static LanguageCode forStringNonFolded(String name) {
        LanguageCode foldedObj = LanguageCode.forStringFolded(name, Leniency.NOT_LENIENT);
        String foldedName = foldedObj.getCacheKey();
        if (foldedName.equals(name) || GRANDFATHERED_TO_LANGUAGE_TAG_MAP.containsKey(name)) {
            return foldedObj;
        }
        return new LanguageCode(name, CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS, Leniency.NOT_LENIENT);
    }

    private static LanguageCode getFromFrozenCache(String name, Leniency leniency) {
        if (leniency == Leniency.NOT_LENIENT) {
            LanguageCodeSupplier cached = frozenStrictCache.get(name);
            return cached == null ? null : cached.get();
        }
        return frozenNonStrictCache.get(name);
    }

    private static String getCacheKeyOfString(String str) {
        if (BCP47CHARS_MATCHER.matchesAllOf(str)) {
            return Ascii.toLowerCase(str).replace('_', '-').replace(',', ';');
        }
        String string = String.valueOf(str);
        throw new IllFormedLanguageCode(string.length() != 0 ? "Illegal characters in language tag: ".concat(string) : new String("Illegal characters in language tag: "));
    }

    private String getCacheKey() {
        return Ascii.toLowerCase(this.toString());
    }

    private static int getBitSetIndexForLanguageSubtag(String subtag) {
        int length = subtag.length();
        if (length == 2) {
            return (subtag.charAt(0) - 97) * 26 + (subtag.charAt(1) - 97);
        }
        if (length == 3) {
            return (subtag.charAt(0) - 97) * 26 * 26 + (subtag.charAt(1) - 97) * 26 + (subtag.charAt(2) - 97) + 676;
        }
        return VALID_LANGUAGE_SUBTAGS_BITSET.length << 6;
    }

    private static boolean isValidLanguageSubtag(String subtag) {
        int index = LanguageCode.getBitSetIndexForLanguageSubtag(subtag);
        int wordIndex = index >> 6;
        if (wordIndex < VALID_LANGUAGE_SUBTAGS_BITSET.length) {
            int bitIndex = index % 64;
            long bitMask = 1L << bitIndex;
            return (VALID_LANGUAGE_SUBTAGS_BITSET[wordIndex] & bitMask) != 0L;
        }
        return false;
    }

    private LanguageCode(String languageTag, CodeConverter.SynonymConversion synonymConversion, Leniency leniency) {
        this.internalParse(languageTag, synonymConversion, leniency);
        this.variants = this.variants.size() == 0 ? null : Collections.unmodifiableList(this.variants);
        int parentEnd = 0;
        StringBuilder sb = new StringBuilder();
        if (this.languageSubtag != null) {
            sb.append(this.languageSubtag);
        }
        if (this.scriptSubtag != null) {
            parentEnd = sb.length();
            sb.append('-').append((Object)this.scriptSubtag);
        }
        if (this.regionSubtag != null) {
            parentEnd = sb.length();
            sb.append('-').append((Object)this.regionSubtag);
        }
        if (this.variants != null) {
            parentEnd = this.appendList(sb, this.variants);
        }
        int optionStart = sb.length();
        if (this.transformLanguage != null || this.transformOptions != null && this.transformOptions.size() > 0) {
            sb.append("-t");
            if (this.transformLanguage != null) {
                sb.append('-').append(this.transformLanguage);
            }
            if (this.transformOptions != null) {
                for (Map.Entry<String, String> entry : this.transformOptions.entrySet()) {
                    sb.append('-').append(entry.getKey());
                    if (entry.getValue().isEmpty()) continue;
                    sb.append('-').append(entry.getValue());
                }
            }
        }
        if (this.options != null && this.options.size() > 0) {
            sb.append("-u");
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                sb.append('-').append(entry.getKey());
                if (entry.getValue().isEmpty()) continue;
                sb.append('-').append(entry.getValue());
            }
        }
        if (this.privateUse != null && !this.privateUse.isEmpty()) {
            sb.append("-x-").append(this.privateUse);
        }
        this.canonicalized = sb.toString();
        if (parentEnd != 0) {
            String string = String.valueOf(sb.substring(0, parentEnd));
            String string2 = String.valueOf(sb.substring(optionStart));
            this.parent = LanguageCode.forString(string2.length() != 0 ? string.concat(string2) : new String(string), CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS);
        } else if (!this.languageSubtag.equals("root")) {
            this.parent = ROOT;
        }
    }

    private int appendList(StringBuilder buffer, List<String> list) {
        int result = 0;
        for (String item : list) {
            result = buffer.length();
            buffer.append('-').append(item);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalParse(String languageTag, CodeConverter.SynonymConversion synonymConversion, Leniency leniency) {
        String subtag;
        Iterator<String> st;
        block60: {
            boolean hasLocaleExtensions;
            if (leniency == Leniency.LENIENT) {
                this.languageSubtag = UNKNOWN_LANGUAGE_TAG;
            }
            if (languageTag.isEmpty()) {
                if (leniency != Leniency.LENIENT) throw new IllFormedLanguageCode("Language tag cannot be empty");
                return;
            }
            int beginExtensions = -1;
            boolean hasOldCldrSyntax = false;
            int extIdx = LanguageCode.indexOfExtensions(languageTag);
            if (extIdx != -1) {
                beginExtensions = extIdx;
                if (beginExtensions == 0) {
                    String string;
                    if (leniency == Leniency.LENIENT) {
                        return;
                    }
                    String string2 = String.valueOf(languageTag);
                    if (string2.length() != 0) {
                        string = "Missing language subtag: ".concat(string2);
                        throw new InvalidLanguageCode(string);
                    }
                    string = new String("Missing language subtag: ");
                    throw new InvalidLanguageCode(string);
                }
                if (languageTag.charAt(extIdx) == '-') {
                    if (languageTag.indexOf(64, beginExtensions + 3) != -1) {
                        String string;
                        if (leniency == Leniency.LENIENT) {
                            return;
                        }
                        String string3 = String.valueOf(languageTag);
                        if (string3.length() != 0) {
                            string = "Mixed old CLDR and BCP-47 syntax: ".concat(string3);
                            throw new InvalidLanguageCode(string);
                        }
                        string = new String("Mixed old CLDR and BCP-47 syntax: ");
                        throw new InvalidLanguageCode(string);
                    }
                } else {
                    hasOldCldrSyntax = true;
                }
            }
            boolean bl = hasLocaleExtensions = beginExtensions != -1;
            if (hasLocaleExtensions) {
                if (hasOldCldrSyntax) {
                    this.oldCldrSyntaxParseExtensions(languageTag.substring(beginExtensions + 1), leniency);
                } else {
                    int position = beginExtensions + 1;
                    block9: while (position != -1) {
                        String string;
                        if (position == languageTag.length() - 1) {
                            String string4;
                            if (leniency != Leniency.NOT_LENIENT) break;
                            String string5 = String.valueOf(languageTag);
                            if (string5.length() != 0) {
                                string4 = "Truncated extension: ".concat(string5);
                                throw new IllFormedLanguageCode(string4);
                            }
                            string4 = new String("Truncated extension: ");
                            throw new IllFormedLanguageCode(string4);
                        }
                        switch (languageTag.charAt(position)) {
                            case 't': {
                                position = this.parseTransforms(languageTag, position + 3 - 1, synonymConversion, leniency);
                                continue block9;
                            }
                            case 'u': {
                                position = this.parseOptions(languageTag, position + 3 - 1, leniency);
                                continue block9;
                            }
                            case 'x': {
                                position = this.parsePrivateUse(languageTag, position + 3 - 1, leniency);
                                continue block9;
                            }
                        }
                        if (leniency == Leniency.LENIENT) break;
                        String string6 = String.valueOf(languageTag);
                        if (string6.length() != 0) {
                            string = "Unsupported singleton in: ".concat(string6);
                            throw new InvalidLanguageCode(string);
                        }
                        string = new String("Unsupported singleton in: ");
                        throw new InvalidLanguageCode(string);
                    }
                }
                languageTag = languageTag.substring(0, beginExtensions);
            }
            if (languageTag.equals("root")) {
                this.languageSubtag = languageTag;
                return;
            }
            if (GRANDFATHERED_TO_LANGUAGE_TAG_MAP.containsKey(languageTag)) {
                languageTag = GRANDFATHERED_TO_LANGUAGE_TAG_MAP.get(languageTag);
            }
            if (GOOGLE_VARIANTS.contains(languageTag)) {
                this.setLanguageSubtagFromAlias(languageTag, synonymConversion, leniency);
                return;
            }
            st = SEPARATOR_SPLITTER.split(languageTag).iterator();
            if (!st.hasNext()) {
                String string;
                String string7 = String.valueOf(languageTag);
                if (string7.length() != 0) {
                    string = "Language tag must have 1+ non-empty subtags: ".concat(string7);
                    throw new IllFormedLanguageCode(string);
                }
                string = new String("Language tag must have 1+ non-empty subtags: ");
                throw new IllFormedLanguageCode(string);
            }
            subtag = this.getSubtag(st, languageTag, leniency);
            if (!ALPHA_MATCHER.matchesAllOf(subtag) || subtag.length() < 2) {
                if (leniency == Leniency.LENIENT) {
                    return;
                }
                LanguageCode.throwInvalidSubtag(subtag, "Ill-formed language subtag", languageTag);
            }
            if (!LanguageCode.isValidLanguageSubtag(subtag)) {
                String string;
                if (leniency == Leniency.LENIENT) {
                    return;
                }
                String string8 = String.valueOf(subtag);
                if (string8.length() != 0) {
                    string = "Invalid language subtag: ".concat(string8);
                    throw new InvalidLanguageCode(string);
                }
                string = new String("Invalid language subtag: ");
                throw new InvalidLanguageCode(string);
            }
            this.languageSubtag = subtag;
            if (!st.hasNext()) {
                this.setLanguageSubtagFromAlias(this.languageSubtag, synonymConversion, leniency);
                return;
            }
            subtag = this.getSubtag(st, languageTag, leniency);
            if (subtag.length() == 3 && ALPHA_MATCHER.matchesAllOf(subtag)) {
                String string;
                if (LanguageCode.isValidLanguageSubtag(subtag)) {
                    Set valid_extlang_tags = VALID_EXTLANG_PREFIX_MAP.get(this.languageSubtag);
                    if (valid_extlang_tags != null && valid_extlang_tags.contains(subtag)) {
                        this.languageSubtag = subtag;
                        if (!st.hasNext()) {
                            this.setLanguageSubtagFromAlias(this.languageSubtag, synonymConversion, leniency);
                            return;
                        }
                        subtag = this.getSubtag(st, languageTag, leniency);
                        break block60;
                    } else {
                        String string9;
                        if (leniency == Leniency.LENIENT) {
                            this.setLanguageSubtagFromAlias(this.languageSubtag, synonymConversion, leniency);
                            return;
                        }
                        String string10 = String.valueOf(subtag);
                        if (string10.length() != 0) {
                            string9 = "Invalid extlang language subtag: ".concat(string10);
                            throw new InvalidLanguageCode(string9);
                        }
                        string9 = new String("Invalid extlang language subtag: ");
                        throw new InvalidLanguageCode(string9);
                    }
                }
                if (leniency == Leniency.LENIENT) {
                    this.setLanguageSubtagFromAlias(this.languageSubtag, synonymConversion, leniency);
                    return;
                }
                String string11 = String.valueOf(subtag);
                if (string11.length() != 0) {
                    string = "Invalid extlang language subtag: ".concat(string11);
                    throw new InvalidLanguageCode(string);
                }
                string = new String("Invalid extlang language subtag: ");
                throw new InvalidLanguageCode(string);
            }
        }
        this.setLanguageSubtagFromAlias(this.languageSubtag, synonymConversion, leniency);
        if (subtag.length() == 4 && ALPHA_MATCHER.matchesAllOf(subtag)) {
            try {
                String string = String.valueOf(Ascii.toUpperCase(subtag.substring(0, 1)));
                String string12 = String.valueOf(Ascii.toLowerCase(subtag.substring(1)));
                this.scriptSubtag = ScriptCode.forString(string12.length() != 0 ? string.concat(string12) : new String(string));
            }
            catch (IllegalArgumentException e) {
                String string;
                if (leniency == Leniency.LENIENT) {
                    return;
                }
                String string13 = String.valueOf(subtag);
                if (string13.length() != 0) {
                    string = "Illegal Script Code: ".concat(string13);
                    throw new InvalidLanguageCode(string);
                }
                string = new String("Illegal Script Code: ");
                throw new InvalidLanguageCode(string);
            }
            if (!st.hasNext()) {
                return;
            }
            subtag = this.getSubtag(st, languageTag, leniency);
        }
        if (subtag.length() == 2 && ALPHA_MATCHER.matchesAllOf(subtag) || subtag.length() == 3 && DIGIT_MATCHER.matchesAllOf(subtag)) {
            try {
                this.regionSubtag = RegionCode.forString(subtag);
            }
            catch (IllegalArgumentException e) {
                String string;
                if (leniency == Leniency.LENIENT) {
                    return;
                }
                String string14 = String.valueOf(subtag);
                if (string14.length() != 0) {
                    string = "Illegal Region Code: ".concat(string14);
                    throw new InvalidLanguageCode(string);
                }
                string = new String("Illegal Region Code: ");
                throw new InvalidLanguageCode(string);
            }
            if (!st.hasNext()) {
                return;
            }
            subtag = this.getSubtag(st, languageTag, leniency);
        }
        while (subtag.length() > 4 || subtag.length() == 4 && this.isDigit(subtag.charAt(0))) {
            if (!VALID_VARIANT_SUBTAGS.contains(subtag)) {
                String string;
                if (leniency == Leniency.LENIENT) {
                    return;
                }
                String string15 = String.valueOf(subtag);
                if (string15.length() != 0) {
                    string = "Invalid variant subtag: ".concat(string15);
                    throw new InvalidLanguageCode(string);
                }
                string = new String("Invalid variant subtag: ");
                throw new InvalidLanguageCode(string);
            }
            this.variants.add(Ascii.toUpperCase(subtag));
            if (!st.hasNext()) {
                return;
            }
            subtag = this.getSubtag(st, languageTag, leniency);
        }
        if (leniency == Leniency.LENIENT) return;
        LanguageCode.throwInvalidSubtag(subtag, "Illegal subtag", languageTag);
    }

    private void setLanguageSubtagFromAlias(String originalSubtag, CodeConverter.SynonymConversion synonymConversion, Leniency leniency) {
        String foldedLanguageTag;
        if (synonymConversion == CodeConverter.SynonymConversion.FOLD_SYNONYMS && (foldedLanguageTag = ALIAS_MAP.get(originalSubtag)) != null && !foldedLanguageTag.equals(originalSubtag)) {
            this.internalParse(LanguageCode.getCacheKeyOfString(foldedLanguageTag), synonymConversion, leniency);
            return;
        }
        this.languageSubtag = originalSubtag;
    }

    private int parseTransforms(String tag, int beginTransforms, CodeConverter.SynonymConversion synonymConversion, Leniency leniency) {
        if (this.transformOptions != null) {
            if (leniency != Leniency.LENIENT) {
                String string = String.valueOf(tag);
                throw new IllFormedLanguageCode(string.length() != 0 ? "More than one -t- in: ".concat(string) : new String("More than one -t- in: "));
            }
            return -1;
        }
        this.transformOptions = new TreeMap<String, String>();
        int beginSubtag = beginTransforms;
        int tlangLength = -1;
        int beginFsep = -1;
        int beginTvalue = -1;
        int nextDash = 0;
        while (true) {
            int subtagLength = -1;
            if (beginSubtag != -1) {
                nextDash = tag.indexOf(45, beginSubtag);
                subtagLength = (nextDash == -1 ? tag.length() : nextDash) - beginSubtag;
            }
            if (beginFsep != -1 && (beginSubtag == -1 || subtagLength <= 2)) {
                if (beginTvalue == -1) {
                    if (leniency == Leniency.NOT_LENIENT) {
                        String string = String.valueOf(tag);
                        throw new IllFormedLanguageCode(string.length() != 0 ? "Transform option without value in: ".concat(string) : new String("Transform option without value in: "));
                    }
                    beginSubtag = -1;
                    break;
                }
                int tvalueLength = (beginSubtag == -1 ? tag.length() : beginSubtag - 1) - beginTvalue;
                String fsep = tag.substring(beginFsep, beginFsep + 2);
                String tvalue = tag.substring(beginTvalue, beginTvalue + tvalueLength);
                this.transformOptions.put(fsep, tvalue);
            }
            if (beginSubtag == -1) break;
            if (tlangLength == 0 && subtagLength <= 2) {
                tlangLength = beginSubtag - beginTransforms - 1;
            }
            if (subtagLength == 0) {
                if (leniency == Leniency.NOT_LENIENT) {
                    String string = String.valueOf(tag);
                    throw new IllFormedLanguageCode(string.length() != 0 ? "Empty -t- subtag in: ".concat(string) : new String("Empty -t- subtag in: "));
                }
                beginSubtag = -1;
                break;
            }
            if (subtagLength == 1) break;
            if (subtagLength == 2 && ALPHA_MATCHER.matches(tag.charAt(beginSubtag)) && DIGIT_MATCHER.matches(tag.charAt(beginSubtag + 1))) {
                beginFsep = beginSubtag;
                beginTvalue = -1;
            } else if (beginFsep == -1) {
                tlangLength = 0;
            } else if (beginTvalue == -1) {
                beginTvalue = beginSubtag;
            }
            beginSubtag = nextDash == -1 ? -1 : nextDash + 1;
        }
        if (tlangLength != -1) {
            String tlangSubstr = tlangLength == 0 ? tag.substring(beginTransforms) : tag.substring(beginTransforms, beginTransforms + tlangLength);
            LanguageCode tlang = LanguageCode.forString(tlangSubstr, synonymConversion);
            if (tlang.getOptions() != null && !tlang.getOptions().isEmpty()) {
                if (leniency == Leniency.NOT_LENIENT) {
                    String string = String.valueOf(tlangSubstr);
                    throw new IllFormedLanguageCode(string.length() != 0 ? "Illegal transform language: ".concat(string) : new String("Illegal transform language: "));
                }
                beginSubtag = -1;
            } else {
                this.transformLanguage = tlang;
            }
        } else if (beginSubtag == beginTransforms) {
            if (leniency == Leniency.NOT_LENIENT) {
                String string = String.valueOf(tag);
                throw new IllFormedLanguageCode(string.length() != 0 ? "No valid subtag found after -t- in: ".concat(string) : new String("No valid subtag found after -t- in: "));
            }
            beginSubtag = -1;
        }
        this.transformOptions = Collections.unmodifiableMap(this.transformOptions);
        return beginSubtag;
    }

    private int parseOptions(String tag, int beginOptions, Leniency leniency) {
        if (this.options != null) {
            if (leniency != Leniency.LENIENT) {
                String string = String.valueOf(tag);
                throw new IllFormedLanguageCode(string.length() != 0 ? "More than one -u- in: ".concat(string) : new String("More than one -u- in: "));
            }
            return -1;
        }
        this.options = new TreeMap<String, String>();
        int beginSubtag = beginOptions;
        int beginKey = -1;
        int beginType = -1;
        int nextDash = 0;
        while (true) {
            int subtagLength = -1;
            if (beginSubtag != -1) {
                nextDash = tag.indexOf(45, beginSubtag);
                subtagLength = (nextDash == -1 ? tag.length() : nextDash) - beginSubtag;
            }
            if (beginKey != -1 && (beginSubtag == -1 || subtagLength <= 2)) {
                String key = tag.substring(beginKey, beginKey + 2);
                String type = "";
                if (beginType != -1) {
                    int typeLength = (beginSubtag == -1 ? tag.length() : beginSubtag - 1) - beginType;
                    if ("true".length() != typeLength || !"true".regionMatches(0, tag, beginType, typeLength)) {
                        type = tag.substring(beginType, beginType + typeLength);
                    }
                }
                this.options.put(key, type);
            }
            if (beginSubtag == -1) break;
            if (subtagLength == 0) {
                if (leniency == Leniency.NOT_LENIENT) {
                    String string = String.valueOf(tag);
                    throw new IllFormedLanguageCode(string.length() != 0 ? "Empty -u- key in: ".concat(string) : new String("Empty -u- key in: "));
                }
                beginSubtag = -1;
                break;
            }
            if (subtagLength == 1) break;
            if (subtagLength == 2) {
                beginKey = beginSubtag;
                beginType = -1;
            } else {
                if (beginKey == -1) {
                    if (leniency == Leniency.NOT_LENIENT) {
                        String string = String.valueOf(tag);
                        throw new IllFormedLanguageCode(string.length() != 0 ? "Unsupported use of attributes: ".concat(string) : new String("Unsupported use of attributes: "));
                    }
                    beginSubtag = -1;
                    break;
                }
                if (beginType == -1) {
                    beginType = beginSubtag;
                }
            }
            beginSubtag = nextDash == -1 ? -1 : nextDash + 1;
        }
        if (beginSubtag == beginOptions) {
            if (leniency == Leniency.NOT_LENIENT) {
                String string = String.valueOf(tag);
                throw new IllFormedLanguageCode(string.length() != 0 ? "No valid subtag found after -u- in: ".concat(string) : new String("No valid subtag found after -u- in: "));
            }
            beginSubtag = -1;
        }
        this.options = Collections.unmodifiableMap(this.options);
        return beginSubtag;
    }

    private int parsePrivateUse(String tag, int beginPrivateUse, Leniency leniency) {
        int beginSubtag = beginPrivateUse;
        int nextDash = 0;
        while (beginSubtag != -1) {
            nextDash = tag.indexOf(45, beginSubtag);
            int subtagLength = (nextDash == -1 ? tag.length() : nextDash) - beginSubtag;
            if (subtagLength < 1 || subtagLength > 8) {
                if (leniency != Leniency.LENIENT) {
                    String string = String.valueOf(tag);
                    throw new IllFormedLanguageCode(string.length() != 0 ? "Malformed subtag in: ".concat(string) : new String("Malformed subtag in: "));
                }
                return -1;
            }
            beginSubtag = nextDash == -1 ? -1 : nextDash + 1;
        }
        this.privateUse = tag.substring(beginPrivateUse);
        return -1;
    }

    private void oldCldrSyntaxParseExtensions(String string, Leniency leniency) {
        this.options = new TreeMap<String, String>();
        for (String pair : OLD_LDML_LOCALE_EXTENSION_SPLITTER.split(string)) {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) {
                if (leniency != Leniency.NOT_LENIENT) break;
                String string2 = String.valueOf(pair);
                throw new IllFormedLanguageCode(string2.length() != 0 ? "Illegal key=value pair: ".concat(string2) : new String("Illegal key=value pair: "));
            }
            String key = keyValue[0];
            if ("attribute".equals(key)) {
                if (leniency != Leniency.NOT_LENIENT) break;
                String string3 = String.valueOf(pair);
                throw new IllFormedLanguageCode(string3.length() != 0 ? "Illegal use of attributes: ".concat(string3) : new String("Illegal use of attributes: "));
            }
            String bcp47key = BCP47_EXT_MAP.get(key);
            if (bcp47key == null) {
                if (leniency != Leniency.NOT_LENIENT) break;
                String string4 = String.valueOf(key);
                throw new IllFormedLanguageCode(string4.length() != 0 ? "Unknown key: ".concat(string4) : new String("Unknown key: "));
            }
            key = bcp47key;
            String value = keyValue[1];
            if ("traditional".equals(value)) {
                if ("co".equals(key)) {
                    value = "trad";
                } else if ("nu".equals(key)) {
                    value = "traditio";
                }
            } else {
                String bcp47value = BCP47_EXT_MAP.get(value);
                if (bcp47value != null) {
                    value = bcp47value;
                }
            }
            this.options.put(key, value);
        }
        this.options = Collections.unmodifiableMap(this.options);
    }

    private String getSubtag(Iterator<String> st, String original, Leniency leniency) {
        String result = st.next();
        if (leniency == Leniency.NOT_LENIENT) {
            if (result.length() < 1 || result.length() > 8) {
                LanguageCode.throwInvalidSubtag(result, "Illegal length (must be 1..8)", original);
            }
            if (!ALPHANUM_MATCHER.matchesAllOf(result)) {
                LanguageCode.throwInvalidSubtag(result, new StringBuilder(24 + String.valueOf(result).length()).append("Illegal characters in (").append(result).append(")").toString(), original);
            }
        }
        return result;
    }

    private static void throwInvalidSubtag(String subtag, String errorText, String original) {
        throw new IllFormedLanguageCode(new StringBuilder(6 + String.valueOf(errorText).length() + String.valueOf(subtag).length() + String.valueOf(original).length()).append(errorText).append(": ").append(subtag).append(" in ").append(original).toString());
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @GwtIncompatible(value="java serialization not supported in GWT")
    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    @GwtIncompatible(value="java serialization not supported in GWT")
    private void readObject(ObjectInputStream unusedOis) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy object required");
    }

    static {
        HashMap<String, LanguageCodeSupplier> tempFrozenStrictCache = Maps.newHashMap();
        HashMap<String, LanguageCode> tempFrozenNonStrictCache = Maps.newHashMap();
        CachedLanguageCode root = new CachedLanguageCode(ROOT);
        tempFrozenStrictCache.put("", root);
        tempFrozenNonStrictCache.put("", ROOT);
        tempFrozenStrictCache.put("root", root);
        tempFrozenNonStrictCache.put("root", ROOT);
        tempFrozenStrictCache.put(UNKNOWN_LANGUAGE_TAG, new CachedLanguageCode(UNKNOWN));
        tempFrozenNonStrictCache.put(UNKNOWN_LANGUAGE_TAG, UNKNOWN);
        for (String name : COMMON_LANGUAGE_CODES.split(",")) {
            try {
                LanguageCode strict = LanguageCode.forString(name);
                CachedLanguageCode cached = new CachedLanguageCode(strict);
                tempFrozenStrictCache.put(name, cached);
                tempFrozenStrictCache.put(strict.canonicalized, cached);
            }
            catch (IllFormedLanguageCode e) {
                tempFrozenStrictCache.put(name, new CachedIllFormedLanguageCode(e));
            }
            catch (InvalidLanguageCode e) {
                tempFrozenStrictCache.put(name, new CachedInvalidLanguageCode(e));
            }
            LanguageCode nonStrict = LanguageCode.forStringLeniently(name);
            tempFrozenNonStrictCache.put(name, nonStrict);
            tempFrozenNonStrictCache.put(nonStrict.canonicalized, nonStrict);
        }
        frozenStrictCache = ImmutableMap.copyOf(tempFrozenStrictCache);
        frozenNonStrictCache = ImmutableMap.copyOf(tempFrozenNonStrictCache);
        AFRIKAANS = LanguageCode.forString("af");
        AKAN = LanguageCode.forString("ak");
        ALBANIAN = LanguageCode.forString("sq");
        AMHARIC = LanguageCode.forString("am");
        ARABIC = LanguageCode.forString("ar");
        ARMENIAN = LanguageCode.forString("hy");
        AZERBAIJANI = LanguageCode.forString("az");
        BASQUE = LanguageCode.forString("eu");
        BELARUSIAN = LanguageCode.forString("be");
        BENGALI = LanguageCode.forString("bn");
        BOSNIAN = LanguageCode.forString("bs");
        BRAZILIAN_PORTUGUESE = LanguageCode.forString("pt-BR");
        BRITISH_ENGLISH = LanguageCode.forString("en-GB");
        BULGARIAN = LanguageCode.forString("bg");
        BURMESE = LanguageCode.forString("my");
        CANADA = LanguageCode.forString("en-CA");
        CANADA_FRENCH = LanguageCode.forString("fr-CA");
        CANTONESE = LanguageCode.forString("yue");
        CATALAN = LanguageCode.forString("ca");
        CEBUANO = LanguageCode.forString("ceb");
        CHEROKEE = LanguageCode.forString("chr");
        CHINA = LanguageCode.forString("zh-Hans-CN");
        CHINA_CHINESE = LanguageCode.forString("zh-CN");
        CHINA_CHINESE_SIMPLIFIED = LanguageCode.forString("zh-Hans-CN");
        CHINESE = LanguageCode.forString("zh");
        CHINESE_SIMPLIFIED = LanguageCode.forString("zh-Hans");
        CHINESE_TRADITIONAL = LanguageCode.forString("zh-Hant");
        CROATIAN = LanguageCode.forString("hr");
        CZECH = LanguageCode.forString("cs");
        DANISH = LanguageCode.forString("da");
        DUTCH = LanguageCode.forString("nl");
        ENGLISH = LanguageCode.forString("en");
        ENGLISH_CANADA = LanguageCode.forString("en-CA");
        ENGLISH_GB = LanguageCode.forString("en-GB");
        ENGLISH_US = LanguageCode.forString("en-US");
        ESPERANTO = LanguageCode.forString("eo");
        ESTONIAN = LanguageCode.forString("et");
        FILIPINO = LanguageCode.forString("fil");
        FINNISH = LanguageCode.forString("fi");
        FRANCE = LanguageCode.forString("fr-FR");
        FRENCH = LanguageCode.forString("fr");
        FRENCH_CANADA = LanguageCode.forString("fr-CA");
        FRENCH_FRANCE = LanguageCode.forString("fr-FR");
        GALICIAN = LanguageCode.forString("gl");
        GEORGIAN = LanguageCode.forString("ka");
        GERMAN = LanguageCode.forString("de");
        GERMANY = LanguageCode.forString("de-DE");
        GERMAN_GERMANY = LanguageCode.forString("de-DE");
        GREEK = LanguageCode.forString("el");
        GUJARATI = LanguageCode.forString("gu");
        HAITIAN_CREOLE = LanguageCode.forString("ht");
        HAUSA = LanguageCode.forString("ha");
        HAWAIIAN = LanguageCode.forString("haw");
        HEBREW = LanguageCode.forString("iw");
        HINDI = LanguageCode.forString("hi");
        HMONG = LanguageCode.forString("hmn");
        HONGKONG_CHINESE = LanguageCode.forString("zh-HK");
        HONGKONG_CHINESE_TRADITIONAL = LanguageCode.forString("zh-Hant-HK");
        HUNGARIAN = LanguageCode.forString("hu");
        ICELANDIC = LanguageCode.forString("is");
        IGBO = LanguageCode.forString("ig");
        INDONESIAN = LanguageCode.forString("id");
        IRISH = LanguageCode.forString("ga");
        ITALIAN = LanguageCode.forString("it");
        ITALIAN_ITALY = LanguageCode.forString("it-IT");
        ITALY = LanguageCode.forString("it-IT");
        JAPAN = LanguageCode.forString("ja-JP");
        JAPANESE = LanguageCode.forString("ja");
        JAPANESE_JAPAN = LanguageCode.forString("ja-JP");
        JAVANESE = LanguageCode.forString("jv");
        KANNADA = LanguageCode.forString("kn");
        KAZAKH = LanguageCode.forString("kk");
        KHMER = LanguageCode.forString("km");
        KOREA = LanguageCode.forString("ko-KR");
        KOREAN = LanguageCode.forString("ko");
        KOREAN_KOREA = LanguageCode.forString("ko-KR");
        LAO = LanguageCode.forString("lo");
        LATIN = LanguageCode.forString("la");
        LATVIAN = LanguageCode.forString("lv");
        LITHUANIAN = LanguageCode.forString("lt");
        LUXEMBOURGISH = LanguageCode.forString("lb");
        MACEDONIAN = LanguageCode.forString("mk");
        MALAGASY = LanguageCode.forString("mg");
        MALAY = LanguageCode.forString("ms");
        MALAYALAM = LanguageCode.forString("ml");
        MALTESE = LanguageCode.forString("mt");
        MAORI = LanguageCode.forString("mi");
        MARATHI = LanguageCode.forString("mr");
        MAURITIAN_CREOLE = LanguageCode.forString("mfe");
        MONGOLIAN = LanguageCode.forString("mn");
        MONTENEGRIN = LanguageCode.forString("sr-ME");
        NEPALI = LanguageCode.forString("ne");
        NORWEGIAN = LanguageCode.forString("no");
        NO_LANGUAGE = LanguageCode.forString("zxx");
        NYANJA = LanguageCode.forString("ny");
        ORIYA = LanguageCode.forString("or");
        PERSIAN = LanguageCode.forString("fa");
        POLISH = LanguageCode.forString("pl");
        PORTUGAL_PORTUGUESE = LanguageCode.forString("pt-PT");
        PORTUGUESE = LanguageCode.forString("pt");
        PUNJABI = LanguageCode.forString("pa");
        ROMANIAN = LanguageCode.forString("ro");
        RUSSIAN = LanguageCode.forString("ru");
        SCOTTISH_GAELIC = LanguageCode.forString("gd");
        SERBIAN = LanguageCode.forString("sr");
        SESOTHO = LanguageCode.forString("st");
        SINHALESE = LanguageCode.forString("si");
        SLOVAK = LanguageCode.forString("sk");
        SLOVENIAN = LanguageCode.forString("sl");
        SOMALI = LanguageCode.forString("so");
        SPANISH = LanguageCode.forString("es");
        SPANISH_LATIN_AMERICAN = LanguageCode.forString("es-419");
        SUNDANESE = LanguageCode.forString("su");
        SWAHILI = LanguageCode.forString("sw");
        SWEDISH = LanguageCode.forString("sv");
        TAIWAN_CHINESE = LanguageCode.forString("zh-TW");
        TAIWAN_CHINESE_TRADITIONAL = LanguageCode.forString("zh-Hant-TW");
        TAJIK = LanguageCode.forString("tg");
        TAMIL = LanguageCode.forString("ta");
        TELUGU = LanguageCode.forString("te");
        THAI = LanguageCode.forString("th");
        TURKISH = LanguageCode.forString("tr");
        UK = LanguageCode.forString("en-GB");
        UKRAINIAN = LanguageCode.forString("uk");
        UNDEFINED = LanguageCode.forString(UNKNOWN_LANGUAGE_TAG);
        URDU = LanguageCode.forString("ur");
        US = LanguageCode.forString("en-US");
        UZBEK = LanguageCode.forString("uz");
        VIETNAMESE = LanguageCode.forString("vi");
        WELSH = LanguageCode.forString("cy");
        YIDDISH = LanguageCode.forString("yi");
        YORUBA = LanguageCode.forString("yo");
        ZULU = LanguageCode.forString("zu");
    }

    @GwtIncompatible(value="java serialization not supported in GWT")
    private static final class SerializationProxy
    implements Serializable {
        private final String canonicalString;
        private static final long serialVersionUID = 1L;

        SerializationProxy(LanguageCode code) {
            this.canonicalString = code.toString();
        }

        private Object readResolve() {
            return LanguageCode.forString(this.canonicalString);
        }
    }

    public static class InvalidLanguageCode
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public InvalidLanguageCode(String message) {
            super(message);
        }
    }

    public static class IllFormedLanguageCode
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public IllFormedLanguageCode(String message) {
            super(message);
        }
    }

    private static enum Leniency {
        LENIENT,
        NOT_LENIENT;

    }

    private static final class CachedInvalidLanguageCode
    implements LanguageCodeSupplier {
        private final String message;

        CachedInvalidLanguageCode(IllegalArgumentException exception) {
            this.message = exception.getMessage();
        }

        @Override
        public LanguageCode get() {
            throw new InvalidLanguageCode(this.message);
        }
    }

    private static final class CachedIllFormedLanguageCode
    implements LanguageCodeSupplier {
        private final String message;

        CachedIllFormedLanguageCode(IllFormedLanguageCode exception) {
            this.message = exception.getMessage();
        }

        @Override
        public LanguageCode get() {
            throw new IllFormedLanguageCode(this.message);
        }
    }

    private static final class CachedLanguageCode
    implements LanguageCodeSupplier {
        private final LanguageCode languageCode;

        CachedLanguageCode(LanguageCode languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public LanguageCode get() {
            return this.languageCode;
        }
    }

    private static interface LanguageCodeSupplier {
        public LanguageCode get();
    }

    public static enum OfficialStatus {
        UNKNOWN("U"),
        RECOGNIZED("R"),
        OFFICIAL_MINORITY("OM"),
        OFFICIAL_REGIONAL("OR"),
        DE_FACTO_OFFICIAL("OD"),
        OFFICIAL("O");

        private final String shortName;

        private OfficialStatus(String shortName) {
            this.shortName = shortName;
        }

        public String toShortName() {
            return this.shortName;
        }
    }
}

