/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.errorprone.annotations.Immutable;
import com.google.i18n.identifiers.LanguageCode;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Immutable
public class LanguagePriorityList
implements Iterable<LanguageCode> {
    private static final Pattern languageSplitter = Pattern.compile("\\s*,\\s*");
    private static final Pattern weightSplitter = Pattern.compile("\\s*(\\S*)\\s*;\\s*q\\s*=\\s*(\\S*)");
    private final ImmutableMap<LanguageCode, Double> languagesAndWeight;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/LanguagePriorityList");
    private static final LanguagePriorityList EMPTY = LanguagePriorityList.builder().build();
    private static Comparator<Double> myDescendingDouble = new Comparator<Double>(){

        @Override
        public int compare(Double o1, Double o2) {
            return -o1.compareTo(o2);
        }
    };

    public static LanguagePriorityListBuilder add(LanguageCode languageCode) {
        return new LanguagePriorityListBuilder().add(languageCode);
    }

    public static LanguagePriorityListBuilder add(LanguageCode languageCode, double weight) {
        return new LanguagePriorityListBuilder().add(languageCode, weight);
    }

    public static LanguagePriorityListBuilder add(LanguagePriorityList languagePriorityList) {
        return new LanguagePriorityListBuilder().add(languagePriorityList);
    }

    public static LanguagePriorityListBuilder add(String acceptLanguageString) {
        return new LanguagePriorityListBuilder().add(acceptLanguageString);
    }

    public static LanguagePriorityListBuilder builder() {
        return new LanguagePriorityListBuilder();
    }

    public static LanguagePriorityListBuilder builder(WeightPolicy weightPolicy) {
        return new LanguagePriorityListBuilder(weightPolicy);
    }

    public static LanguagePriorityList of() {
        return EMPTY;
    }

    public static LanguagePriorityList of(Iterable<LanguageCode> languages) {
        return LanguagePriorityList.of(Iterables.toArray(languages, LanguageCode.class));
    }

    public static LanguagePriorityList of(LanguageCode ... languages) {
        return LanguagePriorityList.builder(WeightPolicy.FIRST_VALUE).add(languages).build();
    }

    public static LanguagePriorityList of(String acceptLanguages) {
        return LanguagePriorityList.builder(WeightPolicy.FIRST_VALUE).add(acceptLanguages).build();
    }

    @Nullable
    public Double getWeight(LanguageCode language) {
        return this.languagesAndWeight.get(language);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (LanguageCode language : this.languagesAndWeight.keySet()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(language);
            double weight = this.languagesAndWeight.get(language);
            if (weight == 1.0) continue;
            result.append(";q=").append(weight);
        }
        return result.toString();
    }

    @Override
    public Iterator<LanguageCode> iterator() {
        return ((ImmutableSet)this.languagesAndWeight.keySet()).iterator();
    }

    public boolean equals(Object o) {
        try {
            if (!(o instanceof LanguagePriorityList)) {
                return false;
            }
            LanguagePriorityList that = (LanguagePriorityList)o;
            return this.languagesAndWeight.equals(that.languagesAndWeight);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.languagesAndWeight.hashCode();
    }

    private LanguagePriorityList(Map<LanguageCode, Double> languageToWeight) {
        this.languagesAndWeight = ImmutableMap.copyOf(languageToWeight);
    }

    public static class LanguagePriorityListBuilder {
        private static final Double D10 = 1.0;
        private final WeightPolicy weightPolicy;
        private final Map<LanguageCode, Double> languageToWeight = Maps.newLinkedHashMap();
        private static final ImmutableMap<String, String> ACCEPT_LANGUAGE_HACK_MAP = ImmutableMap.builder().put("english", "en").put("french", "fr").put("deutsch", "de").put("italian", "it").build();

        public LanguagePriorityListBuilder(WeightPolicy weightPolicy) {
            this.weightPolicy = Preconditions.checkNotNull(weightPolicy);
        }

        public LanguagePriorityListBuilder() {
            this.weightPolicy = WeightPolicy.ADJUSTED_LAST_VALUE;
        }

        public LanguagePriorityList build() {
            TreeMap<Double, LinkedHashSet<LanguageCode>> doubleCheck = new TreeMap<Double, LinkedHashSet<LanguageCode>>(myDescendingDouble);
            for (LanguageCode lang : this.languageToWeight.keySet()) {
                Double weight = this.languageToWeight.get(lang);
                LinkedHashSet<LanguageCode> s = (LinkedHashSet<LanguageCode>)doubleCheck.get(weight);
                if (s == null) {
                    s = new LinkedHashSet<LanguageCode>();
                    doubleCheck.put(weight, s);
                }
                s.add(lang);
            }
            doubleCheck.remove(0.0);
            LinkedHashMap<LanguageCode, Double> temp = new LinkedHashMap<LanguageCode, Double>();
            double fixedWeight = 1.0;
            for (Double weight : doubleCheck.keySet()) {
                for (LanguageCode lang : (Set)doubleCheck.get(weight)) {
                    double newWeight;
                    switch (this.weightPolicy) {
                        case ADJUSTED_LAST_VALUE: {
                            newWeight = fixedWeight;
                            fixedWeight -= 0.001;
                            break;
                        }
                        case BAYESIAN: {
                            newWeight = (double)Math.round(1000.0 * weight) / 1000.0;
                            break;
                        }
                        default: {
                            newWeight = weight;
                        }
                    }
                    temp.put(lang, newWeight);
                }
            }
            return new LanguagePriorityList(Collections.unmodifiableMap(temp));
        }

        public LanguagePriorityListBuilder add(LanguagePriorityList languagePriorityList) {
            for (LanguageCode language : languagePriorityList.languagesAndWeight.keySet()) {
                this.add(language, (Double)languagePriorityList.languagesAndWeight.get(language));
            }
            return this;
        }

        public LanguagePriorityListBuilder add(LanguageCode languageCode) {
            return this.add(languageCode, D10);
        }

        public LanguagePriorityListBuilder add(LanguageCode ... languageCodes) {
            for (LanguageCode languageCode : languageCodes) {
                this.add(languageCode, D10);
            }
            return this;
        }

        public LanguagePriorityListBuilder add(LanguageCode languageCode, double weight) {
            if (weight < 0.0 || weight > 1.0) {
                weight = 0.0;
            }
            if (this.languageToWeight.containsKey(languageCode)) {
                switch (this.weightPolicy) {
                    case FIRST_VALUE: {
                        return this;
                    }
                    case BAYESIAN: {
                        double prevWeight = this.languageToWeight.get(languageCode);
                        weight = -prevWeight * weight + prevWeight + weight;
                        break;
                    }
                    case ADJUSTED_LAST_VALUE: 
                    case LAST_VALUE: {
                        this.languageToWeight.remove(languageCode);
                    }
                }
            }
            this.languageToWeight.put(languageCode, weight);
            return this;
        }

        public LanguagePriorityListBuilder add(String acceptLanguageList) {
            return this.add(acceptLanguageList, true);
        }

        public LanguagePriorityListBuilder add(String acceptLanguageList, boolean strict) {
            String[] items = languageSplitter.split(acceptLanguageList.trim());
            Matcher itemMatcher = weightSplitter.matcher("");
            for (String item : items) {
                LanguageCode language;
                boolean hasWeight;
                double weight;
                String languageString;
                block8: {
                    languageString = item = item.toLowerCase(Locale.ENGLISH);
                    weight = 1.0;
                    hasWeight = itemMatcher.reset(item).matches();
                    if (hasWeight) {
                        languageString = itemMatcher.group(1);
                        try {
                            weight = Double.parseDouble(itemMatcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            if (!strict) break block8;
                            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/i18n/identifiers/LanguagePriorityList$LanguagePriorityListBuilder", "add", 469, "LanguagePriorityList.java")).log("Failed to parse language weight value '%s' for language '%s'", (Object)itemMatcher.group(2), (Object)languageString);
                        }
                    }
                }
                if ("".equals(languageString = languageString.trim())) continue;
                if (ACCEPT_LANGUAGE_HACK_MAP.containsKey(languageString)) {
                    languageString = ACCEPT_LANGUAGE_HACK_MAP.get(languageString);
                }
                try {
                    language = strict ? LanguageCode.forString(languageString) : LanguageCode.forStringLeniently(languageString);
                }
                catch (IllegalArgumentException e) {
                    if (!strict) continue;
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/i18n/identifiers/LanguagePriorityList$LanguagePriorityListBuilder", "add", 490, "LanguagePriorityList.java")).log("Ignoring invalid language tag '%s'", languageString);
                    continue;
                }
                if (LanguageCode.UNDEFINED.equals(language) && !strict && !"und".equals(languageString.toLowerCase(Locale.ENGLISH))) continue;
                if (hasWeight) {
                    this.add(language, weight);
                    continue;
                }
                this.add(language);
            }
            return this;
        }

        public boolean contains(LanguageCode languageCode) {
            return this.languageToWeight.containsKey(languageCode);
        }
    }

    public static enum WeightPolicy {
        FIRST_VALUE,
        LAST_VALUE,
        ADJUSTED_LAST_VALUE,
        BAYESIAN;

    }
}

