/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.money.CurrencyCode;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.RegionCode;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public interface RegionInfo {
    public boolean contains(RegionCode var1, RegionCode var2);

    public Set<RegionCode> getDirectContents(RegionCode var1);

    public Set<RegionCode> getAllContents(RegionCode var1);

    public Set<RegionCode> getDirectContainers(RegionCode var1);

    public Set<RegionCode> getAllContainers(RegionCode var1);

    public String getDisplayName(RegionCode var1, LanguageCode ... var2);

    public String getDisplayName(RegionCode var1, Locale var2, Locale ... var3);

    public Comparator<RegionCode> getDisplayNameComparator(LanguageCode ... var1);

    public boolean isOverlap(RegionCode var1);

    public boolean isPoliticalOverlap(RegionCode var1);

    public RegionCode regionCodeFromDisplayName(String var1, LanguageCode var2);

    public List<RegionCode> getPreferredValues(RegionCode var1);

    public long getRegionPopulation(RegionCode var1);

    public float getRegionLiteracy(RegionCode var1);

    public long getRegionGdp(RegionCode var1);

    public Set<LanguageCode> getRegionLanguages(RegionCode var1);

    public Set<LanguageCode> getRegionOfficialLanguages(RegionCode var1, Set<LanguageCode.OfficialStatus> var2);

    public long getRegionLanguagePopulation(RegionCode var1, LanguageCode var2);

    public LanguageCode getRegionMajorityLanguage(RegionCode var1);

    public float getRegionLanguageWritingPopulation(RegionCode var1, LanguageCode var2);

    public MeasurementSystem getMeasurementSystem(RegionCode var1);

    public TemperatureUnit getWeatherTemperatureUnit(RegionCode var1);

    public LengthUnits getRoadLengthUnits(RegionCode var1);

    public Set<CurrencyCode> getRegionAllCurrenciesEverUsed(RegionCode var1);

    public Set<CurrencyCode> getRegionCurrentCurrenciesInUse(RegionCode var1);

    public static enum LengthUnits {
        KILOMETER_METER,
        MILE_YARD,
        MILE_FOOT;

    }

    public static enum TemperatureUnit {
        CELSIUS,
        FAHRENHEIT;

    }

    public static enum MeasurementSystem {
        METRIC,
        US;

    }
}

