/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.i18n.identifiers.Converters;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.SupportedLanguagesProtos;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class SupportedLanguages {
    private static final String TIER_DATA_RESOURCE = "/i18n/identifiers/data/supported_languages_data.txt";
    private static final ImmutableMap<SupportedLanguagesProtos.TierId, TierId> TIER_ID_MAP = ImmutableMap.builder().put(SupportedLanguagesProtos.TierId.TIER_0, TierId.TIER_0).put(SupportedLanguagesProtos.TierId.TIER_1, TierId.TIER_1).put(SupportedLanguagesProtos.TierId.TIER_2, TierId.TIER_2).put(SupportedLanguagesProtos.TierId.TIER_3, TierId.TIER_3).put(SupportedLanguagesProtos.TierId.TIER_4, TierId.TIER_4).put(SupportedLanguagesProtos.TierId.TIER_5, TierId.TIER_5).put(SupportedLanguagesProtos.TierId.TIER_6, TierId.TIER_6).put(SupportedLanguagesProtos.TierId.TIER_SPECIAL, TierId.TIER_SPECIAL).put(SupportedLanguagesProtos.TierId.TIER_TOP_REGIONAL_VARIANTS, TierId.TIER_TOP_REGIONAL_VARIANTS).put(SupportedLanguagesProtos.TierId.OTHERS, TierId.OTHERS).build();
    private static final ImmutableSetMultimap<TierId, LanguageCode> TIERS = SupportedLanguages.createTiers();
    private static final ImmutableSetMultimap<TierId, LanguageCode> AGGR_TIERS = SupportedLanguages.createAggrTiers(TIERS);

    private SupportedLanguages() {
    }

    public static ImmutableSet<LanguageCode> getLanguagesIn(TierId tier) {
        return TIERS.get((Object)tier);
    }

    public static ImmutableSet<LanguageCode> getLanguagesUpToAndIncluding(TierId tier) {
        return AGGR_TIERS.get((Object)tier);
    }

    public static ImmutableSet<LanguageCode> getOfficialLanguages() {
        return AGGR_TIERS.get((Object)TierId.TIER_4);
    }

    public static ImmutableSet<LanguageCode> getAll() {
        return AGGR_TIERS.get((Object)TierId.OTHERS);
    }

    @Nullable
    public static TierId getTierFor(LanguageCode language) {
        for (TierId id : TierId.values()) {
            if (!TIERS.get((Object)id).contains(language)) continue;
            return id;
        }
        return null;
    }

    private static ImmutableSetMultimap<TierId, LanguageCode> createTiers() {
        SupportedLanguagesProtos.AllTiersProto allTiersProto = SupportedLanguages.resourceToProto(TIER_DATA_RESOURCE);
        return SupportedLanguages.protoToMap(allTiersProto);
    }

    private static SupportedLanguagesProtos.AllTiersProto resourceToProto(String tierDataResource) {
        InputStream input = SupportedLanguages.class.getResourceAsStream(tierDataResource);
        SupportedLanguagesProtos.AllTiersProto.Builder builder = SupportedLanguagesProtos.AllTiersProto.newBuilder();
        try {
            TextFormat.merge((Readable)new InputStreamReader(input, StandardCharsets.UTF_8), (Message.Builder)builder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't read language list from resource stream", e);
        }
        finally {
            SupportedLanguages.close(input);
        }
        return builder.build();
    }

    private static void close(InputStream input) {
        try {
            input.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't close the language list resource stream", e);
        }
    }

    private static ImmutableSetMultimap<TierId, LanguageCode> protoToMap(SupportedLanguagesProtos.AllTiersProto allTiers) {
        ImmutableSetMultimap.Builder mapBuilder = ImmutableSetMultimap.builder();
        for (SupportedLanguagesProtos.TierLanguages tier : allTiers.getTierList()) {
            SupportedLanguagesProtos.TierId key = tier.getKey();
            TierId tierId = TIER_ID_MAP.get(key);
            mapBuilder.putAll((Object)tierId, Lists.transform(tier.getLanguageCodeList(), Converters.LANGUAGE_CODE));
        }
        return mapBuilder.build();
    }

    private static ImmutableSetMultimap<TierId, LanguageCode> createAggrTiers(ImmutableSetMultimap<TierId, LanguageCode> map) {
        ImmutableSetMultimap.Builder mapBuilder = ImmutableSetMultimap.builder();
        block0: for (TierId tier : TierId.values()) {
            for (TierId topTier : TierId.values()) {
                mapBuilder.putAll((Object)tier, (Iterable)map.get((Object)topTier));
                if (topTier.equals((Object)tier)) continue block0;
            }
        }
        return mapBuilder.build();
    }

    public static enum TierId {
        TIER_0,
        TIER_1,
        TIER_2,
        TIER_3,
        TIER_4,
        TIER_5,
        TIER_6,
        TIER_SPECIAL,
        TIER_TOP_REGIONAL_VARIANTS,
        OTHERS;

    }
}

