/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Maps;
import com.google.i18n.identifiers.CodeConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

@GwtCompatible(emulated=true)
public enum TimeZoneId {
    UNKNOWN(0, "Etc/Unknown"){

        @Override
        @GwtIncompatible(value="DateTimeZone")
        public DateTimeZone toJoda() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    LOS_ANGELES(1, "America/Los_Angeles"),
    ABIDJAN(2, "Africa/Abidjan"),
    ACCRA(3, "Africa/Accra"),
    ADDIS_ABABA(4, "Africa/Addis_Ababa"),
    ALGIERS(5, "Africa/Algiers"),
    ASMERA(6, "Africa/Asmera"),
    BAMAKO(7, "Africa/Bamako"),
    BANGUI(8, "Africa/Bangui"),
    BANJUL(9, "Africa/Banjul"),
    BISSAU(10, "Africa/Bissau"),
    BLANTYRE(11, "Africa/Blantyre"),
    BRAZZAVILLE(12, "Africa/Brazzaville"),
    BUJUMBURA(13, "Africa/Bujumbura"),
    CAIRO(14, "Africa/Cairo"),
    CASABLANCA(15, "Africa/Casablanca"),
    CEUTA(16, "Africa/Ceuta"),
    CONAKRY(17, "Africa/Conakry"),
    DAKAR(18, "Africa/Dakar"),
    DAR_ES_SALAAM(19, "Africa/Dar_es_Salaam"),
    DJIBOUTI(20, "Africa/Djibouti"),
    DOUALA(21, "Africa/Douala"),
    EL_AAIUN(22, "Africa/El_Aaiun"),
    FREETOWN(23, "Africa/Freetown"),
    GABORONE(24, "Africa/Gaborone"),
    HARARE(25, "Africa/Harare"),
    JOHANNESBURG(26, "Africa/Johannesburg"),
    KAMPALA(27, "Africa/Kampala"),
    KHARTOUM(28, "Africa/Khartoum"),
    KIGALI(29, "Africa/Kigali"),
    KINSHASA(30, "Africa/Kinshasa"),
    LAGOS(31, "Africa/Lagos"),
    LIBREVILLE(32, "Africa/Libreville"),
    LOME(33, "Africa/Lome"),
    LUANDA(34, "Africa/Luanda"),
    LUBUMBASHI(35, "Africa/Lubumbashi"),
    LUSAKA(36, "Africa/Lusaka"),
    MALABO(37, "Africa/Malabo"),
    MAPUTO(38, "Africa/Maputo"),
    MASERU(39, "Africa/Maseru"),
    MBABANE(40, "Africa/Mbabane"),
    MOGADISHU(41, "Africa/Mogadishu"),
    MONROVIA(42, "Africa/Monrovia"),
    NAIROBI(43, "Africa/Nairobi"),
    NDJAMENA(44, "Africa/Ndjamena"),
    NIAMEY(45, "Africa/Niamey"),
    NOUAKCHOTT(46, "Africa/Nouakchott"),
    OUAGADOUGOU(47, "Africa/Ouagadougou"),
    PORTO_NOVO(48, "Africa/Porto-Novo"),
    SAO_TOME(49, "Africa/Sao_Tome"),
    TRIPOLI(51, "Africa/Tripoli"),
    TUNIS(52, "Africa/Tunis"),
    WINDHOEK(53, "Africa/Windhoek"),
    ADAK(54, "America/Adak"),
    ANCHORAGE(55, "America/Anchorage"),
    ANGUILLA(56, "America/Anguilla"),
    ANTIGUA(57, "America/Antigua"),
    ARAGUAINA(58, "America/Araguaina"),
    BUENOS_AIRES(59, "America/Buenos_Aires"),
    CATAMARCA(60, "America/Catamarca"),
    CORDOBA(62, "America/Cordoba"),
    JUJUY(63, "America/Jujuy"),
    LA_RIOJA(64, "America/Argentina/La_Rioja"),
    MENDOZA(65, "America/Mendoza"),
    RIO_GALLEGOS(66, "America/Argentina/Rio_Gallegos"),
    SAN_JUAN(67, "America/Argentina/San_Juan"),
    TUCUMAN(68, "America/Argentina/Tucuman"),
    USHUAIA(69, "America/Argentina/Ushuaia"),
    ARUBA(70, "America/Aruba"),
    ASUNCION(71, "America/Asuncion"),
    BAHIA(72, "America/Bahia"),
    BARBADOS(73, "America/Barbados"),
    BELEM(74, "America/Belem"),
    BELIZE(75, "America/Belize"),
    BOA_VISTA(76, "America/Boa_Vista"),
    BOGOTA(77, "America/Bogota"),
    BOISE(78, "America/Boise"),
    CAMBRIDGE_BAY(79, "America/Cambridge_Bay"),
    CAMPO_GRANDE(80, "America/Campo_Grande"),
    CANCUN(81, "America/Cancun"),
    CARACAS(82, "America/Caracas"),
    CAYENNE(83, "America/Cayenne"),
    CAYMAN(84, "America/Cayman"),
    CHICAGO(85, "America/Chicago"),
    CHIHUAHUA(86, "America/Chihuahua"),
    COSTA_RICA(87, "America/Costa_Rica"),
    CUIABA(88, "America/Cuiaba"),
    CURACAO(89, "America/Curacao"),
    DANMARKSHAVN(90, "America/Danmarkshavn"),
    DAWSON(91, "America/Dawson"),
    DAWSON_CREEK(92, "America/Dawson_Creek"),
    DENVER(93, "America/Denver"),
    DETROIT(94, "America/Detroit"),
    DOMINICA(95, "America/Dominica"),
    EDMONTON(96, "America/Edmonton"),
    EIRUNEPE(97, "America/Eirunepe"),
    EL_SALVADOR(98, "America/El_Salvador"),
    FORTALEZA(99, "America/Fortaleza"),
    GLACE_BAY(100, "America/Glace_Bay"),
    GODTHAB(101, "America/Godthab"),
    GOOSE_BAY(102, "America/Goose_Bay"),
    GRAND_TURK(103, "America/Grand_Turk"),
    GRENADA(104, "America/Grenada"),
    GUADELOUPE(105, "America/Guadeloupe"),
    GUATEMALA(106, "America/Guatemala"),
    GUAYAQUIL(107, "America/Guayaquil"),
    GUYANA(108, "America/Guyana"),
    HALIFAX(109, "America/Halifax"),
    HAVANA(110, "America/Havana"),
    HERMOSILLO(111, "America/Hermosillo"),
    KNOX(113, "America/Indiana/Knox"),
    MARENGO(114, "America/Indiana/Marengo"),
    INDIANAPOLIS(115, "America/Indianapolis"),
    VEVAY(116, "America/Indiana/Vevay"),
    INUVIK(117, "America/Inuvik"),
    IQALUIT(118, "America/Iqaluit"),
    JAMAICA(119, "America/Jamaica"),
    JUNEAU(120, "America/Juneau"),
    MONTICELLO(122, "America/Kentucky/Monticello"),
    LA_PAZ(123, "America/La_Paz"),
    LIMA(124, "America/Lima"),
    LOUISVILLE(125, "America/Louisville"),
    MACEIO(126, "America/Maceio"),
    MANAGUA(127, "America/Managua"),
    MANAUS(128, "America/Manaus"),
    MARTINIQUE(129, "America/Martinique"),
    MAZATLAN(130, "America/Mazatlan"),
    MENOMINEE(131, "America/Menominee"),
    MERIDA(132, "America/Merida"),
    MEXICO_CITY(133, "America/Mexico_City"),
    MIQUELON(134, "America/Miquelon"),
    MONTERREY(135, "America/Monterrey"),
    MONTEVIDEO(136, "America/Montevideo"),
    MONTREAL(137, "America/Montreal"),
    MONTSERRAT(138, "America/Montserrat"),
    NASSAU(139, "America/Nassau"),
    NEW_YORK(140, "America/New_York"),
    NIPIGON(141, "America/Nipigon"),
    NOME(142, "America/Nome"),
    NORONHA(143, "America/Noronha"),
    CENTER(144, "America/North_Dakota/Center"),
    PANAMA(145, "America/Panama"),
    PANGNIRTUNG(146, "America/Pangnirtung"),
    PARAMARIBO(147, "America/Paramaribo"),
    PHOENIX(148, "America/Phoenix"),
    PORT_AU_PRINCE(149, "America/Port-au-Prince"),
    PORT_OF_SPAIN(150, "America/Port_of_Spain"),
    PORTO_VELHO(151, "America/Porto_Velho"),
    PUERTO_RICO(152, "America/Puerto_Rico"),
    RAINY_RIVER(153, "America/Rainy_River"),
    RANKIN_INLET(154, "America/Rankin_Inlet"),
    RECIFE(155, "America/Recife"),
    REGINA(156, "America/Regina"),
    RIO_BRANCO(157, "America/Rio_Branco"),
    SANTIAGO(158, "America/Santiago"),
    SANTO_DOMINGO(159, "America/Santo_Domingo"),
    SAO_PAULO(160, "America/Sao_Paulo"),
    SCORESBYSUND(161, "America/Scoresbysund"),
    ST_JOHNS(163, "America/St_Johns"),
    ST_KITTS(164, "America/St_Kitts"),
    ST_LUCIA(165, "America/St_Lucia"),
    ST_THOMAS(166, "America/St_Thomas"),
    ST_VINCENT(167, "America/St_Vincent"),
    SWIFT_CURRENT(168, "America/Swift_Current"),
    TEGUCIGALPA(169, "America/Tegucigalpa"),
    THULE(170, "America/Thule"),
    THUNDER_BAY(171, "America/Thunder_Bay"),
    TIJUANA(172, "America/Tijuana"),
    TORONTO(173, "America/Toronto"),
    TORTOLA(174, "America/Tortola"),
    VANCOUVER(175, "America/Vancouver"),
    WHITEHORSE(176, "America/Whitehorse"),
    WINNIPEG(177, "America/Winnipeg"),
    YAKUTAT(178, "America/Yakutat"),
    YELLOWKNIFE(179, "America/Yellowknife"),
    CASEY(180, "Antarctica/Casey"),
    DAVIS(181, "Antarctica/Davis"),
    DUMONTDURVILLE(182, "Antarctica/DumontDUrville"),
    MAWSON(183, "Antarctica/Mawson"),
    MCMURDO(184, "Antarctica/McMurdo"),
    PALMER(185, "Antarctica/Palmer"),
    ROTHERA(186, "Antarctica/Rothera"),
    SYOWA(188, "Antarctica/Syowa"),
    VOSTOK(189, "Antarctica/Vostok"),
    LONGYEARBYEN(190, "Arctic/Longyearbyen"),
    ADEN(191, "Asia/Aden"),
    ALMATY(192, "Asia/Almaty"),
    AMMAN(193, "Asia/Amman"),
    ANADYR(194, "Asia/Anadyr"),
    AQTAU(195, "Asia/Aqtau"),
    AQTOBE(196, "Asia/Aqtobe"),
    ASHGABAT(197, "Asia/Ashgabat"),
    BAGHDAD(198, "Asia/Baghdad"),
    BAHRAIN(199, "Asia/Bahrain"),
    BAKU(200, "Asia/Baku"),
    BANGKOK(201, "Asia/Bangkok"),
    BEIRUT(202, "Asia/Beirut"),
    BISHKEK(203, "Asia/Bishkek"),
    BRUNEI(204, "Asia/Brunei"),
    CALCUTTA(205, "Asia/Calcutta"),
    CHOIBALSAN(206, "Asia/Choibalsan"),
    COLOMBO(208, "Asia/Colombo"),
    DAMASCUS(209, "Asia/Damascus"),
    DHAKA(210, "Asia/Dhaka"),
    DILI(211, "Asia/Dili"),
    DUBAI(212, "Asia/Dubai"),
    DUSHANBE(213, "Asia/Dushanbe"),
    GAZA(214, "Asia/Gaza"),
    HONG_KONG(216, "Asia/Hong_Kong"),
    HOVD(217, "Asia/Hovd"),
    IRKUTSK(218, "Asia/Irkutsk"),
    JAKARTA(220, "Asia/Jakarta"),
    JAYAPURA(221, "Asia/Jayapura"),
    JERUSALEM(222, "Asia/Jerusalem"),
    KABUL(223, "Asia/Kabul"),
    KAMCHATKA(224, "Asia/Kamchatka"),
    KARACHI(225, "Asia/Karachi"),
    KATMANDU(227, "Asia/Katmandu"),
    KRASNOYARSK(228, "Asia/Krasnoyarsk"),
    KUALA_LUMPUR(229, "Asia/Kuala_Lumpur"),
    KUCHING(230, "Asia/Kuching"),
    KUWAIT(231, "Asia/Kuwait"),
    MACAU(232, "Asia/Macau"),
    MAGADAN(233, "Asia/Magadan"),
    MAKASSAR(234, "Asia/Makassar"),
    MANILA(235, "Asia/Manila"),
    MUSCAT(236, "Asia/Muscat"),
    NICOSIA(237, "Asia/Nicosia"),
    NOVOSIBIRSK(238, "Asia/Novosibirsk"),
    OMSK(239, "Asia/Omsk"),
    ORAL(240, "Asia/Oral"),
    PHNOM_PENH(241, "Asia/Phnom_Penh"),
    PONTIANAK(242, "Asia/Pontianak"),
    PYONGYANG(243, "Asia/Pyongyang"),
    QATAR(244, "Asia/Qatar"),
    QYZYLORDA(245, "Asia/Qyzylorda"),
    RANGOON(246, "Asia/Rangoon"),
    RIYADH(247, "Asia/Riyadh"),
    SAIGON(248, "Asia/Saigon"),
    SAKHALIN(249, "Asia/Sakhalin"),
    SAMARKAND(250, "Asia/Samarkand"),
    SEOUL(251, "Asia/Seoul"),
    SHANGHAI(252, "Asia/Shanghai"),
    SINGAPORE(253, "Asia/Singapore"),
    TAIPEI(254, "Asia/Taipei"),
    TASHKENT(255, "Asia/Tashkent"),
    TBILISI(256, "Asia/Tbilisi"),
    TEHRAN(257, "Asia/Tehran"),
    THIMPHU(258, "Asia/Thimphu"),
    TOKYO(259, "Asia/Tokyo"),
    ULAANBAATAR(260, "Asia/Ulaanbaatar"),
    URUMQI(261, "Asia/Urumqi"),
    VIENTIANE(262, "Asia/Vientiane"),
    VLADIVOSTOK(263, "Asia/Vladivostok"),
    YAKUTSK(264, "Asia/Yakutsk"),
    YEKATERINBURG(265, "Asia/Yekaterinburg"),
    YEREVAN(266, "Asia/Yerevan"),
    AZORES(267, "Atlantic/Azores"),
    BERMUDA(268, "Atlantic/Bermuda"),
    CANARY(269, "Atlantic/Canary"),
    CAPE_VERDE(270, "Atlantic/Cape_Verde"),
    FAEROE(271, "Atlantic/Faeroe"),
    MADEIRA(273, "Atlantic/Madeira"),
    REYKJAVIK(274, "Atlantic/Reykjavik"),
    SOUTH_GEORGIA(275, "Atlantic/South_Georgia"),
    STANLEY(276, "Atlantic/Stanley"),
    ST_HELENA(277, "Atlantic/St_Helena"),
    ADELAIDE(278, "Australia/Adelaide"),
    BRISBANE(279, "Australia/Brisbane"),
    BROKEN_HILL(280, "Australia/Broken_Hill"),
    DARWIN(281, "Australia/Darwin"),
    HOBART(282, "Australia/Hobart"),
    LINDEMAN(283, "Australia/Lindeman"),
    LORD_HOWE(284, "Australia/Lord_Howe"),
    MELBOURNE(285, "Australia/Melbourne"),
    PERTH(286, "Australia/Perth"),
    SYDNEY(287, "Australia/Sydney"),
    AMSTERDAM(288, "Europe/Amsterdam"),
    ANDORRA(289, "Europe/Andorra"),
    ATHENS(290, "Europe/Athens"),
    BELGRADE(292, "Europe/Belgrade"),
    BERLIN(293, "Europe/Berlin"),
    BRATISLAVA(294, "Europe/Bratislava"),
    BRUSSELS(295, "Europe/Brussels"),
    BUCHAREST(296, "Europe/Bucharest"),
    BUDAPEST(297, "Europe/Budapest"),
    CHISINAU(298, "Europe/Chisinau"),
    COPENHAGEN(299, "Europe/Copenhagen"),
    DUBLIN(300, "Europe/Dublin"),
    GIBRALTAR(301, "Europe/Gibraltar"),
    HELSINKI(302, "Europe/Helsinki"),
    ISTANBUL(303, "Europe/Istanbul"),
    KALININGRAD(304, "Europe/Kaliningrad"),
    KIEV(305, "Europe/Kiev"),
    LISBON(306, "Europe/Lisbon"),
    LJUBLJANA(307, "Europe/Ljubljana"),
    LONDON(308, "Europe/London"),
    LUXEMBOURG(309, "Europe/Luxembourg"),
    MADRID(310, "Europe/Madrid"),
    MALTA(311, "Europe/Malta"),
    MARIEHAMN(312, "Europe/Mariehamn"),
    MINSK(313, "Europe/Minsk"),
    MONACO(314, "Europe/Monaco"),
    MOSCOW(315, "Europe/Moscow"),
    OSLO(317, "Europe/Oslo"),
    PARIS(318, "Europe/Paris"),
    PRAGUE(319, "Europe/Prague"),
    RIGA(320, "Europe/Riga"),
    ROME(321, "Europe/Rome"),
    SAMARA(322, "Europe/Samara"),
    SAN_MARINO(323, "Europe/San_Marino"),
    SARAJEVO(324, "Europe/Sarajevo"),
    SIMFEROPOL(325, "Europe/Simferopol"),
    SKOPJE(326, "Europe/Skopje"),
    SOFIA(327, "Europe/Sofia"),
    STOCKHOLM(328, "Europe/Stockholm"),
    TALLINN(329, "Europe/Tallinn"),
    TIRANE(330, "Europe/Tirane"),
    UZHGOROD(331, "Europe/Uzhgorod"),
    VADUZ(332, "Europe/Vaduz"),
    VATICAN(333, "Europe/Vatican"),
    VIENNA(334, "Europe/Vienna"),
    VILNIUS(335, "Europe/Vilnius"),
    WARSAW(336, "Europe/Warsaw"),
    ZAGREB(337, "Europe/Zagreb"),
    ZAPOROZHYE(338, "Europe/Zaporozhye"),
    ZURICH(339, "Europe/Zurich"),
    ANTANANARIVO(340, "Indian/Antananarivo"),
    CHAGOS(341, "Indian/Chagos"),
    CHRISTMAS(342, "Indian/Christmas"),
    COCOS(343, "Indian/Cocos"),
    COMORO(344, "Indian/Comoro"),
    KERGUELEN(345, "Indian/Kerguelen"),
    MAHE(346, "Indian/Mahe"),
    MALDIVES(347, "Indian/Maldives"),
    MAURITIUS(348, "Indian/Mauritius"),
    MAYOTTE(349, "Indian/Mayotte"),
    REUNION(350, "Indian/Reunion"),
    APIA(351, "Pacific/Apia"),
    AUCKLAND(352, "Pacific/Auckland"),
    CHATHAM(353, "Pacific/Chatham"),
    EASTER(354, "Pacific/Easter"),
    EFATE(355, "Pacific/Efate"),
    ENDERBURY(356, "Pacific/Enderbury"),
    FAKAOFO(357, "Pacific/Fakaofo"),
    FIJI(358, "Pacific/Fiji"),
    FUNAFUTI(359, "Pacific/Funafuti"),
    GALAPAGOS(360, "Pacific/Galapagos"),
    GAMBIER(361, "Pacific/Gambier"),
    GUADALCANAL(362, "Pacific/Guadalcanal"),
    GUAM(363, "Pacific/Guam"),
    HONOLULU(364, "Pacific/Honolulu"),
    JOHNSTON(365, "Pacific/Johnston"),
    KIRITIMATI(366, "Pacific/Kiritimati"),
    KOSRAE(367, "Pacific/Kosrae"),
    KWAJALEIN(368, "Pacific/Kwajalein"),
    MAJURO(369, "Pacific/Majuro"),
    MARQUESAS(370, "Pacific/Marquesas"),
    MIDWAY(371, "Pacific/Midway"),
    NAURU(372, "Pacific/Nauru"),
    NIUE(373, "Pacific/Niue"),
    NORFOLK(374, "Pacific/Norfolk"),
    NOUMEA(375, "Pacific/Noumea"),
    PAGO_PAGO(376, "Pacific/Pago_Pago"),
    PALAU(377, "Pacific/Palau"),
    PITCAIRN(378, "Pacific/Pitcairn"),
    PONAPE(379, "Pacific/Ponape"),
    PORT_MORESBY(380, "Pacific/Port_Moresby"),
    RAROTONGA(381, "Pacific/Rarotonga"),
    SAIPAN(382, "Pacific/Saipan"),
    TAHITI(383, "Pacific/Tahiti"),
    TARAWA(384, "Pacific/Tarawa"),
    TONGATAPU(385, "Pacific/Tongatapu"),
    TRUK(386, "Pacific/Truk"),
    WAKE(387, "Pacific/Wake"),
    WALLIS(388, "Pacific/Wallis"),
    CORAL_HARBOUR(390, "America/Coral_Harbour"),
    CURRIE(391, "Australia/Currie"),
    GMT_M14(392, "Etc/GMT-14"),
    GMT_M13(393, "Etc/GMT-13"),
    GMT_M12(394, "Etc/GMT-12"),
    GMT_M11(395, "Etc/GMT-11"),
    GMT_M10(396, "Etc/GMT-10"),
    GMT_M9(397, "Etc/GMT-9"),
    GMT_M8(398, "Etc/GMT-8"),
    GMT_M7(399, "Etc/GMT-7"),
    GMT_M6(400, "Etc/GMT-6"),
    GMT_M5(401, "Etc/GMT-5"),
    GMT_M4(402, "Etc/GMT-4"),
    GMT_M3(403, "Etc/GMT-3"),
    GMT_M2(404, "Etc/GMT-2"),
    GMT_M1(405, "Etc/GMT-1"),
    GMT(406, "Etc/GMT"),
    GMT_P1(407, "Etc/GMT+1"),
    GMT_P2(408, "Etc/GMT+2"),
    GMT_P3(409, "Etc/GMT+3"),
    GMT_P4(410, "Etc/GMT+4"),
    GMT_P5(411, "Etc/GMT+5"),
    GMT_P6(412, "Etc/GMT+6"),
    GMT_P7(413, "Etc/GMT+7"),
    GMT_P8(414, "Etc/GMT+8"),
    GMT_P9(415, "Etc/GMT+9"),
    GMT_P10(416, "Etc/GMT+10"),
    GMT_P11(417, "Etc/GMT+11"),
    GMT_P12(418, "Etc/GMT+12"),
    NEW_SALEM(419, "America/North_Dakota/New_Salem"),
    PETERSBURG(420, "America/Indiana/Petersburg"),
    VINCENNES(421, "America/Indiana/Vincennes"),
    MONCTON(422, "America/Moncton"),
    BLANC_SABLON(423, "America/Blanc-Sablon"),
    GUERNSEY(424, "Europe/Guernsey"),
    ISLE_OF_MAN(425, "Europe/Isle_of_Man"),
    JERSEY(426, "Europe/Jersey"),
    PODGORICA(427, "Europe/Podgorica"),
    VOLGOGRAD(428, "Europe/Volgograd"),
    WINAMAC(429, "America/Indiana/Winamac"),
    EUCLA(430, "Australia/Eucla"),
    TELL_CITY(431, "America/Indiana/Tell_City"),
    RESOLUTE(432, "America/Resolute"),
    SAN_LUIS(433, "America/Argentina/San_Luis"),
    SANTAREM(434, "America/Santarem"),
    SALTA(435, "America/Argentina/Salta"),
    BAHIA_BANDERAS(436, "America/Bahia_Banderas"),
    MARIGOT(437, "America/Marigot"),
    MATAMOROS(438, "America/Matamoros"),
    OJINAGA(439, "America/Ojinaga"),
    SANTA_ISABEL(440, "America/Santa_Isabel"),
    ST_BARTHELEMY(441, "America/St_Barthelemy"),
    MACQUARIE(442, "Antarctica/Macquarie"),
    NOVOKUZNETSK(443, "Asia/Novokuznetsk"),
    JUBA(444, "Africa/Juba"),
    METLAKATLA(445, "America/Metlakatla"),
    BEULAH(446, "America/North_Dakota/Beulah"),
    SITKA(447, "America/Sitka"),
    HEBRON(448, "Asia/Hebron"),
    CRESTON(449, "America/Creston"),
    KRALENDIJK(450, "America/Kralendijk"),
    LOWER_PRINCES(451, "America/Lower_Princes"),
    TROLL(452, "Antarctica/Troll"),
    KHANDYGA(453, "Asia/Khandyga"),
    UST_NERA(454, "Asia/Ust-Nera"),
    BUSINGEN(455, "Europe/Busingen"),
    CHITA(456, "Asia/Chita"),
    SREDNEKOLYMSK(457, "Asia/Srednekolymsk"),
    FORT_NELSON(458, "America/Fort_Nelson"),
    BOUGAINVILLE(459, "Pacific/Bougainville"),
    ASTRAKHAN(460, "Europe/Astrakhan"),
    BARNAUL(461, "Asia/Barnaul"),
    KIROV(462, "Europe/Kirov"),
    TOMSK(463, "Asia/Tomsk"),
    ULYANOVSK(464, "Europe/Ulyanovsk"),
    PUNTA_ARENAS(465, "America/Punta_Arenas"),
    FAMAGUSTA(466, "Asia/Famagusta"),
    ATYRAU(467, "Asia/Atyrau"),
    SARATOV(468, "Europe/Saratov"),
    UTC(469, "Etc/UTC");

    private static final int NUM_TIMEZONES = 470;
    public static final TimeZoneId JAN_MAYEN;
    public static final TimeZoneId SHIPROCK;
    public static final TimeZoneId SOUTH_POLE;
    public static final TimeZoneId CHONGQING;
    public static final TimeZoneId HARBIN;
    public static final TimeZoneId KASHGAR;
    private static final TimeZoneId[] adsDbArray;
    private static final Map<String, TimeZoneId> stringMap;
    private final int numericValue;
    private final String stringValue;

    public static int getNumberOfTimeZones() {
        return 470;
    }

    public static CodeConverter.Status getStatus(String strValue) {
        if (stringMap.containsKey(strValue)) {
            String canonicalValue = stringMap.get(strValue).toString();
            if (canonicalValue.equals(strValue)) {
                return CodeConverter.Status.CANONICAL;
            }
            return CodeConverter.Status.NON_CANONICAL;
        }
        return CodeConverter.Status.INVALID;
    }

    public static CodeConverter.Status getStatus(int numValue) {
        if (numValue >= 0 && numValue < 470) {
            int canonicalValue = adsDbArray[numValue].toNumber();
            if (canonicalValue == numValue) {
                return CodeConverter.Status.CANONICAL;
            }
            return CodeConverter.Status.NON_CANONICAL;
        }
        return CodeConverter.Status.INVALID;
    }

    public static TimeZoneId forString(@Nullable String strValue) {
        TimeZoneId val = stringMap.get(strValue);
        if (val == null) {
            return UNKNOWN;
        }
        return val;
    }

    public static TimeZoneId forNumber(int numValue) {
        if (numValue >= 0 && numValue < 470) {
            return adsDbArray[numValue];
        }
        return UNKNOWN;
    }

    public static Set<String> allAliasStrings() {
        return stringMap.keySet();
    }

    public int toNumber() {
        return this.numericValue;
    }

    @GwtIncompatible(value="DateTimeZone")
    public DateTimeZone toJoda() {
        return DateTimeZone.forID(this.toString());
    }

    public String toString() {
        return this.stringValue;
    }

    private TimeZoneId(int numValue, String strValue) {
        this.numericValue = numValue;
        this.stringValue = strValue;
    }

    static {
        JAN_MAYEN = LONGYEARBYEN;
        SHIPROCK = DENVER;
        SOUTH_POLE = AUCKLAND;
        CHONGQING = SHANGHAI;
        HARBIN = SHANGHAI;
        KASHGAR = URUMQI;
        HashMap<String, TimeZoneId> tempStringTzMap = Maps.newHashMap();
        TimeZoneId[] tempTzArray = new TimeZoneId[470];
        for (TimeZoneId tz : TimeZoneId.values()) {
            tempStringTzMap.put(tz.stringValue, tz);
            tempTzArray[tz.numericValue] = tz;
        }
        tempStringTzMap.put("Africa/Asmara", ASMERA);
        tempStringTzMap.put("Africa/Timbuktu", BAMAKO);
        tempStringTzMap.put("America/Argentina/Buenos_Aires", BUENOS_AIRES);
        tempStringTzMap.put("America/Argentina/Catamarca", CATAMARCA);
        tempStringTzMap.put("America/Argentina/ComodRivadavia", CATAMARCA);
        tempStringTzMap.put("America/Argentina/Cordoba", CORDOBA);
        tempStringTzMap.put("America/Argentina/Jujuy", JUJUY);
        tempStringTzMap.put("America/Argentina/Mendoza", MENDOZA);
        tempStringTzMap.put("America/Atikokan", CORAL_HARBOUR);
        tempStringTzMap.put("America/Atka", ADAK);
        tempStringTzMap.put("America/Ensenada", TIJUANA);
        tempStringTzMap.put("America/Fort_Wayne", INDIANAPOLIS);
        tempStringTzMap.put("America/Indiana/Indianapolis", INDIANAPOLIS);
        tempStringTzMap.put("America/Kentucky/Louisville", LOUISVILLE);
        tempStringTzMap.put("America/Knox_IN", KNOX);
        tempStringTzMap.put("America/Porto_Acre", RIO_BRANCO);
        tempStringTzMap.put("America/Rosario", CORDOBA);
        tempStringTzMap.put("America/Shiprock", DENVER);
        tempStringTzMap.put("America/Virgin", ST_THOMAS);
        tempStringTzMap.put("Antarctica/South_Pole", AUCKLAND);
        tempStringTzMap.put("Asia/Ashkhabad", ASHGABAT);
        tempStringTzMap.put("Asia/Chongqing", SHANGHAI);
        tempStringTzMap.put("Asia/Chungking", SHANGHAI);
        tempStringTzMap.put("Asia/Dacca", DHAKA);
        tempStringTzMap.put("Asia/Harbin", SHANGHAI);
        tempStringTzMap.put("Asia/Ho_Chi_Minh", SAIGON);
        tempStringTzMap.put("Asia/Istanbul", ISTANBUL);
        tempStringTzMap.put("Asia/Kashgar", URUMQI);
        tempStringTzMap.put("Asia/Kathmandu", KATMANDU);
        tempStringTzMap.put("Asia/Kolkata", CALCUTTA);
        tempStringTzMap.put("Asia/Macao", MACAU);
        tempStringTzMap.put("Asia/Tel_Aviv", JERUSALEM);
        tempStringTzMap.put("Asia/Thimbu", THIMPHU);
        tempStringTzMap.put("Asia/Ujung_Pandang", MAKASSAR);
        tempStringTzMap.put("Asia/Ulan_Bator", ULAANBAATAR);
        tempStringTzMap.put("Asia/Yangon", RANGOON);
        tempStringTzMap.put("Atlantic/Faroe", FAEROE);
        tempStringTzMap.put("Atlantic/Jan_Mayen", LONGYEARBYEN);
        tempStringTzMap.put("Australia/ACT", SYDNEY);
        tempStringTzMap.put("Australia/Canberra", SYDNEY);
        tempStringTzMap.put("Australia/LHI", LORD_HOWE);
        tempStringTzMap.put("Australia/NSW", SYDNEY);
        tempStringTzMap.put("Australia/North", DARWIN);
        tempStringTzMap.put("Australia/Queensland", BRISBANE);
        tempStringTzMap.put("Australia/South", ADELAIDE);
        tempStringTzMap.put("Australia/Tasmania", HOBART);
        tempStringTzMap.put("Australia/Victoria", MELBOURNE);
        tempStringTzMap.put("Australia/West", PERTH);
        tempStringTzMap.put("Australia/Yancowinna", BROKEN_HILL);
        tempStringTzMap.put("Brazil/Acre", RIO_BRANCO);
        tempStringTzMap.put("Brazil/DeNoronha", NORONHA);
        tempStringTzMap.put("Brazil/East", SAO_PAULO);
        tempStringTzMap.put("Brazil/West", MANAUS);
        tempStringTzMap.put("CST6CDT", CHICAGO);
        tempStringTzMap.put("Canada/Atlantic", HALIFAX);
        tempStringTzMap.put("Canada/Central", WINNIPEG);
        tempStringTzMap.put("Canada/East-Saskatchewan", REGINA);
        tempStringTzMap.put("Canada/Eastern", TORONTO);
        tempStringTzMap.put("Canada/Mountain", EDMONTON);
        tempStringTzMap.put("Canada/Newfoundland", ST_JOHNS);
        tempStringTzMap.put("Canada/Pacific", VANCOUVER);
        tempStringTzMap.put("Canada/Saskatchewan", REGINA);
        tempStringTzMap.put("Canada/Yukon", WHITEHORSE);
        tempStringTzMap.put("Chile/Continental", SANTIAGO);
        tempStringTzMap.put("Chile/EasterIsland", EASTER);
        tempStringTzMap.put("Cuba", HAVANA);
        tempStringTzMap.put("EST", GMT_P5);
        tempStringTzMap.put("EST5EDT", NEW_YORK);
        tempStringTzMap.put("Egypt", CAIRO);
        tempStringTzMap.put("Eire", DUBLIN);
        tempStringTzMap.put("Etc/GMT+0", GMT);
        tempStringTzMap.put("Etc/GMT-0", GMT);
        tempStringTzMap.put("Etc/GMT0", GMT);
        tempStringTzMap.put("Etc/Greenwich", GMT);
        tempStringTzMap.put("Etc/UCT", UTC);
        tempStringTzMap.put("Etc/Universal", UTC);
        tempStringTzMap.put("Etc/Zulu", UTC);
        tempStringTzMap.put("Europe/Belfast", LONDON);
        tempStringTzMap.put("Europe/Nicosia", NICOSIA);
        tempStringTzMap.put("Europe/Tiraspol", CHISINAU);
        tempStringTzMap.put("GB", LONDON);
        tempStringTzMap.put("GB-Eire", LONDON);
        tempStringTzMap.put("GMT", GMT);
        tempStringTzMap.put("GMT+0", GMT);
        tempStringTzMap.put("GMT-0", GMT);
        tempStringTzMap.put("GMT0", GMT);
        tempStringTzMap.put("Greenwich", GMT);
        tempStringTzMap.put("HST", GMT_P10);
        tempStringTzMap.put("Hongkong", HONG_KONG);
        tempStringTzMap.put("Iceland", REYKJAVIK);
        tempStringTzMap.put("Iran", TEHRAN);
        tempStringTzMap.put("Israel", JERUSALEM);
        tempStringTzMap.put("Jamaica", JAMAICA);
        tempStringTzMap.put("Japan", TOKYO);
        tempStringTzMap.put("Kwajalein", KWAJALEIN);
        tempStringTzMap.put("Libya", TRIPOLI);
        tempStringTzMap.put("MST", GMT_P7);
        tempStringTzMap.put("MST7MDT", DENVER);
        tempStringTzMap.put("Mexico/BajaNorte", TIJUANA);
        tempStringTzMap.put("Mexico/BajaSur", MAZATLAN);
        tempStringTzMap.put("Mexico/General", MEXICO_CITY);
        tempStringTzMap.put("NZ", AUCKLAND);
        tempStringTzMap.put("NZ-CHAT", CHATHAM);
        tempStringTzMap.put("Navajo", DENVER);
        tempStringTzMap.put("PRC", SHANGHAI);
        tempStringTzMap.put("PST8PDT", LOS_ANGELES);
        tempStringTzMap.put("Pacific/Chuuk", TRUK);
        tempStringTzMap.put("Pacific/Pohnpei", PONAPE);
        tempStringTzMap.put("Pacific/Samoa", PAGO_PAGO);
        tempStringTzMap.put("Pacific/Yap", TRUK);
        tempStringTzMap.put("Poland", WARSAW);
        tempStringTzMap.put("Portugal", LISBON);
        tempStringTzMap.put("ROC", TAIPEI);
        tempStringTzMap.put("ROK", SEOUL);
        tempStringTzMap.put("Singapore", SINGAPORE);
        tempStringTzMap.put("SystemV/AST4", GMT_P4);
        tempStringTzMap.put("SystemV/AST4ADT", HALIFAX);
        tempStringTzMap.put("SystemV/CST6", GMT_P6);
        tempStringTzMap.put("SystemV/CST6CDT", CHICAGO);
        tempStringTzMap.put("SystemV/EST5", GMT_P5);
        tempStringTzMap.put("SystemV/EST5EDT", NEW_YORK);
        tempStringTzMap.put("SystemV/HST10", GMT_P10);
        tempStringTzMap.put("SystemV/MST7", GMT_P7);
        tempStringTzMap.put("SystemV/MST7MDT", DENVER);
        tempStringTzMap.put("SystemV/PST8", GMT_P8);
        tempStringTzMap.put("SystemV/PST8PDT", LOS_ANGELES);
        tempStringTzMap.put("SystemV/YST9", GMT_P9);
        tempStringTzMap.put("SystemV/YST9YDT", ANCHORAGE);
        tempStringTzMap.put("Turkey", ISTANBUL);
        tempStringTzMap.put("UCT", UTC);
        tempStringTzMap.put("US/Alaska", ANCHORAGE);
        tempStringTzMap.put("US/Aleutian", ADAK);
        tempStringTzMap.put("US/Arizona", PHOENIX);
        tempStringTzMap.put("US/Central", CHICAGO);
        tempStringTzMap.put("US/East-Indiana", INDIANAPOLIS);
        tempStringTzMap.put("US/Eastern", NEW_YORK);
        tempStringTzMap.put("US/Hawaii", HONOLULU);
        tempStringTzMap.put("US/Indiana-Starke", KNOX);
        tempStringTzMap.put("US/Michigan", DETROIT);
        tempStringTzMap.put("US/Mountain", DENVER);
        tempStringTzMap.put("US/Pacific", LOS_ANGELES);
        tempStringTzMap.put("US/Pacific-New", LOS_ANGELES);
        tempStringTzMap.put("US/Samoa", PAGO_PAGO);
        tempStringTzMap.put("UTC", UTC);
        tempStringTzMap.put("Universal", UTC);
        tempStringTzMap.put("W-SU", MOSCOW);
        tempStringTzMap.put("Zulu", UTC);
        tempTzArray[50] = BAMAKO;
        tempTzArray[61] = CATAMARCA;
        tempTzArray[112] = INDIANAPOLIS;
        tempTzArray[121] = LOUISVILLE;
        tempTzArray[162] = DENVER;
        tempTzArray[187] = AUCKLAND;
        tempTzArray[207] = SHANGHAI;
        tempTzArray[215] = SHANGHAI;
        tempTzArray[219] = ISTANBUL;
        tempTzArray[226] = URUMQI;
        tempTzArray[272] = LONGYEARBYEN;
        tempTzArray[291] = LONDON;
        tempTzArray[316] = NICOSIA;
        tempTzArray[389] = TRUK;
        stringMap = Collections.unmodifiableMap(tempStringTzMap);
        adsDbArray = tempTzArray;
    }
}

