/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.i18n.identifiers.CaseNormalizingStringConverter;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.LanguageCode;
import java.util.Locale;
import java.util.regex.Pattern;

public class TranslationConsoleConverter
extends CaseNormalizingStringConverter<LanguageCode> {
    public static final TranslationConsoleConverter CONVERTER = new TranslationConsoleConverter();
    private static final Pattern validRfc1766 = Pattern.compile("[a-zA-Z]{1,8}([-][a-zA-Z0-9]{1,8})*");

    @Override
    public LanguageCode getUnknown() {
        return LanguageCode.forString("und");
    }

    private void addTo(LanguageCode lc, String other) {
        this.mapToString.put(lc, this.normalize(other));
    }

    private void addFrom(String other, LanguageCode lc) {
        this.mapFromString.put(this.normalize(other), lc);
    }

    private void addOneWay(String canonical, String nonCanonical) {
        this.addTo(LanguageCode.forString(nonCanonical, CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS), canonical);
        this.addFrom(nonCanonical, LanguageCode.forString(canonical));
    }

    @Override
    public CodeConverter.Status getStatusFromOther(String otherCode) {
        if (!validRfc1766.matcher(otherCode).matches()) {
            return CodeConverter.Status.ILL_FORMED;
        }
        LanguageCode languageCode = (LanguageCode)this.fromOther(otherCode);
        if (!this.getUnknown().equals(languageCode) || "un".equals(otherCode.toLowerCase(Locale.ENGLISH))) {
            return languageCode.getStatus();
        }
        return CodeConverter.Status.INVALID;
    }

    @Override
    public CodeConverter.Status getStatus(LanguageCode languageCode) {
        String otherCode = (String)this.toOther(languageCode);
        if (!this.getUnknown().equals(languageCode) || "un".equals(otherCode)) {
            return languageCode.getStatus();
        }
        return CodeConverter.Status.INVALID;
    }

    private TranslationConsoleConverter() {
        this.add("aa", LanguageCode.forString("aa"));
        this.add("ab", LanguageCode.forString("ab"));
        this.add("ach", LanguageCode.forString("ach"));
        this.add("af", LanguageCode.forString("af"));
        this.add("ak", LanguageCode.forString("ak"));
        this.add("am", LanguageCode.forString("am"));
        this.add("ar", LanguageCode.forString("ar"));
        this.add("as", LanguageCode.forString("as"));
        this.add("av", LanguageCode.forString("av"));
        this.add("ay", LanguageCode.forString("ay"));
        this.add("az", LanguageCode.forString("az"));
        this.add("ba", LanguageCode.forString("ba"));
        this.add("be", LanguageCode.forString("be"));
        this.add("bg", LanguageCode.forString("bg"));
        this.add("bh", LanguageCode.forString("bh"));
        this.add("bi", LanguageCode.forString("bi"));
        this.add("bm", LanguageCode.forString("bm"));
        this.add("bn", LanguageCode.forString("bn"));
        this.add("bo", LanguageCode.forString("bo"));
        this.add("br", LanguageCode.forString("br"));
        this.add("bs", LanguageCode.forString("bs"));
        this.add("ca", LanguageCode.forString("ca"));
        this.add("ce", LanguageCode.forString("ce"));
        this.add("chr", LanguageCode.forString("chr"));
        this.add("co", LanguageCode.forString("co"));
        this.add("cs", LanguageCode.forString("cs"));
        this.add("cu", LanguageCode.forString("cu"));
        this.add("cy", LanguageCode.forString("cy"));
        this.add("da", LanguageCode.forString("da"));
        this.add("de", LanguageCode.forString("de"));
        this.add("de-AT", LanguageCode.forString("de-AT"));
        this.add("de-CH", LanguageCode.forString("de-CH"));
        this.add("dv", LanguageCode.forString("dv"));
        this.add("dz", LanguageCode.forString("dz"));
        this.add("ee", LanguageCode.forString("ee"));
        this.add("el", LanguageCode.forString("el"));
        this.add("en", LanguageCode.forString("en"));
        this.add("en-AU", LanguageCode.forString("en-AU"));
        this.add("en-CA", LanguageCode.forString("en-CA"));
        this.add("en-GB", LanguageCode.forString("en-GB"));
        this.add("en-IE", LanguageCode.forString("en-IE"));
        this.add("en-IN", LanguageCode.forString("en-IN"));
        this.add("en-SG", LanguageCode.forString("en-SG"));
        this.add("en-ZA", LanguageCode.forString("en-ZA"));
        this.add("eo", LanguageCode.forString("eo"));
        this.add("es", LanguageCode.forString("es"));
        this.add("es-419", LanguageCode.forString("es-419"));
        this.add("es-AR", LanguageCode.forString("es-AR"));
        this.add("es-BO", LanguageCode.forString("es-BO"));
        this.add("es-CL", LanguageCode.forString("es-CL"));
        this.add("es-CO", LanguageCode.forString("es-CO"));
        this.add("es-CR", LanguageCode.forString("es-CR"));
        this.add("es-DO", LanguageCode.forString("es-DO"));
        this.add("es-EC", LanguageCode.forString("es-EC"));
        this.add("es-GT", LanguageCode.forString("es-GT"));
        this.add("es-HN", LanguageCode.forString("es-HN"));
        this.add("es-MX", LanguageCode.forString("es-MX"));
        this.add("es-NI", LanguageCode.forString("es-NI"));
        this.add("es-PA", LanguageCode.forString("es-PA"));
        this.add("es-PE", LanguageCode.forString("es-PE"));
        this.add("es-PR", LanguageCode.forString("es-PR"));
        this.add("es-PY", LanguageCode.forString("es-PY"));
        this.add("es-SV", LanguageCode.forString("es-SV"));
        this.add("es-US", LanguageCode.forString("es-US"));
        this.add("es-UY", LanguageCode.forString("es-UY"));
        this.add("es-VE", LanguageCode.forString("es-VE"));
        this.add("et", LanguageCode.forString("et"));
        this.add("eu", LanguageCode.forString("eu"));
        this.add("fa", LanguageCode.forString("fa"));
        this.add("ff", LanguageCode.forString("ff"));
        this.add("fi", LanguageCode.forString("fi"));
        this.add("fil", LanguageCode.forString("fil"));
        this.add("fj", LanguageCode.forString("fj"));
        this.add("fo", LanguageCode.forString("fo"));
        this.add("fr", LanguageCode.forString("fr"));
        this.add("fr-CA", LanguageCode.forString("fr-CA"));
        this.add("fr-CH", LanguageCode.forString("fr-CH"));
        this.add("fy", LanguageCode.forString("fy"));
        this.add("ga", LanguageCode.forString("ga"));
        this.add("gd", LanguageCode.forString("gd"));
        this.add("gl", LanguageCode.forString("gl"));
        this.add("gn", LanguageCode.forString("gn"));
        this.add("gsw", LanguageCode.forString("gsw"));
        this.add("gu", LanguageCode.forString("gu"));
        this.add("ha", LanguageCode.forString("ha"));
        this.add("haw", LanguageCode.forString("haw"));
        this.add("hi", LanguageCode.forString("hi"));
        this.add("hr", LanguageCode.forString("hr"));
        this.add("ht", LanguageCode.forString("ht"));
        this.add("hu", LanguageCode.forString("hu"));
        this.add("hy", LanguageCode.forString("hy"));
        this.add("hz", LanguageCode.forString("hz"));
        this.add("ia", LanguageCode.forString("ia"));
        this.add("id", LanguageCode.forString("id"));
        this.add("ie", LanguageCode.forString("ie"));
        this.add("ig", LanguageCode.forString("ig"));
        this.add("ik", LanguageCode.forString("ik"));
        this.add("is", LanguageCode.forString("is"));
        this.add("it", LanguageCode.forString("it"));
        this.add("iu", LanguageCode.forString("iu"));
        this.add("iw", LanguageCode.forString("iw"));
        this.add("ja", LanguageCode.forString("ja"));
        this.add("jv", LanguageCode.forString("jv"));
        this.add("ka", LanguageCode.forString("ka"));
        this.add("kg", LanguageCode.forString("kg"));
        this.add("ki", LanguageCode.forString("ki"));
        this.add("kj", LanguageCode.forString("kj"));
        this.add("kk", LanguageCode.forString("kk"));
        this.add("kl", LanguageCode.forString("kl"));
        this.add("km", LanguageCode.forString("km"));
        this.add("kn", LanguageCode.forString("kn"));
        this.add("ko", LanguageCode.forString("ko"));
        this.add("kr", LanguageCode.forString("kr"));
        this.add("ks", LanguageCode.forString("ks"));
        this.add("ku", LanguageCode.forString("ku"));
        this.add("kv", LanguageCode.forString("kv"));
        this.add("ky", LanguageCode.forString("ky"));
        this.add("la", LanguageCode.forString("la"));
        this.add("lg", LanguageCode.forString("lg"));
        this.add("ln", LanguageCode.forString("ln"));
        this.add("lo", LanguageCode.forString("lo"));
        this.add("lt", LanguageCode.forString("lt"));
        this.add("lu", LanguageCode.forString("lu"));
        this.add("lua", LanguageCode.forString("lua"));
        this.add("lv", LanguageCode.forString("lv"));
        this.add("mfe", LanguageCode.forString("mfe"));
        this.add("mg", LanguageCode.forString("mg"));
        this.add("mi", LanguageCode.forString("mi"));
        this.add("mk", LanguageCode.forString("mk"));
        this.add("ml", LanguageCode.forString("ml"));
        this.add("mn", LanguageCode.forString("mn"));
        this.add("mr", LanguageCode.forString("mr"));
        this.add("ms", LanguageCode.forString("ms"));
        this.add("mt", LanguageCode.forString("mt"));
        this.add("my", LanguageCode.forString("my"));
        this.add("na", LanguageCode.forString("na"));
        this.add("nd", LanguageCode.forString("nd"));
        this.add("ne", LanguageCode.forString("ne"));
        this.add("ng", LanguageCode.forString("ng"));
        this.add("nl", LanguageCode.forString("nl"));
        this.add("nn", LanguageCode.forString("nn"));
        this.add("no", LanguageCode.forString("no"));
        this.add("nr", LanguageCode.forString("nr"));
        this.add("nv", LanguageCode.forString("nv"));
        this.add("ny", LanguageCode.forString("ny"));
        this.add("nyn", LanguageCode.forString("nyn"));
        this.add("oc", LanguageCode.forString("oc"));
        this.add("om", LanguageCode.forString("om"));
        this.add("or", LanguageCode.forString("or"));
        this.add("pa", LanguageCode.forString("pa"));
        this.add("pl", LanguageCode.forString("pl"));
        this.add("ps", LanguageCode.forString("ps"));
        this.add("pt", LanguageCode.forString("pt"));
        this.add("pt-BR", LanguageCode.forString("pt-BR"));
        this.add("pt-PT", LanguageCode.forString("pt-PT"));
        this.add("qu", LanguageCode.forString("qu"));
        this.add("rm", LanguageCode.forString("rm"));
        this.add("rn", LanguageCode.forString("rn"));
        this.add("ro", LanguageCode.forString("ro"));
        this.add("ru", LanguageCode.forString("ru"));
        this.add("rw", LanguageCode.forString("rw"));
        this.add("sa", LanguageCode.forString("sa"));
        this.add("sc", LanguageCode.forString("sc"));
        this.add("sd", LanguageCode.forString("sd"));
        this.add("sg", LanguageCode.forString("sg"));
        this.add("sh", LanguageCode.forString("sh"));
        this.add("si", LanguageCode.forString("si"));
        this.add("sk", LanguageCode.forString("sk"));
        this.add("sl", LanguageCode.forString("sl"));
        this.add("sm", LanguageCode.forString("sm"));
        this.add("sn", LanguageCode.forString("sn"));
        this.add("so", LanguageCode.forString("so"));
        this.add("sq", LanguageCode.forString("sq"));
        this.add("sr", LanguageCode.forString("sr"));
        this.add("sr-ME", LanguageCode.forString("sr-ME"));
        this.add("ss", LanguageCode.forString("ss"));
        this.add("st", LanguageCode.forString("st"));
        this.add("su", LanguageCode.forString("su"));
        this.add("sv", LanguageCode.forString("sv"));
        this.add("sw", LanguageCode.forString("sw"));
        this.add("ta", LanguageCode.forString("ta"));
        this.add("te", LanguageCode.forString("te"));
        this.add("tg", LanguageCode.forString("tg"));
        this.add("th", LanguageCode.forString("th"));
        this.add("ti", LanguageCode.forString("ti"));
        this.add("tk", LanguageCode.forString("tk"));
        this.add("tn", LanguageCode.forString("tn"));
        this.add("to", LanguageCode.forString("to"));
        this.add("tr", LanguageCode.forString("tr"));
        this.add("ts", LanguageCode.forString("ts"));
        this.add("tt", LanguageCode.forString("tt"));
        this.add("ty", LanguageCode.forString("ty"));
        this.add("ug", LanguageCode.forString("ug"));
        this.add("uk", LanguageCode.forString("uk"));
        this.add("ur", LanguageCode.forString("ur"));
        this.add("uz", LanguageCode.forString("uz"));
        this.add("ve", LanguageCode.forString("ve"));
        this.add("vi", LanguageCode.forString("vi"));
        this.add("vo", LanguageCode.forString("vo"));
        this.add("wo", LanguageCode.forString("wo"));
        this.add("xh", LanguageCode.forString("xh"));
        this.add("yi", LanguageCode.forString("yi"));
        this.add("yo", LanguageCode.forString("yo"));
        this.add("za", LanguageCode.forString("za"));
        this.add("zh-CN", LanguageCode.forString("zh-CN"));
        this.add("zh-HK", LanguageCode.forString("zh-HK"));
        this.add("zh-TW", LanguageCode.forString("zh-TW"));
        this.add("zu", LanguageCode.forString("zu"));
        this.add("en-US-pseudo", LanguageCode.forString("en-US-x-PSEUDO"));
        this.add("xx-bork", LanguageCode.forString("x-bork"));
        this.add("xx-elmer", LanguageCode.forString("x-elmer"));
        this.add("xx-hacker", LanguageCode.forString("x-hacker"));
        this.add("xx-klingon", LanguageCode.forString("tlh"));
        this.add("xx-piglatin", LanguageCode.forString("x-piglatin"));
        this.add("xx-pirate", LanguageCode.forString("x-pirate"));
        this.add("un", LanguageCode.forString("und"));
        this.addTo(LanguageCode.forString("sr-Latn"), "sh");
        this.addTo(LanguageCode.forString("zh-Hans"), "zh-CN");
        this.addTo(LanguageCode.forString("zh-Hans-CN"), "zh-CN");
        this.addTo(LanguageCode.forString("zh-Hant"), "zh-TW");
        this.addTo(LanguageCode.forString("zh-Hant-TW"), "zh-TW");
        this.addOneWay("ak", "tw");
        this.addOneWay("fil", "tl");
        this.addOneWay("iw", "he");
        this.addOneWay("ro", "mo");
        this.addOneWay("id", "in");
        this.addOneWay("jv", "jw");
        this.addOneWay("no", "nb");
        this.addOneWay("yi", "ji");
        this.addOneWay("zh-CN", "zh");
    }
}

