/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.ibm.icu.util.ULocale;
import java.util.Set;

public class ULocaleConverter
implements CodeConverter<LanguageCode, ULocale> {
    public static final ULocaleConverter CONVERTER = new ULocaleConverter();
    private static final String ULOCALE_GRANDFATHERED_VARIANT_ID = ".*-x-lvariant-.*";
    private static final ULocale undefinedUlocale = new ULocale("und");

    @Override
    public ULocale toOther(LanguageCode languageCode) {
        return new ULocale(languageCode.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LanguageCode fromOther(ULocale uLocale) {
        Set extensions = uLocale.getExtensionKeys();
        String languageTagString = uLocale.toLanguageTag();
        if (extensions.contains(Character.valueOf('x'))) {
            if ("".equals(uLocale.getLanguage()) && !languageTagString.startsWith("x-")) {
                if (!languageTagString.startsWith("und-x-")) return this.getUnknown();
                languageTagString = languageTagString.substring(4);
            }
        } else if (!uLocale.getVariant().isEmpty()) {
            languageTagString = uLocale.toString().replaceAll("__", "_");
        } else {
            if (ULocaleConverter.hasInvalidParts(uLocale, languageTagString)) {
                return this.getUnknown();
            }
            if (languageTagString.matches(ULOCALE_GRANDFATHERED_VARIANT_ID)) {
                languageTagString = uLocale.toString();
            }
        }
        try {
            return LanguageCode.forString(languageTagString);
        }
        catch (LanguageCode.InvalidLanguageCode e) {
            return this.getUnknown();
        }
        catch (LanguageCode.IllFormedLanguageCode e) {
            return this.getUnknown();
        }
    }

    private static boolean hasInvalidParts(ULocale uLocale, String languageTag) {
        boolean hasVariant;
        if (languageTag.length() >= 3 && "und".equals(languageTag.substring(0, 3)) && !"und".equals(uLocale.getLanguage())) {
            return true;
        }
        boolean hasRegion = !"".equals(uLocale.getCountry());
        boolean hasScript = !"".equals(uLocale.getScript());
        boolean bl = hasVariant = !"".equals(uLocale.getVariant());
        if (!(hasRegion || hasScript || hasVariant)) {
            return false;
        }
        ULocale reparsedLocale = ULocale.forLanguageTag((String)languageTag);
        return hasRegion && "".equals(reparsedLocale.getCountry()) || hasScript && "".equals(reparsedLocale.getScript()) || hasVariant && "".equals(reparsedLocale.getVariant());
    }

    @Override
    public CodeConverter.Status getStatusFromOther(ULocale uLocale) {
        LanguageCode languageCode = this.fromOther(uLocale);
        if (!LanguageCode.UNDEFINED.equals(languageCode) || undefinedUlocale.equals((Object)uLocale)) {
            return languageCode.getStatus();
        }
        try {
            languageCode = LanguageCode.forString(uLocale.toString().replace("__", "_"));
            return languageCode.getStatus();
        }
        catch (LanguageCode.InvalidLanguageCode e) {
            return CodeConverter.Status.INVALID;
        }
        catch (LanguageCode.IllFormedLanguageCode e) {
            return CodeConverter.Status.ILL_FORMED;
        }
    }

    @Override
    public CodeConverter.Status getStatus(LanguageCode languageCode) {
        return languageCode.getStatus();
    }

    @Override
    public LanguageCode getUnknown() {
        return LanguageCode.UNKNOWN;
    }
}

