/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.money.CurrencyCode;
import com.google.i18n.identifiers.CurrencyInfo;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.impl.StandardRegionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.LocalDate;

public class CurrencyInfoImpl
implements CurrencyInfo {
    private final Multimap<CurrencyCode, RegionCurrencyRecord> currencyMap = ArrayListMultimap.create();
    private final Multimap<RegionCode, RegionCurrencyRecord> regionMap = ArrayListMultimap.create();

    @Inject
    public CurrencyInfoImpl(Set<RegionCurrencyRecord> records) {
        for (RegionCurrencyRecord r : records) {
            this.currencyMap.put(r.currency, r);
            this.regionMap.put(r.region, r);
        }
    }

    @Override
    public Set<RegionCode> getRegionsThatEverUsedCurrency(CurrencyCode cc) {
        Preconditions.checkNotNull(cc);
        EnumSet<RegionCode> result = EnumSet.noneOf(RegionCode.class);
        for (RegionCurrencyRecord r : this.currencyMap.get(cc)) {
            result.add(r.region);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<RegionCode> getRegionsCurrentlyUsingCurrency(CurrencyCode cc) {
        return this.getRegionsUsingCurrencyOn(cc, new LocalDate());
    }

    @Override
    public Set<RegionCode> getRegionsUsingCurrencyOn(CurrencyCode cc, LocalDate date) {
        Preconditions.checkNotNull(cc);
        Preconditions.checkNotNull(date);
        EnumSet<RegionCode> result = EnumSet.noneOf(RegionCode.class);
        for (RegionCurrencyRecord r : this.currencyMap.get(cc)) {
            if (!r.range.contains(date)) continue;
            result.add(r.region);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<CurrencyCode> getCurrenciesInCurrentUse() {
        return this.getCurrenciesInUseOn(new LocalDate());
    }

    @Override
    public Set<CurrencyCode> getCurrenciesInUseOn(LocalDate date) {
        Preconditions.checkNotNull(date);
        EnumSet<CurrencyCode> result = EnumSet.noneOf(CurrencyCode.class);
        for (RegionCurrencyRecord r : this.currencyMap.values()) {
            if (!r.range.contains(date)) continue;
            result.add(r.currency);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<CurrencyCode> getCurrenciesInUseInRegionOn(RegionCode rc, LocalDate date) {
        Preconditions.checkNotNull(date);
        Preconditions.checkNotNull(rc);
        EnumSet<CurrencyCode> result = EnumSet.noneOf(CurrencyCode.class);
        for (RegionCurrencyRecord r : this.currencyMap.values()) {
            if (!r.range.contains(date) || !r.region.equals((Object)rc)) continue;
            result.add(r.currency);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public SortedSet<CurrencyInfo.DateRange> getDatesInUse(CurrencyCode cc) {
        Preconditions.checkNotNull(cc);
        Collection<RegionCurrencyRecord> records = this.currencyMap.get(cc);
        ArrayList<CurrencyInfo.DateRange> ranges = Lists.newArrayListWithCapacity(records.size());
        for (RegionCurrencyRecord r : records) {
            ranges.add(r.range);
        }
        return CurrencyInfoImpl.union(ranges);
    }

    @Override
    public SortedSet<CurrencyInfo.DateRange> getDatesInUseInRegion(CurrencyCode cc, RegionCode rc) {
        Preconditions.checkNotNull(cc);
        Preconditions.checkNotNull(rc);
        StandardRegionInfo rinfo = StandardRegionInfo.getInstance();
        Set<RegionCode> regions = rinfo.getAllContents(rc);
        if (regions.isEmpty()) {
            regions = ImmutableSet.of(rc);
        }
        ArrayList<CurrencyInfo.DateRange> ranges = Lists.newArrayList();
        for (RegionCode r : regions) {
            for (RegionCurrencyRecord rcr : this.regionMap.get(r)) {
                if (rcr.currency != cc) continue;
                ranges.add(rcr.range);
            }
        }
        return CurrencyInfoImpl.union(ranges);
    }

    @Override
    public boolean inCurrentUse(CurrencyCode cc) {
        return this.inUseOn(cc, new LocalDate());
    }

    @Override
    public boolean inUseOn(CurrencyCode cc, LocalDate date) {
        for (RegionCurrencyRecord rcr : this.currencyMap.get(cc)) {
            if (!rcr.range.contains(date)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inCurrentUseInRegion(CurrencyCode cc, RegionCode rc) {
        return this.inUseInRegionOn(cc, rc, new LocalDate());
    }

    @Override
    public boolean inUseInRegionOn(CurrencyCode cc, RegionCode rc, LocalDate date) {
        Preconditions.checkNotNull(cc);
        Preconditions.checkNotNull(rc);
        Preconditions.checkNotNull(date);
        StandardRegionInfo rinfo = StandardRegionInfo.getInstance();
        Set<RegionCode> regions = rinfo.getAllContents(rc);
        if (regions.isEmpty()) {
            regions = ImmutableSet.of(rc);
        }
        for (RegionCode r : regions) {
            for (RegionCurrencyRecord rcr : this.regionMap.get(r)) {
                if (rcr.currency != cc || !rcr.range.contains(date)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CurrencyCode getCurrency(RegionCode rc, LocalDate date) {
        CurrencyCode bestCurrency = null;
        LocalDate mostRecentlyIntroduced = null;
        block0: for (CurrencyCode currency : this.getCurrenciesInUseInRegionOn(rc, date)) {
            for (CurrencyInfo.DateRange dr : this.getDatesInUseInRegion(currency, rc)) {
                if (!dr.contains(date)) continue;
                if (mostRecentlyIntroduced != null && !dr.start.isAfter(mostRecentlyIntroduced)) continue block0;
                mostRecentlyIntroduced = dr.start;
                bestCurrency = currency;
                continue block0;
            }
        }
        return bestCurrency;
    }

    public static SortedSet<CurrencyInfo.DateRange> union(Collection<CurrencyInfo.DateRange> ranges) {
        TreeSet<CurrencyInfo.DateRange> sortedRanges = Sets.newTreeSet(LSCOMPARATOR);
        sortedRanges.addAll(ranges);
        if (sortedRanges.size() < 2) {
            return Collections.unmodifiableSortedSet(sortedRanges);
        }
        TreeSet<CurrencyInfo.DateRange> result = Sets.newTreeSet(LSCOMPARATOR);
        Iterator iter = sortedRanges.iterator();
        CurrencyInfo.DateRange range = (CurrencyInfo.DateRange)iter.next();
        LocalDate prevLimit = range.limit;
        LocalDate prevStart = range.start;
        while (iter.hasNext() && prevStart != null) {
            range = (CurrencyInfo.DateRange)iter.next();
            if (range.limit != null && range.limit.compareTo(prevStart) < 0) {
                result.add(new CurrencyInfo.DateRange(prevStart, prevLimit));
                prevLimit = range.limit;
                prevStart = range.start;
                continue;
            }
            if (range.start != null && range.start.compareTo(prevStart) >= 0) continue;
            prevStart = range.start;
        }
        result.add(new CurrencyInfo.DateRange(prevStart, prevLimit));
        return Collections.unmodifiableSortedSet(result);
    }

    private void addCurrencies(RegionCode rc, @Nullable LocalDate date, EnumSet<CurrencyCode> result) {
        for (RegionCurrencyRecord r : this.regionMap.get(rc)) {
            if (date != null && !r.range.contains(date)) continue;
            result.add(r.currency);
        }
    }

    Set<CurrencyCode> getCurrenciesInCurrentUseByRegion(RegionCode rc) {
        Preconditions.checkNotNull(rc);
        return this.regionToCurrenciesImpl(rc, new LocalDate());
    }

    Set<CurrencyCode> getCurrenciesInUseByRegionOn(RegionCode rc, LocalDate date) {
        Preconditions.checkNotNull(rc);
        Preconditions.checkNotNull(date);
        return this.regionToCurrenciesImpl(rc, date);
    }

    Set<CurrencyCode> getCurrenciesEverUsedByRegion(RegionCode rc) {
        return this.regionToCurrenciesImpl(rc, null);
    }

    private Set<CurrencyCode> regionToCurrenciesImpl(RegionCode rc, @Nullable LocalDate date) {
        EnumSet<CurrencyCode> result = EnumSet.noneOf(CurrencyCode.class);
        this.addCurrencies(rc, date, result);
        for (RegionCode r : StandardRegionInfo.getInstance().getAllContents(rc)) {
            this.addCurrencies(r, date, result);
        }
        return Collections.unmodifiableSet(result);
    }

    public static class RegionCurrencyRecord {
        public final RegionCode region;
        public final CurrencyCode currency;
        public final CurrencyInfo.DateRange range;

        public RegionCurrencyRecord(RegionCode region, CurrencyCode currency, LocalDate start, LocalDate end) {
            this.region = region;
            this.currency = currency;
            this.range = new CurrencyInfo.DateRange(start, end);
        }

        public boolean equals(Object rhs) {
            return rhs instanceof RegionCurrencyRecord && this.equals((RegionCurrencyRecord)rhs);
        }

        public boolean equals(RegionCurrencyRecord rhs) {
            return rhs != null && this.region == rhs.region && this.currency == rhs.currency && this.range.equals(rhs.range);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.region, this.currency, this.range});
        }

        public String toString() {
            String string = String.valueOf((Object)this.region);
            String string2 = String.valueOf(this.currency);
            String string3 = String.valueOf(this.range);
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(";").append(string2).append(";").append(string3).toString();
        }
    }
}

