/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.i18n.identifiers.CurrencyInfo;
import com.google.i18n.identifiers.LanguageInfo;
import com.google.i18n.identifiers.LanguageNameInfo;
import com.google.i18n.identifiers.SubdivisionNameService;
import com.google.i18n.identifiers.SubdivisionRepository;
import com.google.i18n.identifiers.impl.CurrencyInfoFactory;
import com.google.i18n.identifiers.impl.CurrencyInfoImpl;
import com.google.i18n.identifiers.impl.LanguageNameInfoRecordSetProvider;
import com.google.i18n.identifiers.impl.LanguageScriptInfoRecordSetProvider;
import com.google.i18n.identifiers.impl.RealSubdivisionRepository;
import com.google.i18n.identifiers.impl.StandardLanguageInfo;
import com.google.i18n.identifiers.impl.StandardLanguageInfoHashMapProvider;
import com.google.i18n.identifiers.impl.StandardLanguageNameInfo;
import com.google.i18n.identifiers.impl.StandardSubdivisionNameService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;

public class IdentifierFactories {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/IdentifierFactories");

    private IdentifierFactories() {
    }

    public static LanguageInfo getLanguageInfo() {
        return LILoader.info;
    }

    public static LanguageNameInfo getLanguageNameInfo() {
        return LNILoader.info;
    }

    public static SubdivisionRepository getSubdivisionRepository() {
        return SRLoader.repository;
    }

    public static SubdivisionNameService getSubdivisionNameService() {
        return SNSLoader.nameService;
    }

    public static CurrencyInfo getCurrencyInfo() {
        return CILoader.currencyInfo;
    }

    static class CILoader {
        static CurrencyInfoImpl currencyInfo = CurrencyInfoFactory.CILoader.currencyInfo;

        private CILoader() {
        }
    }

    static class SNSLoader {
        static StandardSubdivisionNameService nameService;

        private SNSLoader() {
        }

        static {
            try {
                nameService = new StandardSubdivisionNameService(new InputStreamReader(SNSLoader.class.getResourceAsStream("/i18n/identifiers/data/subdivisiondata.txt"), "UTF-8"));
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/IdentifierFactories$SNSLoader", "<clinit>", 170, "IdentifierFactories.java")).log(e.getMessage());
            }
        }
    }

    static class SRLoader {
        static RealSubdivisionRepository repository;

        private SRLoader() {
        }

        static {
            try {
                repository = new RealSubdivisionRepository(new InputStreamReader(SRLoader.class.getResourceAsStream("/i18n/identifiers/data/subdivisiondata.txt"), "UTF-8"));
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/IdentifierFactories$SRLoader", "<clinit>", 149, "IdentifierFactories.java")).log(e.getMessage());
            }
        }
    }

    static class LNILoader {
        static StandardLanguageNameInfo info;

        private LNILoader() {
        }

        static {
            try {
                info = new StandardLanguageNameInfo((Set<StandardLanguageNameInfo.LanguageNameInfoRecord>)new LanguageNameInfoRecordSetProvider(new InputStreamReader(LNILoader.class.getResourceAsStream("resources/languageNameTable.txt"), "UTF-8")).get(), (Set<StandardLanguageNameInfo.LanguageScriptInfoRecord>)new LanguageScriptInfoRecordSetProvider(new InputStreamReader(LNILoader.class.getResourceAsStream("resources/languageScriptTable.txt"), "UTF-8")).get());
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/IdentifierFactories$LNILoader", "<clinit>", 127, "IdentifierFactories.java")).log(e.getMessage());
            }
        }
    }

    static class LILoader {
        static StandardLanguageInfo info = new StandardLanguageInfo(LikelySubtagsMap.get());

        private LILoader() {
        }
    }

    public static class LikelySubtagsMap {
        static ImmutableMap<String, String> map;

        static ImmutableMap<String, String> get() {
            return map;
        }

        static {
            try {
                map = ImmutableMap.copyOf(new StandardLanguageInfoHashMapProvider(new InputStreamReader(LILoader.class.getResourceAsStream("resources/likelySubtags.txt"), "UTF-8")).get());
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/IdentifierFactories$LikelySubtagsMap", "<clinit>", 86, "IdentifierFactories.java")).log(e.getMessage());
            }
        }
    }
}

