/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.i18n.identifiers.BasicCodeConverter;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.Language;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.LanguageMatcher;
import com.google.i18n.identifiers.LanguagePriorityList;
import com.google.i18n.identifiers.impl.StandardLanguageMatcher;

public class LangEncConverter
extends BasicCodeConverter<LanguageCode, Integer> {
    public static final LangEncConverter CONVERTER = new LangEncConverter();
    private static final int UNKNOWN_LANGUAGE_ENUM_VALUE = 26;
    private final LanguageMatcher languageMatcher;

    @Override
    public LanguageCode getUnknown() {
        return LanguageCode.UNKNOWN;
    }

    @Override
    public CodeConverter.Status getStatusFromOther(Integer otherCode) {
        if (otherCode < 0) {
            return CodeConverter.Status.ILL_FORMED;
        }
        if (this.mapFromString.containsKey(otherCode)) {
            return this.getStatus((LanguageCode)this.fromOther(otherCode));
        }
        return CodeConverter.Status.ILL_FORMED;
    }

    @Override
    public CodeConverter.Status getStatus(LanguageCode languageCode) {
        int otherCode = (Integer)this.toOther(languageCode);
        if (otherCode != 26 || this.getUnknown().equals(languageCode)) {
            return languageCode.getStatus();
        }
        return CodeConverter.Status.INVALID;
    }

    public int toOtherBestMatch(LanguageCode languageCode) {
        int otherCode = (Integer)this.toOther(languageCode);
        if (otherCode != 26 || this.getUnknown().equals(languageCode)) {
            return otherCode;
        }
        LanguageCode best = this.languageMatcher.getBestMatch(languageCode);
        if (best != null) {
            return (Integer)this.toOther(best);
        }
        return 26;
    }

    public LangEncConverter() {
        this.add(0, LanguageCode.forString("en"));
        this.add(1, LanguageCode.forString("da"));
        this.add(2, LanguageCode.forString("nl"));
        this.add(3, LanguageCode.forString("fi"));
        this.add(4, LanguageCode.forString("fr"));
        this.add(5, LanguageCode.forString("de"));
        this.add(6, LanguageCode.forString("iw"), LanguageCode.forString("he", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(7, LanguageCode.forString("it"));
        this.add(8, LanguageCode.forString("ja"));
        this.add(9, LanguageCode.forString("ko"));
        this.add(10, LanguageCode.forString("no"), LanguageCode.forString("nb", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(11, LanguageCode.forString("pl"));
        this.add(13, LanguageCode.forString("ru"));
        this.add(14, LanguageCode.forString("es"));
        this.add(15, LanguageCode.forString("sv"));
        this.add(16, LanguageCode.forString("zh"));
        this.add(17, LanguageCode.forString("cs"));
        this.add(18, LanguageCode.forString("el"));
        this.add(19, LanguageCode.forString("is"));
        this.add(20, LanguageCode.forString("lv"));
        this.add(21, LanguageCode.forString("lt"));
        this.add(22, LanguageCode.forString("ro"));
        this.add(23, LanguageCode.forString("hu"));
        this.add(24, LanguageCode.forString("et"));
        this.add(25, LanguageCode.forString("mul"));
        this.add(26, LanguageCode.forString("und"));
        this.add(27, LanguageCode.forString("bg"));
        this.add(28, LanguageCode.forString("hr"));
        this.add(29, LanguageCode.forString("sr"));
        this.add(30, LanguageCode.forString("ga"));
        this.add(31, LanguageCode.forString("gl"));
        this.add(32, LanguageCode.forString("fil"), LanguageCode.forString("tl", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(33, LanguageCode.forString("tr"));
        this.add(34, LanguageCode.forString("uk"));
        this.add(35, LanguageCode.forString("hi"));
        this.add(36, LanguageCode.forString("mk"));
        this.add(37, LanguageCode.forString("bn"));
        this.add(38, LanguageCode.forString("id"), LanguageCode.forString("in", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(39, LanguageCode.forString("la"));
        this.add(40, LanguageCode.forString("ms"));
        this.add(41, LanguageCode.forString("ml"));
        this.add(42, LanguageCode.forString("cy"));
        this.add(43, LanguageCode.forString("ne"));
        this.add(44, LanguageCode.forString("te"));
        this.add(45, LanguageCode.forString("sq"));
        this.add(46, LanguageCode.forString("ta"));
        this.add(47, LanguageCode.forString("be"));
        this.add(48, LanguageCode.forString("jv"), LanguageCode.forString("jw", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(49, LanguageCode.forString("oc"));
        this.add(50, LanguageCode.forString("ur"));
        this.add(51, LanguageCode.forString("bh"));
        this.add(52, LanguageCode.forString("gu"));
        this.add(53, LanguageCode.forString("th"));
        this.add(54, LanguageCode.forString("ar"));
        this.add(55, LanguageCode.forString("ca"));
        this.add(56, LanguageCode.forString("eo"));
        this.add(57, LanguageCode.forString("eu"));
        this.add(58, LanguageCode.forString("ia"));
        this.add(59, LanguageCode.forString("kn"));
        this.add(60, LanguageCode.forString("pa"));
        this.add(61, LanguageCode.forString("gd"));
        this.add(62, LanguageCode.forString("sw"));
        this.add(63, LanguageCode.forString("sl"));
        this.add(64, LanguageCode.forString("mr"));
        this.add(65, LanguageCode.forString("mt"));
        this.add(66, LanguageCode.forString("vi"));
        this.add(67, LanguageCode.forString("fy"));
        this.add(68, LanguageCode.forString("sk"));
        this.add(69, LanguageCode.forString("zh-Hant"));
        this.add(70, LanguageCode.forString("fo"));
        this.add(71, LanguageCode.forString("su"));
        this.add(72, LanguageCode.forString("uz"));
        this.add(73, LanguageCode.forString("am"));
        this.add(74, LanguageCode.forString("az"));
        this.add(75, LanguageCode.forString("ka"));
        this.add(76, LanguageCode.forString("ti"));
        this.add(77, LanguageCode.forString("fa"));
        this.add(78, LanguageCode.forString("bs"));
        this.add(79, LanguageCode.forString("si"));
        this.add(80, LanguageCode.forString("nn"));
        this.add(81, LanguageCode.forString("pt-PT"));
        this.add(82, LanguageCode.forString("pt"), LanguageCode.forString("pt-BR"));
        this.add(83, LanguageCode.forString("xh"));
        this.add(84, LanguageCode.forString("zu"));
        this.add(85, LanguageCode.forString("gn"));
        this.add(86, LanguageCode.forString("st"));
        this.add(87, LanguageCode.forString("tk"));
        this.add(88, LanguageCode.forString("ky"));
        this.add(89, LanguageCode.forString("br"));
        this.add(90, LanguageCode.forString("tw", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(91, LanguageCode.forString("yi"), LanguageCode.forString("ji", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(92, LanguageCode.forString("sh"), LanguageCode.forString("sh", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(93, LanguageCode.forString("so"));
        this.add(94, LanguageCode.forString("ug"));
        this.add(95, LanguageCode.forString("ku"));
        this.add(96, LanguageCode.forString("mn"));
        this.add(97, LanguageCode.forString("hy"));
        this.add(98, LanguageCode.forString("lo"));
        this.add(99, LanguageCode.forString("sd"));
        this.add(100, LanguageCode.forString("rm"));
        this.add(101, LanguageCode.forString("af"));
        this.add(102, LanguageCode.forString("lb"));
        this.add(103, LanguageCode.forString("my"));
        this.add(104, LanguageCode.forString("km"));
        this.add(105, LanguageCode.forString("bo"));
        this.add(106, LanguageCode.forString("dv"));
        this.add(107, LanguageCode.forString("chr"));
        this.add(108, LanguageCode.forString("syr"));
        this.add(109, LanguageCode.forString("sit-NP"));
        this.add(110, LanguageCode.forString("or"));
        this.add(111, LanguageCode.forString("as"));
        this.add(112, LanguageCode.forString("co"));
        this.add(113, LanguageCode.forString("ie"));
        this.add(114, LanguageCode.forString("kk"));
        this.add(115, LanguageCode.forString("ln"));
        this.add(116, LanguageCode.forString("mo"), LanguageCode.forString("mo", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        this.add(117, LanguageCode.forString("ps"));
        this.add(118, LanguageCode.forString("qu"));
        this.add(119, LanguageCode.forString("sn"));
        this.add(120, LanguageCode.forString("tg"));
        this.add(121, LanguageCode.forString("tt"));
        this.add(122, LanguageCode.forString("to"));
        this.add(123, LanguageCode.forString("yo"));
        this.add(124, LanguageCode.forString("cpe"));
        this.add(125, LanguageCode.forString("cpf"));
        this.add(126, LanguageCode.forString("cpp"));
        this.add(127, LanguageCode.forString("crp"));
        this.add(128, LanguageCode.forString("mi"));
        this.add(129, LanguageCode.forString("wo"));
        this.add(130, LanguageCode.forString("ab"));
        this.add(131, LanguageCode.forString("aa"));
        this.add(132, LanguageCode.forString("ay"));
        this.add(133, LanguageCode.forString("ba"));
        this.add(134, LanguageCode.forString("bi"));
        this.add(135, LanguageCode.forString("dz"));
        this.add(136, LanguageCode.forString("fj"));
        this.add(137, LanguageCode.forString("kl"));
        this.add(138, LanguageCode.forString("ha"));
        this.add(139, LanguageCode.forString("ht"));
        this.add(140, LanguageCode.forString("ik"));
        this.add(141, LanguageCode.forString("iu"));
        this.add(142, LanguageCode.forString("ks"));
        this.add(143, LanguageCode.forString("rw"));
        this.add(144, LanguageCode.forString("mg"));
        this.add(145, LanguageCode.forString("na"));
        this.add(146, LanguageCode.forString("om"));
        this.add(147, LanguageCode.forString("rn"));
        this.add(148, LanguageCode.forString("sm"));
        this.add(149, LanguageCode.forString("sg"));
        this.add(150, LanguageCode.forString("sa"));
        this.add(151, LanguageCode.forString("ss"));
        this.add(152, LanguageCode.forString("ts"));
        this.add(153, LanguageCode.forString("tn"));
        this.add(154, LanguageCode.forString("vo"));
        this.add(155, LanguageCode.forString("za"));
        this.add(156, LanguageCode.forString("kha"));
        this.add(157, LanguageCode.forString("sco"));
        this.add(158, LanguageCode.forString("lg"));
        this.add(159, LanguageCode.forString("gv"));
        this.add(160, LanguageCode.forString("sr-ME"));
        this.add(161, LanguageCode.forString("ak"));
        this.add(162, LanguageCode.forString("ig"));
        this.add(163, LanguageCode.forString("mfe"));
        this.add(164, LanguageCode.forString("haw"));
        this.add(165, LanguageCode.forString("ceb"));
        this.add(166, LanguageCode.forString("ee"));
        this.add(167, LanguageCode.forString("gaa"));
        this.add(168, LanguageCode.forString("hmn"));
        this.add(169, LanguageCode.forString("kri"));
        this.add(170, LanguageCode.forString("loz"));
        this.add(171, LanguageCode.forString("lua"));
        this.add(172, LanguageCode.forString("luo"));
        this.add(173, LanguageCode.forString("new"));
        this.add(174, LanguageCode.forString("ny"));
        this.add(175, LanguageCode.forString("os"));
        this.add(176, LanguageCode.forString("pam"));
        this.add(177, LanguageCode.forString("nso"));
        this.add(178, LanguageCode.forString("raj"));
        this.add(179, LanguageCode.forString("crs"));
        this.add(180, LanguageCode.forString("tum"));
        this.add(181, LanguageCode.forString("ve"));
        this.add(182, LanguageCode.forString("war"));
        this.mapFromString.put(Language.PORTUGUESE.ordinal(), LanguageCode.forString("pt-PT"));
        this.mapFromString.put(Language.TWI.ordinal(), LanguageCode.forString("tw", CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS));
        LanguagePriorityList.LanguagePriorityListBuilder prioListBuilder = new LanguagePriorityList.LanguagePriorityListBuilder();
        prioListBuilder.add(LanguageCode.UNDEFINED);
        for (LanguageCode languageCode : this.mapToString.keySet()) {
            if (LanguageCode.UNKNOWN.equals(languageCode)) continue;
            prioListBuilder.add(languageCode);
        }
        this.languageMatcher = new StandardLanguageMatcher(prioListBuilder.build());
    }
}

