/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.ScriptCode;
import com.google.i18n.identifiers.impl.StandardLanguageNameInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;

class LanguageScriptInfoRecordSetProvider
implements Provider<Set<StandardLanguageNameInfo.LanguageScriptInfoRecord>> {
    private final Reader reader;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/LanguageScriptInfoRecordSetProvider");

    @Inject
    public LanguageScriptInfoRecordSetProvider(@Named(value="LanguageScriptInfo") Reader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<StandardLanguageNameInfo.LanguageScriptInfoRecord> get() {
        HashSet<StandardLanguageNameInfo.LanguageScriptInfoRecord> allRecords = Sets.newHashSet();
        BufferedReader br = new BufferedReader(this.reader);
        try {
            String line;
            block13: while (null != (line = br.readLine())) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                String[] fields = line.split(";");
                try {
                    String[] scripts;
                    LanguageCode language = LanguageCode.forString(fields[0]);
                    String[] stringArray = scripts = fields[1].split(" ");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block13;
                        String s = stringArray[n2];
                        StandardLanguageNameInfo.LanguageScriptInfoRecord rec = new StandardLanguageNameInfo.LanguageScriptInfoRecord(language, ScriptCode.forString(s));
                        if (!allRecords.contains(rec)) {
                            allRecords.add(rec);
                        }
                        ++n2;
                    }
                }
                catch (IllegalArgumentException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/i18n/identifiers/impl/LanguageScriptInfoRecordSetProvider", "get", 66, "LanguageScriptInfoRecordSetProvider.java")).log("record '%s' %s", (Object)line, (Object)e.getMessage());
                }
            }
            return Collections.unmodifiableSet(allRecords);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/LanguageScriptInfoRecordSetProvider", "get", 70, "LanguageScriptInfoRecordSetProvider.java")).log(e.getMessage());
            return Collections.unmodifiableSet(allRecords);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }
}

