/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.common.money.CurrencyCode;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.impl.CurrencyInfoImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.joda.time.LocalDate;

public class RegionCurrencyRecordSetProvider
implements Provider<Set<CurrencyInfoImpl.RegionCurrencyRecord>> {
    private final Reader reader;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/RegionCurrencyRecordSetProvider");

    @Inject
    public RegionCurrencyRecordSetProvider(@Named(value="CurrencyInfo") Reader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CurrencyInfoImpl.RegionCurrencyRecord> get() {
        HashSet<CurrencyInfoImpl.RegionCurrencyRecord> allRecords = Sets.newHashSet();
        BufferedReader br = new BufferedReader(this.reader);
        try {
            String line;
            while (null != (line = br.readLine())) {
                CurrencyCode currency;
                RegionCode region;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                String[] fields = line.split(";");
                try {
                    region = RegionCode.valueOf(fields[0]);
                }
                catch (IllegalArgumentException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).withInjectedLogSite("com/google/i18n/identifiers/impl/RegionCurrencyRecordSetProvider", "get", 64, "RegionCurrencyRecordSetProvider.java")).log("currencyTable.txt: unknown region code \"%s\"", fields[0]);
                    throw e;
                }
                try {
                    currency = CurrencyCode.valueOf((String)fields[1]);
                }
                catch (IllegalArgumentException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).withInjectedLogSite("com/google/i18n/identifiers/impl/RegionCurrencyRecordSetProvider", "get", 72, "RegionCurrencyRecordSetProvider.java")).log("currencyTable.txt: unknown currency code \"%s\"", fields[1]);
                    throw e;
                }
                LocalDate start = null;
                if (!fields[2].equals("-")) {
                    start = RegionCurrencyRecordSetProvider.parseIsoDate(fields[2]);
                }
                LocalDate limit = null;
                if (!fields[3].equals("-")) {
                    limit = RegionCurrencyRecordSetProvider.parseIsoDate(fields[3]);
                }
                allRecords.add(new CurrencyInfoImpl.RegionCurrencyRecord(region, currency, start, limit));
            }
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).withInjectedLogSite("com/google/i18n/identifiers/impl/RegionCurrencyRecordSetProvider", "get", 90, "RegionCurrencyRecordSetProvider.java")).log("Couldn't open currencyTable.txt.");
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return Collections.unmodifiableSet(allRecords);
    }

    private static LocalDate parseIsoDate(String dateString) {
        int year = Integer.parseInt(dateString.substring(0, 4));
        int month = Integer.parseInt(dateString.substring(4, 6));
        int day = Integer.parseInt(dateString.substring(6, 8));
        return new LocalDate(year, month, day);
    }
}

