/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.LanguageInfo;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.ScriptCode;
import com.ibm.icu.lang.UScript;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;

public class StandardLanguageInfo
implements LanguageInfo {
    private final Map<String, String> map;
    private final Cache<LanguageCode, LanguageCodeCacheEntry> codeToEntry;
    private static final int DEFAULT_CACHE_SIZE = 1000;

    @Inject
    public StandardLanguageInfo(@Named(value="StandardLanguageInfoMap") Map<String, String> mapToUse) {
        this(mapToUse, 1000);
    }

    @VisibleForTesting
    StandardLanguageInfo(Map<String, String> map, int cacheSize) {
        this.map = Preconditions.checkNotNull(map);
        this.codeToEntry = StandardLanguageInfo.buildCache(cacheSize);
    }

    private static Cache<LanguageCode, LanguageCodeCacheEntry> buildCache(int cacheSize) {
        return cacheSize <= 0 ? null : CacheBuilder.newBuilder().initialCapacity(Math.min(cacheSize, 100)).maximumSize(cacheSize).build();
    }

    private LanguageCodeCacheEntry getCachedLanguageCodeEntry(final LanguageCode code) {
        try {
            return this.codeToEntry.get(code, new Callable<LanguageCodeCacheEntry>(){

                @Override
                public LanguageCodeCacheEntry call() {
                    return new LanguageCodeCacheEntry(StandardLanguageInfo.this.addLikelySubtagsInternal(code), StandardLanguageInfo.this.minimizeSubtagsInternal(code));
                }
            });
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e.toString());
        }
    }

    @Override
    public LanguageCode addLikelySubtags(LanguageCode code) {
        return this.codeToEntry == null ? this.addLikelySubtagsInternal(code) : this.getCachedLanguageCodeEntry(code).likelySubtag;
    }

    @Override
    public LanguageCode minimizeSubtags(LanguageCode code) {
        return this.codeToEntry == null ? this.minimizeSubtagsInternal(code) : this.getCachedLanguageCodeEntry(code).minimalSubtag;
    }

    private LanguageCode addLikelySubtagsInternal(LanguageCode code) {
        String likelySubtags = this.createLikelySubtagsString(StandardLanguageInfo.getLanguageSubtag(code), StandardLanguageInfo.getScriptSubtag(code), StandardLanguageInfo.getRegionSubtag(code), code.getVariantSubtags());
        if (likelySubtags != null) {
            return LanguageCode.forString(likelySubtags);
        }
        return null;
    }

    private LanguageCode minimizeSubtagsInternal(LanguageCode code) {
        LanguageCode maximizedCode = this.addLikelySubtagsInternal(code);
        if (maximizedCode != null) {
            List<String> variants = maximizedCode.getVariantSubtags();
            String language = StandardLanguageInfo.getLanguageSubtag(maximizedCode);
            String script = StandardLanguageInfo.getScriptSubtag(maximizedCode);
            String region = StandardLanguageInfo.getRegionSubtag(maximizedCode);
            String subtags = this.createLikelySubtagsString(language, null, null, variants);
            if (subtags.equals(maximizedCode.toString())) {
                subtags = StandardLanguageInfo.createTagString(language, null, null, variants, null);
                return LanguageCode.forString(subtags);
            }
            if (!StandardLanguageInfo.isEmptyString(region) && (subtags = this.createLikelySubtagsString(language, null, region, variants)).equals(maximizedCode.toString())) {
                subtags = StandardLanguageInfo.createTagString(language, null, region, variants, null);
                return LanguageCode.forString(subtags);
            }
            if (!StandardLanguageInfo.isEmptyString(script) && (subtags = this.createLikelySubtagsString(language, script, null, variants)).equals(maximizedCode.toString())) {
                subtags = StandardLanguageInfo.createTagString(language, script, null, variants, null);
                return LanguageCode.forString(subtags);
            }
        }
        return maximizedCode;
    }

    @Override
    public ScriptCode getLikelyScriptCode(LanguageCode language) {
        LanguageCode likely;
        ScriptCode script = language.getScriptSubtag();
        if (script == null && (likely = this.addLikelySubtags(language)) != null) {
            script = likely.getScriptSubtag();
        }
        return script;
    }

    @Override
    public RegionCode getLikelyRegionCode(LanguageCode language) {
        LanguageCode likely;
        RegionCode region = language.getRegionSubtag();
        if (region == null && (likely = this.addLikelySubtags(language)) != null) {
            region = likely.getRegionSubtag();
        }
        return region;
    }

    @Override
    public boolean isRightToLeftScript(ScriptCode script) {
        int usc = UScriptCode.fromScriptCode(script);
        return UScript.isRightToLeft((int)usc) || usc == 124;
    }

    @Override
    public boolean isRightToLeftLanguage(LanguageCode language) {
        return this.isRightToLeftScript(this.getLikelyScriptCode(language));
    }

    @Override
    public boolean hasCapitalization(ScriptCode script) {
        int usc = UScriptCode.fromScriptCode(script);
        return UScript.isCased((int)usc);
    }

    @Override
    public boolean hasCapitalization(LanguageCode language) {
        return this.hasCapitalization(this.getLikelyScriptCode(language));
    }

    private LanguageCode getLikelySubtagsByString(String canonicalTag) {
        String subtags = this.map.get(canonicalTag);
        if (subtags == null) {
            return null;
        }
        return LanguageCode.forString(subtags);
    }

    private String createLikelySubtagsString(String language, String script, String region, List<String> variants) {
        String searchString;
        LanguageCode maximizedCode;
        if (!StandardLanguageInfo.isEmptyString(script) && !StandardLanguageInfo.isEmptyString(region) && (maximizedCode = this.getLikelySubtagsByString(searchString = StandardLanguageInfo.createTagString(language, script, region, null, null))) != null) {
            return StandardLanguageInfo.createTagString(StandardLanguageInfo.getLanguageSubtag(maximizedCode), null, null, variants, maximizedCode);
        }
        if (!StandardLanguageInfo.isEmptyString(script) && (maximizedCode = this.getLikelySubtagsByString(searchString = StandardLanguageInfo.createTagString(language, script, null, null, null))) != null) {
            return StandardLanguageInfo.createTagString(StandardLanguageInfo.getLanguageSubtag(maximizedCode), null, region, variants, maximizedCode);
        }
        if (!StandardLanguageInfo.isEmptyString(region) && (maximizedCode = this.getLikelySubtagsByString(searchString = StandardLanguageInfo.createTagString(language, null, region, null, null))) != null) {
            return StandardLanguageInfo.createTagString(StandardLanguageInfo.getLanguageSubtag(maximizedCode), script, null, variants, maximizedCode);
        }
        LanguageCode maximizedCode2 = this.getLikelySubtagsByString(language);
        if (maximizedCode2 != null) {
            return StandardLanguageInfo.createTagString(StandardLanguageInfo.getLanguageSubtag(maximizedCode2), script, region, variants, maximizedCode2);
        }
        return null;
    }

    private static String createTagString(String language, String script, String region, List<String> variants, LanguageCode code) {
        String codeRegion;
        String codeScript;
        StringBuilder result = new StringBuilder();
        result.append(language);
        if (!StandardLanguageInfo.isEmptyString(script)) {
            result.append('-').append(script);
        } else if (code != null && !StandardLanguageInfo.isEmptyString(codeScript = StandardLanguageInfo.getScriptSubtag(code))) {
            result.append('-').append(codeScript);
        }
        if (!StandardLanguageInfo.isEmptyString(region)) {
            result.append('-').append(region);
        } else if (code != null && !StandardLanguageInfo.isEmptyString(codeRegion = StandardLanguageInfo.getRegionSubtag(code))) {
            result.append('-').append(codeRegion);
        }
        if (!StandardLanguageInfo.isEmptyList(variants)) {
            ListIterator<String> i = variants.listIterator();
            while (i.hasNext()) {
                result.append('-').append(i.next());
            }
        }
        return result.toString();
    }

    private static String getScriptSubtag(LanguageCode code) {
        ScriptCode script = code.getScriptSubtag();
        if (script == null || script == ScriptCode.Zzzz) {
            return null;
        }
        return script.toString();
    }

    private static String getRegionSubtag(LanguageCode code) {
        RegionCode region = code.getRegionSubtag();
        if (region == null || region == RegionCode.ZZ) {
            return null;
        }
        return region.toString();
    }

    private static String getLanguageSubtag(LanguageCode code) {
        LanguageCode lang = code.getLanguageSubtag();
        if (lang == null) {
            return null;
        }
        return lang.toString();
    }

    private static boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    private static boolean isEmptyString(String string) {
        return string == null || string.isEmpty();
    }

    private static final class UScriptCode {
        private static final int[] ICU_FROM_III;

        private UScriptCode() {
        }

        static int fromScriptCode(ScriptCode sc) {
            return sc == null ? -1 : ICU_FROM_III[sc.ordinal()];
        }

        static {
            ScriptCode[] scripts = ScriptCode.values();
            if (scripts.length != 185) {
                throw new AssertionError((Object)"Add III ScriptCode values parallel with ICU UScript");
            }
            ICU_FROM_III = new int[scripts.length];
            for (ScriptCode iii : scripts) {
                int icu;
                UScriptCode.ICU_FROM_III[iii.ordinal()] = icu = UScript.getCodeFromName((String)iii.toString());
            }
        }
    }

    private static class LanguageCodeCacheEntry {
        private final LanguageCode likelySubtag;
        private final LanguageCode minimalSubtag;

        LanguageCodeCacheEntry(LanguageCode likely, LanguageCode minimal) {
            this.likelySubtag = likely;
            this.minimalSubtag = minimal;
        }
    }
}

