/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Pair;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.errorprone.annotations.Immutable;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.LanguageInfo;
import com.google.i18n.identifiers.LanguageMatcher;
import com.google.i18n.identifiers.LanguagePriorityList;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.RegionInfo;
import com.google.i18n.identifiers.ScriptCode;
import com.google.i18n.identifiers.impl.IdentifierFactories;
import com.google.i18n.identifiers.impl.StandardRegionInfo;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Immutable
public class StandardLanguageMatcher
implements LanguageMatcher {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/StandardLanguageMatcher");
    private static final double BASE_LANGUAGE_DISTANCE = 0.75;
    private static final double SCRIPT_DISTANCE = 0.2;
    @VisibleForTesting
    static final double REGION_DISTANCE = 0.04;
    private static final double SMALLER_REGION_DISTANCE = 0.004;
    private static final double LARGER_REGION_DISTANCE = 0.08;
    private static final double VARIANT_DISTANCE = 0.01;
    private static final double PSEUDO_LOCALE_DISTANCE = 0.8999999999999999;
    @VisibleForTesting
    static final double DEFAULT_THRESHOLD = 0.5;
    private static final double CLOSE_ENOUGH_THRESHOLD = 0.96;
    private final LanguageCode defaultLanguage;
    private final ImmutableSet<LanguageCode> languages;
    private final ImmutableMultimap<LanguageCode, LanguageCode> langSubtagToLanguageMap;
    private static final LanguageInfo languageInfo = IdentifierFactories.getLanguageInfo();
    private static final LoadingCache<LanguageCode, LanguageCode> toMaximizedMap = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<LanguageCode, LanguageCode>(){

        @Override
        public LanguageCode load(LanguageCode languageCode) {
            if (LanguageCode.ROOT.equals(languageCode) || LanguageCode.UNDEFINED.equals(languageCode)) {
                return languageCode;
            }
            LanguageCode result = languageInfo.addLikelySubtags(languageCode);
            if (result == null) {
                if (languageCode.getStatus() == CodeConverter.Status.PRIVATE_USE) {
                    return languageCode;
                }
                LanguageCode language = languageCode.getLanguageSubtag();
                ScriptCode script = languageCode.getScriptSubtag();
                RegionCode region = languageCode.getRegionSubtag();
                String string = String.valueOf(language == null ? LanguageCode.UNDEFINED : language);
                String string2 = String.valueOf((Object)(script == null ? ScriptCode.Zzzz : script));
                String string3 = String.valueOf((Object)(region == null ? RegionCode.ZZ : region));
                return LanguageCode.forString(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("_").append(string2).append("_").append(string3).toString());
            }
            return result;
        }
    });
    private static final ImmutableMap<LanguageCode, ImmutableMap<LanguageCode, Double>> distanceMap = new LanguageDistanceTableBuilder().build();
    private static final int MAX_DISTANCE_BETWEEN_REGIONS = 6;
    private static final LoadingCache<Pair<RegionCode, RegionCode>, Double> distanceCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).maximumSize(1000L).build(new CacheLoader<Pair<RegionCode, RegionCode>, Double>(){

        @Override
        public Double load(Pair<RegionCode, RegionCode> key) throws Exception {
            double d = StandardLanguageMatcher.computeDistance((RegionCode)((Object)key.first), (RegionCode)((Object)key.second));
            double e = d / 6.0;
            return 0.04 * e;
        }
    });
    private static final ImmutableSet<String> GOOGLE_PSEUDO_LOCALE_VARIANTS = ImmutableSet.of("PSACCENT", "PSBIDI", "PSCRACK");

    public StandardLanguageMatcher(LanguagePriorityList languagePriorityList, LanguageCode defaultLang) {
        Iterator<LanguageCode> it;
        ImmutableMultimap.Builder<LanguageCode, LanguageCode> builder = ImmutableMultimap.builder();
        for (LanguageCode language : languagePriorityList) {
            builder.put(language.getLanguageSubtag(), language);
        }
        this.languages = ImmutableSet.copyOf(languagePriorityList);
        this.langSubtagToLanguageMap = builder.build();
        this.defaultLanguage = defaultLang != null ? defaultLang : ((it = languagePriorityList.iterator()).hasNext() ? it.next() : null);
    }

    public StandardLanguageMatcher(LanguagePriorityList languagePriorityList) {
        this(languagePriorityList, null);
    }

    public StandardLanguageMatcher(String languagePriorityListString, LanguageCode defaultLang) {
        this(LanguagePriorityList.add(languagePriorityListString).build(), defaultLang);
    }

    public StandardLanguageMatcher(String languagePriorityListString) {
        this(LanguagePriorityList.add(languagePriorityListString).build(), null);
    }

    public static double match(LanguageCode a, LanguageCode b) {
        double d = StandardLanguageMatcher.distance(a, b);
        return Math.max(0.0, Math.min(1.0, 1.0 - d));
    }

    private static Pair<LanguageCode, Double> getBestMatchInternal(LanguageCode languageCode, Collection<LanguageCode> supportedLanguages) {
        LanguageCode bestMatch = null;
        double bestWeight = 0.0;
        for (LanguageCode supported : supportedLanguages) {
            double weight = StandardLanguageMatcher.match(languageCode, supported);
            if (!(weight > bestWeight)) continue;
            bestWeight = weight;
            bestMatch = supported;
        }
        return Pair.of(bestMatch, bestWeight);
    }

    @Override
    public LanguageCode getBestMatch(LanguageCode languageCode) {
        if (this.languages.contains(languageCode)) {
            return languageCode;
        }
        LanguageCode languageSubtag = languageCode.getLanguageSubtag();
        Pair<LanguageCode, Double> match = null;
        if (this.langSubtagToLanguageMap.containsKey(languageSubtag)) {
            Collection matchingLanguages = this.langSubtagToLanguageMap.get((Object)languageSubtag);
            if (((AbstractCollection)matchingLanguages).size() == 1) {
                return (LanguageCode)((ImmutableCollection)matchingLanguages).iterator().next();
            }
            match = StandardLanguageMatcher.getBestMatchInternal(languageCode, matchingLanguages);
        } else {
            match = StandardLanguageMatcher.getBestMatchInternal(languageCode, this.languages);
        }
        if ((Double)match.second >= 0.5) {
            return (LanguageCode)match.first;
        }
        return this.defaultLanguage;
    }

    @Override
    public LanguageCode getBestMatch(LanguagePriorityList preferredLanguages) {
        Iterator<LanguageCode> it = preferredLanguages.iterator();
        if (it.hasNext()) {
            LanguageCode first = it.next();
            if (!it.hasNext()) {
                return this.getBestMatch(first);
            }
        } else {
            return this.defaultLanguage;
        }
        double bestWeight = 0.0;
        LanguageCode bestMatch = null;
        for (LanguageCode languageCode : preferredLanguages) {
            if (this.languages.contains(languageCode)) {
                return languageCode;
            }
            LanguageCode languageSubtag = languageCode.getLanguageSubtag();
            if (!this.langSubtagToLanguageMap.containsKey(languageSubtag)) continue;
            LanguageCode maximized = StandardLanguageMatcher.addLikelySubtagsWithDefaults(languageCode);
            Collection candidates = this.langSubtagToLanguageMap.get((Object)languageSubtag);
            for (LanguageCode candidate : candidates) {
                LanguageCode maximizedCandidate = StandardLanguageMatcher.addLikelySubtagsWithDefaults(candidate);
                if (!maximized.equals(maximizedCandidate)) continue;
                return candidate;
            }
            Pair<LanguageCode, Double> match = StandardLanguageMatcher.getBestMatchInternal(languageCode, candidates);
            if ((Double)match.second >= 0.96) {
                return (LanguageCode)match.first;
            }
            if (!((Double)match.second > bestWeight)) continue;
            bestWeight = (Double)match.second;
            bestMatch = (LanguageCode)match.first;
        }
        if (bestWeight >= 0.5) {
            return bestMatch;
        }
        if (bestWeight > 0.0) {
            return this.defaultLanguage;
        }
        for (LanguageCode languageCode : preferredLanguages) {
            Pair<LanguageCode, Double> match = StandardLanguageMatcher.getBestMatchInternal(languageCode, this.languages);
            if (!((Double)match.second > bestWeight)) continue;
            bestWeight = (Double)match.second;
            bestMatch = (LanguageCode)match.first;
        }
        if (bestWeight >= 0.5) {
            return bestMatch;
        }
        return this.defaultLanguage;
    }

    @Override
    public LanguageCode getBestMatch(String preferredLanguages) {
        return this.getBestMatch(LanguagePriorityList.add(preferredLanguages).build());
    }

    public String toString() {
        String string = String.valueOf(this.defaultLanguage);
        String string2 = String.valueOf(this.languages);
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append("{").append(string).append(", ").append(string2).append("}").toString();
    }

    private static LanguageCode addLikelySubtagsWithDefaults(LanguageCode languageCode) {
        return toMaximizedMap.getUnchecked(languageCode);
    }

    @VisibleForTesting
    static double distance(LanguageCode x, LanguageCode y) {
        LanguageCode xl = x.getLanguageSubtag();
        ScriptCode xs = x.getScriptSubtag();
        RegionCode xr = x.getRegionSubtag();
        LanguageCode xmax = StandardLanguageMatcher.addLikelySubtagsWithDefaults(x);
        LanguageCode xml = xmax.getLanguageSubtag();
        ScriptCode xms = xmax.getScriptSubtag();
        RegionCode xmr = xmax.getRegionSubtag();
        LanguageCode yl = y.getLanguageSubtag();
        ScriptCode ys = y.getScriptSubtag();
        RegionCode yr = y.getRegionSubtag();
        LanguageCode ymax = StandardLanguageMatcher.addLikelySubtagsWithDefaults(y);
        LanguageCode yml = ymax.getLanguageSubtag();
        ScriptCode yms = ymax.getScriptSubtag();
        RegionCode ymr = ymax.getRegionSubtag();
        double dist = StandardLanguageMatcher.languageDistance(xl, xml, yl, yml) + StandardLanguageMatcher.regionDistance(xr, xmr, xml, yr, ymr, yml) + StandardLanguageMatcher.scriptDistance(xs, xms, ys, yms) + StandardLanguageMatcher.variantsDistance(x, y);
        return dist;
    }

    private static double getLanguageSubtagDistance(LanguageCode languageSubtag, LanguageCode languageSubtag2) {
        Double weight;
        Map aMap = distanceMap.get(languageSubtag);
        if (aMap != null && (weight = (Double)aMap.get(languageSubtag2)) != null) {
            return weight;
        }
        return 0.75;
    }

    private static double languageDistance(LanguageCode d, LanguageCode dm, LanguageCode s, LanguageCode sm) {
        double dist;
        boolean sc;
        boolean dc = !d.equals(dm);
        boolean bl = sc = !s.equals(sm);
        if (!dm.equals(sm)) {
            dist = StandardLanguageMatcher.getLanguageSubtagDistance(dm, sm);
            if (dc != sc) {
                dist *= 0.75;
            } else if (dc) {
                dist *= 0.5;
            }
        } else {
            dist = dc == sc ? 0.0 : 0.1875;
        }
        return dist;
    }

    private static boolean ignoredForDistance(RegionInfo info, RegionCode r) {
        return r == RegionCode.ZZ || info.isPoliticalOverlap(r);
    }

    @VisibleForTesting
    static double getRegionDistance(@Nullable RegionCode r1, @Nullable RegionCode r2, LanguageCode r1Sublanguage, LanguageCode r2Sublanguage) {
        if (r1 == r2) {
            return 0.0;
        }
        if (r1 == null || r2 == null) {
            return 0.04;
        }
        if (LanguageCode.ENGLISH.equals(r1Sublanguage) && LanguageCode.ENGLISH.equals(r2Sublanguage) && r1 != r2 && !RegionCode.US.equals((Object)r1) && !RegionCode.US.equals((Object)r2)) {
            return 0.004;
        }
        if (LanguageCode.PORTUGUESE.equals(r1Sublanguage) && LanguageCode.PORTUGUESE.equals(r2Sublanguage)) {
            boolean r2IsBr;
            boolean r1IsBr = RegionCode.BR.equals((Object)r1) || RegionCode.US.equals((Object)r1);
            boolean bl = r2IsBr = RegionCode.BR.equals((Object)r2) || RegionCode.US.equals((Object)r2);
            if (r1IsBr != r2IsBr) {
                return 0.08;
            }
        }
        Pair<RegionCode, RegionCode> regionPair = r1.ordinal() < r2.ordinal() ? Pair.of(r1, r2) : Pair.of(r2, r1);
        try {
            return distanceCache.get(regionPair);
        }
        catch (ExecutionException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/StandardLanguageMatcher", "getRegionDistance", 636, "StandardLanguageMatcher.java")).log(e.getMessage());
            return 0.04;
        }
    }

    @VisibleForTesting
    static int computeDistance(RegionCode r1, RegionCode r2) {
        StandardRegionInfo info = StandardRegionInfo.getInstance();
        if (StandardLanguageMatcher.ignoredForDistance(info, r1) || StandardLanguageMatcher.ignoredForDistance(info, r2)) {
            return 6;
        }
        if (r1 == r2) {
            return 0;
        }
        if (r1.getStatus() == CodeConverter.Status.PRIVATE_USE || r2.getStatus() == CodeConverter.Status.PRIVATE_USE) {
            return 6;
        }
        LinkedList<RegionDist> queue = Lists.newLinkedList();
        queue.add(new RegionDist(r1, 0));
        EnumSet<RegionCode> marked = EnumSet.of(r1);
        while (!queue.isEmpty()) {
            RegionDist v = (RegionDist)queue.peek();
            if (v.region == r2) {
                return v.dist;
            }
            for (RegionCode r : info.getDirectContainers(v.region)) {
                if (StandardLanguageMatcher.ignoredForDistance(info, r)) continue;
                StandardLanguageMatcher.addDist(marked, queue, r, v.dist + 1);
            }
            for (RegionCode r : info.getDirectContents(v.region)) {
                if (StandardLanguageMatcher.ignoredForDistance(info, r)) continue;
                StandardLanguageMatcher.addDist(marked, queue, r, v.dist + 1);
            }
            queue.remove();
        }
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/StandardLanguageMatcher", "computeDistance", 681, "StandardLanguageMatcher.java")).log("regions %s and %s not both in region graph", (Object)r1, (Object)r2);
        return 6;
    }

    private static void addDist(Set<RegionCode> marked, Queue<RegionDist> queue, RegionCode r, int distance) {
        if (!marked.contains((Object)r)) {
            marked.add(r);
            queue.add(new RegionDist(r, distance));
        }
    }

    private static boolean isPseudoLocaleRegionCode(RegionCode r) {
        return RegionCode.XA == r || RegionCode.XB == r || RegionCode.XC == r;
    }

    private static double regionDistance(@Nullable RegionCode d, @Nullable RegionCode dm, LanguageCode dmsublang, @Nullable RegionCode s, @Nullable RegionCode sm, LanguageCode smsublang) {
        double dist;
        boolean sc;
        boolean dc = d != dm;
        boolean bl = sc = s != sm;
        if (dm != sm) {
            if (StandardLanguageMatcher.isPseudoLocaleRegionCode(dm) || StandardLanguageMatcher.isPseudoLocaleRegionCode(sm)) {
                return 0.8999999999999999;
            }
            dist = StandardLanguageMatcher.getRegionDistance(dm, sm, dmsublang, smsublang);
            if (dc != sc) {
                dist *= 0.75;
            } else if (dc) {
                dist *= 0.5;
            }
        } else {
            dist = dc == sc ? 0.0 : 0.003333333333333333;
        }
        return dist;
    }

    private static double getScriptDistance(@Nullable ScriptCode x, @Nullable ScriptCode y) {
        return x == y ? 0.0 : 0.2;
    }

    private static double scriptDistance(@Nullable ScriptCode d, @Nullable ScriptCode dm, @Nullable ScriptCode s, @Nullable ScriptCode sm) {
        double dist;
        boolean sc;
        boolean dc = d != dm;
        boolean bl = sc = s != sm;
        if (dm != sm) {
            dist = StandardLanguageMatcher.getScriptDistance(dm, sm);
            if (dc != sc) {
                dist *= 0.75;
            } else if (dc) {
                dist *= 0.5;
            }
        } else {
            dist = dc == sc ? 0.0 : 0.05;
        }
        return dist;
    }

    private static String findPseudoLocaleVariantOrNull(List<String> variants) {
        if (null == variants) {
            return null;
        }
        for (String variant : variants) {
            if (!GOOGLE_PSEUDO_LOCALE_VARIANTS.contains(variant)) continue;
            return variant;
        }
        return null;
    }

    static double variantsDistance(LanguageCode x, LanguageCode y) {
        List<String> yVariants;
        List<String> xVariants = x.getVariantSubtags();
        if (Objects.equals(xVariants, yVariants = y.getVariantSubtags())) {
            return 0.0;
        }
        String xv = StandardLanguageMatcher.findPseudoLocaleVariantOrNull(xVariants);
        String yv = StandardLanguageMatcher.findPseudoLocaleVariantOrNull(yVariants);
        if (null == xv && null == yv) {
            return 0.01;
        }
        if (null == xv || null == yv) {
            return 0.8999999999999999;
        }
        if (xv.equals(yv)) {
            return 0.01;
        }
        return 0.8999999999999999;
    }

    static class RegionDist {
        RegionCode region;
        int dist;

        RegionDist(RegionCode region, int dist) {
            this.region = region;
            this.dist = dist;
        }
    }

    private static class LanguageDistanceTableBuilder {
        private Map<LanguageCode, Map<LanguageCode, Double>> table = new HashMap<LanguageCode, Map<LanguageCode, Double>>();

        private LanguageDistanceTableBuilder() {
        }

        private void addDistance(LanguageCode a, LanguageCode b, double d) {
            this.addDistance2(a, b, d);
            this.addDistance2(b, a, d);
        }

        private void addDistance2(LanguageCode a, LanguageCode b, double d) {
            Map<LanguageCode, Double> aMap = this.table.get(a);
            if (aMap == null) {
                aMap = new HashMap<LanguageCode, Double>();
                this.table.put(a, aMap);
            }
            aMap.put(b, d);
        }

        ImmutableMap<LanguageCode, ImmutableMap<LanguageCode, Double>> build() {
            LanguageCode mo = LanguageCode.forString("mo");
            LanguageCode ro = LanguageCode.forString("ro");
            this.addDistance(ro, mo, 0.04);
            LanguageCode tl = LanguageCode.forString("tl");
            LanguageCode fil = LanguageCode.forString("fil");
            this.addDistance(tl, fil, 0.04);
            LanguageCode nb = LanguageCode.forString("nb");
            LanguageCode no = LanguageCode.forString("no");
            LanguageCode nn = LanguageCode.forString("nn");
            this.addDistance(nn, nb, 0.04);
            this.addDistance(no, nb, 0.04);
            this.addDistance(nn, no, 0.04);
            LanguageCode hr = LanguageCode.forString("hr");
            LanguageCode bs = LanguageCode.forString("bs");
            LanguageCode sh = LanguageCode.forString("sh");
            LanguageCode sr = LanguageCode.forString("sr");
            this.addDistance(hr, bs, 0.04);
            this.addDistance(sh, bs, 0.04);
            this.addDistance(sr, bs, 0.04);
            this.addDistance(sh, hr, 0.04);
            this.addDistance(sh, sr, 0.04);
            ImmutableMap.Builder<LanguageCode, ImmutableMap<LanguageCode, Double>> builder = ImmutableMap.builder();
            for (Map.Entry<LanguageCode, Map<LanguageCode, Double>> entry : this.table.entrySet()) {
                builder.put(entry.getKey(), ImmutableMap.copyOf(entry.getValue()));
            }
            return builder.build();
        }
    }
}

