/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.LanguageNameInfo;
import com.google.i18n.identifiers.ScriptCode;
import com.google.i18n.identifiers.impl.LangEncConverter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StandardLanguageNameInfo
implements LanguageNameInfo {
    private final Set<LanguageNameInfoRecord> allRecords;
    private final Multimap<LanguageCode, LanguageCode> supportedLanguages;
    private final Map<String, String> translations;
    private final Multimap<LanguageCode, ScriptCode> scripts;

    @Inject
    public StandardLanguageNameInfo(Set<LanguageNameInfoRecord> records, Set<LanguageScriptInfoRecord> scriptRecords) {
        Preconditions.checkNotNull(records);
        Preconditions.checkNotNull(scriptRecords);
        this.allRecords = ImmutableSet.copyOf(records);
        ImmutableSetMultimap.Builder supportedLanguagesBuilder = ImmutableSetMultimap.builder();
        ImmutableMap.Builder<String, String> translationsBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder<LanguageCode, ScriptCode> scriptsBuilder = ImmutableMultimap.builder();
        for (LanguageNameInfoRecord languageNameInfoRecord : records) {
            supportedLanguagesBuilder.put(languageNameInfoRecord.language, languageNameInfoRecord.translationLanguage);
            translationsBuilder.put(this.key(languageNameInfoRecord.language, languageNameInfoRecord.translationLanguage), languageNameInfoRecord.translation);
        }
        this.supportedLanguages = supportedLanguagesBuilder.build();
        this.translations = translationsBuilder.build();
        for (LanguageScriptInfoRecord languageScriptInfoRecord : scriptRecords) {
            scriptsBuilder.put(languageScriptInfoRecord.language, languageScriptInfoRecord.script);
        }
        this.scripts = scriptsBuilder.build();
    }

    @Override
    public String getDisplayName(LanguageCode language, LanguageCode ... languages) {
        Preconditions.checkNotNull(language);
        Collection<LanguageCode> supported = this.supportedLanguages.get(language);
        for (LanguageCode l : languages) {
            if (!supported.contains(l)) continue;
            return this.translations.get(this.key(language, l));
        }
        return null;
    }

    @Override
    public Set<LanguageCode> getSupportedDisplayNameLanguages(LanguageCode language) {
        Preconditions.checkNotNull(language);
        return ImmutableSet.copyOf(this.supportedLanguages.get(language));
    }

    @Override
    public Set<ScriptCode> getScripts(LanguageCode language) {
        Collection<ScriptCode> collection;
        Preconditions.checkNotNull(language);
        ScriptCode script = language.getScriptSubtag();
        if (null != script && !ScriptCode.Zzzz.equals((Object)script)) {
            return ImmutableSet.of(script);
        }
        if (language.hasRegionSubtag() && !(collection = this.scripts.get(language)).isEmpty()) {
            return ImmutableSet.copyOf(collection);
        }
        return ImmutableSet.copyOf(this.scripts.get(language.getLanguageSubtag()));
    }

    @Override
    public Set<LanguageCode> find(String name) {
        Preconditions.checkNotNull(name);
        String lowerName = Ascii.toLowerCase(name);
        HashSet<LanguageCode> results = Sets.newHashSet();
        for (LanguageNameInfoRecord r : this.allRecords) {
            if (Ascii.toLowerCase(r.translation).indexOf(lowerName) == -1) continue;
            results.add(r.language);
        }
        return results;
    }

    @Override
    public LanguageCode getDisplayNameLanguageCodeForLangEnc(int enc) {
        if (enc < 0 || enc > 159) {
            throw new IllegalArgumentException(new StringBuilder(39).append("lang_enc value ").append(enc).append(" out of range").toString());
        }
        switch (enc) {
            case 12: {
                return LanguageCode.PORTUGUESE;
            }
            case 16: {
                return LanguageCode.CHINESE_SIMPLIFIED;
            }
            case 81: {
                return LanguageCode.PORTUGAL_PORTUGUESE;
            }
            case 82: {
                return LanguageCode.BRAZILIAN_PORTUGUESE;
            }
        }
        return (LanguageCode)LangEncConverter.CONVERTER.fromOther(enc);
    }

    private String key(LanguageCode language, LanguageCode translationLanguage) {
        String string = String.valueOf(language);
        String string2 = String.valueOf(translationLanguage);
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
    }

    public static class LanguageScriptInfoRecord {
        public final LanguageCode language;
        public final ScriptCode script;

        LanguageScriptInfoRecord(LanguageCode language, ScriptCode script) {
            this.language = language;
            this.script = script;
        }
    }

    public static class LanguageNameInfoRecord {
        public final LanguageCode language;
        public final LanguageCode translationLanguage;
        public final String translation;

        LanguageNameInfoRecord(LanguageCode language, LanguageCode translationLanguage, String translation) {
            this.language = language;
            this.translationLanguage = translationLanguage;
            this.translation = translation;
        }
    }
}

