/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.labs.collect.BiMultimaps;
import com.google.common.labs.collect.HashBiMultimap;
import com.google.common.money.CurrencyCode;
import com.google.i18n.identifiers.JavaLocaleConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.RegionInfo;
import com.google.i18n.identifiers.ULocaleConverter;
import com.google.i18n.identifiers.impl.CurrencyInfoFactory;
import com.google.i18n.identifiers.impl.CurrencyInfoImpl;
import com.google.i18n.identifiers.impl.RegionDisplayNames;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class StandardRegionInfo
implements RegionInfo {
    private Map<RegionCode, TerritoryData> populationData = new EnumMap<RegionCode, TerritoryData>(RegionCode.class);
    private final RegionDisplayNames regionDisplayNames;
    private final CurrencyInfoImpl cinfo;
    private static final ImmutableMultimap<RegionCode, RegionCode> CONTAINMENT_EDGES = new ImmutableMultimap.Builder<RegionCode, RegionCode>().putAll(RegionCode.UN001, RegionCode.UN019, RegionCode.UN002, RegionCode.UN150, RegionCode.UN142, RegionCode.UN009, RegionCode.EU, RegionCode.EZ, RegionCode.UN, RegionCode.QU).putAll(RegionCode.UN002, (RegionCode[])new RegionCode[]{RegionCode.UN015, RegionCode.UN011, RegionCode.UN017, RegionCode.UN014, RegionCode.UN018, RegionCode.UN202}).putAll(RegionCode.UN003, (RegionCode[])new RegionCode[]{RegionCode.UN021, RegionCode.UN013, RegionCode.UN029}).putAll(RegionCode.UN005, (RegionCode[])new RegionCode[]{RegionCode.AR, RegionCode.BO, RegionCode.BR, RegionCode.BV, RegionCode.CL, RegionCode.CO, RegionCode.EC, RegionCode.FK, RegionCode.GF, RegionCode.GS, RegionCode.GY, RegionCode.PE, RegionCode.PY, RegionCode.SR, RegionCode.UY, RegionCode.VE}).putAll(RegionCode.UN009, (RegionCode[])new RegionCode[]{RegionCode.UN053, RegionCode.UN054, RegionCode.UN057, RegionCode.UN061, RegionCode.QO}).putAll(RegionCode.UN011, (RegionCode[])new RegionCode[]{RegionCode.BF, RegionCode.BJ, RegionCode.CI, RegionCode.CV, RegionCode.GH, RegionCode.GM, RegionCode.GN, RegionCode.GW, RegionCode.LR, RegionCode.ML, RegionCode.MR, RegionCode.NE, RegionCode.NG, RegionCode.SH, RegionCode.SL, RegionCode.SN, RegionCode.TG}).putAll(RegionCode.UN013, (RegionCode[])new RegionCode[]{RegionCode.BZ, RegionCode.CR, RegionCode.GT, RegionCode.HN, RegionCode.MX, RegionCode.NI, RegionCode.PA, RegionCode.SV}).putAll(RegionCode.UN014, (RegionCode[])new RegionCode[]{RegionCode.BI, RegionCode.DJ, RegionCode.ER, RegionCode.ET, RegionCode.IO, RegionCode.KE, RegionCode.KM, RegionCode.MG, RegionCode.MU, RegionCode.MW, RegionCode.MZ, RegionCode.RE, RegionCode.RW, RegionCode.SC, RegionCode.SO, RegionCode.SS, RegionCode.TF, RegionCode.TZ, RegionCode.UG, RegionCode.YT, RegionCode.ZM, RegionCode.ZW}).putAll(RegionCode.UN015, (RegionCode[])new RegionCode[]{RegionCode.DZ, RegionCode.EG, RegionCode.EH, RegionCode.LY, RegionCode.MA, RegionCode.SD, RegionCode.TN, RegionCode.EA, RegionCode.IC}).putAll(RegionCode.UN017, (RegionCode[])new RegionCode[]{RegionCode.AO, RegionCode.CD, RegionCode.CF, RegionCode.CG, RegionCode.CM, RegionCode.GA, RegionCode.GQ, RegionCode.ST, RegionCode.TD, RegionCode.ZR}).putAll(RegionCode.UN018, (RegionCode[])new RegionCode[]{RegionCode.BW, RegionCode.LS, RegionCode.NA, RegionCode.SZ, RegionCode.ZA}).putAll(RegionCode.UN019, (RegionCode[])new RegionCode[]{RegionCode.UN021, RegionCode.UN013, RegionCode.UN029, RegionCode.UN005, RegionCode.UN003, RegionCode.UN419}).putAll(RegionCode.UN021, (RegionCode[])new RegionCode[]{RegionCode.BM, RegionCode.CA, RegionCode.GL, RegionCode.PM, RegionCode.US}).putAll(RegionCode.UN029, (RegionCode[])new RegionCode[]{RegionCode.AG, RegionCode.AI, RegionCode.AW, RegionCode.BB, RegionCode.BL, RegionCode.BQ, RegionCode.BS, RegionCode.CU, RegionCode.CW, RegionCode.DM, RegionCode.DO, RegionCode.GD, RegionCode.GP, RegionCode.HT, RegionCode.JM, RegionCode.KN, RegionCode.KY, RegionCode.LC, RegionCode.MF, RegionCode.MQ, RegionCode.MS, RegionCode.PR, RegionCode.SX, RegionCode.TC, RegionCode.TT, RegionCode.VC, RegionCode.VG, RegionCode.VI, RegionCode.AN}).putAll(RegionCode.UN030, (RegionCode[])new RegionCode[]{RegionCode.CN, RegionCode.HK, RegionCode.JP, RegionCode.KP, RegionCode.KR, RegionCode.MN, RegionCode.MO, RegionCode.TW}).putAll(RegionCode.UN034, (RegionCode[])new RegionCode[]{RegionCode.AF, RegionCode.BD, RegionCode.BT, RegionCode.IN, RegionCode.IR, RegionCode.LK, RegionCode.MV, RegionCode.NP, RegionCode.PK}).putAll(RegionCode.UN035, (RegionCode[])new RegionCode[]{RegionCode.BN, RegionCode.ID, RegionCode.KH, RegionCode.LA, RegionCode.MM, RegionCode.MY, RegionCode.PH, RegionCode.SG, RegionCode.TH, RegionCode.TL, RegionCode.VN, RegionCode.BU, RegionCode.TP}).putAll(RegionCode.UN039, (RegionCode[])new RegionCode[]{RegionCode.AD, RegionCode.AL, RegionCode.BA, RegionCode.ES, RegionCode.GI, RegionCode.GR, RegionCode.HR, RegionCode.IT, RegionCode.ME, RegionCode.MK, RegionCode.MT, RegionCode.RS, RegionCode.PT, RegionCode.SI, RegionCode.SM, RegionCode.VA, RegionCode.XK, RegionCode.CS, RegionCode.YU}).putAll(RegionCode.UN053, (RegionCode[])new RegionCode[]{RegionCode.AU, RegionCode.CC, RegionCode.CX, RegionCode.HM, RegionCode.NF, RegionCode.NZ}).putAll(RegionCode.UN054, (RegionCode[])new RegionCode[]{RegionCode.FJ, RegionCode.NC, RegionCode.PG, RegionCode.SB, RegionCode.VU}).putAll(RegionCode.UN057, (RegionCode[])new RegionCode[]{RegionCode.FM, RegionCode.GU, RegionCode.KI, RegionCode.MH, RegionCode.MP, RegionCode.NR, RegionCode.PW, RegionCode.UM}).putAll(RegionCode.UN061, (RegionCode[])new RegionCode[]{RegionCode.AS, RegionCode.CK, RegionCode.NU, RegionCode.PF, RegionCode.PN, RegionCode.TK, RegionCode.TO, RegionCode.TV, RegionCode.WF, RegionCode.WS}).putAll(RegionCode.UN142, (RegionCode[])new RegionCode[]{RegionCode.UN145, RegionCode.UN143, RegionCode.UN030, RegionCode.UN034, RegionCode.UN035}).putAll(RegionCode.UN143, (RegionCode[])new RegionCode[]{RegionCode.TM, RegionCode.TJ, RegionCode.KG, RegionCode.KZ, RegionCode.UZ}).putAll(RegionCode.UN145, (RegionCode[])new RegionCode[]{RegionCode.AE, RegionCode.AM, RegionCode.AZ, RegionCode.BH, RegionCode.CY, RegionCode.GE, RegionCode.IL, RegionCode.IQ, RegionCode.JO, RegionCode.KW, RegionCode.LB, RegionCode.OM, RegionCode.PS, RegionCode.QA, RegionCode.SA, RegionCode.SY, RegionCode.TR, RegionCode.YE, RegionCode.NT, RegionCode.YD}).putAll(RegionCode.UN150, (RegionCode[])new RegionCode[]{RegionCode.UN154, RegionCode.UN155, RegionCode.UN151, RegionCode.UN039}).putAll(RegionCode.UN151, (RegionCode[])new RegionCode[]{RegionCode.BG, RegionCode.BY, RegionCode.CZ, RegionCode.HU, RegionCode.MD, RegionCode.PL, RegionCode.RO, RegionCode.RU, RegionCode.SK, RegionCode.UA, RegionCode.SU}).putAll(RegionCode.UN154, (RegionCode[])new RegionCode[]{RegionCode.GG, RegionCode.IM, RegionCode.JE, RegionCode.AX, RegionCode.DK, RegionCode.EE, RegionCode.FI, RegionCode.FO, RegionCode.GB, RegionCode.IE, RegionCode.IS, RegionCode.LT, RegionCode.LV, RegionCode.NO, RegionCode.SE, RegionCode.SJ}).putAll(RegionCode.UN155, (RegionCode[])new RegionCode[]{RegionCode.AT, RegionCode.BE, RegionCode.CH, RegionCode.DE, RegionCode.FR, RegionCode.LI, RegionCode.LU, RegionCode.MC, RegionCode.NL, RegionCode.DD, RegionCode.FX}).putAll(RegionCode.UN202, (RegionCode[])new RegionCode[]{RegionCode.UN011, RegionCode.UN017, RegionCode.UN014, RegionCode.UN018}).putAll(RegionCode.UN419, (RegionCode[])new RegionCode[]{RegionCode.UN013, RegionCode.UN029, RegionCode.UN005}).putAll(RegionCode.EU, (RegionCode[])new RegionCode[]{RegionCode.AT, RegionCode.BE, RegionCode.CY, RegionCode.CZ, RegionCode.DE, RegionCode.DK, RegionCode.EE, RegionCode.ES, RegionCode.FI, RegionCode.FR, RegionCode.GB, RegionCode.GR, RegionCode.HR, RegionCode.HU, RegionCode.IE, RegionCode.IT, RegionCode.LT, RegionCode.LU, RegionCode.LV, RegionCode.MT, RegionCode.NL, RegionCode.PL, RegionCode.PT, RegionCode.SE, RegionCode.SI, RegionCode.SK, RegionCode.BG, RegionCode.RO}).putAll(RegionCode.EZ, (RegionCode[])new RegionCode[]{RegionCode.AT, RegionCode.BE, RegionCode.CY, RegionCode.DE, RegionCode.EE, RegionCode.ES, RegionCode.FI, RegionCode.FR, RegionCode.GR, RegionCode.IE, RegionCode.IT, RegionCode.LT, RegionCode.LU, RegionCode.LV, RegionCode.MT, RegionCode.NL, RegionCode.PT, RegionCode.SI, RegionCode.SK}).putAll(RegionCode.QO, (RegionCode[])new RegionCode[]{RegionCode.AQ, RegionCode.AC, RegionCode.CP, RegionCode.DG, RegionCode.TA}).putAll(RegionCode.UN, (RegionCode[])new RegionCode[]{RegionCode.AD, RegionCode.AE, RegionCode.AF, RegionCode.AG, RegionCode.AL, RegionCode.AM, RegionCode.AO, RegionCode.AR, RegionCode.AT, RegionCode.AU, RegionCode.AZ, RegionCode.BA, RegionCode.BB, RegionCode.BD, RegionCode.BE, RegionCode.BF, RegionCode.BG, RegionCode.BH, RegionCode.BI, RegionCode.BJ, RegionCode.BN, RegionCode.BO, RegionCode.BR, RegionCode.BS, RegionCode.BT, RegionCode.BW, RegionCode.BY, RegionCode.BZ, RegionCode.CA, RegionCode.CD, RegionCode.CF, RegionCode.CG, RegionCode.CH, RegionCode.CI, RegionCode.CL, RegionCode.CM, RegionCode.CN, RegionCode.CO, RegionCode.CR, RegionCode.CU, RegionCode.CV, RegionCode.CY, RegionCode.CZ, RegionCode.DE, RegionCode.DJ, RegionCode.DK, RegionCode.DM, RegionCode.DO, RegionCode.DZ, RegionCode.EC, RegionCode.EE, RegionCode.EG, RegionCode.ER, RegionCode.ES, RegionCode.ET, RegionCode.FI, RegionCode.FJ, RegionCode.FM, RegionCode.FR, RegionCode.GA, RegionCode.GB, RegionCode.GD, RegionCode.GE, RegionCode.GH, RegionCode.GM, RegionCode.GN, RegionCode.GQ, RegionCode.GR, RegionCode.GT, RegionCode.GW, RegionCode.GY, RegionCode.HN, RegionCode.HR, RegionCode.HT, RegionCode.HU, RegionCode.ID, RegionCode.IE, RegionCode.IL, RegionCode.IN, RegionCode.IQ, RegionCode.IR, RegionCode.IS, RegionCode.IT, RegionCode.JM, RegionCode.JO, RegionCode.JP, RegionCode.KE, RegionCode.KG, RegionCode.KH, RegionCode.KI, RegionCode.KM, RegionCode.KN, RegionCode.KP, RegionCode.KR, RegionCode.KW, RegionCode.KZ, RegionCode.LA, RegionCode.LB, RegionCode.LC, RegionCode.LI, RegionCode.LK, RegionCode.LR, RegionCode.LS, RegionCode.LT, RegionCode.LU, RegionCode.LV, RegionCode.LY, RegionCode.MA, RegionCode.MC, RegionCode.MD, RegionCode.ME, RegionCode.MG, RegionCode.MH, RegionCode.MK, RegionCode.ML, RegionCode.MM, RegionCode.MN, RegionCode.MR, RegionCode.MT, RegionCode.MU, RegionCode.MV, RegionCode.MX, RegionCode.MW, RegionCode.MY, RegionCode.MZ, RegionCode.NA, RegionCode.NE, RegionCode.NG, RegionCode.NI, RegionCode.NL, RegionCode.NO, RegionCode.NR, RegionCode.NP, RegionCode.NZ, RegionCode.OM, RegionCode.PA, RegionCode.PE, RegionCode.PG, RegionCode.PH, RegionCode.PK, RegionCode.PL, RegionCode.PT, RegionCode.PW, RegionCode.PY, RegionCode.QA, RegionCode.RO, RegionCode.RS, RegionCode.RU, RegionCode.RW, RegionCode.SA, RegionCode.SB, RegionCode.SC, RegionCode.SD, RegionCode.SE, RegionCode.SG, RegionCode.SI, RegionCode.SK, RegionCode.SL, RegionCode.SM, RegionCode.SN, RegionCode.SO, RegionCode.SR, RegionCode.SS, RegionCode.ST, RegionCode.SV, RegionCode.SY, RegionCode.SZ, RegionCode.TD, RegionCode.TG, RegionCode.TH, RegionCode.TJ, RegionCode.TL, RegionCode.TM, RegionCode.TN, RegionCode.TO, RegionCode.TR, RegionCode.TT, RegionCode.TV, RegionCode.TZ, RegionCode.UA, RegionCode.UG, RegionCode.US, RegionCode.UY, RegionCode.UZ, RegionCode.VC, RegionCode.VE, RegionCode.VN, RegionCode.VU, RegionCode.WS, RegionCode.YE, RegionCode.ZA, RegionCode.ZM, RegionCode.ZW}).build();
    private static final Dag<RegionCode> CONTAINMENT_GRAPH = new Dag(CONTAINMENT_EDGES);
    private static final ImmutableMap<RegionCode, String> DISPLAY_NAME_OVERRIDES = new ImmutableMap.Builder<RegionCode, String>().put(RegionCode.DD, "East Germany").put(RegionCode.GG, "Guernsey").put(RegionCode.IM, "Isle of Man").put(RegionCode.JE, "Jersey").put(RegionCode.ME, "Montenegro").put(RegionCode.NT, "Neutral Zone").put(RegionCode.QU, "European Union").put(RegionCode.RS, "Serbia").put(RegionCode.SU, "Union of Soviet Socialist Republics").put(RegionCode.YD, "People's Democratic Republic of Yemen").put(RegionCode.ZZ, "Unknown or Invalid Region").put(RegionCode.UN034, "Southern Asia").put(RegionCode.UN143, "Central Asia").build();
    private static final ImmutableMap<String, RegionCode> EXTRA_ENGLISH_NAMES = new ImmutableMap.Builder<String, RegionCode>().put("Bosnia", RegionCode.BA).put("Bolivia (Plurinational State of)", RegionCode.BO).put("The Bahamas", RegionCode.BS).put("Cocos Islands", RegionCode.CC).put("Dem. Rep. Congo", RegionCode.CD).put("Democratic Republic of the Congo", RegionCode.CD).put("The Democratic Republic of the Congo", RegionCode.CD).put("Congo (Democratic Republic of the)", RegionCode.CD).put("Congo (Democratic Republic of)", RegionCode.CD).put("Democratic Republic of Congo", RegionCode.CD).put("Rep. Congo", RegionCode.CG).put("Republic of the Congo", RegionCode.CG).put("Congo (Republic of the)", RegionCode.CG).put("Congo (Republic of)", RegionCode.CG).put("Ivory Coast", RegionCode.CI).put("Cabo Verde", RegionCode.CV).put("Arab Rep. Egypt", RegionCode.EG).put("Falkland Islands", RegionCode.FK).put("Fed. Sts. Micronesia", RegionCode.FM).put("Federated States of Micronesia", RegionCode.FM).put("Faeroe Islands", RegionCode.FO).put("UK", RegionCode.GB).put("Channel Islands", RegionCode.GG).put("The Gambia", RegionCode.GM).put("Hong Kong SAR China", RegionCode.HK).put("China Hong Kong", RegionCode.HK).put("Islamic Rep. Iran", RegionCode.IR).put("Islamic Republic of Iran", RegionCode.IR).put("Kyrgyz Republic", RegionCode.KG).put("St. Kitts and Nevis", RegionCode.KN).put("Dem. Rep. Korea", RegionCode.KP).put("Democratic People's Republic of Korea", RegionCode.KP).put("Korea (Democratic People's Rep. of)", RegionCode.KP).put("Rep. Korea", RegionCode.KR).put("Republic of Korea", RegionCode.KR).put("Lao PDR", RegionCode.LA).put("Lao People's Democratic Republic", RegionCode.LA).put("Saint Lucia", RegionCode.LC).put("Republic of Moldova", RegionCode.MD).put("St. Martin (French part)", RegionCode.MF).put("Saint Martin", RegionCode.MF).put("Macedonia", RegionCode.MK).put("FYR Macedonia", RegionCode.MK).put("The Former Yugoslav Rep. of Macedonia", RegionCode.MK).put("TFYR of Macedonia", RegionCode.MK).put("The Former Yugoslav Republic of Macedonia", RegionCode.MK).put("Burma", RegionCode.MM).put("Myanmar", RegionCode.MM).put("Macao", RegionCode.MO).put("China Macau", RegionCode.MO).put("China Macao", RegionCode.MO).put("China, Macau Special Administrative Region", RegionCode.MO).put("China, Macao Special Administrative Region", RegionCode.MO).put("Macao SAR China", RegionCode.MO).put("Macau SAR China", RegionCode.MO).put("Macao SAR, China", RegionCode.MO).put("Macau SAR, China", RegionCode.MO).put("Gaza Strip", RegionCode.PS).put("Occupied Palestinian Territory", RegionCode.PS).put("Palestinian Autonomous Territories", RegionCode.PS).put("Palestinian Territories", RegionCode.PS).put("Palestinian", RegionCode.PS).put("West Bank and Gaza", RegionCode.PS).put("West Bank", RegionCode.PS).put("Russian Federation", RegionCode.RU).put("Saint Helena, Ascension, and Tristan da Cunha", RegionCode.SH).put("Svalbard", RegionCode.SJ).put("Svalbard and Jan Mayen", RegionCode.SJ).put("Slovak Republic", RegionCode.SK).put("Syrian Arab Republic", RegionCode.SY).put("East Timor", RegionCode.TL).put("Province of China Taiwan", RegionCode.TW).put("United Republic of Tanzania", RegionCode.TZ).put("USA", RegionCode.US).put("US", RegionCode.US).put("United States of America", RegionCode.US).put("The Vatican", RegionCode.VA).put("Holy See (Vatican City)", RegionCode.VA).put("Holy See (Vatican City State)", RegionCode.VA).put("St. Vincent and the Grenadines", RegionCode.VC).put("Saint Vincent and the Grenadines", RegionCode.VC).put("RB Venezuela", RegionCode.VE).put("Venezuela (Bolivarian Republic of)", RegionCode.VE).put("United States of Virgin Islands", RegionCode.VI).put("Rep. Yemen", RegionCode.YE).build();
    private static final ImmutableSet<RegionCode> OVERLAP_REGIONS = Sets.immutableEnumSet((Enum)RegionCode.UN003, (Enum[])new RegionCode[]{RegionCode.UN202, RegionCode.UN419, RegionCode.EU, RegionCode.QU, RegionCode.EZ, RegionCode.UN});
    private static final ImmutableSet<RegionCode> POLITICAL_OVERLAP_REGIONS = Sets.immutableEnumSet((Enum)RegionCode.EU, (Enum[])new RegionCode[]{RegionCode.QU, RegionCode.EZ, RegionCode.UN});
    private static final ImmutableListMultimap<RegionCode, RegionCode> REPLACEMENTS = ((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)new ImmutableListMultimap.Builder().putAll((Object)RegionCode.AN, (Object[])new RegionCode[]{RegionCode.CW, RegionCode.SX, RegionCode.BQ})).putAll((Object)RegionCode.BU, (Object[])new RegionCode[]{RegionCode.MM})).putAll((Object)RegionCode.CS, (Object[])new RegionCode[]{RegionCode.RS, RegionCode.ME})).putAll((Object)RegionCode.DD, (Object[])new RegionCode[]{RegionCode.DE})).putAll((Object)RegionCode.FX, (Object[])new RegionCode[]{RegionCode.FR})).putAll((Object)RegionCode.NT, (Object[])new RegionCode[]{RegionCode.SA, RegionCode.IQ})).putAll((Object)RegionCode.QU, (Object[])new RegionCode[]{RegionCode.EU})).putAll((Object)RegionCode.SU, (Object[])new RegionCode[]{RegionCode.RU, RegionCode.AM, RegionCode.AZ, RegionCode.BY, RegionCode.EE, RegionCode.GE, RegionCode.KZ, RegionCode.KG, RegionCode.LV, RegionCode.LT, RegionCode.MD, RegionCode.TJ, RegionCode.TM, RegionCode.UA, RegionCode.UZ})).putAll((Object)RegionCode.TP, (Object[])new RegionCode[]{RegionCode.TL})).putAll((Object)RegionCode.YD, (Object[])new RegionCode[]{RegionCode.YE})).putAll((Object)RegionCode.YU, (Object[])new RegionCode[]{RegionCode.RS, RegionCode.ME})).putAll((Object)RegionCode.ZR, (Object[])new RegionCode[]{RegionCode.CD})).build();
    private static final StandardRegionInfo INSTANCE = new StandardRegionInfo(CurrencyInfoFactory.CILoader.currencyInfo);

    @Inject
    StandardRegionInfo(CurrencyInfoImpl cinfo) {
        this.cinfo = Preconditions.checkNotNull(cinfo);
        this.buildTerritoryData();
        this.freezeTerritoryData();
        this.regionDisplayNames = RegionDisplayNames.createWithExtraEnglishNames(REPLACEMENTS, EXTRA_ENGLISH_NAMES);
    }

    public static StandardRegionInfo getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean contains(RegionCode regionCode, RegionCode possibleContainee) {
        Preconditions.checkNotNull(regionCode);
        Preconditions.checkNotNull(possibleContainee);
        return CONTAINMENT_GRAPH.hasPath(regionCode, possibleContainee);
    }

    @Override
    public Set<RegionCode> getDirectContents(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithEdgeFrom(regionCode);
    }

    @Override
    public Set<RegionCode> getAllContents(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithPathFrom(regionCode);
    }

    @Override
    public Set<RegionCode> getDirectContainers(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithEdgeTo(regionCode);
    }

    @Override
    public Set<RegionCode> getAllContainers(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithPathTo(regionCode);
    }

    @Override
    public String getDisplayName(RegionCode regionCode, LanguageCode ... desiredDisplayLocales) {
        String rfcName = regionCode.toString();
        for (LanguageCode desiredDisplayLocale : desiredDisplayLocales) {
            String string = String.valueOf(rfcName);
            String result = ULocale.getDisplayCountry((String)(string.length() != 0 ? "und-".concat(string) : new String("und-")), (ULocale)ULocaleConverter.CONVERTER.toOther(desiredDisplayLocale));
            if (result.equals(rfcName)) continue;
            return result;
        }
        String string = String.valueOf(rfcName);
        String result = ULocale.getDisplayCountry((String)(string.length() != 0 ? "und-".concat(string) : new String("und-")), (ULocale)ULocale.ENGLISH);
        if (!result.equals(rfcName)) {
            return result;
        }
        return DISPLAY_NAME_OVERRIDES.containsKey((Object)regionCode) ? DISPLAY_NAME_OVERRIDES.get((Object)regionCode) : rfcName;
    }

    @Override
    public String getDisplayName(RegionCode regionCode, Locale desiredDisplayLocale, Locale ... fallbackDisplayLocales) {
        ArrayList<LanguageCode> desiredDisplayLanguages = new ArrayList<LanguageCode>();
        desiredDisplayLanguages.add(JavaLocaleConverter.CONVERTER.fromOther(desiredDisplayLocale));
        for (Locale fallbackDisplayLocale : fallbackDisplayLocales) {
            desiredDisplayLanguages.add(JavaLocaleConverter.CONVERTER.fromOther(fallbackDisplayLocale));
        }
        LanguageCode[] desiredLanguageCodes = desiredDisplayLanguages.toArray(new LanguageCode[desiredDisplayLanguages.size()]);
        return this.getDisplayName(regionCode, desiredLanguageCodes);
    }

    @Override
    public Comparator<RegionCode> getDisplayNameComparator(LanguageCode ... languages) {
        return StandardRegionInfo.getDisplayNameComparator(this, languages);
    }

    public static Ordering<RegionCode> getDisplayNameComparator(final RegionInfo regionInfo, final LanguageCode ... languages) {
        ULocale uLocale = languages.length == 0 ? ULocale.ROOT : ULocaleConverter.CONVERTER.toOther(languages[0]);
        Ordering<String> collator = Ordering.from(Collator.getInstance((ULocale)uLocale));
        return collator.onResultOf(new Function<RegionCode, String>(){

            @Override
            public String apply(RegionCode region) {
                return regionInfo.getDisplayName(region, languages);
            }
        }).compound(Ordering.usingToString());
    }

    @Override
    public boolean isOverlap(RegionCode regionCode) {
        return OVERLAP_REGIONS.contains((Object)regionCode);
    }

    @Override
    public boolean isPoliticalOverlap(RegionCode regionCode) {
        return POLITICAL_OVERLAP_REGIONS.contains((Object)regionCode);
    }

    @Override
    public RegionCode regionCodeFromDisplayName(String displayName, LanguageCode language) {
        return this.regionDisplayNames.getRegionCode(displayName, language);
    }

    @Override
    public List<RegionCode> getPreferredValues(RegionCode code) {
        return REPLACEMENTS.get((Object)code);
    }

    @Override
    public long getRegionPopulation(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1L;
        }
        return data.population;
    }

    @Override
    public float getRegionLiteracy(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1.0f;
        }
        return data.literacy;
    }

    @Override
    public long getRegionGdp(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1L;
        }
        return data.gdp;
    }

    @Override
    public Set<LanguageCode> getRegionLanguages(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return ImmutableSet.of();
        }
        return data.languageData.keySet();
    }

    @Override
    public Set<LanguageCode> getRegionOfficialLanguages(RegionCode region, final Set<LanguageCode.OfficialStatus> officialStatuses) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(Maps.filterEntries(this.populationData.get((Object)((Object)region)).languageData, new Predicate<Map.Entry<LanguageCode, LanguageData>>(this){

            @Override
            public boolean apply(Map.Entry<LanguageCode, LanguageData> entry) {
                return entry.getValue().hasOfficialStatus() && officialStatuses.contains((Object)entry.getValue().officialStatus);
            }
        }).keySet());
    }

    @Override
    public LanguageCode getRegionMajorityLanguage(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return LanguageCode.UNKNOWN;
        }
        long majorityLanguageSize = 0L;
        LanguageCode majorityLanguage = LanguageCode.UNKNOWN;
        for (Map.Entry<LanguageCode, LanguageData> dataEntry : data.languageData.entrySet()) {
            if (dataEntry.getValue().population <= majorityLanguageSize) continue;
            majorityLanguage = dataEntry.getKey();
            majorityLanguageSize = dataEntry.getValue().population;
        }
        return majorityLanguage;
    }

    @Override
    public long getRegionLanguagePopulation(RegionCode region, LanguageCode language) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1L;
        }
        LanguageData languageData = data.languageData.get(language);
        if (languageData == null) {
            return -1L;
        }
        return languageData.population;
    }

    @Override
    public float getRegionLanguageWritingPopulation(RegionCode region, LanguageCode language) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1.0f;
        }
        LanguageData languageData = data.languageData.get(language);
        if (languageData == null) {
            return -1.0f;
        }
        return languageData.writing;
    }

    @Override
    public RegionInfo.MeasurementSystem getMeasurementSystem(RegionCode region) {
        switch (region) {
            case LR: 
            case MM: 
            case US: {
                return RegionInfo.MeasurementSystem.US;
            }
        }
        return RegionInfo.MeasurementSystem.METRIC;
    }

    @Override
    public RegionInfo.TemperatureUnit getWeatherTemperatureUnit(RegionCode region) {
        switch (region) {
            case US: 
            case BS: 
            case BZ: 
            case KY: 
            case PR: 
            case PW: {
                return RegionInfo.TemperatureUnit.FAHRENHEIT;
            }
        }
        return RegionInfo.TemperatureUnit.CELSIUS;
    }

    @Override
    public RegionInfo.LengthUnits getRoadLengthUnits(RegionCode region) {
        switch (region) {
            case MM: 
            case GB: {
                return RegionInfo.LengthUnits.MILE_YARD;
            }
            case LR: 
            case US: {
                return RegionInfo.LengthUnits.MILE_FOOT;
            }
        }
        return RegionInfo.LengthUnits.KILOMETER_METER;
    }

    @Override
    public Set<CurrencyCode> getRegionCurrentCurrenciesInUse(RegionCode rc) {
        return this.cinfo.getCurrenciesInCurrentUseByRegion(rc);
    }

    @Override
    public Set<CurrencyCode> getRegionAllCurrenciesEverUsed(RegionCode rc) {
        return this.cinfo.getCurrenciesEverUsedByRegion(rc);
    }

    private TerritoryData addRegion(RegionCode codeToAddDataTo, double population, double literacy, double gdp) {
        TerritoryData data = new TerritoryData(population, literacy, gdp);
        this.populationData.put(codeToAddDataTo, data);
        return data;
    }

    private void freezeTerritoryData() {
        for (TerritoryData data : this.populationData.values()) {
            data.freeze();
        }
    }

    private void buildTerritoryData() {
        this.addRegion(RegionCode.AC, 940.0, 0.99, 4.229E7).addLanguage("en", 930.6, 0.99);
        this.addRegion(RegionCode.AD, 85702.0, 1.0, 3.327E9).addLanguage("ca", 43708.0, 1.0, "OFFICIAL").addLanguage("es", 36851.9, 1.0).addLanguage("fr", 5742.03, 1.0);
        this.addRegion(RegionCode.AE, 6072480.0, 0.9, 6.868E11).addLanguage("ar", 4736530.0, 0.9, "OFFICIAL").addLanguage("ml", 425074.0, 0.9).addLanguage("ps", 176102.0, 0.9).addLanguage("bal", 139667.0, 0.9).addLanguage("fa", 115377.0, 0.9);
        this.addRegion(RegionCode.AF, 3.41248E7, 0.281, 6.955E10).addLanguage("fa", 1.70624E7, 0.281, "OFFICIAL").addLanguage("ps", 1.46737E7, 0.281, "OFFICIAL").addLanguage("haz", 2013360.0, 0.281).addLanguage("uz_Arab", 1603870.0, 0.281, "OFFICIAL_REGIONAL").addLanguage("tk", 580122.0, 0.281, "OFFICIAL_REGIONAL").addLanguage("prd", 409498.0, 0.281).addLanguage("bal", 228636.0, 0.281, "OFFICIAL_REGIONAL").addLanguage("bgn", 214986.0, 0.05).addLanguage("ug", 3002.98, 0.281).addLanguage("kk_Arab", 2013.36, 0.281);
        this.addRegion(RegionCode.AG, 94731.0, 0.99, 2.393E9).addLanguage("en", 81468.7, 0.99, "OFFICIAL").addLanguage("pt", 1610.43, 0.99);
        this.addRegion(RegionCode.AI, 17087.0, 0.95, 1.754E8).addLanguage("en", 16232.6, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.AL, 3047990.0, 0.968, 3.597E10).addLanguage("sq", 3047990.0, 0.968, "OFFICIAL").addLanguage("el", 57911.8, 0.968).addLanguage("mk", 14325.6, 0.968);
        this.addRegion(RegionCode.AM, 3045190.0, 0.996, 2.828E10).addLanguage("hy", 2984290.0, 0.996, "OFFICIAL").addLanguage("ku", 100491.0, 0.996).addLanguage("az", 0.0, 0.996);
        this.addRegion(RegionCode.AO, 2.93103E7, 0.704, 1.903E11).addLanguage("pt", 1.96379E7, 0.704, "OFFICIAL").addLanguage("umb", 8499990.0, 0.704).addLanguage("kmb", 7327580.0, 0.704).addLanguage("ln", 196379.0, 0.704);
        this.addRegion(RegionCode.AQ, 300.0, 0.99, 1.781E7).addLanguage("und", 300.0, 0.99);
        this.addRegion(RegionCode.AR, 4.42933E7, 0.979, 9.202E11).addLanguage("es", 4.42933E7, 0.979, "OFFICIAL").addLanguage("en", 3100530.0, 0.979).addLanguage("cy", 28790.6, 0.979).addLanguage("gn", 20817.9, 0.979);
        this.addRegion(RegionCode.AS, 51504.0, 0.97, 6.58E8).addLanguage("sm", 50989.0, 0.97, "OFFICIAL").addLanguage("en", 49958.9, 0.97, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.AT, 8754410.0, 0.98, 4.396E11).addLanguage("de", 8491780.0, 0.98, "OFFICIAL").addLanguage("bar", 8316690.0, 0.98).addLanguage("en", 6390720.0, 0.98).addLanguage("fr", 962985.0, 0.98).addLanguage("it", 787897.0, 0.98).addLanguage("hr", 105053.0, 0.98, "OFFICIAL_REGIONAL").addLanguage("sl", 32391.3, 0.98, "OFFICIAL_REGIONAL").addLanguage("hu", 23636.9, 0.98, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.AU, 2.32324E7, 0.99, 1.246E12).addLanguage("en", 2.23031E7, 0.99, "DE_FACTO_OFFICIAL").addLanguage("zh_Hant", 487880.0, 0.99).addLanguage("it", 441416.0, 0.99).addLanguage("wbp", 2555.56, 0.99);
        this.addRegion(RegionCode.AW, 115120.0, 0.968, 2.516E9).addLanguage("nl", 111666.0, 0.968, "OFFICIAL").addLanguage("pap", 70223.2, 0.968, "OFFICIAL").addLanguage("en", 2993.12, 0.968);
        this.addRegion(RegionCode.AX, 26200.0, 1.0, 9.298E8).addLanguage("sv", 25938.0, 1.0, "OFFICIAL");
        this.addRegion(RegionCode.AZ, 9961400.0, 0.998, 1.718E11).addLanguage("az", 8865650.0, 0.998, "OFFICIAL").addLanguage("az_Cyrl", 986179.0, 0.998, "OFFICIAL").addLanguage("tly", 976217.0, 0.998).addLanguage("ku", 23907.4, 0.998).addLanguage("ttt", 21915.1, 0.998).addLanguage("tkr", 15938.2, 0.998);
        this.addRegion(RegionCode.BA, 3856180.0, 0.98, 4.462E10).addLanguage("bs", 3817620.0, 0.98, "OFFICIAL").addLanguage("bs_Cyrl", 3817620.0, 0.05, "OFFICIAL").addLanguage("en", 1735280.0, 0.98).addLanguage("hr", 462742.0, 0.98, "OFFICIAL").addLanguage("sr", 385618.0, 0.98, "OFFICIAL").addLanguage("sr_Latn", 385618.0, 0.05, "OFFICIAL");
        this.addRegion(RegionCode.BB, 292336.0, 0.997, 5.244E9).addLanguage("en", 292336.0, 0.997, "OFFICIAL");
        this.addRegion(RegionCode.BD, 1.57827E8, 0.577, 6.871E11).addLanguage("bn", 1.5467E8, 0.577, "OFFICIAL").addLanguage("en", 2.84089E7, 0.577).addLanguage("rkt", 1.02588E7, 0.577).addLanguage("syl", 7891350.0, 0.577).addLanguage("ccp", 347219.0, 0.577).addLanguage("my", 331437.0, 0.577).addLanguage("grt", 115214.0, 0.577).addLanguage("mro", 28408.9, 0.577).addLanguage("mni", 17361.0, 0.577);
        this.addRegion(RegionCode.BE, 1.14913E7, 0.99, 5.285E11).addLanguage("en", 6779870.0, 0.99).addLanguage("nl", 6320220.0, 0.99, "OFFICIAL").addLanguage("fr", 4366690.0, 0.99, "OFFICIAL").addLanguage("de", 2528090.0, 0.99, "OFFICIAL").addLanguage("vls", 1149130.0, 0.99).addLanguage("wa", 666495.0, 0.05);
        this.addRegion(RegionCode.BF, 2.01075E7, 0.287, 3.578E10).addLanguage("mos", 8043000.0, 0.287).addLanguage("dyu", 6434400.0, 0.287).addLanguage("fr", 4423650.0, 0.287, "OFFICIAL").addLanguage("ff", 0.0, 0.287).addLanguage("ff_Adlm", 0.0, 0.287);
        this.addRegion(RegionCode.BG, 7101510.0, 0.984, 1.531E11).addLanguage("bg", 7101510.0, 0.984, "OFFICIAL").addLanguage("en", 1775380.0, 0.984).addLanguage("ru", 1633350.0, 0.984).addLanguage("tr", 781166.0, 0.984).addLanguage("de", 568121.0, 0.984);
        this.addRegion(RegionCode.BH, 1410940.0, 0.946, 7.044E10).addLanguage("ar", 1227520.0, 0.946, "OFFICIAL").addLanguage("ml", 46561.0, 0.946);
        this.addRegion(RegionCode.BI, 1.14668E7, 0.672, 7.99E9).addLanguage("rn", 7224080.0, 0.672, "OFFICIAL").addLanguage("fr", 6765410.0, 0.672, "OFFICIAL").addLanguage("sw", 6306.74, 0.672).addLanguage("en", 6192.07, 0.672, "OFFICIAL");
        this.addRegion(RegionCode.BJ, 1.10388E7, 0.424, 2.533E10).addLanguage("fr", 3863580.0, 0.424, "OFFICIAL").addLanguage("fon", 2759700.0, 0.424).addLanguage("yo", 739600.0, 0.424);
        this.addRegion(RegionCode.BL, 7184.0, 0.99, 2.55E8).addLanguage("fr", 6824.8, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.BM, 70864.0, 0.98, 6.127E9).addLanguage("en", 65194.9, 0.98, "OFFICIAL");
        this.addRegion(RegionCode.BN, 443593.0, 0.954, 3.354E10).addLanguage("ms", 412541.0, 0.954, "OFFICIAL").addLanguage("zh_Hant", 48795.2, 0.954).addLanguage("ms_Arab", 22179.7, 0.954, "OFFICIAL").addLanguage("en", 7984.67, 0.954);
        this.addRegion(RegionCode.BO, 1.11382E7, 0.912, 8.355E10).addLanguage("es", 6794300.0, 0.912, "OFFICIAL").addLanguage("qu", 3564220.0, 0.912, "OFFICIAL").addLanguage("ay", 2227640.0, 0.912, "OFFICIAL").addLanguage("gn", 50121.9, 0.912).addLanguage("aro", 111.382, 0.912);
        this.addRegion(RegionCode.BQ, 20000.0, 0.96, 4.18E8).addLanguage("pap", 16200.0, 0.96).addLanguage("nl", 1600.0, 0.96, "OFFICIAL");
        this.addRegion(RegionCode.BR, 2.07353E8, 0.904, 3.24E12).addLanguage("pt", 1.88691E8, 0.904, "OFFICIAL").addLanguage("en", 1.65882E7, 0.904).addLanguage("de", 1741770.0, 0.904).addLanguage("it", 580588.0, 0.904).addLanguage("ja", 435441.0, 0.904).addLanguage("es", 76720.6, 0.904).addLanguage("ko", 43544.1, 0.904).addLanguage("kgp", 20735.3, 0.904).addLanguage("gub", 17417.7, 0.904).addLanguage("yrl", 10782.4, 0.904).addLanguage("xav", 9952.94, 0.904);
        this.addRegion(RegionCode.BS, 329988.0, 0.956, 1.16E10).addLanguage("en", 329988.0, 0.956, "OFFICIAL");
        this.addRegion(RegionCode.BT, 758288.0, 0.528, 7.03E9).addLanguage("dz", 356395.0, 0.528, "OFFICIAL").addLanguage("ne", 128909.0, 0.528).addLanguage("tsj", 113743.0, 0.528).addLanguage("en", 83411.7, 0.528).addLanguage("lep", 29573.2, 0.528);
        this.addRegion(RegionCode.BV, 1.0, 0.99, 44990.0).addLanguage("und", 1.0, 0.99);
        this.addRegion(RegionCode.BW, 2214860.0, 0.851, 3.886E10).addLanguage("en", 1794040.0, 0.851, "OFFICIAL").addLanguage("tn", 1373210.0, 0.851, "OFFICIAL").addLanguage("af", 5980.12, 0.851);
        this.addRegion(RegionCode.BY, 9549750.0, 0.996, 1.789E11).addLanguage("be", 9549750.0, 0.996, "OFFICIAL").addLanguage("ru", 1145970.0, 0.996, "OFFICIAL");
        this.addRegion(RegionCode.BZ, 360346.0, 0.769, 3.211E9).addLanguage("en", 360346.0, 0.769, "OFFICIAL").addLanguage("es", 100897.0, 0.769);
        this.addRegion(RegionCode.CA, 3.56237E7, 0.99, 1.769E12).addLanguage("en", 3.06364E7, 0.99, "OFFICIAL").addLanguage("fr", 7837210.0, 0.99, "OFFICIAL").addLanguage("it", 712474.0, 0.99).addLanguage("de", 676850.0, 0.99).addLanguage("pdt", 85496.9, 0.99).addLanguage("cr", 39186.1, 0.99).addLanguage("crk", 39186.1, 0.99).addLanguage("yi", 16030.7, 0.99).addLanguage("iu", 14962.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("iu_Latn", 14962.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("moe", 11755.8, 0.99).addLanguage("crj", 7480.98, 0.99).addLanguage("atj", 5699.79, 0.99).addLanguage("crl", 5343.56, 0.99).addLanguage("csw", 4987.32, 0.99).addLanguage("crm", 4631.08, 0.99).addLanguage("ikt", 3918.61, 0.99, "OFFICIAL_REGIONAL").addLanguage("moh", 3491.12, 0.99).addLanguage("dgr", 2636.15, 0.99).addLanguage("den", 2315.54, 0.99).addLanguage("scs", 1246.83, 0.99).addLanguage("nsk", 1175.58, 0.99).addLanguage("chp", 783.721, 0.99).addLanguage("gwi", 569.979, 0.99);
        this.addRegion(RegionCode.CC, 596.0, 0.99, 3.196E7).addLanguage("ms_Arab", 494.68, 0.99).addLanguage("en", 101.32, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.CD, 8.33012E7, 0.668, 6.845E10).addLanguage("sw", 4.16506E7, 0.668, "OFFICIAL_REGIONAL").addLanguage("lua", 7996920.0, 0.668, "OFFICIAL_REGIONAL").addLanguage("fr", 3165450.0, 0.668, "OFFICIAL").addLanguage("ln", 2582340.0, 0.668, "OFFICIAL_REGIONAL").addLanguage("lu", 1915930.0, 0.668).addLanguage("kg", 1249520.0, 0.668, "OFFICIAL_REGIONAL").addLanguage("lol", 508137.0, 0.668).addLanguage("rw", 316545.0, 0.668);
        this.addRegion(RegionCode.CF, 5625120.0, 0.566, 3.373E9).addLanguage("fr", 2756310.0, 0.566, "OFFICIAL").addLanguage("sg", 2756310.0, 0.566, "OFFICIAL").addLanguage("ln", 13500.3, 0.566);
        this.addRegion(RegionCode.CG, 4954670.0, 0.838, 2.888E10).addLanguage("fr", 4161920.0, 0.838, "OFFICIAL").addLanguage("ln", 118912.0, 0.838);
        this.addRegion(RegionCode.CH, 8236300.0, 0.99, 5.172E11).addLanguage("de", 6012500.0, 0.99, "OFFICIAL").addLanguage("gsw", 5353600.0, 0.05, "DE_FACTO_OFFICIAL").addLanguage("en", 5024140.0, 0.99).addLanguage("fr", 1729620.0, 0.99, "OFFICIAL").addLanguage("it", 354161.0, 0.99, "OFFICIAL").addLanguage("lmo", 337688.0, 0.05).addLanguage("pt", 280034.0, 0.99).addLanguage("rm", 41181.5, 0.99, "OFFICIAL_REGIONAL").addLanguage("rmo", 23885.3, 0.99).addLanguage("wae", 9883.56, 0.99);
        this.addRegion(RegionCode.CI, 2.41848E7, 0.569, 9.692E10).addLanguage("fr", 1.18506E7, 0.569, "OFFICIAL").addLanguage("bci", 2660330.0, 0.569).addLanguage("sef", 1039950.0, 0.05).addLanguage("dnj", 967392.0, 0.569).addLanguage("kfo", 55625.0, 0.569).addLanguage("bqv", 41114.2, 0.569);
        this.addRegion(RegionCode.CK, 9290.0, 0.95, 2.999E8).addLanguage("en", 8825.5, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.CL, 1.77893E7, 0.986, 4.511E11).addLanguage("es", 1.74335E7, 0.986, "OFFICIAL").addLanguage("en", 1689980.0, 0.986).addLanguage("arn", 266840.0, 0.986);
        this.addRegion(RegionCode.CM, 2.49949E7, 0.713, 8.886E10).addLanguage("fr", 1.69965E7, 0.713, "OFFICIAL").addLanguage("en", 9498060.0, 0.713, "OFFICIAL").addLanguage("bum", 1149770.0, 0.713).addLanguage("ff", 899816.0, 0.713).addLanguage("ewo", 774842.0, 0.713).addLanguage("ybb", 399918.0, 0.713).addLanguage("bbj", 349929.0, 0.713).addLanguage("nnh", 349929.0, 0.713).addLanguage("bkm", 324934.0, 0.05).addLanguage("bas", 299939.0, 0.713).addLanguage("bax", 299939.0, 0.713).addLanguage("byv", 274944.0, 0.713).addLanguage("mua", 249949.0, 0.713).addLanguage("maf", 184962.0, 0.713).addLanguage("bfd", 142471.0, 0.713).addLanguage("bss", 134972.0, 0.713).addLanguage("kkj", 134972.0, 0.713).addLanguage("dua", 119976.0, 0.713).addLanguage("mgo", 117476.0, 0.05).addLanguage("ar", 97480.1, 0.713).addLanguage("jgo", 84982.7, 0.713).addLanguage("ksf", 79983.7, 0.713).addLanguage("agq", 34992.9, 0.713).addLanguage("ha_Arab", 34992.9, 0.713).addLanguage("nmg", 8998.16, 0.713).addLanguage("yav", 2299.53, 0.713).addLanguage("ff_Adlm", 0.0, 0.713);
        this.addRegion(RegionCode.CN, 1.3793E9, 0.951, 2.316E13).addLanguage("zh", 1.24137E9, 0.951, "OFFICIAL").addLanguage("wuu", 8.2758E7, 0.951).addLanguage("yue_Hans", 7.17236E7, 0.951).addLanguage("hsn", 3.99997E7, 0.951).addLanguage("hak", 3.17239E7, 0.951).addLanguage("nan", 2.62067E7, 0.951).addLanguage("gan", 2.34481E7, 0.951).addLanguage("ii", 8275800.0, 0.951).addLanguage("ug", 7586150.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("za", 4275830.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("mn_Mong", 3586180.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("bo", 2758600.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("ko", 2068950.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("kk_Arab", 1186200.0, 0.951).addLanguage("lis", 620685.0, 0.951).addLanguage("ky_Arab", 468962.0, 0.951).addLanguage("nxq", 331032.0, 0.951).addLanguage("khb", 262067.0, 0.951).addLanguage("tdd", 262067.0, 0.951).addLanguage("lcp", 79999.4, 0.951).addLanguage("en", 62068.5, 0.951).addLanguage("ru", 13793.0, 0.951).addLanguage("vi", 6896.5, 0.951).addLanguage("uz_Cyrl", 5517.2, 0.951).addLanguage("lzh", 0.0, 0.951);
        this.addRegion(RegionCode.CO, 4.76985E7, 0.936, 7.14E11).addLanguage("es", 4.43596E7, 0.936, "OFFICIAL").addLanguage("guc", 128786.0, 0.936);
        this.addRegion(RegionCode.CP, 1.0, 0.99, 42260.0).addLanguage("und", 1.0, 0.99);
        this.addRegion(RegionCode.CR, 4930260.0, 0.963, 8.385E10).addLanguage("es", 4683750.0, 0.963, "OFFICIAL");
        this.addRegion(RegionCode.CU, 1.11474E7, 0.998, 1.37E11).addLanguage("es", 1.11474E7, 0.998, "OFFICIAL");
        this.addRegion(RegionCode.CV, 560899.0, 0.849, 3.735E9).addLanguage("kea", 510418.0, 0.849).addLanguage("pt", 426283.0, 0.849, "OFFICIAL");
        this.addRegion(RegionCode.CW, 149648.0, 0.96, 3.128E9).addLanguage("pap", 121215.0, 0.96, "DE_FACTO_OFFICIAL").addLanguage("nl", 11971.8, 0.96, "OFFICIAL").addLanguage("es", 5686.62, 0.96);
        this.addRegion(RegionCode.CX, 2205.0, 0.99, 1.183E8).addLanguage("en", 1389.15, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.CY, 1221550.0, 0.987, 3.159E10).addLanguage("el", 1160470.0, 0.987, "OFFICIAL").addLanguage("en", 891732.0, 0.987).addLanguage("tr", 280956.0, 0.987, "OFFICIAL").addLanguage("fr", 85508.5, 0.987).addLanguage("hy", 2687.41, 0.987).addLanguage("ar", 1343.7, 0.987);
        this.addRegion(RegionCode.CZ, 1.06747E7, 0.99, 3.757E11).addLanguage("cs", 1.04612E7, 0.99, "OFFICIAL").addLanguage("en", 2882170.0, 0.99).addLanguage("sk", 1707950.0, 0.99).addLanguage("de", 1601200.0, 0.99).addLanguage("pl", 52306.0, 0.99);
        this.addRegion(RegionCode.DE, 8.0594E7, 0.99, 4.171E12).addLanguage("de", 7.33405E7, 0.99, "OFFICIAL").addLanguage("en", 5.15802E7, 0.99).addLanguage("fr", 1.45069E7, 0.99).addLanguage("bar", 1.3701E7, 0.05).addLanguage("nds", 9671280.0, 0.05).addLanguage("nl", 7253460.0, 0.99).addLanguage("it", 5641580.0, 0.99).addLanguage("es", 4835640.0, 0.99).addLanguage("ru", 4835640.0, 0.99).addLanguage("vmf", 4835640.0, 0.99).addLanguage("tr", 2014850.0, 0.99).addLanguage("gsw", 1853660.0, 0.05).addLanguage("da", 1611880.0, 0.99).addLanguage("swg", 805940.0, 0.05).addLanguage("hr", 636693.0, 0.99).addLanguage("ku", 531920.0, 0.99).addLanguage("el", 306257.0, 0.99).addLanguage("ksh", 241782.0, 0.99).addLanguage("pl", 233723.0, 0.99).addLanguage("hsb", 12895.0, 0.05).addLanguage("frr", 9671.28, 0.99).addLanguage("dsb", 7011.68, 0.05).addLanguage("frs", 2014.85, 0.99).addLanguage("stq", 967.128, 0.99).addLanguage("pfl", 0.0, 0.99);
        this.addRegion(RegionCode.DG, 500.0, 0.99, 2.25E7).addLanguage("en", 495.0, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.DJ, 865267.0, 0.679, 3.632E9).addLanguage("aa", 363412.0, 0.679).addLanguage("so", 354759.0, 0.679).addLanguage("ar", 63164.5, 0.679, "OFFICIAL").addLanguage("fr", 18170.6, 0.679, "OFFICIAL");
        this.addRegion(RegionCode.DK, 5605950.0, 0.99, 2.868E11).addLanguage("da", 5213530.0, 0.99, "OFFICIAL").addLanguage("en", 4821120.0, 0.99).addLanguage("de", 2634800.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("sv", 728774.0, 0.99).addLanguage("fo", 21302.6, 0.99).addLanguage("kl", 6727.14, 0.99, "OFFICIAL_REGIONAL").addLanguage("jut", 0.0, 0.99);
        this.addRegion(RegionCode.DM, 73897.0, 0.94, 7.85E8).addLanguage("en", 69463.2, 0.94, "OFFICIAL");
        this.addRegion(RegionCode.DO, 1.07342E7, 0.901, 1.724E11).addLanguage("es", 8372680.0, 0.901, "OFFICIAL").addLanguage("en", 8050.65, 0.901);
        this.addRegion(RegionCode.DZ, 4.09694E7, 0.726, 6.329E11).addLanguage("arq", 3.40046E7, 0.726).addLanguage("ar", 3.03174E7, 0.726, "OFFICIAL").addLanguage("fr", 8193880.0, 0.726, "OFFICIAL").addLanguage("kab", 3195610.0, 0.726).addLanguage("en", 2867860.0, 0.726);
        this.addRegion(RegionCode.EA, 150000.0, 0.977, 5.435E9).addLanguage("es", 147000.0, 0.977, "OFFICIAL");
        this.addRegion(RegionCode.EC, 1.62909E7, 0.916, 1.926E11).addLanguage("es", 1.56393E7, 0.916, "OFFICIAL").addLanguage("qu", 2769450.0, 0.916, "OFFICIAL").addLanguage("qug", 928581.0, 0.916);
        this.addRegion(RegionCode.EE, 1251580.0, 0.998, 4.156E10).addLanguage("et", 888622.0, 0.998, "OFFICIAL").addLanguage("ru", 700885.0, 0.998).addLanguage("en", 625790.0, 0.998).addLanguage("fi", 262832.0, 0.998).addLanguage("vro", 71340.1, 0.998);
        this.addRegion(RegionCode.EG, 9.70411E7, 0.739, 1.201E12).addLanguage("ar", 9.12186E7, 0.739, "OFFICIAL").addLanguage("arz", 6.21063E7, 0.739).addLanguage("en", 3.39644E7, 0.739).addLanguage("el", 59195.1, 0.739);
        this.addRegion(RegionCode.EH, 603253.0, 0.5, 9.065E8).addLanguage("ar", 603253.0, 0.5, "OFFICIAL");
        this.addRegion(RegionCode.ER, 5918920.0, 0.689, 9.382E9).addLanguage("ti", 3551350.0, 0.689, "DE_FACTO_OFFICIAL").addLanguage("en", 3492160.0, 0.689, "OFFICIAL").addLanguage("tig", 1065410.0, 0.689).addLanguage("ar", 290027.0, 0.05, "OFFICIAL").addLanguage("aa", 213081.0, 0.689).addLanguage("ssy", 213081.0, 0.689).addLanguage("byn", 76946.0, 0.689);
        this.addRegion(RegionCode.ES, 4.89582E7, 0.977, 1.774E12).addLanguage("es", 4.84686E7, 0.977, "OFFICIAL").addLanguage("en", 1.175E7, 0.977).addLanguage("ca", 8322890.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("gl", 3427070.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("eu", 979164.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("ast", 636457.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("ext", 239895.0, 0.977);
        this.addRegion(RegionCode.ET, 1.0535E8, 0.39, 2.002E11).addLanguage("en", 4.53005E7, 0.39).addLanguage("am", 3.47655E7, 0.39, "OFFICIAL").addLanguage("om", 3.3712E7, 0.39).addLanguage("so", 6321000.0, 0.39).addLanguage("ti", 6321000.0, 0.39).addLanguage("sid", 3687250.0, 0.39).addLanguage("wal", 1896300.0, 0.39).addLanguage("aa", 1474900.0, 0.39);
        this.addRegion(RegionCode.FI, 5518370.0, 1.0, 2.44E11).addLanguage("fi", 5187270.0, 1.0, "OFFICIAL").addLanguage("en", 3862860.0, 1.0).addLanguage("sv", 2428080.0, 1.0, "OFFICIAL").addLanguage("de", 993307.0, 1.0).addLanguage("ru", 44698.8, 1.0).addLanguage("et", 6070.21, 1.0).addLanguage("rmf", 5021.72, 1.0).addLanguage("se", 1986.61, 1.0).addLanguage("smn", 607.021, 1.0).addLanguage("sms", 607.021, 1.0);
        this.addRegion(RegionCode.FJ, 920938.0, 0.937, 8.652E9).addLanguage("en", 865682.0, 0.937, "OFFICIAL").addLanguage("hi", 405213.0, 0.937).addLanguage("hif", 377585.0, 0.937, "OFFICIAL").addLanguage("fj", 359166.0, 0.937, "OFFICIAL").addLanguage("rtm", 2486.53, 0.937);
        this.addRegion(RegionCode.FK, 2931.0, 0.99, 2.064E8).addLanguage("en", 2813.76, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.FM, 104196.0, 0.89, 3.47E8).addLanguage("en", 59391.7, 0.89, "OFFICIAL").addLanguage("chk", 31258.8, 0.89).addLanguage("pon", 23965.1, 0.89).addLanguage("kos", 8023.09, 0.89).addLanguage("yap", 6564.35, 0.89).addLanguage("uli", 3021.68, 0.89);
        this.addRegion(RegionCode.FO, 50730.0, 0.99, 2.001E9).addLanguage("fo", 48193.5, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.FR, 6.71062E7, 0.99, 2.836E12).addLanguage("fr", 6.64351E7, 0.99, "OFFICIAL").addLanguage("en", 2.61714E7, 0.99).addLanguage("es", 8723810.0, 0.99).addLanguage("de", 3355310.0, 0.99).addLanguage("oc", 2013190.0, 0.05).addLanguage("it", 1140810.0, 0.99).addLanguage("pt", 872381.0, 0.99).addLanguage("pcd", 738168.0, 0.99).addLanguage("gsw", 610666.0, 0.05).addLanguage("br", 556981.0, 0.99).addLanguage("co", 161055.0, 0.05).addLanguage("ca", 114081.0, 0.99).addLanguage("nl", 87238.1, 0.99).addLanguage("eu", 87238.1, 0.99).addLanguage("frp", 63079.8, 0.99).addLanguage("ia", 134.212, 0.99);
        this.addRegion(RegionCode.GA, 1772260.0, 0.89, 3.673E10).addLanguage("fr", 1116520.0, 0.89, "OFFICIAL").addLanguage("puu", 159503.0, 0.89);
        this.addRegion(RegionCode.GB, 6.47695E7, 0.99, 2.914E12).addLanguage("en", 6.41218E7, 0.99, "OFFICIAL").addLanguage("fr", 1.23062E7, 0.99).addLanguage("de", 3886170.0, 0.99).addLanguage("sco", 1748780.0, 0.05).addLanguage("pa", 511679.0, 0.99).addLanguage("cy", 498725.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("bn", 433956.0, 0.99).addLanguage("zh_Hant", 349755.0, 0.99).addLanguage("syl", 323848.0, 0.99).addLanguage("el", 220216.0, 0.99).addLanguage("it", 220216.0, 0.99).addLanguage("ks", 123062.0, 0.99).addLanguage("gd", 64121.8, 0.05, "OFFICIAL_REGIONAL").addLanguage("yi", 31737.1, 0.99).addLanguage("ml", 22669.3, 0.99).addLanguage("ga", 16840.1, 0.99, "OFFICIAL_REGIONAL").addLanguage("kw", 2007.85, 0.99);
        this.addRegion(RegionCode.GD, 111724.0, 0.96, 1.606E9).addLanguage("en", 107255.0, 0.96, "OFFICIAL");
        this.addRegion(RegionCode.GE, 4926330.0, 0.997, 3.97E10).addLanguage("ka", 4236640.0, 0.997, "OFFICIAL").addLanguage("xmf", 541896.0, 0.997).addLanguage("ru", 443370.0, 0.997).addLanguage("hy", 344843.0, 0.997).addLanguage("ab", 108379.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("os", 108379.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ku", 43844.3, 0.997);
        this.addRegion(RegionCode.GF, 199509.0, 0.83, 1.551E9).addLanguage("fr", 153622.0, 0.83, "OFFICIAL").addLanguage("gcr", 51872.3, 0.83).addLanguage("zh_Hant", 4987.73, 0.83);
        this.addRegion(RegionCode.GG, 66502.0, 1.0, 3.465E9).addLanguage("en", 66502.0, 1.0, "OFFICIAL");
        this.addRegion(RegionCode.GH, 2.74999E7, 0.715, 1.337E11).addLanguage("ak", 1.0725E7, 0.715, "OFFICIAL_REGIONAL").addLanguage("en", 5774980.0, 0.715, "OFFICIAL").addLanguage("ee", 3024990.0, 0.715, "OFFICIAL_REGIONAL").addLanguage("abr", 1375000.0, 0.715).addLanguage("gur", 962496.0, 0.715).addLanguage("ada", 824997.0, 0.715).addLanguage("gaa", 769997.0, 0.715, "OFFICIAL_REGIONAL").addLanguage("nzi", 274999.0, 0.715).addLanguage("ha", 239249.0, 0.715).addLanguage("saf", 4124.98, 0.715).addLanguage("ff", 0.0, 0.715).addLanguage("ff_Adlm", 0.0, 0.715);
        this.addRegion(RegionCode.GI, 29396.0, 0.8, 2.044E9).addLanguage("en", 23516.8, 0.8, "OFFICIAL").addLanguage("es", 14698.0, 0.8);
        this.addRegion(RegionCode.GL, 57713.0, 1.0, 2.413E9).addLanguage("kl", 48478.9, 1.0, "OFFICIAL").addLanguage("da", 8079.82, 1.0);
        this.addRegion(RegionCode.GM, 2051360.0, 0.511, 3.602E9).addLanguage("en", 820544.0, 0.511, "OFFICIAL").addLanguage("man", 594894.0, 0.511).addLanguage("ff", 0.0, 0.511).addLanguage("ff_Adlm", 0.0, 0.511);
        this.addRegion(RegionCode.GN, 1.24139E7, 0.41, 2.647E10).addLanguage("fr", 3600030.0, 0.41, "OFFICIAL").addLanguage("ff", 3227610.0, 0.41).addLanguage("man_Nkoo", 2855200.0, 0.41).addLanguage("sus", 1365530.0, 0.41).addLanguage("nqo", 620695.0, 0.41).addLanguage("kpe", 471728.0, 0.41).addLanguage("ff_Adlm", 0.0, 0.41);
        this.addRegion(RegionCode.GP, 452776.0, 0.9, 3.513E9).addLanguage("fr", 407498.0, 0.9, "OFFICIAL");
        this.addRegion(RegionCode.GQ, 778358.0, 0.942, 3.035E10).addLanguage("es", 677171.0, 0.942, "OFFICIAL").addLanguage("fan", 396963.0, 0.942).addLanguage("fr", 68495.5, 0.942, "OFFICIAL").addLanguage("bvb", 61490.3, 0.942).addLanguage("pt", 0.778358, 0.942, "OFFICIAL");
        this.addRegion(RegionCode.GR, 1.07685E7, 0.973, 2.987E11).addLanguage("el", 1.06608E7, 0.973, "OFFICIAL").addLanguage("en", 5491940.0, 0.973).addLanguage("fr", 969165.0, 0.973).addLanguage("de", 538425.0, 0.973).addLanguage("pnt", 398434.0, 0.973).addLanguage("mk", 172296.0, 0.973).addLanguage("tr", 129222.0, 0.973).addLanguage("bg", 29075.0, 0.973).addLanguage("sq", 10014.7, 0.973).addLanguage("tsd", 204.602, 0.973);
        this.addRegion(RegionCode.GS, 20.0, 0.99, 899800.0).addLanguage("und", 20.0, 0.99);
        this.addRegion(RegionCode.GT, 1.54607E7, 0.759, 1.378E11).addLanguage("es", 1.43785E7, 0.759, "OFFICIAL").addLanguage("quc", 1082250.0, 0.759, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.GU, 167358.0, 0.99, 5.793E9).addLanguage("en", 152296.0, 0.99, "DE_FACTO_OFFICIAL").addLanguage("ch", 36818.8, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.GW, 1792340.0, 0.553, 3.137E9).addLanguage("pt", 1792340.0, 0.553, "OFFICIAL").addLanguage("knf", 46600.8, 0.553).addLanguage("ff", 1.79234, 0.553).addLanguage("ff_Adlm", 1.79234, 0.553);
        this.addRegion(RegionCode.GY, 737718.0, 0.918, 6.287E9).addLanguage("en", 737718.0, 0.918, "OFFICIAL");
        this.addRegion(RegionCode.HK, 7191500.0, 0.935, 4.549E11).addLanguage("zh_Hant", 6831920.0, 0.935, "OFFICIAL").addLanguage("yue", 6472350.0, 0.935).addLanguage("en", 3667660.0, 0.935, "OFFICIAL").addLanguage("zh", 359575.0, 0.935);
        this.addRegion(RegionCode.HM, 1.0, 0.99, 53630.0).addLanguage("und", 1.0, 0.99);
        this.addRegion(RegionCode.HN, 9038740.0, 0.851, 4.62E10).addLanguage("es", 7050220.0, 0.851, "OFFICIAL").addLanguage("en", 39770.5, 0.851);
        this.addRegion(RegionCode.HR, 4292100.0, 0.989, 1.013E11).addLanguage("hr", 4249180.0, 0.989, "OFFICIAL").addLanguage("en", 2103130.0, 0.989).addLanguage("it", 68673.6, 0.989, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.HT, 1.06467E7, 0.487, 1.993E10).addLanguage("ht", 8623830.0, 0.487, "OFFICIAL").addLanguage("fr", 500395.0, 0.487, "OFFICIAL");
        this.addRegion(RegionCode.HU, 9850850.0, 0.99, 2.89E11).addLanguage("hu", 9850850.0, 0.99, "OFFICIAL").addLanguage("en", 1970170.0, 0.99).addLanguage("de", 1773150.0, 0.99).addLanguage("fr", 295526.0, 0.99).addLanguage("ro", 97523.4, 0.99).addLanguage("hr", 31522.7, 0.99).addLanguage("sk", 10835.9, 0.99).addLanguage("sl", 5023.93, 0.99);
        this.addRegion(RegionCode.IC, 2098590.0, 0.977, 7.604E10).addLanguage("es", 2056620.0, 0.977, "OFFICIAL");
        this.addRegion(RegionCode.ID, 2.60581E8, 0.928, 3.243E12).addLanguage("id", 1.66772E8, 0.928, "OFFICIAL").addLanguage("jv", 8.85975E7, 0.928).addLanguage("su", 3.12697E7, 0.928).addLanguage("mad", 1.64166E7, 0.928).addLanguage("ms_Arab", 1.19867E7, 0.928).addLanguage("min", 7817430.0, 0.928).addLanguage("bew", 5472200.0, 0.928).addLanguage("ban", 4690460.0, 0.928).addLanguage("bug", 4169300.0, 0.928).addLanguage("bjn", 3908720.0, 0.928).addLanguage("ace", 3648130.0, 0.928).addLanguage("sas", 2527640.0, 0.928).addLanguage("bbc", 2397350.0, 0.928).addLanguage("zh_Hant", 2397350.0, 0.928).addLanguage("mak", 1902240.0, 0.928).addLanguage("ljp", 1798010.0, 0.928).addLanguage("rej", 1198670.0, 0.928).addLanguage("gor", 1068380.0, 0.928).addLanguage("nij", 964150.0, 0.928).addLanguage("kge", 833859.0, 0.928).addLanguage("aoz", 703569.0, 0.928).addLanguage("kvr", 364813.0, 0.928).addLanguage("lbw", 338755.0, 0.928).addLanguage("gay", 312697.0, 0.928).addLanguage("rob", 286639.0, 0.928).addLanguage("mdr", 239735.0, 0.928).addLanguage("sxn", 239735.0, 0.928).addLanguage("sly", 140714.0, 0.928).addLanguage("mwv", 62539.4, 0.928);
        this.addRegion(RegionCode.IE, 5011100.0, 0.99, 3.572E11).addLanguage("en", 4910880.0, 0.99, "OFFICIAL").addLanguage("ga", 1102440.0, 0.99, "OFFICIAL").addLanguage("fr", 851887.0, 0.99);
        this.addRegion(RegionCode.IL, 8299710.0, 0.971, 3.165E11).addLanguage("he", 8299710.0, 0.971, "OFFICIAL").addLanguage("en", 7054750.0, 0.971).addLanguage("ar", 1659940.0, 0.971, "OFFICIAL").addLanguage("ru", 912968.0, 0.971).addLanguage("ro", 307089.0, 0.971).addLanguage("yi", 248991.0, 0.971).addLanguage("pl", 124496.0, 0.971).addLanguage("lad", 107896.0, 0.971).addLanguage("hu", 82997.1, 0.971).addLanguage("am", 48968.3, 0.971).addLanguage("ti", 9959.65, 0.971).addLanguage("ml", 7967.72, 0.971);
        this.addRegion(RegionCode.IM, 88815.0, 0.99, 6.792E9).addLanguage("en", 88815.0, 0.99, "OFFICIAL").addLanguage("gv", 1687.49, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.IN, 1.28194E9, 0.628, 9.459E12).addLanguage("hi", 5.25595E8, 0.628, "OFFICIAL").addLanguage("en", 2.43569E8, 0.628, "OFFICIAL").addLanguage("bn", 1.03837E8, 0.628, "OFFICIAL_REGIONAL").addLanguage("te", 9.22997E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("mr", 8.97358E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("ta", 7.56345E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("ur", 6.4097E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("gu", 5.76873E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("kn", 4.74318E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("ml", 4.10221E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("or", 4.10221E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("pa", 3.58943E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("bho", 2.94846E7, 0.628).addLanguage("awa", 2.30749E7, 0.05).addLanguage("as", 1.66652E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("bgc", 1.53833E7, 0.628).addLanguage("mag", 1.53833E7, 0.628).addLanguage("mwr", 1.53833E7, 0.628).addLanguage("mai", 1.53833E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("hne", 1.41013E7, 0.628).addLanguage("dcc", 1.28194E7, 0.628).addLanguage("bjj", 7178860.0, 0.628).addLanguage("ne", 7178860.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("sat", 7050670.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("wtm", 5896920.0, 0.628).addLanguage("rkt", 5640540.0, 0.628).addLanguage("ks", 5255950.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("kok", 4743180.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("gom", 4102210.0, 0.628).addLanguage("swv", 3589430.0, 0.628).addLanguage("gbm", 3461240.0, 0.628).addLanguage("lmn", 3461240.0, 0.628).addLanguage("sd", 3333040.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("gon", 3076660.0, 0.628).addLanguage("kfy", 2820270.0, 0.628).addLanguage("doi", 2563880.0, 0.628).addLanguage("kru", 2435690.0, 0.628).addLanguage("sck", 2307490.0, 0.628).addLanguage("wbq", 2307490.0, 0.628).addLanguage("xnr", 2051100.0, 0.628).addLanguage("tcy", 1922910.0, 0.628).addLanguage("wbr", 1922910.0, 0.628).addLanguage("khn", 1922910.0, 0.628).addLanguage("brx", 1794720.0, 0.628).addLanguage("noe", 1666520.0, 0.628).addLanguage("bhb", 1538330.0, 0.628).addLanguage("mni", 1410130.0, 0.628).addLanguage("raj", 1281940.0, 0.628).addLanguage("hoc", 1281940.0, 0.628).addLanguage("mtr", 1256300.0, 0.628).addLanguage("unr", 1205020.0, 0.628).addLanguage("bhi", 1179380.0, 0.628).addLanguage("hoj", 1051190.0, 0.628).addLanguage("kha", 1025550.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("kfr", 961455.0, 0.628).addLanguage("grt", 679428.0, 0.628).addLanguage("unx", 615331.0, 0.628).addLanguage("bfy", 474318.0, 0.628).addLanguage("srx", 448679.0, 0.628).addLanguage("saz", 371763.0, 0.628).addLanguage("ccp", 358943.0, 0.628).addLanguage("sd_Deva", 333304.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("bfq", 294846.0, 0.628).addLanguage("njo", 294846.0, 0.628).addLanguage("ria", 166652.0, 0.628).addLanguage("bo", 141013.0, 0.628).addLanguage("bpy", 87171.9, 0.628).addLanguage("bft", 79480.3, 0.628).addLanguage("bra", 52559.5, 0.628).addLanguage("lep", 44867.9, 0.628).addLanguage("btv", 33330.4, 0.628).addLanguage("lif", 33330.4, 0.628).addLanguage("lah", 32048.5, 0.628).addLanguage("sa", 15383.3, 0.628, "OFFICIAL_REGIONAL").addLanguage("kht", 8973.58, 0.628).addLanguage("dv", 5127.76, 0.628).addLanguage("dz", 2563.88, 0.628);
        this.addRegion(RegionCode.IO, 3500.0, 0.99, 1.575E8).addLanguage("en", 3500.0, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.IQ, 3.91921E7, 0.785, 6.588E11).addLanguage("ar", 2.66506E7, 0.785, "OFFICIAL").addLanguage("en", 1.37172E7, 0.785).addLanguage("ckb", 7838420.0, 0.785, "OFFICIAL_REGIONAL").addLanguage("az_Arab", 705458.0, 0.785, "OFFICIAL_REGIONAL").addLanguage("fa", 340971.0, 0.785).addLanguage("lrc", 239072.0, 0.785).addLanguage("syr", 195960.0, 0.785);
        this.addRegion(RegionCode.IR, 8.20216E7, 0.85, 1.645E12).addLanguage("fa", 6.15162E7, 0.85, "OFFICIAL").addLanguage("az_Arab", 1.96852E7, 0.85).addLanguage("mzn", 4101080.0, 0.85).addLanguage("glk", 3772990.0, 0.85).addLanguage("ckb", 3198840.0, 0.85).addLanguage("sdh", 3034800.0, 0.85).addLanguage("tk", 2296600.0, 0.85).addLanguage("lrc", 1722450.0, 0.85).addLanguage("ar", 1640430.0, 0.85).addLanguage("bal", 1640430.0, 0.85).addLanguage("rmt", 1558410.0, 0.85).addLanguage("bqi", 1148300.0, 0.85).addLanguage("luz", 984259.0, 0.85).addLanguage("lki", 623364.0, 0.85).addLanguage("bgn", 459321.0, 0.05).addLanguage("prd", 410108.0, 0.85).addLanguage("hy", 196852.0, 0.85).addLanguage("ps", 131235.0, 0.85).addLanguage("ka", 58235.3, 0.85).addLanguage("gbz", 8038.12, 0.85).addLanguage("kk_Arab", 3034.8, 0.85);
        this.addRegion(RegionCode.IS, 339747.0, 0.99, 1.762E10).addLanguage("is", 339747.0, 0.99, "OFFICIAL").addLanguage("da", 2242.33, 0.99);
        this.addRegion(RegionCode.IT, 6.21378E7, 0.99, 2.311E12).addLanguage("it", 5.90309E7, 0.99, "OFFICIAL").addLanguage("en", 2.11269E7, 0.99).addLanguage("fr", 3914680.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("sc", 1056340.0, 0.99).addLanguage("de", 994205.0, 0.99).addLanguage("vec", 807791.0, 0.99).addLanguage("nap", 602737.0, 0.05).addLanguage("lij", 534385.0, 0.99).addLanguage("scn", 509530.0, 0.05).addLanguage("sl", 105634.0, 0.99).addLanguage("sdc", 105634.0, 0.99).addLanguage("fur", 37282.7, 0.05).addLanguage("egl", 31068.9, 0.99).addLanguage("ca", 21748.2, 0.99).addLanguage("el", 21748.2, 0.99).addLanguage("lmo", 18641.3, 0.99).addLanguage("pms", 6151.64, 0.99).addLanguage("hr", 3479.72, 0.99).addLanguage("rgn", 0.0, 0.99);
        this.addRegion(RegionCode.JE, 98840.0, 0.99, 5.569E9).addLanguage("en", 93898.0, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.JM, 2990560.0, 0.87, 2.606E10).addLanguage("en", 2930750.0, 0.87, "OFFICIAL").addLanguage("jam", 2841030.0, 0.87);
        this.addRegion(RegionCode.JO, 1.02481E7, 0.959, 8.91E10).addLanguage("ar", 1.02481E7, 0.959, "OFFICIAL").addLanguage("en", 4611640.0, 0.959);
        this.addRegion(RegionCode.JP, 1.26451E8, 0.99, 5.429E12).addLanguage("ja", 1.20128E8, 0.99, "OFFICIAL").addLanguage("ryu", 973673.0, 0.05).addLanguage("ko", 657545.0, 0.99);
        this.addRegion(RegionCode.KE, 4.76157E7, 0.874, 1.631E11).addLanguage("sw", 3.14264E7, 0.874, "OFFICIAL").addLanguage("en", 9046980.0, 0.874, "OFFICIAL").addLanguage("ki", 8094670.0, 0.874).addLanguage("luy", 5237730.0, 0.874).addLanguage("luo", 4666340.0, 0.874).addLanguage("kam", 3618790.0, 0.874).addLanguage("kln", 3618790.0, 0.874).addLanguage("guz", 2333170.0, 0.874).addLanguage("mer", 1904630.0, 0.874).addLanguage("mas", 761851.0, 0.874).addLanguage("ebu", 714236.0, 0.874).addLanguage("so", 619004.0, 0.874).addLanguage("dav", 390449.0, 0.05).addLanguage("teo", 352356.0, 0.874).addLanguage("pko", 333310.0, 0.874).addLanguage("om", 223794.0, 0.874).addLanguage("saq", 219032.0, 0.874).addLanguage("ar", 21903.2, 0.874).addLanguage("pa", 9999.3, 0.874).addLanguage("gu", 5237.73, 0.874);
        this.addRegion(RegionCode.KG, 5789120.0, 0.992, 2.297E10).addLanguage("ky", 2778780.0, 0.992, "OFFICIAL").addLanguage("ru", 2084080.0, 0.992, "OFFICIAL");
        this.addRegion(RegionCode.KH, 1.62045E7, 0.739, 6.425E10).addLanguage("km", 1.4422E7, 0.739, "OFFICIAL").addLanguage("cja", 259272.0, 0.739).addLanguage("kdt", 17825.0, 0.739);
        this.addRegion(RegionCode.KI, 108145.0, 0.9, 2.26E8).addLanguage("en", 108145.0, 0.9, "OFFICIAL").addLanguage("gil", 64887.0, 0.9, "OFFICIAL");
        this.addRegion(RegionCode.KM, 808080.0, 0.755, 1.313E9).addLanguage("ar", 533333.0, 0.755, "OFFICIAL").addLanguage("fr", 452525.0, 0.755, "OFFICIAL").addLanguage("zdj", 298990.0, 0.755, "OFFICIAL").addLanguage("wni", 274747.0, 0.755, "OFFICIAL");
        this.addRegion(RegionCode.KN, 52715.0, 0.978, 1.528E9).addLanguage("en", 51660.7, 0.978, "OFFICIAL");
        this.addRegion(RegionCode.KP, 2.52481E7, 1.0, 4.0E10).addLanguage("ko", 2.22183E7, 1.0, "OFFICIAL");
        this.addRegion(RegionCode.KR, 5.11813E7, 0.979, 2.029E12).addLanguage("ko", 5.11813E7, 0.979, "OFFICIAL");
        this.addRegion(RegionCode.KW, 2875420.0, 0.939, 2.915E11).addLanguage("ar", 2875420.0, 0.939, "OFFICIAL");
        this.addRegion(RegionCode.KY, 58441.0, 0.989, 2.507E9).addLanguage("en", 57272.2, 0.989, "OFFICIAL");
        this.addRegion(RegionCode.KZ, 1.85567E7, 0.997, 4.776E11).addLanguage("ru", 1.33608E7, 0.997, "OFFICIAL").addLanguage("kk", 1.18763E7, 0.997, "OFFICIAL").addLanguage("en", 2783500.0, 0.997).addLanguage("de", 1187630.0, 0.997).addLanguage("ug_Cyrl", 371134.0, 0.997);
        this.addRegion(RegionCode.LA, 7126710.0, 0.727, 4.921E10).addLanguage("lo", 4917430.0, 0.727, "OFFICIAL").addLanguage("kjg", 413349.0, 0.727).addLanguage("kdt", 68416.4, 0.727);
        this.addRegion(RegionCode.LB, 6229790.0, 0.896, 8.768E10).addLanguage("ar", 5357620.0, 0.896, "OFFICIAL").addLanguage("en", 2491920.0, 0.896).addLanguage("hy", 323949.0, 0.896).addLanguage("ku_Arab", 105906.0, 0.896).addLanguage("fr", 23050.2, 0.896);
        this.addRegion(RegionCode.LC, 164994.0, 0.901, 2.536E9).addLanguage("en", 148495.0, 0.901, "OFFICIAL");
        this.addRegion(RegionCode.LI, 38244.0, 1.0, 4.978E9).addLanguage("de", 38244.0, 1.0, "OFFICIAL").addLanguage("gsw", 32507.4, 0.05, "DE_FACTO_OFFICIAL").addLanguage("wae", 1300.3, 1.0);
        this.addRegion(RegionCode.LK, 2.24094E7, 0.912, 2.747E11).addLanguage("si", 1.52384E7, 0.912, "OFFICIAL").addLanguage("ta", 3361410.0, 0.912, "OFFICIAL").addLanguage("en", 2240940.0, 0.912);
        this.addRegion(RegionCode.LR, 4689020.0, 0.608, 6.099E9).addLanguage("en", 3891890.0, 0.608, "OFFICIAL").addLanguage("kpe", 656463.0, 0.608).addLanguage("vai", 121915.0, 0.608).addLanguage("men", 22507.3, 0.608).addLanguage("ff", 0.0, 0.608).addLanguage("ff_Adlm", 0.0, 0.608).addLanguage("vai_Latn", 0.0, 0.608);
        this.addRegion(RegionCode.LS, 1958040.0, 0.896, 6.955E9).addLanguage("st", 1918880.0, 0.896, "OFFICIAL").addLanguage("en", 528671.0, 0.896, "OFFICIAL").addLanguage("zu", 274126.0, 0.896).addLanguage("ss", 46993.0, 0.896).addLanguage("xh", 19580.4, 0.896);
        this.addRegion(RegionCode.LT, 2823860.0, 0.997, 9.124E10).addLanguage("lt", 2428520.0, 0.997, "OFFICIAL").addLanguage("ru", 2259090.0, 0.997).addLanguage("en", 1073070.0, 0.997).addLanguage("de", 395340.0, 0.997).addLanguage("sgs", 0.0, 0.997);
        this.addRegion(RegionCode.LU, 594130.0, 1.0, 6.273E10).addLanguage("fr", 516893.0, 1.0, "OFFICIAL").addLanguage("lb", 398067.0, 0.05, "OFFICIAL").addLanguage("de", 374302.0, 1.0, "OFFICIAL").addLanguage("en", 332713.0, 1.0).addLanguage("pt", 95060.8, 1.0);
        this.addRegion(RegionCode.LV, 1944640.0, 0.998, 5.391E10).addLanguage("lv", 1186230.0, 0.998, "OFFICIAL").addLanguage("en", 894534.0, 0.998).addLanguage("ru", 738963.0, 0.998).addLanguage("ltg", 173073.0, 0.998);
        this.addRegion(RegionCode.LY, 6653210.0, 0.895, 6.44E10).addLanguage("ar", 4923380.0, 0.895, "OFFICIAL");
        this.addRegion(RegionCode.MA, 3.39867E7, 0.671, 2.986E11).addLanguage("ary", 2.95684E7, 0.671).addLanguage("ar", 2.10718E7, 0.671, "OFFICIAL").addLanguage("zgh", 7477070.0, 0.671).addLanguage("fr", 6797340.0, 0.671, "DE_FACTO_OFFICIAL").addLanguage("en", 4758140.0, 0.671).addLanguage("tzm", 3330700.0, 0.671, "OFFICIAL").addLanguage("shi", 2956840.0, 0.671).addLanguage("shi_Latn", 2956840.0, 0.671).addLanguage("rif", 1665350.0, 0.05).addLanguage("rif_Latn", 1665350.0, 0.05).addLanguage("es", 22091.4, 0.671);
        this.addRegion(RegionCode.MC, 30645.0, 0.99, 7.672E9).addLanguage("fr", 30338.5, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.MD, 3474120.0, 0.99, 2.008E10).addLanguage("ro", 2188700.0, 0.99, "OFFICIAL").addLanguage("uk", 486377.0, 0.99).addLanguage("bg", 326567.0, 0.99).addLanguage("gag", 114646.0, 0.99).addLanguage("ru", 104224.0, 0.99);
        this.addRegion(RegionCode.ME, 642550.0, 0.985, 1.105E10).addLanguage("sr_Latn", 642550.0, 0.985, "OFFICIAL").addLanguage("sq", 50761.5, 0.985).addLanguage("sr", 32127.5, 0.985);
        this.addRegion(RegionCode.MF, 32125.0, 0.99, 5.615E8).addLanguage("fr", 32125.0, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.MG, 2.50542E7, 0.645, 3.973E10).addLanguage("mg", 2.25488E7, 0.645, "OFFICIAL").addLanguage("fr", 1.72874E7, 0.645, "OFFICIAL").addLanguage("en", 4509760.0, 0.645, "OFFICIAL");
        this.addRegion(RegionCode.MH, 74539.0, 0.937, 1.89E8).addLanguage("en", 69321.3, 0.937, "OFFICIAL").addLanguage("mh", 54413.5, 0.937, "OFFICIAL");
        this.addRegion(RegionCode.MK, 2103720.0, 0.974, 3.096E10).addLanguage("mk", 1409490.0, 0.974, "OFFICIAL").addLanguage("sq", 525930.0, 0.974, "OFFICIAL_REGIONAL").addLanguage("tr", 73630.2, 0.974);
        this.addRegion(RegionCode.ML, 1.78852E7, 0.334, 4.1E10).addLanguage("bm", 8227190.0, 0.334).addLanguage("fr", 8227190.0, 0.334, "OFFICIAL").addLanguage("ffm", 1377160.0, 0.334).addLanguage("snk", 1055230.0, 0.334).addLanguage("mwk", 894260.0, 0.334).addLanguage("ses", 608097.0, 0.334).addLanguage("tmh", 375589.0, 0.334).addLanguage("bm_Nkoo", 357704.0, 0.334).addLanguage("khq", 304048.0, 0.334).addLanguage("dtm", 196737.0, 0.334).addLanguage("kao", 178852.0, 0.334).addLanguage("ar", 159178.0, 0.334).addLanguage("bmq", 153813.0, 0.334).addLanguage("bze", 150236.0, 0.334);
        this.addRegion(RegionCode.MM, 5.51238E7, 0.927, 3.287E11).addLanguage("my", 3.52792E7, 0.927, "OFFICIAL").addLanguage("shn", 3527920.0, 0.927).addLanguage("kac", 937105.0, 0.927).addLanguage("mnw", 826857.0, 0.927).addLanguage("kht", 4244.53, 0.927);
        this.addRegion(RegionCode.MN, 3068240.0, 0.974, 3.97E10).addLanguage("mn", 2853460.0, 0.974, "OFFICIAL").addLanguage("kk_Arab", 220913.0, 0.974).addLanguage("zh", 42955.4, 0.974).addLanguage("ru", 3988.71, 0.974).addLanguage("ug_Cyrl", 1012.52, 0.974);
        this.addRegion(RegionCode.MO, 601969.0, 0.956, 7.178E10).addLanguage("zh_Hant", 589930.0, 0.956, "OFFICIAL").addLanguage("pt", 30098.5, 0.956, "OFFICIAL").addLanguage("zh", 30098.5, 0.956).addLanguage("en", 13845.3, 0.956);
        this.addRegion(RegionCode.MP, 52263.0, 0.97, 1.242E9).addLanguage("en", 50695.1, 0.97, "DE_FACTO_OFFICIAL").addLanguage("ch", 9407.34, 0.97);
        this.addRegion(RegionCode.MQ, 436131.0, 0.98, 6.117E9).addLanguage("fr", 427408.0, 0.98, "OFFICIAL");
        this.addRegion(RegionCode.MR, 3758570.0, 0.586, 1.725E10).addLanguage("ar", 3194780.0, 0.586, "OFFICIAL").addLanguage("fr", 638957.0, 0.586).addLanguage("ff", 214238.0, 0.586).addLanguage("wo", 10148.1, 0.586).addLanguage("ff_Adlm", 0.0, 0.586);
        this.addRegion(RegionCode.MS, 5292.0, 0.97, 1.674E8).addLanguage("en", 3492.72, 0.97, "OFFICIAL");
        this.addRegion(RegionCode.MT, 416338.0, 0.924, 1.931E10).addLanguage("mt", 416338.0, 0.924, "OFFICIAL").addLanguage("en", 366377.0, 0.924, "OFFICIAL").addLanguage("it", 233149.0, 0.924).addLanguage("fr", 45797.2, 0.924);
        this.addRegion(RegionCode.MU, 1356390.0, 0.888, 2.746E10).addLanguage("mfe", 1220750.0, 0.888).addLanguage("en", 976601.0, 0.888, "OFFICIAL").addLanguage("bho", 366225.0, 0.888).addLanguage("ur", 70532.3, 0.888).addLanguage("fr", 40691.7, 0.888, "OFFICIAL").addLanguage("ta", 33909.8, 0.888);
        this.addRegion(RegionCode.MV, 392709.0, 0.984, 6.887E9).addLanguage("dv", 369146.0, 0.984, "OFFICIAL");
        this.addRegion(RegionCode.MW, 1.91962E7, 0.748, 2.237E10).addLanguage("en", 1.20936E7, 0.748, "OFFICIAL").addLanguage("ny", 1.20936E7, 0.748, "OFFICIAL").addLanguage("tum", 1612480.0, 0.748).addLanguage("tog", 188123.0, 0.748).addLanguage("zu", 63347.5, 0.748);
        this.addRegion(RegionCode.MX, 1.24575E8, 0.935, 2.458E12).addLanguage("es", 1.03397E8, 0.935, "DE_FACTO_OFFICIAL").addLanguage("en", 1.61948E7, 0.935).addLanguage("yua", 834652.0, 0.935).addLanguage("nhe", 485842.0, 0.935).addLanguage("nhw", 485842.0, 0.935).addLanguage("maz", 423555.0, 0.935).addLanguage("nch", 236692.0, 0.935).addLanguage("sei", 872.025, 0.935);
        this.addRegion(RegionCode.MY, 3.1382E7, 0.931, 9.308E11).addLanguage("ms", 2.35365E7, 0.931, "OFFICIAL").addLanguage("en", 6590220.0, 0.931).addLanguage("zh_Hant", 5334940.0, 0.931).addLanguage("ta", 1318040.0, 0.931).addLanguage("iba", 784550.0, 0.931).addLanguage("jv", 376584.0, 0.931).addLanguage("zmi", 376584.0, 0.931).addLanguage("dtp", 175739.0, 0.931).addLanguage("ml", 47073.0, 0.931).addLanguage("bug", 24791.8, 0.931).addLanguage("bjn", 5021.12, 0.931);
        this.addRegion(RegionCode.MZ, 2.65737E7, 0.561, 3.673E10).addLanguage("pt", 7174900.0, 0.561, "OFFICIAL").addLanguage("vmw", 3454580.0, 0.561).addLanguage("ndc", 2630800.0, 0.561).addLanguage("ts", 2099320.0, 0.561).addLanguage("ngl", 1807010.0, 0.561).addLanguage("seh", 1222390.0, 0.561).addLanguage("mgh", 1195820.0, 0.561).addLanguage("rng", 903506.0, 0.561).addLanguage("ny", 690916.0, 0.561).addLanguage("yao", 637769.0, 0.561).addLanguage("sw", 9300.8, 0.561).addLanguage("zu", 1807.01, 0.561);
        this.addRegion(RegionCode.NA, 2484780.0, 0.888, 2.651E10).addLanguage("af", 1863580.0, 0.888).addLanguage("kj", 869673.0, 0.888).addLanguage("ng", 521804.0, 0.888).addLanguage("naq", 273326.0, 0.888).addLanguage("hz", 226115.0, 0.888).addLanguage("en", 173935.0, 0.888, "OFFICIAL").addLanguage("de", 22363.0, 0.888).addLanguage("tn", 13914.8, 0.888);
        this.addRegion(RegionCode.NC, 279070.0, 0.962, 1.111E10).addLanguage("fr", 267907.0, 0.962, "OFFICIAL");
        this.addRegion(RegionCode.NE, 1.92453E7, 0.287, 2.184E10).addLanguage("ha", 7890570.0, 0.287).addLanguage("fr", 5581140.0, 0.287, "OFFICIAL").addLanguage("dje", 3271700.0, 0.287).addLanguage("fuq", 1347170.0, 0.287).addLanguage("tmh", 1154720.0, 0.287).addLanguage("ar", 40415.1, 0.287).addLanguage("twq", 8083.03, 0.287).addLanguage("ff", 0.0, 0.287).addLanguage("ff_Adlm", 0.0, 0.287);
        this.addRegion(RegionCode.NF, 2210.0, 0.99, 1.185E8).addLanguage("en", 1679.6, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.NG, 1.90632E8, 0.613, 1.119E12).addLanguage("en", 1.01035E8, 0.613, "OFFICIAL").addLanguage("pcm", 4.00327E7, 0.613).addLanguage("ha", 2.47822E7, 0.613).addLanguage("ig", 2.47822E7, 0.613).addLanguage("yo", 2.47822E7, 0.613, "OFFICIAL").addLanguage("fuv", 1.27723E7, 0.613).addLanguage("tiv", 3050110.0, 0.613).addLanguage("efi", 2668850.0, 0.613).addLanguage("ibb", 2668850.0, 0.613).addLanguage("ha_Arab", 1906320.0, 0.613).addLanguage("bin", 1353490.0, 0.613).addLanguage("kaj", 400327.0, 0.613).addLanguage("kcg", 177288.0, 0.613).addLanguage("ar", 135349.0, 0.613).addLanguage("cch", 40032.7, 0.613).addLanguage("amo", 16775.6, 0.613).addLanguage("ff", 0.0, 0.613).addLanguage("ff_Adlm", 0.0, 0.613);
        this.addRegion(RegionCode.NI, 6025950.0, 0.78, 3.638E10).addLanguage("es", 4700240.0, 0.78, "OFFICIAL");
        this.addRegion(RegionCode.NL, 1.70847E7, 0.99, 9.161E11).addLanguage("nl", 1.70847E7, 0.99, "OFFICIAL").addLanguage("en", 1.53762E7, 0.99).addLanguage("de", 1.21301E7, 0.05).addLanguage("fr", 4954560.0, 0.99).addLanguage("nds", 1879320.0, 0.05).addLanguage("li", 939658.0, 0.05).addLanguage("fy", 734642.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("gos", 615049.0, 0.05).addLanguage("id", 307525.0, 0.99).addLanguage("zea", 239186.0, 0.99).addLanguage("rif_Latn", 205016.0, 0.99).addLanguage("tr", 205016.0, 0.99);
        this.addRegion(RegionCode.NO, 5320050.0, 1.0, 3.8E11).addLanguage("nb", 5320050.0, 1.0, "OFFICIAL").addLanguage("nn", 1330010.0, 1.0, "OFFICIAL").addLanguage("se", 15428.1, 1.0, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.NP, 2.93843E7, 0.574, 7.859E10).addLanguage("ne", 1.29291E7, 0.574, "OFFICIAL").addLanguage("mai", 3232270.0, 0.574).addLanguage("bho", 1998130.0, 0.574).addLanguage("new", 969682.0, 0.574).addLanguage("jml", 940298.0, 0.574).addLanguage("en", 881529.0, 0.574).addLanguage("taj", 881529.0, 0.574).addLanguage("dty", 734608.0, 0.574).addLanguage("awa", 646455.0, 0.574).addLanguage("thl", 587686.0, 0.574).addLanguage("bap", 440764.0, 0.574).addLanguage("tdg", 381996.0, 0.574).addLanguage("thr", 352612.0, 0.574).addLanguage("mgp", 323227.0, 0.574).addLanguage("lif", 323227.0, 0.574).addLanguage("thq", 293843.0, 0.574).addLanguage("mrd", 243890.0, 0.574).addLanguage("bfy", 158675.0, 0.574).addLanguage("xsr", 152798.0, 0.574).addLanguage("rjs", 129291.0, 0.574).addLanguage("tsf", 126352.0, 0.574).addLanguage("hi", 123414.0, 0.574).addLanguage("ggn", 123414.0, 0.574).addLanguage("gvr", 85214.5, 0.574).addLanguage("bo", 70522.3, 0.574).addLanguage("tkt", 70522.3, 0.574).addLanguage("tdh", 35261.2, 0.574).addLanguage("bn", 27621.2, 0.574).addLanguage("unr_Deva", 5583.02, 0.574).addLanguage("lep", 2820.89, 0.574);
        this.addRegion(RegionCode.NR, 9642.0, 0.99, 1.59E8).addLanguage("en", 9352.74, 0.99, "OFFICIAL").addLanguage("na", 6845.82, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.NU, 1626.0, 0.95, 1.001E7).addLanguage("en", 1121.94, 0.95, "OFFICIAL").addLanguage("niu", 1121.94, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.NZ, 4510330.0, 0.99, 1.886E11).addLanguage("en", 4420120.0, 0.99, "DE_FACTO_OFFICIAL").addLanguage("mi", 126289.0, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.OM, 3424390.0, 0.869, 1.866E11).addLanguage("ar", 2773760.0, 0.869, "OFFICIAL").addLanguage("bal", 167795.0, 0.869).addLanguage("fa", 32189.3, 0.869);
        this.addRegion(RegionCode.PA, 3753140.0, 0.941, 1.039E11).addLanguage("es", 2589670.0, 0.941, "OFFICIAL").addLanguage("en", 525440.0, 0.941).addLanguage("zh_Hant", 6005.02, 0.941);
        this.addRegion(RegionCode.PE, 3.10367E7, 0.896, 4.244E11).addLanguage("es", 2.26568E7, 0.896, "OFFICIAL").addLanguage("qu", 4655500.0, 0.896, "OFFICIAL").addLanguage("ay", 496587.0, 0.896);
        this.addRegion(RegionCode.PF, 287881.0, 0.98, 5.49E9).addLanguage("fr", 175607.0, 0.98, "OFFICIAL").addLanguage("ty", 89243.1, 0.98, "OFFICIAL").addLanguage("zh_Hant", 22454.7, 0.98);
        this.addRegion(RegionCode.PG, 6909700.0, 0.624, 3.033E10).addLanguage("tpi", 4905890.0, 0.624, "OFFICIAL").addLanguage("en", 3454850.0, 0.624, "OFFICIAL").addLanguage("ho", 145104.0, 0.05, "OFFICIAL");
        this.addRegion(RegionCode.PH, 1.04256E8, 0.954, 8.756E11).addLanguage("en", 6.67238E7, 0.954, "OFFICIAL").addLanguage("fil", 6.25536E7, 0.954, "OFFICIAL").addLanguage("es", 3.23194E7, 0.954).addLanguage("ceb", 2.50214E7, 0.954, "OFFICIAL_REGIONAL").addLanguage("ilo", 1.00086E7, 0.954, "OFFICIAL_REGIONAL").addLanguage("hil", 8757500.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("bik", 3127680.0, 0.954).addLanguage("war", 3023420.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("bhk", 2397890.0, 0.954).addLanguage("pam", 2397890.0, 0.954).addLanguage("pag", 1459580.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("mdh", 1251070.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("tsg", 1146820.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("zh_Hant", 761069.0, 0.954).addLanguage("cps", 688090.0, 0.954).addLanguage("krj", 406598.0, 0.954).addLanguage("bto", 291917.0, 0.954).addLanguage("hnn", 16681.0, 0.954).addLanguage("tbw", 10008.6, 0.954).addLanguage("bku", 8027.71, 0.954);
        this.addRegion(RegionCode.PK, 2.04925E8, 0.549, 1.057E12).addLanguage("ur", 1.94679E8, 0.549, "OFFICIAL").addLanguage("pa_Arab", 1.43448E8, 0.549).addLanguage("en", 1.02462E8, 0.549, "OFFICIAL").addLanguage("lah", 8.197E7, 0.549).addLanguage("ps", 3.07388E7, 0.549).addLanguage("sd", 2.4591E7, 0.549).addLanguage("skr", 1.86482E7, 0.549).addLanguage("bal", 7582220.0, 0.549).addLanguage("brh", 2664020.0, 0.549).addLanguage("hno", 2459100.0, 0.549).addLanguage("fa", 1352500.0, 0.549).addLanguage("bgn", 1168070.0, 0.05).addLanguage("hnd", 840192.0, 0.549).addLanguage("tg_Arab", 676252.0, 0.549).addLanguage("gju", 409850.0, 0.549).addLanguage("bft", 368865.0, 0.549).addLanguage("kvx", 327880.0, 0.549).addLanguage("khw", 307388.0, 0.549).addLanguage("mvy", 286895.0, 0.549).addLanguage("kxp", 245910.0, 0.549).addLanguage("gjk", 225418.0, 0.549).addLanguage("ks", 141398.0, 0.549).addLanguage("btv", 38935.8, 0.549);
        this.addRegion(RegionCode.PL, 3.84763E7, 0.997, 1.121E12).addLanguage("pl", 3.69372E7, 0.997, "OFFICIAL").addLanguage("en", 1.26972E7, 0.997).addLanguage("de", 7310500.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ru", 6925730.0, 0.997).addLanguage("szl", 500192.0, 0.997).addLanguage("be", 223163.0, 0.997).addLanguage("uk", 150058.0, 0.997).addLanguage("csb", 50019.2, 0.997, "OFFICIAL_REGIONAL").addLanguage("sli", 11927.7, 0.997).addLanguage("lt", 8080.02, 0.997, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.PM, 5533.0, 0.99, 2.613E8).addLanguage("fr", 5090.36, 0.99, "OFFICIAL").addLanguage("en", 188.122, 0.99);
        this.addRegion(RegionCode.PN, 54.0, 0.99, 2429000.0).addLanguage("en", 45.9, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.PR, 3351830.0, 0.903, 1.21E11).addLanguage("es", 2916090.0, 0.903, "OFFICIAL").addLanguage("en", 1642400.0, 0.903, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.PS, 4543130.0, 0.953, 2.122E10).addLanguage("ar", 4543130.0, 0.953, "OFFICIAL");
        this.addRegion(RegionCode.PT, 1.08395E7, 0.954, 3.134E11).addLanguage("pt", 1.04059E7, 0.954, "OFFICIAL").addLanguage("en", 2926660.0, 0.954).addLanguage("fr", 1625920.0, 0.954).addLanguage("es", 1083950.0, 0.954).addLanguage("gl", 15175.3, 0.954);
        this.addRegion(RegionCode.PW, 21431.0, 0.92, 2.91E8).addLanguage("pau", 15858.9, 0.92, "OFFICIAL").addLanguage("en", 1885.93, 0.92, "OFFICIAL");
        this.addRegion(RegionCode.PY, 6943740.0, 0.939, 6.833E10).addLanguage("gn", 5554990.0, 0.939, "OFFICIAL").addLanguage("es", 222200.0, 0.939, "OFFICIAL").addLanguage("de", 201368.0, 0.939);
        this.addRegion(RegionCode.QA, 2314310.0, 0.963, 3.406E11).addLanguage("ar", 2059740.0, 0.963, "OFFICIAL").addLanguage("fa", 254574.0, 0.963).addLanguage("ml", 6480.07, 0.963);
        this.addRegion(RegionCode.RE, 787584.0, 0.88, 4.791E9).addLanguage("fr", 700950.0, 0.88, "OFFICIAL").addLanguage("rcf", 559185.0, 0.88).addLanguage("ta", 118138.0, 0.88);
        this.addRegion(RegionCode.RO, 2.153E7, 0.977, 4.815E11).addLanguage("ro", 1.9377E7, 0.977, "OFFICIAL").addLanguage("en", 6674300.0, 0.977).addLanguage("fr", 3660100.0, 0.977).addLanguage("es", 2153000.0, 0.977).addLanguage("hu", 1420980.0, 0.977).addLanguage("de", 45213.0, 0.977).addLanguage("tr", 27989.0, 0.977).addLanguage("sr_Latn", 25836.0, 0.977).addLanguage("bg", 6674.3, 0.977).addLanguage("el", 4090.7, 0.977).addLanguage("pl", 2798.9, 0.977);
        this.addRegion(RegionCode.RS, 7111020.0, 0.98, 1.055E11).addLanguage("sr", 7039910.0, 0.98, "OFFICIAL").addLanguage("sr_Latn", 7039910.0, 0.05, "OFFICIAL").addLanguage("sq", 1351090.0, 0.98).addLanguage("hu", 341329.0, 0.98, "OFFICIAL_REGIONAL").addLanguage("ro", 149331.0, 0.98, "OFFICIAL_REGIONAL").addLanguage("hr", 66132.5, 0.98, "OFFICIAL_REGIONAL").addLanguage("sk", 61154.8, 0.98, "OFFICIAL_REGIONAL").addLanguage("uk", 0.0, 0.98, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.RU, 1.42258E8, 0.997, 4.008E12).addLanguage("ru", 1.33723E8, 0.997, "OFFICIAL").addLanguage("tt", 1991610.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ba", 1849350.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("cv", 1849350.0, 0.997).addLanguage("hy", 1194970.0, 0.997).addLanguage("ce", 938903.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("av", 554806.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("udm", 540580.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("chm", 526355.0, 0.997).addLanguage("sah", 455226.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("os", 455226.0, 0.997).addLanguage("kbd", 441000.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("myv", 441000.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("dar", 369871.0, 0.997).addLanguage("bua", 312968.0, 0.997).addLanguage("mdf", 298742.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("kum", 284516.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("kv", 256064.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("lez", 256064.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("krc", 241839.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("inh", 227613.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("tyv", 184935.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("az_Cyrl", 132300.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ady", 125187.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("krl", 116652.0, 0.997).addLanguage("lbe", 110961.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("koi", 64016.1, 0.997, "OFFICIAL_REGIONAL").addLanguage("mrj", 29874.2, 0.997).addLanguage("alt", 19916.1, 0.997).addLanguage("fi", 17071.0, 0.997).addLanguage("sr_Latn", 4979.03, 0.997).addLanguage("vep", 3556.45, 0.997).addLanguage("mn", 2133.87, 0.997).addLanguage("izh", 142.258, 0.997).addLanguage("vot", 0.0, 0.997).addLanguage("cu", 0.0, 0.997);
        this.addRegion(RegionCode.RW, 1.19015E7, 0.711, 2.463E10).addLanguage("rw", 9164160.0, 0.711, "OFFICIAL").addLanguage("en", 1785220.0, 0.711, "OFFICIAL").addLanguage("fr", 2261.28, 0.711, "OFFICIAL");
        this.addRegion(RegionCode.SA, 2.85718E7, 0.872, 1.774E12).addLanguage("ar", 2.85718E7, 0.872, "OFFICIAL");
        this.addRegion(RegionCode.SB, 647581.0, 0.841, 1.324E9).addLanguage("en", 647581.0, 0.841, "OFFICIAL").addLanguage("rug", 9713.72, 0.841);
        this.addRegion(RegionCode.SC, 93920.0, 0.918, 2.718E9).addLanguage("crs", 92041.6, 0.918).addLanguage("fr", 56352.0, 0.918, "OFFICIAL").addLanguage("en", 35689.6, 0.918, "OFFICIAL");
        this.addRegion(RegionCode.SD, 3.73459E7, 0.719, 1.87E11).addLanguage("ar", 2.2781E7, 0.719, "OFFICIAL").addLanguage("en", 2.2781E7, 0.719, "OFFICIAL").addLanguage("bej", 2016680.0, 0.719).addLanguage("fvr", 1008340.0, 0.719).addLanguage("ha_Arab", 672226.0, 0.719).addLanguage("mls", 369724.0, 0.719).addLanguage("fia", 309971.0, 0.719).addLanguage("zag", 190464.0, 0.719);
        this.addRegion(RegionCode.SE, 9960490.0, 0.99, 5.209E11).addLanguage("sv", 9462470.0, 0.99, "OFFICIAL").addLanguage("en", 8566020.0, 0.99).addLanguage("fi", 219131.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("fit", 54782.7, 0.99).addLanguage("se", 32869.6, 0.99).addLanguage("rmu", 9462.47, 0.99).addLanguage("yi", 2988.15, 0.99).addLanguage("smj", 1494.07, 0.99).addLanguage("sma", 298.815, 0.99).addLanguage("ia", 0.0, 0.99);
        this.addRegion(RegionCode.SG, 5888930.0, 0.959, 5.27E11).addLanguage("en", 5476700.0, 0.959, "OFFICIAL").addLanguage("zh", 4534480.0, 0.959, "OFFICIAL").addLanguage("ms", 824450.0, 0.959, "OFFICIAL").addLanguage("ta", 123668.0, 0.959, "OFFICIAL").addLanguage("ml", 10011.2, 0.959).addLanguage("pa", 9422.29, 0.959);
        this.addRegion(RegionCode.SH, 7828.0, 0.97, 3.11E7).addLanguage("en", 5401.32, 0.97, "OFFICIAL");
        this.addRegion(RegionCode.SI, 1972130.0, 0.997, 7.108E10).addLanguage("sl", 1715750.0, 0.997, "OFFICIAL").addLanguage("hr", 1203000.0, 0.997).addLanguage("en", 1163560.0, 0.997).addLanguage("de", 828295.0, 0.997).addLanguage("hu", 9269.01, 0.997).addLanguage("it", 3944.26, 0.997);
        this.addRegion(RegionCode.SJ, 2667.0, 1.0, 1.905E8).addLanguage("nb", 1493.52, 1.0, "OFFICIAL").addLanguage("ru", 1200.15, 1.0);
        this.addRegion(RegionCode.SK, 5445830.0, 0.996, 1.794E11).addLanguage("sk", 4901250.0, 0.996, "OFFICIAL").addLanguage("cs", 2559540.0, 0.996).addLanguage("en", 1415920.0, 0.996).addLanguage("de", 1198080.0, 0.996).addLanguage("hu", 599041.0, 0.996).addLanguage("uk", 103471.0, 0.996).addLanguage("pl", 50646.2, 0.996);
        this.addRegion(RegionCode.SL, 6163200.0, 0.433, 1.15E10).addLanguage("kri", 5855040.0, 0.433).addLanguage("en", 2157120.0, 0.433, "OFFICIAL").addLanguage("men", 1664060.0, 0.433).addLanguage("tem", 1602430.0, 0.433).addLanguage("ff", 0.0, 0.433).addLanguage("ff_Adlm", 0.0, 0.433);
        this.addRegion(RegionCode.SM, 33537.0, 0.96, 2.052E9).addLanguage("it", 29847.9, 0.96, "OFFICIAL").addLanguage("eo", 298.479, 0.96);
        this.addRegion(RegionCode.SN, 1.46685E7, 0.497, 4.324E10).addLanguage("wo", 1.0268E7, 0.497, "DE_FACTO_OFFICIAL").addLanguage("fr", 5720720.0, 0.497, "OFFICIAL").addLanguage("ff", 3080380.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("srr", 1613540.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("dyo", 381381.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("sav", 220028.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("mfv", 112947.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("bjt", 89477.9, 0.497, "OFFICIAL_REGIONAL").addLanguage("snf", 35204.4, 0.497, "OFFICIAL_REGIONAL").addLanguage("knf", 30803.9, 0.497, "OFFICIAL_REGIONAL").addLanguage("bsc", 14228.4, 0.497, "OFFICIAL_REGIONAL").addLanguage("mey", 7187.57, 0.497, "OFFICIAL_REGIONAL").addLanguage("tnr", 3373.76, 0.497, "OFFICIAL_REGIONAL").addLanguage("ff_Adlm", 0.0, 0.497);
        this.addRegion(RegionCode.SO, 1.10314E7, 0.378, 1.866E10).addLanguage("so", 8604490.0, 0.378, "OFFICIAL").addLanguage("ar", 3750680.0, 0.378, "OFFICIAL").addLanguage("sw", 220628.0, 0.378).addLanguage("om", 46331.9, 0.378);
        this.addRegion(RegionCode.SR, 591919.0, 0.947, 8.508E9).addLanguage("nl", 532727.0, 0.947, "OFFICIAL").addLanguage("srn", 402505.0, 0.947).addLanguage("zh_Hant", 7103.03, 0.947);
        this.addRegion(RegionCode.SS, 1.30261E7, 0.27, 1.874E10).addLanguage("ar", 3517050.0, 0.27).addLanguage("en", 3517050.0, 0.27, "OFFICIAL").addLanguage("nus", 729462.0, 0.27);
        this.addRegion(RegionCode.ST, 201025.0, 0.695, 6.76E8).addLanguage("pt", 170871.0, 0.695, "OFFICIAL");
        this.addRegion(RegionCode.SV, 6172010.0, 0.845, 5.699E10).addLanguage("es", 5493090.0, 0.845, "OFFICIAL");
        this.addRegion(RegionCode.SX, 42083.0, 0.99, 3.658E8).addLanguage("en", 28616.4, 0.99, "OFFICIAL").addLanguage("es", 5049.96, 0.99).addLanguage("vic", 3114.14, 0.99).addLanguage("nl", 1599.15, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.SY, 1.80285E7, 0.841, 5.028E10).addLanguage("ar", 1.44228E7, 0.841, "OFFICIAL").addLanguage("ku", 1442280.0, 0.841).addLanguage("fr", 1063680.0, 0.841, "OFFICIAL").addLanguage("hy", 324513.0, 0.841).addLanguage("syr", 15143.9, 0.05);
        this.addRegion(RegionCode.SZ, 1467150.0, 0.878, 1.134E10).addLanguage("en", 1173720.0, 0.878, "OFFICIAL").addLanguage("ss", 850947.0, 0.878, "OFFICIAL").addLanguage("zu", 99766.2, 0.878).addLanguage("ts", 24941.5, 0.878);
        this.addRegion(RegionCode.TA, 275.0, 0.99, 1.237E7).addLanguage("en", 272.25, 0.99);
        this.addRegion(RegionCode.TC, 52570.0, 0.98, 6.32E8).addLanguage("en", 51518.6, 0.98, "OFFICIAL");
        this.addRegion(RegionCode.TD, 1.2076E7, 0.354, 2.856E10).addLanguage("fr", 3139760.0, 0.354, "OFFICIAL").addLanguage("ar", 2052920.0, 0.354, "OFFICIAL");
        this.addRegion(RegionCode.TF, 140.0, 0.99, 5917000.0).addLanguage("fr", 140.0, 0.99);
        this.addRegion(RegionCode.TG, 7965060.0, 0.604, 1.294E10).addLanguage("fr", 4858690.0, 0.604, "OFFICIAL").addLanguage("ee", 1354060.0, 0.604).addLanguage("ife", 103546.0, 0.604);
        this.addRegion(RegionCode.TH, 6.84141E7, 0.935, 1.234E12).addLanguage("th", 5.47313E7, 0.935, "OFFICIAL").addLanguage("en", 1.84718E7, 0.935).addLanguage("tts", 1.64194E7, 0.05).addLanguage("nod", 6567750.0, 0.05).addLanguage("sou", 5473130.0, 0.05).addLanguage("mfa", 3420700.0, 0.935).addLanguage("zh_Hant", 1231450.0, 0.935).addLanguage("kxm", 1163040.0, 0.935).addLanguage("kdt", 328388.0, 0.935).addLanguage("mnw", 116304.0, 0.935).addLanguage("shn", 65677.5, 0.935).addLanguage("lcp", 6841.41, 0.935).addLanguage("lwl", 6841.41, 0.935);
        this.addRegion(RegionCode.TJ, 8468560.0, 0.997, 2.838E10).addLanguage("tg", 8468560.0, 0.997, "OFFICIAL").addLanguage("ru", 1016230.0, 0.997).addLanguage("fa", 66054.8, 0.997).addLanguage("ar", 1016.23, 0.997);
        this.addRegion(RegionCode.TK, 1285.0, 0.94, 1500000.0).addLanguage("en", 1285.0, 0.94, "OFFICIAL").addLanguage("tkl", 1285.0, 0.05, "OFFICIAL");
        this.addRegion(RegionCode.TL, 1291360.0, 0.583, 6.753E9).addLanguage("pt", 761902.0, 0.583, "OFFICIAL").addLanguage("tet", 761902.0, 0.583, "OFFICIAL");
        this.addRegion(RegionCode.TM, 5351280.0, 0.996, 1.035E11).addLanguage("tk", 3745900.0, 0.996, "OFFICIAL").addLanguage("ru", 642154.0, 0.996).addLanguage("uz", 481615.0, 0.996).addLanguage("ku", 21940.2, 0.996);
        this.addRegion(RegionCode.TN, 1.14038E7, 0.791, 1.354E11).addLanguage("aeb", 1.02634E7, 0.791).addLanguage("ar", 1.02634E7, 0.791, "OFFICIAL").addLanguage("fr", 8438810.0, 0.791, "OFFICIAL");
        this.addRegion(RegionCode.TO, 106479.0, 0.99, 5.87E8).addLanguage("to", 101155.0, 0.99, "OFFICIAL").addLanguage("en", 29814.1, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.TR, 8.08452E7, 0.941, 2.173E12).addLanguage("tr", 7.5186E7, 0.941, "OFFICIAL").addLanguage("en", 1.37437E7, 0.941).addLanguage("ku", 4446490.0, 0.941).addLanguage("zza", 1131830.0, 0.941).addLanguage("kbd", 622508.0, 0.941).addLanguage("az", 598254.0, 0.941).addLanguage("az_Arab", 525494.0, 0.941).addLanguage("ar", 452733.0, 0.941).addLanguage("bgx", 371888.0, 0.941).addLanguage("bg", 339550.0, 0.941).addLanguage("ady", 315296.0, 0.941).addLanguage("kiu", 153606.0, 0.941).addLanguage("hy", 45273.3, 0.941).addLanguage("ka", 45273.3, 0.941).addLanguage("sr_Latn", 22636.7, 0.05).addLanguage("lzz", 22636.7, 0.941).addLanguage("sq", 16977.5, 0.941).addLanguage("ab", 3961.41, 0.941).addLanguage("el", 3961.41, 0.941).addLanguage("tru", 2991.27, 0.941).addLanguage("uz", 1940.28, 0.941).addLanguage("ky_Latn", 1131.83, 0.941).addLanguage("kk", 565.916, 0.941);
        this.addRegion(RegionCode.TT, 1218210.0, 0.988, 4.301E10).addLanguage("en", 1072020.0, 0.988, "OFFICIAL").addLanguage("es", 4141.91, 0.988);
        this.addRegion(RegionCode.TV, 11052.0, 0.95, 4.2E7).addLanguage("tvl", 9946.8, 0.95, "OFFICIAL").addLanguage("en", 1072.04, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.TW, 2.35084E7, 0.961, 1.185E12).addLanguage("zh_Hant", 2.2333E7, 0.961, "OFFICIAL").addLanguage("trv", 4701.68, 0.961);
        this.addRegion(RegionCode.TZ, 5.39509E7, 0.678, 1.622E11).addLanguage("sw", 4.85558E7, 0.678, "OFFICIAL").addLanguage("en", 3.72261E7, 0.678, "OFFICIAL").addLanguage("suk", 4693730.0, 0.678).addLanguage("nym", 1780380.0, 0.678).addLanguage("kde", 1294820.0, 0.678).addLanguage("bez", 917165.0, 0.678).addLanguage("ksb", 917165.0, 0.678).addLanguage("mas", 809264.0, 0.678).addLanguage("mgy", 755313.0, 0.678).addLanguage("asa", 647411.0, 0.678).addLanguage("lag", 469373.0, 0.678).addLanguage("jmc", 404632.0, 0.678).addLanguage("rof", 404632.0, 0.678).addLanguage("vun", 404632.0, 0.678).addLanguage("rwk", 118692.0, 0.678).addLanguage("sbp", 107902.0, 0.678);
        this.addRegion(RegionCode.UA, 4.40339E7, 0.997, 3.688E11).addLanguage("uk", 2.8622E7, 0.997, "OFFICIAL").addLanguage("ru", 2.02556E7, 0.997, "DE_FACTO_OFFICIAL").addLanguage("pl", 1056810.0, 0.997).addLanguage("yi", 572441.0, 0.997).addLanguage("rue", 528407.0, 0.997).addLanguage("be", 365481.0, 0.997).addLanguage("crh", 246590.0, 0.997).addLanguage("ro", 228976.0, 0.997).addLanguage("bg", 215766.0, 0.997).addLanguage("tr", 184942.0, 0.997).addLanguage("hu", 162925.0, 0.997).addLanguage("el", 7045.42, 0.997);
        this.addRegion(RegionCode.UG, 3.95701E7, 0.732, 8.867E10).addLanguage("sw", 2.96776E7, 0.732, "OFFICIAL").addLanguage("lg", 5144110.0, 0.732).addLanguage("nyn", 2492920.0, 0.732).addLanguage("cgg", 2136790.0, 0.732).addLanguage("xog", 2097220.0, 0.732).addLanguage("en", 1543230.0, 0.732, "OFFICIAL").addLanguage("teo", 1543230.0, 0.732).addLanguage("laj", 1503660.0, 0.732).addLanguage("ach", 1464090.0, 0.732).addLanguage("myx", 1147530.0, 0.732).addLanguage("rw", 830972.0, 0.732).addLanguage("ttj", 751832.0, 0.732).addLanguage("hi", 2215.93, 0.732);
        this.addRegion(RegionCode.UM, 316.0, 0.99, 1.876E7).addLanguage("en", 316.0, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.US, 3.26626E8, 0.99, 1.939E13).addLanguage("en", 3.13561E8, 0.99, "DE_FACTO_OFFICIAL").addLanguage("es", 3.13561E7, 0.99, "OFFICIAL_REGIONAL").addLanguage("zh_Hant", 2253720.0, 0.99).addLanguage("fr", 1829110.0, 0.99).addLanguage("de", 1535140.0, 0.99).addLanguage("fil", 1371830.0, 0.99).addLanguage("it", 1110530.0, 0.99).addLanguage("vi", 1110530.0, 0.99).addLanguage("ko", 979878.0, 0.99).addLanguage("ru", 783902.0, 0.99).addLanguage("nv", 166579.0, 0.99).addLanguage("yi", 160047.0, 0.99).addLanguage("pdc", 127384.0, 0.99).addLanguage("haw", 29069.7, 0.99, "OFFICIAL_REGIONAL").addLanguage("frc", 27763.2, 0.99).addLanguage("chr", 25150.2, 0.05).addLanguage("esu", 20250.8, 0.99).addLanguage("dak", 19270.9, 0.99).addLanguage("cho", 10778.7, 0.99).addLanguage("lkt", 8165.65, 0.99).addLanguage("ik", 7839.02, 0.05).addLanguage("mus", 3919.51, 0.99);
        this.addRegion(RegionCode.UY, 3360150.0, 0.981, 7.815E10).addLanguage("es", 2956930.0, 0.981, "OFFICIAL");
        this.addRegion(RegionCode.UZ, 2.97489E7, 0.994, 2.226E11).addLanguage("uz", 2.52866E7, 0.994, "OFFICIAL").addLanguage("uz_Cyrl", 4462340.0, 0.994, "OFFICIAL").addLanguage("ru", 4164850.0, 0.994).addLanguage("kaa", 475982.0, 0.994).addLanguage("tr", 226092.0, 0.994);
        this.addRegion(RegionCode.VA, 1000.0, 1.0, 3.719E7).addLanguage("it", 820.0, 1.0, "DE_FACTO_OFFICIAL").addLanguage("la", 820.0, 1.0);
        this.addRegion(RegionCode.VC, 102089.0, 0.96, 1.266E9).addLanguage("en", 98005.4, 0.96, "OFFICIAL");
        this.addRegion(RegionCode.VE, 3.1304E7, 0.955, 3.807E11).addLanguage("es", 2.56693E7, 0.955, "OFFICIAL");
        this.addRegion(RegionCode.VG, 35015.0, 0.978, 5.0E8).addLanguage("en", 34314.7, 0.978, "OFFICIAL");
        this.addRegion(RegionCode.VI, 107268.0, 0.99, 3.872E9).addLanguage("en", 80451.0, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.VN, 9.61602E7, 0.934, 6.474E11).addLanguage("vi", 8.26978E7, 0.934, "OFFICIAL").addLanguage("zh_Hant", 1057760.0, 0.934).addLanguage("cjm", 85582.6, 0.934);
        this.addRegion(RegionCode.VU, 282814.0, 0.832, 7.7E8).addLanguage("bi", 254533.0, 0.832, "OFFICIAL").addLanguage("en", 234736.0, 0.832, "OFFICIAL").addLanguage("fr", 141407.0, 0.832, "OFFICIAL");
        this.addRegion(RegionCode.WF, 15714.0, 0.5, 6.0E7).addLanguage("wls", 9428.4, 0.5).addLanguage("fr", 7542.72, 0.5, "OFFICIAL").addLanguage("fud", 4871.34, 0.5);
        this.addRegion(RegionCode.WS, 200108.0, 0.988, 1.134E9).addLanguage("sm", 200108.0, 0.988, "OFFICIAL").addLanguage("en", 4402.38, 0.988, "OFFICIAL");
        this.addRegion(RegionCode.XK, 1895250.0, 0.919, 1.963E10).addLanguage("sq", 1743630.0, 0.919, "OFFICIAL").addLanguage("aln", 1402480.0, 0.919).addLanguage("sr", 94762.5, 0.919, "OFFICIAL").addLanguage("sr_Latn", 94762.5, 0.919, "OFFICIAL");
        this.addRegion(RegionCode.YE, 2.80368E7, 0.653, 3.86E10).addLanguage("ar", 2.07472E7, 0.653, "OFFICIAL").addLanguage("en", 2523310.0, 0.653);
        this.addRegion(RegionCode.YT, 194000.0, 0.92, 9.536E8).addLanguage("swb", 170720.0, 0.92).addLanguage("fr", 110580.0, 0.92, "OFFICIAL").addLanguage("buc", 44620.0, 0.92).addLanguage("sw", 2716.0, 0.92);
        this.addRegion(RegionCode.ZA, 5.48416E7, 0.93, 7.656E11).addLanguage("en", 1.70009E7, 0.93, "OFFICIAL").addLanguage("zu", 1.3162E7, 0.93, "OFFICIAL_REGIONAL").addLanguage("xh", 9871490.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("af", 7129410.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("nso", 5155110.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("tn", 4497010.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("st", 4332490.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("ts", 2413030.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("ss", 1480720.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("ve", 1261360.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("hi", 1096830.0, 0.93).addLanguage("nr", 877466.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("sw", 987.149, 0.93);
        this.addRegion(RegionCode.ZM, 1.5972E7, 0.614, 6.889E10).addLanguage("bem", 4951320.0, 0.614).addLanguage("en", 2555520.0, 0.614, "OFFICIAL").addLanguage("ny", 2395800.0, 0.614).addLanguage("loz", 958320.0, 0.614);
        this.addRegion(RegionCode.ZW, 1.38051E7, 0.836, 3.396E10).addLanguage("sn", 1.11821E7, 0.836, "OFFICIAL").addLanguage("en", 5798140.0, 0.836, "OFFICIAL").addLanguage("nd", 1656610.0, 0.836, "OFFICIAL").addLanguage("mxc", 897332.0, 0.836).addLanguage("ndc", 842111.0, 0.836).addLanguage("kck", 731670.0, 0.836).addLanguage("ny", 262297.0, 0.836).addLanguage("ve", 88352.6, 0.836).addLanguage("tn", 30371.2, 0.836);
    }

    private static class LanguageData {
        final long population;
        final float writing;
        final LanguageCode.OfficialStatus officialStatus;

        LanguageData(double population, double writing) {
            this.population = (long)population;
            this.writing = (float)writing;
            this.officialStatus = null;
        }

        LanguageData(double population, double writing, String officialStatus) {
            this.population = (long)population;
            this.writing = (float)writing;
            this.officialStatus = LanguageCode.OfficialStatus.valueOf(officialStatus);
        }

        public String toString() {
            long l = this.population;
            float f = this.writing;
            String string = this.hasOfficialStatus() ? this.officialStatus.toShortName() : "";
            return new StringBuilder(37 + String.valueOf(string).length()).append(l).append(",").append(f).append(",").append(string).toString();
        }

        boolean hasOfficialStatus() {
            return this.officialStatus != null;
        }
    }

    @VisibleForTesting
    static class TerritoryData {
        final long population;
        final float literacy;
        final long gdp;
        Map<LanguageCode, LanguageData> languageData;

        TerritoryData(double population, double literacy, double gdp) {
            this.population = (long)population;
            this.literacy = (float)literacy;
            this.gdp = (long)gdp;
            this.languageData = new LinkedHashMap<LanguageCode, LanguageData>();
        }

        TerritoryData addLanguage(String languageSubtag, double languagePopulation, double writingPopulation) {
            this.languageData.put(LanguageCode.forString(languageSubtag), new LanguageData(languagePopulation, writingPopulation));
            return this;
        }

        TerritoryData addLanguage(String languageSubtag, double languagePopulation, double writingPopulation, String officialStatus) {
            this.languageData.put(LanguageCode.forString(languageSubtag), new LanguageData(languagePopulation, writingPopulation, officialStatus));
            return this;
        }

        void freeze() {
            this.languageData = ImmutableMap.copyOf(this.languageData);
        }

        public String toString() {
            long l = this.population;
            long l2 = this.gdp;
            float f = this.literacy;
            String string = String.valueOf(this.languageData);
            return new StringBuilder(58 + String.valueOf(string).length()).append(l).append(",").append(l2).append(",").append(f).append(",").append(string).toString();
        }
    }

    private static class Dag<N> {
        private final SetMultimap<N, N> edges;
        private final SetMultimap<N, N> inverseEdges;
        private final SetMultimap<N, N> connections;
        private final SetMultimap<N, N> inverseConnections;

        private Dag(Multimap<N, N> edges) {
            HashBiMultimap copy = BiMultimaps.newHashBiMultimap();
            copy.putAll(edges);
            this.edges = Multimaps.unmodifiableSetMultimap(copy);
            this.inverseEdges = Multimaps.unmodifiableSetMultimap(copy.inverse());
            SetMultimap closure = new Traverser().computeClosure();
            this.connections = Multimaps.unmodifiableSetMultimap(closure);
            this.inverseConnections = Multimaps.unmodifiableSetMultimap(Multimaps.invertFrom(this.connections, HashMultimap.create()));
        }

        public boolean hasPath(N from, N to) {
            return this.connections.containsEntry(from, to);
        }

        public Set<N> getNodesWithEdgeFrom(N node) {
            return this.edges.get((Object)node);
        }

        public Set<N> getNodesWithEdgeTo(N node) {
            return this.inverseEdges.get((Object)node);
        }

        public Set<N> getNodesWithPathFrom(N node) {
            return this.connections.get((Object)node);
        }

        public Set<N> getNodesWithPathTo(N node) {
            return this.inverseConnections.get((Object)node);
        }

        private static <N> Set<N> minus(Set<N> set, Collection<N> collection) {
            HashSet<N> result = Sets.newHashSet(set);
            result.removeAll(collection);
            return result;
        }

        private class Traverser {
            private final SetMultimap<N, N> collector = HashMultimap.create();
            private final Set<N> upline = Sets.newHashSet();

            private Traverser() {
            }

            private SetMultimap<N, N> computeClosure() {
                Set sources = Dag.minus(Dag.this.edges.keySet(), Dag.this.edges.values());
                for (Object source : sources) {
                    this.recurse(source);
                }
                return this.collector;
            }

            private void recurse(N node) {
                for (Object ancestor : this.upline) {
                    if (ancestor.equals(node)) {
                        throw new IllegalArgumentException("cycle found");
                    }
                    this.collector.put(ancestor, node);
                }
                this.upline.add(node);
                for (Object child : Dag.this.edges.get(node)) {
                    this.recurse(child);
                }
                this.upline.remove(node);
            }
        }
    }
}

