/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class DebuggingObjectOutputStream
extends ObjectOutputStream {
    private static final Field DEPTH_FIELD;
    List<Object> stack = new ArrayList<Object>();
    boolean broken = false;

    public DebuggingObjectOutputStream(OutputStream out) throws IOException {
        super(out);
        this.enableReplaceObject(true);
    }

    @Override
    protected Object replaceObject(Object o) {
        int currentDepth = this.currentDepth();
        if (o instanceof IOException && currentDepth == 0) {
            this.broken = true;
        }
        if (!this.broken) {
            this.truncate(currentDepth);
            this.stack.add(o);
        }
        return o;
    }

    private void truncate(int depth) {
        while (this.stack.size() > depth) {
            this.pop();
        }
    }

    private Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private int currentDepth() {
        try {
            return (Integer)DEPTH_FIELD.get(this) - 1;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getStackString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append("[");
        for (Object o : this.stack) {
            if (!first) {
                builder.append(" => ");
            }
            builder.append(o.getClass().getName()).append(": \"").append(o).append("\"");
            first = false;
        }
        builder.append("]");
        return builder.toString();
    }

    public RuntimeException decorate(Throwable t) {
        String string = String.valueOf(this.getStackString());
        return new RuntimeException(string.length() != 0 ? "Error during serialization. Here's the path to the last object we tried to serialize: ".concat(string) : new String("Error during serialization. Here's the path to the last object we tried to serialize: "), t);
    }

    public List<Object> getStack() {
        return this.stack;
    }

    static {
        try {
            DEPTH_FIELD = ObjectOutputStream.class.getDeclaredField("depth");
            DEPTH_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

