/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;

public final class ServerAddress {
    public static final int NO_PORT = -1;
    public final String host;
    public final int port;
    private static final CharMatcher IPV6_CHARS = CharMatcher.anyOf(":.").or(CharMatcher.inRange('0', '9')).or(CharMatcher.inRange('a', 'f')).or(CharMatcher.inRange('A', 'F')).precomputed();
    private static final Splitter SPLIT_HOST_PAIRS = Splitter.on(',').trimResults(CharMatcher.inRange('\u0000', ' ')).omitEmptyStrings();

    public ServerAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ServerAddress(String spec) {
        HostAndPort hp = HostAndPort.fromString((String)spec);
        this.host = hp.getHost();
        if (this.host.isEmpty()) {
            String string = String.valueOf(spec);
            throw new IllegalArgumentException(string.length() != 0 ? "no hostname: ".concat(string) : new String("no hostname: "));
        }
        if (!hp.hasPort()) {
            String string = String.valueOf(spec);
            throw new IllegalArgumentException(string.length() != 0 ? "no port: ".concat(string) : new String("no port: "));
        }
        this.port = hp.getPort();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (other instanceof ServerAddress) {
            ServerAddress x = (ServerAddress)other;
            return x.port == this.port && x.host.equals(this.host);
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode() + this.port;
    }

    public String toString() {
        boolean needsBrackets = ServerAddress.looksLikeIpv6Address(this.host);
        if (this.port == -1) {
            if (needsBrackets) {
                String string = this.host;
                return new StringBuilder(2 + String.valueOf(string).length()).append('[').append(string).append(']').toString();
            }
            return this.host;
        }
        StringBuilder builder = new StringBuilder(this.host.length() + 8);
        if (needsBrackets) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        return builder.append(':').append(this.port).toString();
    }

    private static boolean looksLikeIpv6Address(String host) {
        int colons = 0;
        for (int i = 0; i < host.length(); ++i) {
            char c = host.charAt(i);
            if (c == ':') {
                ++colons;
                continue;
            }
            if (IPV6_CHARS.matches(c)) continue;
            return false;
        }
        return colons >= 2;
    }

    public static ServerAddress[] parseServerAddresses(String spec) {
        ImmutableList<String> hostPortPairs = ImmutableList.copyOf(SPLIT_HOST_PAIRS.split(spec));
        ServerAddress[] servAddrs = new ServerAddress[hostPortPairs.size()];
        for (int i = 0; i < hostPortPairs.size(); ++i) {
            servAddrs[i] = new ServerAddress((String)hostPortPairs.get(i));
        }
        return servAddrs;
    }

    public static ServerAddress valueOf(String spec) {
        return new ServerAddress(spec);
    }
}

