/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base.shell;

import com.google.io.base.shell.Killable;
import com.google.io.base.shell.KillableObserver;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TimeoutKillableObserver
implements KillableObserver {
    private static final Logger log = Logger.getLogger("com.google.io.base.shell.TimeoutKillableObserver");
    private final long timeoutMS;
    private Killable killable;
    private SleeperThread sleeperThread;
    private boolean timedOut;

    public TimeoutKillableObserver(long timeoutMS) {
        this.timeoutMS = timeoutMS;
    }

    @Override
    public synchronized void startObserving(Killable killable) {
        this.timedOut = false;
        this.killable = killable;
        this.sleeperThread = new SleeperThread();
        this.sleeperThread.start();
    }

    @Override
    public synchronized void stopObserving(Killable killable) {
        if (!this.killable.equals(killable)) {
            throw new IllegalStateException("start/stopObservering called with different Killables");
        }
        if (this.sleeperThread.isAlive()) {
            this.sleeperThread.interrupt();
        }
        this.killable = null;
        this.sleeperThread = null;
    }

    public synchronized boolean hasTimedOut() {
        return this.timedOut;
    }

    private final class SleeperThread
    extends Thread {
        private SleeperThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (log.isLoggable(Level.FINE)) {
                    long l = TimeoutKillableObserver.this.timeoutMS;
                    log.logp(Level.FINE, "com.google.io.base.shell.TimeoutKillableObserver$SleeperThread", "run", new StringBuilder(50).append("Waiting for ").append(l).append("ms to kill process").toString());
                }
                Thread.sleep(TimeoutKillableObserver.this.timeoutMS);
                TimeoutKillableObserver timeoutKillableObserver = TimeoutKillableObserver.this;
                synchronized (timeoutKillableObserver) {
                    if (TimeoutKillableObserver.this.killable != null) {
                        log.logp(Level.FINE, "com.google.io.base.shell.TimeoutKillableObserver$SleeperThread", "run", "Killing process");
                        TimeoutKillableObserver.this.killable.kill();
                        TimeoutKillableObserver.this.timedOut = true;
                    }
                }
            }
            catch (InterruptedException ie) {
                log.logp(Level.FINE, "com.google.io.base.shell.TimeoutKillableObserver$SleeperThread", "run", "Wait interrupted since process finished; continuing...");
            }
        }
    }
}

