/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.protocol;

import java.util.Arrays;

public final class GrowableProtocolSink {
    private byte[] buf;
    private int pos;

    public GrowableProtocolSink(byte[] array, int offset) {
        this.buf = array;
        this.pos = offset;
    }

    public GrowableProtocolSink(byte[] array) {
        this(array, 0);
    }

    public GrowableProtocolSink(int size) {
        this(new byte[size], 0);
    }

    public GrowableProtocolSink() {
        this(new byte[128], 0);
    }

    public final void reset() {
        this.pos = 0;
    }

    public final int position() {
        return this.pos;
    }

    public final void skip(int n) {
        if (n > 0 && this.buf.length - this.pos < n) {
            this.increaseCapacityBy(n);
        }
        this.pos += n;
    }

    public final byte[] array() {
        return this.buf;
    }

    public final byte[] toArray() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    private void increaseCapacityBy(int needed) {
        int size = Math.max(this.pos + needed, 64);
        size = Integer.highestOneBit(size) * 2;
        byte[] newbuf = new byte[size];
        System.arraycopy(this.buf, 0, newbuf, 0, this.pos);
        this.buf = newbuf;
    }

    public final void putBytes(byte[] src, int offset, int length) {
        if (this.buf.length - this.pos < length) {
            this.increaseCapacityBy(length);
        }
        System.arraycopy(src, offset, this.buf, this.pos, length);
        this.pos += length;
    }

    public final void putBytes(byte[] src) {
        this.putBytes(src, 0, src.length);
    }

    public final void putByte(byte v) {
        if (this.buf.length - this.pos < 1) {
            this.increaseCapacityBy(1);
        }
        this.buf[this.pos++] = v;
    }

    public final void putShort(short v) {
        if (this.buf.length - this.pos < 2) {
            this.increaseCapacityBy(2);
        }
        this.buf[this.pos++] = (byte)v;
        this.buf[this.pos++] = (byte)(v >> 8);
    }

    public final void putInt(int v) {
        if (this.buf.length - this.pos < 4) {
            this.increaseCapacityBy(4);
        }
        this.buf[this.pos++] = (byte)v;
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)(v >> 16);
        this.buf[this.pos++] = (byte)(v >> 24);
    }

    public final void putLong(long v) {
        if (this.buf.length - this.pos < 8) {
            this.increaseCapacityBy(8);
        }
        this.buf[this.pos++] = (byte)v;
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)(v >> 16);
        this.buf[this.pos++] = (byte)(v >> 24);
        this.buf[this.pos++] = (byte)(v >> 32);
        this.buf[this.pos++] = (byte)(v >> 40);
        this.buf[this.pos++] = (byte)(v >> 48);
        this.buf[this.pos++] = (byte)(v >> 56);
    }

    public final void putVarInt(int v) {
        if (this.buf.length - this.pos < 5) {
            this.increaseCapacityBy(5);
        }
        while (true) {
            int bits = v & 0x7F;
            if ((v >>>= 7) == 0) {
                this.putByte((byte)bits);
                return;
            }
            this.putByte((byte)(bits | 0x80));
        }
    }

    public final void putVarLong(long v) {
        if (this.buf.length - this.pos < 10) {
            this.increaseCapacityBy(10);
        }
        while (true) {
            int bits = (int)v & 0x7F;
            if ((v >>>= 7) == 0L) {
                this.putByte((byte)bits);
                return;
            }
            this.putByte((byte)(bits | 0x80));
        }
    }

    public final void putBoolean(boolean v) {
        if (this.buf.length - this.pos < 1) {
            this.increaseCapacityBy(1);
        }
        if (v) {
            this.putByte((byte)1);
        } else {
            this.putByte((byte)0);
        }
    }

    public final void putFloat(float v) {
        this.putInt(Float.floatToIntBits(v));
    }

    public final void putDouble(double v) {
        this.putLong(Double.doubleToLongBits(v));
    }

    public final void putPrefixedData(byte[] v) {
        if (this.buf.length - this.pos < 5 + v.length) {
            this.increaseCapacityBy(5 + v.length);
        }
        this.putVarInt(v.length);
        this.putBytes(v, 0, v.length);
    }
}

