/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.protocol;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Bytes;
import com.google.io.protocol.ExtendableProtocolMessage;
import com.google.io.protocol.GrowableProtocolSink;
import com.google.io.protocol.MessageVisitor;
import com.google.io.protocol.Protocol;
import com.google.io.protocol.ProtocolMessage;
import com.google.io.protocol.ProtocolSink;
import com.google.io.protocol.ProtocolSource;
import com.google.io.protocol.ProtocolSupport;
import com.google.io.protocol.ProtocolType;
import com.google.io.protocol.RawMessage;
import com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Extension;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class MessageSet
extends ProtocolMessage<MessageSet> {
    private static final byte TAG_BEGIN_ITEM_GROUP = 11;
    private static final byte TAG_END_ITEM_GROUP = 12;
    private static final byte TAG_TYPE_ID = 16;
    private static final byte TAG_MESSAGE = 26;
    private final Map<Integer, Item> items;
    private static final Logger LOG = Logger.getLogger(MessageSet.class.getName());
    public static final MessageSet IMMUTABLE_DEFAULT_INSTANCE = new MessageSet(ImmutableMap.of());
    private static Optional<ProtocolMessage.FieldAccessorTable> cachedFieldAccessorTable;
    private static ProtocolType cachedClassProtocolType;
    private static final ConcurrentMap<Class<?>, TypedIdInfo> classToTypedIdHash;
    private static final ConcurrentMap<String, TypedIdInfo> nameToTypedIdHash;
    private static final ConcurrentMap<Integer, TypedIdInfo> typeIdToInfoHash;
    private static final TypedIdInfo TYPED_ID_ERROR;
    private static boolean allowDuplicates;
    public static final int NO_TYPE_ID = 0;

    @Override
    public MessageSet getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public static MessageSet getDefaultInstance() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public MessageSet() {
        this.items = new TreeMap<Integer, Item>();
    }

    private MessageSet(Map<Integer, Item> items) {
        this.items = items;
    }

    @Nullable
    private byte[] get(int typeId) {
        Item item = this.items.get(typeId);
        if (item == null) {
            return null;
        }
        return item.toByteArray();
    }

    public <T extends ProtocolMessage> T get(Class<T> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        Item item = this.items.get(typeId);
        if (item == null) {
            return ProtocolSupport.newInstance(messageClass);
        }
        Class<T> upgraded = item.parseAs(messageClass);
        return (T)(upgraded != null ? upgraded : ProtocolSupport.newInstance(messageClass));
    }

    public MessageLite get(int typeId, MessageLite prototype) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        Item item = this.items.get(typeId);
        if (item == null) {
            return prototype.getDefaultInstanceForType();
        }
        MessageLite upgraded = item.parseAs(prototype);
        return upgraded != null ? upgraded : prototype.getDefaultInstanceForType();
    }

    public <T extends ProtocolMessage> T mutable(Class<T> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        Item item = this.items.get(typeId);
        Class<T> result = null;
        if (item != null) {
            result = item.parseAs(messageClass);
        }
        if (result == null) {
            result = ProtocolSupport.newInstance(messageClass);
            item = Item.from(result);
            this.items.put(typeId, item);
        }
        return (T)result;
    }

    public MessageLite mutable(int typeId, ProtocolMessage prototype) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        Item item = this.items.get(typeId);
        ProtocolMessage result = null;
        if (item != null) {
            result = item.parseAs(prototype);
        }
        if (result == null) {
            result = prototype.newInstance();
            item = Item.from((MessageLite)result);
            this.items.put(typeId, item);
        }
        return result;
    }

    public <T extends ProtocolMessage> MessageSet add(T message) {
        int typeId = MessageSet.getTypeId(MessageSet.findCanonicalProtocolMessageClass(message.getClass()));
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(message.getClass());
        }
        this.items.put(typeId, Item.from(message));
        return this;
    }

    public MessageSet add(int typeId, MessageLite message) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        this.items.put(typeId, Item.from(message));
        return this;
    }

    public boolean has(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            return false;
        }
        Item item = this.items.get(typeId);
        return item != null && item.parseAs(messageClass) != null;
    }

    public boolean has(int typeId, MessageLite prototype) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        Item item = this.items.get(typeId);
        return item != null && item.parseAs(prototype) != null;
    }

    public boolean hasUnparsed(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        return typeId != 0 && this.items.containsKey(typeId);
    }

    public boolean hasUnparsed(int typeId) {
        if (typeId == 0) {
            throw new IllegalArgumentException("Bad TypeId");
        }
        return this.items.containsKey(typeId);
    }

    public void remove(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        this.remove(typeId);
    }

    public void remove(int typeId) {
        this.items.remove(typeId);
    }

    public Set<Integer> getTypeIds() {
        return Collections.unmodifiableSet(this.items.keySet());
    }

    public int numMessages() {
        return this.items.size();
    }

    public final <Ex extends MessageLite> boolean hasExtension(Extension<MessageSet, Ex> extension) {
        return this.has(extension.getNumber(), extension.getMessageDefaultInstance());
    }

    public final <Ex extends MessageLite> Ex getExtension(Extension<MessageSet, Ex> extension) {
        return (Ex)this.get(extension.getNumber(), extension.getMessageDefaultInstance());
    }

    public final <Ex extends ProtocolMessage<Ex>> Ex getMutableExtension(Extension<MessageSet, Ex> extension) {
        return (Ex)((ProtocolMessage)this.mutable(extension.getNumber(), (ProtocolMessage)extension.getDefaultValue()));
    }

    public final <Ex extends MessageLite> MessageSet setExtension(Extension<MessageSet, Ex> extension, Ex message) {
        this.add(extension.getNumber(), message);
        return this;
    }

    public final <Ex extends MessageLite> MessageSet clearExtension(Extension<MessageSet, Ex> extension) {
        this.remove(extension.getNumber());
        return this;
    }

    @Override
    public MessageSet mergeFrom(MessageSet that) {
        Verify.verify(that != this);
        for (Map.Entry<Integer, Item> entry : that.items.entrySet()) {
            Item item = this.items.get(entry.getKey());
            if (item != null) {
                item.mergeFrom(entry.getValue());
                continue;
            }
            this.items.put(entry.getKey(), entry.getValue().copy());
        }
        return this;
    }

    @Override
    public boolean equals(MessageSet that, boolean ignoreUninterpreted) {
        if (this == that) {
            return true;
        }
        return this.items.equals(that.items);
    }

    @Override
    public boolean equalsIgnoreUninterpreted(MessageSet that) {
        return this.equals(that, true);
    }

    @Override
    public boolean equals(MessageSet that) {
        return this.equals(that, false);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof MessageSet && this.equals((MessageSet)that);
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("Do not use MessageSets as hash table keys.");
    }

    @Override
    public boolean isInitialized() {
        for (Item item : this.items.values()) {
            if (item.isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int encodingSize() {
        int size = this.items.size() * 4;
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            Item item = entry.getValue();
            int typeId = entry.getKey();
            int messageSize = item.encodingSize();
            size += Protocol.stringSize(messageSize) + Protocol.varIntSize(typeId);
        }
        return size;
    }

    @Override
    public int maxEncodingSize() {
        int size = this.items.size() * 14;
        for (Item item : this.items.values()) {
            size += item.maxEncodingSize();
        }
        return size;
    }

    @Override
    protected MessageSet internalClear() {
        this.items.clear();
        return this;
    }

    @Override
    public MessageSet newInstance() {
        return new MessageSet();
    }

    @Override
    public void outputTo(ProtocolSink sink) {
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            Item item = entry.getValue();
            Integer typeId = entry.getKey();
            sink.putByte((byte)11);
            sink.putByte((byte)16);
            sink.putVarInt(typeId);
            sink.putByte((byte)26);
            sink.putVarInt(item.encodingSize());
            item.output(sink);
            sink.putByte((byte)12);
        }
    }

    @Override
    public boolean merge(ProtocolSource source) {
        block4: while (source.remaining() > 0) {
            int tag = source.getVarInt();
            switch (tag) {
                case 0: {
                    return false;
                }
                case 11: {
                    Item item = new Item();
                    int typeId = Item.decode(source, item);
                    if (typeId == 0) {
                        return false;
                    }
                    Item oldItem = this.items.get(typeId);
                    if (oldItem == null) {
                        this.items.put(typeId, item);
                        continue block4;
                    }
                    oldItem.mergeFrom(item);
                    continue block4;
                }
            }
            source.skipData(tag);
        }
        return true;
    }

    @Override
    protected ProtocolMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        if (cachedFieldAccessorTable == null) {
            try {
                cachedFieldAccessorTable = Optional.of(new ProtocolMessage.FieldAccessorTable(Class.forName("com.google.protos.proto2.bridge.MessageSet"), new ProtocolType(MessageSet.class, null, new ProtocolType.FieldType[0]), "com.google.protos.proto2.bridge.MessageSetProtosInternalDescriptors", 0));
            }
            catch (ReflectiveOperationException e) {
                LOG.logp(Level.WARNING, "com.google.io.protocol.MessageSet", "internalGetFieldAccessorTable", "Failed to load proto2 descriptor for MessageSet", e);
                cachedFieldAccessorTable = Optional.absent();
            }
        }
        return cachedFieldAccessorTable.isPresent() ? cachedFieldAccessorTable.get() : super.internalGetFieldAccessorTable();
    }

    @Override
    public ProtocolType getProtocolType() {
        return MessageSet.getClassProtocolType();
    }

    private static synchronized ProtocolType getClassProtocolType() {
        if (cachedClassProtocolType == null) {
            String name = MessageSet.class.getName();
            String string = name.replace('.', '/');
            String fileName = new StringBuilder(10 + String.valueOf(string).length()).append("java/").append(string).append(".java").toString();
            final ProtocolDescriptor descriptor = new ProtocolDescriptor().setName(name).setProtoName("MessageSet").setFilename(fileName);
            cachedClassProtocolType = new ProtocolType(MessageSet.class, null, new ProtocolType.FieldType[0]){

                @Override
                protected void visitInternal(ProtocolMessage message, ProtocolType.Visitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    ((MessageSet)message).visit(visitor);
                }

                @Override
                protected void visitInternal(ProtocolMessage message, MessageVisitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    ((MessageSet)message).visit(visitor);
                }

                @Override
                public ProtocolDescriptor getProtocolDescriptor() {
                    return descriptor;
                }
            };
        }
        return cachedClassProtocolType;
    }

    private void visit(ProtocolType.Visitor visitor) {
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            int typeId = entry.getKey();
            Item item = entry.getValue();
            FieldType fieldType = item.getFieldType(typeId);
            if (!visitor.shouldVisitField(fieldType, 1)) continue;
            visitor.visitForeign(fieldType, 0, item.coerceToProtocol1ForVisitor());
        }
    }

    static void outputTo(GrowableProtocolSink sink, int typeId, GrowableProtocolSink typeValue) {
        sink.putByte((byte)11);
        sink.putByte((byte)16);
        sink.putVarInt(typeId);
        sink.putByte((byte)26);
        sink.putVarInt(typeValue.position());
        sink.putBytes(typeValue.array(), 0, typeValue.position());
        sink.putByte((byte)12);
    }

    public static Class<? extends ProtocolMessage> getRegisteredClazz(int typeId) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typeIdToInfoHash.get(typeId);
        return typedIdInfo != null && typedIdInfo.clazz != null ? (Class)typedIdInfo.clazz.get() : null;
    }

    public static Class<? extends ProtocolMessage> getRegisteredClazz(String typeName) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)nameToTypedIdHash.get(typeName);
        return typedIdInfo != null && typedIdInfo.clazz != null ? (Class)typedIdInfo.clazz.get() : null;
    }

    private static RuntimeException newNoTypeIdException(Class<? extends ProtocolMessage> cls) {
        String string = String.valueOf(cls.getName());
        return new RuntimeException(string.length() != 0 ? "MESSAGE_TYPE_ID not defined for class: ".concat(string) : new String("MESSAGE_TYPE_ID not defined for class: "));
    }

    private static Class<? extends ProtocolMessage> findCanonicalProtocolMessageClass(Class<? extends ProtocolMessage> clazz) {
        Class<? extends ProtocolMessage> next;
        while ((next = clazz.getSuperclass()) != ProtocolMessage.class && next != ExtendableProtocolMessage.class) {
            clazz = next;
        }
        return clazz;
    }

    public static int getTypeId(Class<? extends ProtocolMessage> clazz) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)classToTypedIdHash.get(clazz);
        if (typedIdInfo == null) {
            ProtocolSupport.newInstance(clazz);
            typedIdInfo = (TypedIdInfo)classToTypedIdHash.get(clazz);
            if (typedIdInfo == null) {
                LOG.logp(Level.WARNING, "com.google.io.protocol.MessageSet", "getTypeId", String.format("Class %s has no type id", clazz.getName()));
                typedIdInfo = new TypedIdInfo(clazz, null, 0);
                classToTypedIdHash.put(clazz, typedIdInfo);
            }
        }
        return typedIdInfo.typeId;
    }

    public static int getTypeIdForMessage(ProtocolMessage message) {
        return MessageSet.getTypeId(MessageSet.findCanonicalProtocolMessageClass(message.getClass()));
    }

    static void setAllowMessageSetNameAndTypeDuplicates(boolean value) {
        allowDuplicates = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTypeId(Class<? extends ProtocolMessage> clazz, int typeId, String name) {
        TypedIdInfo typedIdInfo = new TypedIdInfo(clazz, name, typeId);
        ConcurrentMap<Class<?>, TypedIdInfo> concurrentMap = classToTypedIdHash;
        synchronized (concurrentMap) {
            classToTypedIdHash.put(clazz, typedIdInfo);
            if (allowDuplicates) {
                nameToTypedIdHash.put(name, typedIdInfo);
                typeIdToInfoHash.put(typeId, typedIdInfo);
            } else {
                MessageSet.putOrReplace(nameToTypedIdHash, name, typedIdInfo, Level.WARNING, String.format("Class %s has an ambiguous external name", clazz.getName()));
                MessageSet.putOrReplace(typeIdToInfoHash, typeId, typedIdInfo, Level.SEVERE, String.format("Class %s has an ambiguous MESSAGE_TYPE_ID", clazz.getName()));
            }
        }
    }

    private static <K> void putOrReplace(ConcurrentMap<K, TypedIdInfo> map, K key, TypedIdInfo info, Level logLevel, String logErrorMessage) {
        TypedIdInfo oldInfo = map.putIfAbsent(key, info);
        if (oldInfo == null) {
            return;
        }
        if (info.canSafelyReplace(oldInfo)) {
            map.put(key, info);
            return;
        }
        LOG.logp(logLevel, "com.google.io.protocol.MessageSet", "putOrReplace", logErrorMessage);
        map.put(key, TYPED_ID_ERROR);
    }

    static Class<? extends ProtocolMessage> findClass(String name) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)nameToTypedIdHash.get(name);
        if (typedIdInfo == null) {
            return null;
        }
        if (typedIdInfo.clazz == null) {
            String string = String.valueOf(name);
            throw new RuntimeException(string.length() != 0 ? "Ambiguous name: ".concat(string) : new String("Ambiguous name: "));
        }
        return (Class)typedIdInfo.clazz.get();
    }

    @Override
    public MessageSet freeze() {
        for (Item item : this.items.values()) {
            item.freeze();
        }
        return this;
    }

    @Override
    public MessageSet unfreeze() {
        for (Item item : this.items.values()) {
            item.unfreeze();
        }
        return this;
    }

    @Override
    public boolean isFrozen() {
        for (Item item : this.items.values()) {
            if (!item.isFrozen()) continue;
            return true;
        }
        return false;
    }

    static {
        classToTypedIdHash = new MapMaker().weakKeys().makeMap();
        nameToTypedIdHash = new ConcurrentHashMap<String, TypedIdInfo>();
        typeIdToInfoHash = new ConcurrentHashMap<Integer, TypedIdInfo>();
        TYPED_ID_ERROR = new TypedIdInfo(null, null, 0);
        allowDuplicates = false;
    }

    private static class TypedIdInfo {
        final WeakReference<Class<? extends ProtocolMessage>> clazz;
        final String name;
        final int typeId;

        public TypedIdInfo(@Nullable Class<? extends ProtocolMessage> clazz, @Nullable String name, int typeId) {
            this.clazz = clazz == null ? null : new WeakReference<Class<? extends ProtocolMessage>>(clazz);
            this.name = name;
            this.typeId = typeId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypedIdInfo)) {
                return false;
            }
            TypedIdInfo info = (TypedIdInfo)obj;
            if (this.typeId != info.typeId) {
                return false;
            }
            if (this.clazz == null ^ info.clazz == null) {
                return false;
            }
            if (this.clazz != null && this.clazz.get() != info.clazz.get()) {
                return false;
            }
            return this.name != null && this.name.equals(info.name);
        }

        public int hashCode() {
            throw new RuntimeException("Do not use TypedIdInfo as hash table keys.");
        }

        boolean canSafelyReplace(TypedIdInfo oldInfo) {
            if (oldInfo.equals(this)) {
                return true;
            }
            Class oldMessageClass = oldInfo.clazz == null ? null : (Class)oldInfo.clazz.get();
            Class newMessageClass = this.clazz == null ? null : (Class)this.clazz.get();
            return oldMessageClass == null || newMessageClass != null && oldMessageClass.getCanonicalName().equals(newMessageClass.getCanonicalName());
        }
    }

    private static class Item
    implements Serializable {
        volatile Object message;

        Item() {
        }

        static Item from(ProtocolMessage message) {
            Preconditions.checkNotNull(message);
            Item result = new Item();
            result.message = message;
            return result;
        }

        static Item from(MessageLite message) {
            Preconditions.checkNotNull(message);
            Item result = new Item();
            result.message = message;
            return result;
        }

        byte[] toByteArray() {
            Object value = this.message;
            if (value instanceof MessageLite) {
                return ((MessageLite)value).toByteArray();
            }
            return (byte[])((byte[])value).clone();
        }

        void freeze() {
            Object value = this.message;
            if (value instanceof ProtocolMessage) {
                ((ProtocolMessage)value).freeze();
            }
        }

        void unfreeze() {
            Object value = this.message;
            if (value instanceof ProtocolMessage) {
                ((ProtocolMessage)value).unfreeze();
            }
        }

        boolean isFrozen() {
            Object value = this.message;
            return value instanceof ProtocolMessage && ((ProtocolMessage)value).isFrozen();
        }

        FieldType getFieldType(int typeId) {
            Class<? extends ProtocolMessage> converted;
            Class<? extends ProtocolMessage> clazz;
            Class<? extends ProtocolMessage> value = this.message;
            if (!(value instanceof ProtocolMessage) && (clazz = MessageSet.getRegisteredClazz(typeId)) != null && (converted = Item.parseAs(clazz, (Object)value)) != null) {
                value = converted;
                this.message = converted;
            }
            if (value instanceof ProtocolMessage) {
                return new FieldType(MessageSet.findCanonicalProtocolMessageClass(((ProtocolMessage)((Object)value)).getClass()), typeId);
            }
            return new FieldType(typeId);
        }

        <T extends ProtocolMessage<?>> T parseAs(Class<T> newMessageClass) {
            Class<T> converted = Item.parseAs(newMessageClass, this.message);
            if (converted != null) {
                this.message = converted;
            }
            return (T)converted;
        }

        <T extends MessageLite> T parseAs(T prototype) {
            T converted = Item.parseAs(prototype, this.message);
            if (converted != null) {
                this.message = converted;
            }
            return converted;
        }

        static <T extends ProtocolMessage<?>> T parseAs(Class<T> newMessageClass, Object value) {
            if (value instanceof ProtocolMessage && newMessageClass.isInstance(value)) {
                return (T)((ProtocolMessage)value);
            }
            T prototype = ProtocolSupport.newInstance(newMessageClass);
            return (T)((ProtocolMessage)Item.convertByteArrayAs(prototype, Item.valueToByteArray(value)));
        }

        static <T extends MessageLite> T parseAs(T prototype, Object value) {
            MessageLite messageDefaultInstance;
            MessageLite protoDefaultInstance;
            if (value instanceof MessageLite && (protoDefaultInstance = prototype.getDefaultInstanceForType()) == (messageDefaultInstance = ((MessageLite)value).getDefaultInstanceForType())) {
                return (T)((MessageLite)value);
            }
            return Item.convertByteArrayAs(prototype, Item.valueToByteArray(value));
        }

        private static byte[] valueToByteArray(Object value) {
            if (value instanceof MessageLite) {
                return ((MessageLite)value).toByteArray();
            }
            return (byte[])value;
        }

        static <T extends MessageLite> T convertByteArrayAs(T prototype, byte[] data) {
            try {
                return (T)prototype.getParserForType().parsePartialFrom(data);
            }
            catch (InvalidProtocolBufferException e) {
                String string = String.valueOf(prototype.getClass().getName());
                LOG.logp(Level.WARNING, "com.google.io.protocol.MessageSet$Item", "convertByteArrayAs", string.length() != 0 ? "Parse error in message inside MessageSet.  Tried to parse as: ".concat(string) : new String("Parse error in message inside MessageSet.  Tried to parse as: "));
                return null;
            }
        }

        void mergeFrom(Item that) {
            Object thisValue = this.message;
            Object thatValue = that.message;
            if (thisValue instanceof ProtocolMessage) {
                ProtocolMessage converted = Item.parseAs((ProtocolMessage)thisValue, thatValue);
                if (converted != null) {
                    this.message = ((ProtocolMessage)thisValue).mergeFrom(converted);
                }
            } else if (thisValue instanceof Message) {
                Message converted = Item.parseAs((Message)thisValue, thatValue);
                if (converted != null) {
                    this.message = ((Message)thisValue).toBuilder().mergeFrom(converted).buildPartial();
                }
            } else if (thatValue instanceof ProtocolMessage) {
                ProtocolMessage converted = Item.parseAs((ProtocolMessage)thatValue, thisValue);
                this.message = converted != null ? converted.mergeFrom((ProtocolMessage)thatValue) : ((ProtocolMessage)thatValue).clone();
            } else if (thatValue instanceof Message) {
                Message converted = Item.parseAs((Message)thatValue, thisValue);
                this.message = converted != null ? converted.toBuilder().mergeFrom((Message)thatValue).buildPartial() : thatValue;
            } else {
                byte[] thisByteString = (byte[])thisValue;
                byte[] thatByteString = (byte[])thatValue;
                if (thatByteString.length > 0) {
                    this.message = Bytes.concat(thisByteString, thatByteString);
                }
            }
        }

        Item copy() {
            Object value = this.message;
            Item result = new Item();
            result.message = value instanceof ProtocolMessage ? ((ProtocolMessage)value).clone() : value;
            return result;
        }

        boolean equals(Item that) {
            Object thisValue = this.message;
            Object thatValue = that.message;
            if (thisValue instanceof MessageLite) {
                if (thatValue instanceof MessageLite) {
                    MessageLite thatDefaultInstance;
                    MessageLite thisDefaultInstance = ((MessageLite)thisValue).getDefaultInstanceForType();
                    if (thisDefaultInstance == (thatDefaultInstance = ((MessageLite)thatValue).getDefaultInstanceForType())) {
                        return thisValue.equals(thatValue);
                    }
                    return thisValue.equals(Item.parseAs((MessageLite)thisValue, (Object)Item.valueToByteArray(thatValue)));
                }
                return thisValue.equals(Item.parseAs((MessageLite)thisValue, thatValue));
            }
            if (thatValue instanceof MessageLite) {
                return thatValue.equals(Item.parseAs((MessageLite)thatValue, thisValue));
            }
            return Arrays.equals((byte[])thisValue, (byte[])thatValue);
        }

        public int hashCode() {
            throw new RuntimeException("Do not use MessageSets as hash table keys.");
        }

        public boolean equals(Object that) {
            return that instanceof Item && this.equals((Item)that);
        }

        boolean isInitialized() {
            Object value = this.message;
            return !(value instanceof MessageLite) || ((MessageLite)value).isInitialized();
        }

        int encodingSize() {
            Object value = this.message;
            return value instanceof MessageLite ? ((MessageLite)value).getSerializedSize() : ((byte[])value).length;
        }

        int maxEncodingSize() {
            Object value = this.message;
            if (value instanceof ProtocolMessage) {
                return ((ProtocolMessage)value).maxEncodingSize();
            }
            if (value instanceof Message) {
                return ((Message)value).getSerializedSize();
            }
            return ((byte[])value).length;
        }

        void output(ProtocolSink sink) {
            Object value = this.message;
            if (value instanceof ProtocolMessage) {
                ((ProtocolMessage)value).outputTo(sink);
            } else if (value instanceof Message) {
                Message proto2 = (Message)value;
                int encodingSize = proto2.getSerializedSize();
                CodedOutputStream cos = CodedOutputStream.newInstance(sink.array(), sink.position(), encodingSize);
                try {
                    proto2.writeTo(cos);
                }
                catch (IOException e) {
                    throw new IndexOutOfBoundsException();
                }
                sink.skip(encodingSize);
            } else {
                sink.putBytes((byte[])value);
            }
        }

        static int decode(ProtocolSource source, Item item) {
            byte[] rawBytes = null;
            int typeId = 0;
            block8: while (true) {
                int tag = source.getVarInt();
                switch (tag) {
                    case 0: {
                        return 0;
                    }
                    case 16: {
                        typeId = source.getVarInt();
                        continue block8;
                    }
                    case 26: {
                        int len = source.getVarInt();
                        rawBytes = new byte[len];
                        try {
                            source.getBytes(rawBytes, 0, len);
                            continue block8;
                        }
                        catch (IndexOutOfBoundsException e) {
                            return 0;
                        }
                    }
                    case 12: {
                        if (typeId != 0 && rawBytes != null) {
                            item.message = rawBytes;
                            return typeId;
                        }
                        return 0;
                    }
                }
                source.skipData(tag);
            }
        }

        public ProtocolMessage coerceToProtocol1ForVisitor() {
            Object value = this.message;
            if (value instanceof ProtocolMessage) {
                return (ProtocolMessage)value;
            }
            if (value instanceof Message) {
                RawMessage rawMessage = new RawMessage();
                rawMessage.mergeFrom(((Message)value).toByteArray());
                return rawMessage;
            }
            RawMessage rawMessage = new RawMessage();
            rawMessage.mergeFrom((byte[])value);
            return rawMessage;
        }
    }

    public static class FieldType
    extends ProtocolType.FieldType {
        public FieldType(Class<? extends ProtocolMessage> cls, int typeId) {
            super(FieldType.getFieldTypeClassName(cls), cls.getName(), typeId, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, cls);
        }

        public FieldType(int typeId) {
            super(String.valueOf(typeId), String.valueOf(typeId), typeId, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, RawMessage.class);
        }

        @Override
        public int size(ProtocolMessage message) {
            return ((MessageSet)message).items.containsKey(this.getTag()) ? 1 : 0;
        }

        @Override
        public void visit(ProtocolMessage message, ProtocolType.Visitor visitor) {
            MessageSet messageSet = (MessageSet)message;
            Item item = (Item)messageSet.items.get(this.getTag());
            if (!visitor.shouldVisitField(this, item == null ? 0 : 1)) {
                return;
            }
            if (item != null) {
                visitor.visitForeign(this, 0, item.coerceToProtocol1ForVisitor());
            }
        }

        @Override
        public Object getSingleValue(ProtocolMessage message) {
            return ((MessageSet)message).get(this.getTag());
        }

        private static String getFieldTypeClassName(Class<? extends ProtocolMessage> cls) {
            TypedIdInfo idInfo = (TypedIdInfo)classToTypedIdHash.get(cls);
            if (idInfo != null) {
                return idInfo.name;
            }
            return cls.getName();
        }
    }
}

