/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.rpc3;

import com.google.common.base.Preconditions;
import com.google.net.rpc3.RpcStatus;
import com.google.net.rpc3.impl.RpcStatusFactory;
import com.google.net.rpc3.impl.RpcStatusUtil;
import com.google.net.util.Status;
import com.google.net.util.error.Codes;
import java.io.IOException;

public class RpcException
extends IOException {
    private final Status status;

    public RpcException(Status status) {
        super(RpcStatusUtil.toString((Status)status));
        this.status = status;
    }

    public RpcException(Status status, String message) {
        super(message);
        this.status = Preconditions.checkNotNull(status);
    }

    public RpcException(int applicationError, String errorDetail) {
        this(RpcStatusFactory.createApplicationError((int)applicationError, (String)errorDetail), new StringBuilder(33 + String.valueOf(errorDetail).length()).append("Application error (").append(applicationError).append("): ").append(errorDetail).toString());
    }

    @Deprecated
    public RpcException(RpcStatus status, int applicationError, String errorDetail, String message) {
        super(message);
        this.status = RpcStatusFactory.fromLegacyStatusFull((RpcStatus)status, (String)errorDetail, (int)applicationError);
        Preconditions.checkArgument(!RpcStatusUtil.isActive((Status)this.status), "Cannot return ACTIVE from an RPC");
        Preconditions.checkArgument(!RpcStatusUtil.isOk((Status)this.status), "Cannot return OK from an RPC as an Exception");
    }

    @Deprecated
    public final RpcStatus getRpcStatus() {
        return RpcStatusUtil.toLegacyRpcStatus((Status)this.status);
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Codes.Code getCode() {
        return this.status.getCanonicalCode();
    }

    public final boolean isApplicationError() {
        return RpcStatusUtil.isApplicationError((Status)this.status);
    }

    public final int getApplicationError() {
        return RpcStatusUtil.getApplicationErrorCode((Status)this.status);
    }

    public final String getErrorDetail() {
        String detail = RpcStatusUtil.getLegacyErrorDetail((Status)this.status);
        if (detail != null && detail.length() != 0) {
            return detail;
        }
        return null;
    }

    @Deprecated
    public final int appErrorCode() {
        return this.getApplicationError();
    }

    @Deprecated
    public final String errorDetail() {
        return this.getErrorDetail();
    }
}

