/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AllocatedBuffer;
import com.google.protobuf.BinaryWriter;
import com.google.protobuf.BufferAllocator;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Protobuf;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ExperimentalRuntimeForTesting {
    public static void enableExperimentalRuntime() {
        AbstractMessageLite.useExperimentalRuntime();
    }

    public static boolean isExperimentalRuntimeEnabledAtBuildTime() {
        return true;
    }

    public static ByteBuffer encode(ByteBuffer output, MessageLite payload) throws IOException {
        BinaryWriter writer = BinaryWriter.newHeapInstance(new HeapBufferAllocator(output), output.remaining());
        int originalPos = output.position();
        int originalIndex = output.arrayOffset() + originalPos;
        Protobuf.getInstance().writeTo(payload, writer);
        writer.complete();
        byte[] arry = output.array();
        int dataStartIndex = output.arrayOffset() + output.position();
        int bytesWritten = output.remaining();
        System.arraycopy(arry, dataStartIndex, arry, originalIndex, output.remaining());
        output.position(originalPos + bytesWritten);
        return ByteBuffer.wrap(arry, originalIndex, bytesWritten);
    }

    public static Object schemaFor(Class<?> clazz) {
        return Protobuf.getInstance().schemaFor(clazz);
    }

    private static final class HeapBufferAllocator
    extends BufferAllocator {
        private final AllocatedBuffer buffer;

        private HeapBufferAllocator(ByteBuffer buffer) {
            this.buffer = AllocatedBuffer.wrap(buffer);
        }

        @Override
        public AllocatedBuffer allocateHeapBuffer(int capacity) {
            return this.buffer;
        }

        @Override
        public AllocatedBuffer allocateDirectBuffer(int capacity) {
            throw new UnsupportedOperationException();
        }
    }
}

