/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.bridge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.io.protocol.RawMessage;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcStreamingCallback;
import com.google.net.rpc.RpcStreamingListener;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc3.impl.compatibility.Rpc1CompatibilityStub;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.bridge.AbstractStubbyService;
import com.google.protobuf.bridge.DowngradedMessage;
import com.google.protobuf.bridge.StubbyRpcController;
import com.google.protobuf.bridge.StubbyServiceException;
import java.util.List;
import javax.annotation.Nullable;

public class StubbyChannel
extends Rpc1CompatibilityStub
implements RpcChannel,
BlockingRpcChannel {
    private static final RpcCallback<Message> NO_OP_CALLBACK = new RpcCallback<Message>(){

        @Override
        public void run(Message parameter) {
        }
    };
    private final RPC[] prototypeRpc;
    private final Descriptors.ServiceDescriptor serviceDescriptor;
    private final ExtensionRegistry extensionRegistry;

    public StubbyChannel(Descriptors.ServiceDescriptor descriptor, RpcStubParameters parameters) {
        this(descriptor, parameters, descriptor.getName());
    }

    public StubbyChannel(Descriptors.ServiceDescriptor descriptor, RpcStubParameters parameters, ExtensionRegistry registry) {
        this(descriptor, parameters, descriptor.getName(), registry);
    }

    public StubbyChannel(Descriptors.ServiceDescriptor serviceDescriptor, RpcStubParameters parameters, String serviceName) {
        this(serviceDescriptor, parameters, serviceName, ExtensionRegistry.getEmptyRegistry());
    }

    public StubbyChannel(Descriptors.ServiceDescriptor serviceDescriptor, RpcStubParameters parameters, String serviceName, ExtensionRegistry registry) {
        super(serviceName, parameters, null, registry);
        this.serviceDescriptor = serviceDescriptor;
        this.extensionRegistry = Preconditions.checkNotNull(registry);
        List<Descriptors.MethodDescriptor> methodDescriptors = serviceDescriptor.getMethods();
        this.prototypeRpc = new RPC[methodDescriptors.size()];
        for (Descriptors.MethodDescriptor methodDescriptor : methodDescriptors) {
            DescriptorProtos.MethodOptions options = methodDescriptor.getOptions();
            RPC rpc = new RPC();
            StubbyRpcController.applyMethodOptions(options, rpc);
            String string = methodDescriptor.getName();
            rpc.internalSetMethodName(new StringBuilder(2 + String.valueOf(serviceName).length() + String.valueOf(string).length()).append("/").append(serviceName).append(".").append(string).toString());
            this.prototypeRpc[methodDescriptor.getIndex()] = rpc;
        }
    }

    @Nullable
    @VisibleForTesting
    public RPC getRpcPrototype(String methodName) {
        Descriptors.MethodDescriptor methodDescriptor = this.serviceDescriptor.findMethodByName(methodName);
        if (methodDescriptor == null) {
            return null;
        }
        return this.prototypeRpc[methodDescriptor.getIndex()];
    }

    @Override
    public void callMethod(Descriptors.MethodDescriptor methodDescriptor, RpcController rpcController, Message request, Message responsePrototype, RpcCallback<Message> done) {
        try {
            this.callMethod(methodDescriptor, rpcController, request, responsePrototype, done, IsBlocking.NO);
        }
        catch (ServiceException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    @Override
    public Message callBlockingMethod(Descriptors.MethodDescriptor methodDescriptor, RpcController rpcController, Message request, Message responsePrototype) throws ServiceException {
        return this.callMethod(methodDescriptor, rpcController, request, responsePrototype, NO_OP_CALLBACK, IsBlocking.YES);
    }

    private Message callMethod(Descriptors.MethodDescriptor methodDescriptor, RpcController rpcController, Message request, Message responsePrototype, RpcCallback<Message> done, IsBlocking isBlocking) throws ServiceException {
        Message streamPrototype;
        if (methodDescriptor.getService() != this.serviceDescriptor) {
            throw new IllegalArgumentException("Method isn't part of service");
        }
        StubbyRpcController controller = (StubbyRpcController)rpcController;
        String streamType = AbstractStubbyService.getStreamType(methodDescriptor);
        if (streamType != null && (streamPrototype = controller.getStreamingPrototype()) != null && !streamPrototype.getDescriptorForType().getFullName().equals(streamType)) {
            throw new UnsupportedOperationException("Bad prototype in callback");
        }
        String methodName = methodDescriptor.getName();
        DowngradedMessage bridgedRequest = new DowngradedMessage(request, this.extensionRegistry);
        DowngradedMessage bridgedResponse = new DowngradedMessage(responsePrototype, this.extensionRegistry);
        RpcStreamingCallback<RawMessage> callback = this.newCallback(controller, bridgedResponse, done);
        RPC rpc = controller.getStubbyRpc();
        RPC proto = this.prototypeRpc[methodDescriptor.getIndex()];
        if (isBlocking == IsBlocking.YES) {
            try {
                if (streamType == null) {
                    this.startBlockingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, proto);
                } else {
                    this.startStreamingBlockingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, RawMessage.IMMUTABLE_DEFAULT_INSTANCE, (RpcStreamingListener)callback, proto);
                }
                return bridgedResponse.getProto2Message();
            }
            catch (RpcException cause) {
                throw new StubbyServiceException(cause);
            }
        }
        if (streamType == null) {
            this.startNonBlockingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, (com.google.net.rpc.RpcCallback)callback, proto);
        } else {
            this.startStreamingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, RawMessage.IMMUTABLE_DEFAULT_INSTANCE, callback, proto);
        }
        return null;
    }

    public static RpcStubFactory newFactory(final Descriptors.ServiceDescriptor descriptor) {
        return new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new StubbyChannel(descriptor, params);
            }
        };
    }

    private RpcStreamingCallback<RawMessage> newCallback(final StubbyRpcController controller, final DowngradedMessage bridgedResponse, final RpcCallback<Message> done) {
        return new RpcStreamingCallback<RawMessage>(){

            public void rpcFinished() {
                done.run(bridgedResponse.getProto2Message());
            }

            public void streamReady(RawMessage stream) {
                RPC rpc = controller.getStubbyRpc();
                Message streamPrototype = controller.getStreamingPrototype();
                if (streamPrototype != null && (rpc.status() == RPC.Status.OK || rpc.status() == RPC.Status.ACTIVE)) {
                    try {
                        Message message = null;
                        if (streamPrototype instanceof MutableMessage) {
                            ((MutableMessage)streamPrototype).newMessageForType().mergeFrom(stream.toByteArray(), (ExtensionRegistryLite)StubbyChannel.this.extensionRegistry);
                        } else {
                            Message.Builder builder = streamPrototype.newBuilderForType();
                            message = builder.mergeFrom(stream.toByteArray(), (ExtensionRegistryLite)StubbyChannel.this.extensionRegistry).build();
                        }
                        controller.streamReady(message);
                    }
                    catch (InvalidProtocolBufferException e) {
                        rpc.internalSetStatus(RPC.Status.SERVER_ERROR);
                        rpc.internalSetErrorDetail("client could not parse server reply");
                    }
                    catch (UninitializedMessageException e) {
                        rpc.internalSetStatus(RPC.Status.SERVER_ERROR);
                        rpc.internalSetErrorDetail("client could not parse server reply");
                    }
                }
            }
        };
    }

    private static enum IsBlocking {
        YES,
        NO;

    }
}

