/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageFactories;
import com.google.protobuf.MessageLite;
import com.google.protobuf.contrib.descriptor.pool.GeneratedDescriptorPool;
import javax.annotation.Nullable;

public final class AnyUtil {
    public static final String INTERNAL_TYPE_URL_PREFIX = "type.googleprod.com/";
    private static final GeneratedDescriptorPool DESCRIPTOR_POOL = GeneratedDescriptorPool.getInstance();

    public static Any parseAsAny(MessageLite message) throws InvalidProtocolBufferException {
        if (message instanceof Any) {
            Any any = (Any)message;
            return any;
        }
        return Any.parseFrom(message.toByteString());
    }

    public static Message unpack(Any any) throws InvalidProtocolBufferException {
        Optional<Message> prototype;
        try {
            prototype = AnyUtil.getMessagePrototype(any.getTypeUrl());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidProtocolBufferException(e.getMessage());
        }
        if (!prototype.isPresent()) {
            String string = String.valueOf(any.getTypeUrl());
            throw new InvalidProtocolBufferException(string.length() != 0 ? "No descriptor found for type: ".concat(string) : new String("No descriptor found for type: "));
        }
        return prototype.get().getParserForType().parseFrom(any.getValue(), (ExtensionRegistryLite)ExtensionRegistry.getGeneratedRegistry());
    }

    public static <T extends Message> T unpack(Any any, Class<T> clazz) throws InvalidProtocolBufferException {
        return (T)((Message)clazz.cast(AnyUtil.unpack(any)));
    }

    @Nullable
    public static Message getMessagePrototype(Any any) {
        try {
            return AnyUtil.getMessagePrototype(any.getTypeUrl()).orNull();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static Optional<Message> getMessagePrototype(String typeUrl) {
        String typeName = AnyUtil.getTypeNameFromTypeUrl(typeUrl);
        Descriptors.Descriptor typeDescriptor = DESCRIPTOR_POOL.getDescriptorForTypeName(typeName);
        if (typeDescriptor == null) {
            return Optional.absent();
        }
        Message immutableMessage = MessageFactories.getImmutableMessageFactory().getPrototype(typeDescriptor);
        if (immutableMessage != null) {
            return Optional.of(immutableMessage);
        }
        return Optional.fromNullable(MessageFactories.getMutableMessageFactory().getPrototype(typeDescriptor));
    }

    public static String getTypeNameFromTypeUrl(String typeUrl) {
        int pos = typeUrl.lastIndexOf(47);
        Preconditions.checkArgument(pos != -1, "malformed type URL: %s", (Object)typeUrl);
        return typeUrl.substring(pos + 1);
    }

    public static String getInternalTypeUrlFromDescriptor(Descriptors.Descriptor descriptor) {
        return AnyUtil.getInternalTypeUrlFromTypeName(descriptor.getFullName());
    }

    public static String getInternalTypeUrlFromTypeName(String internalTypeName) {
        String string = String.valueOf(INTERNAL_TYPE_URL_PREFIX);
        String string2 = String.valueOf(internalTypeName);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public static boolean isAny(Message message) {
        if (message instanceof Any) {
            return true;
        }
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        if (!descriptor.getFullName().equals("google.protobuf.Any")) {
            return false;
        }
        Descriptors.FieldDescriptor typeUrlField = descriptor.findFieldByNumber(1);
        Descriptors.FieldDescriptor valueField = descriptor.findFieldByNumber(2);
        return typeUrlField != null && typeUrlField.getType() == Descriptors.FieldDescriptor.Type.STRING && valueField != null && valueField.getType() == Descriptors.FieldDescriptor.Type.BYTES;
    }

    private AnyUtil() {
    }
}

