/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import java.util.Comparator;

public final class MessageComparators {
    public static final Comparator<Descriptors.EnumValueDescriptor> ENUM_NUMBER_COMPARATOR = new Comparator<Descriptors.EnumValueDescriptor>(){

        @Override
        public int compare(Descriptors.EnumValueDescriptor first, Descriptors.EnumValueDescriptor second) {
            int secondNumber;
            int firstNumber = first.getNumber();
            if (firstNumber < (secondNumber = second.getNumber())) {
                return -1;
            }
            if (firstNumber > secondNumber) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Descriptors.EnumValueDescriptor> ENUM_NAME_COMPARATOR = new Comparator<Descriptors.EnumValueDescriptor>(){

        @Override
        public int compare(Descriptors.EnumValueDescriptor first, Descriptors.EnumValueDescriptor second) {
            return first.getName().compareTo(second.getName());
        }
    };

    public static <T extends MessageOrBuilder> Comparator<T> newMessageComparator(Descriptors.Descriptor descriptor, int fieldNumber) {
        return MessageComparators.newMessageComparator(descriptor.findFieldByNumber(fieldNumber));
    }

    public static <T extends MessageOrBuilder> Comparator<T> newMessageComparator(final Descriptors.FieldDescriptor field) {
        Preconditions.checkNotNull(field, "Null field can not be used as a sort key.");
        Preconditions.checkArgument(field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE, String.format("Message field '%s' can not be used as a sort key.", field.getName()));
        Preconditions.checkArgument(!field.isRepeated(), String.format("Repeated field '%s' can not be used as a sort key.", field.getName()));
        return new Comparator<T>(){

            @Override
            public int compare(T first, T second) {
                Object firstField = this.getField(first);
                Object secondField = this.getField(second);
                Preconditions.checkArgument(firstField.getClass() == secondField.getClass(), "Fields to compare must be the same type, got: %s and %s.", firstField.getClass(), secondField.getClass());
                Preconditions.checkArgument(firstField instanceof Comparable, "Fields must be comparable, not %s.", firstField.getClass());
                Comparable firstCompare = (Comparable)firstField;
                Comparable secondCompare = (Comparable)secondField;
                return firstCompare.compareTo(secondCompare);
            }

            private Object getField(T message) {
                Preconditions.checkArgument(message.getDescriptorForType() == field.getContainingType(), "Message type %s does not match %s.", (Object)message.getDescriptorForType().getFullName(), (Object)field.getContainingType().getFullName());
                Object sortField = message.getField(field);
                Preconditions.checkNotNull(sortField, "Sort field cannot be null.");
                return sortField;
            }
        };
    }
}

