/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.contrib.AnyUtil;
import com.google.protobuf.contrib.AutoValue_MessageDifferencer_SpecificField;
import com.google.protobuf.contrib.AutoValue_MessageDifferencer_UnknownDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class MessageDifferencer {
    private static final ProtoMapKeyComparator PROTO_MAP_KEY_COMPARATOR = new ProtoMapKeyComparator();
    private final ImmutableSet<Descriptors.FieldDescriptor> setFields;
    private final IgnoreCriteria ignoreCriteria;
    private final ImmutableMap<Descriptors.FieldDescriptor, MapKeyComparator> mapKeyComparatorMap;
    private final MessageFieldComparison messageFieldComparison;
    private final Scope scope;
    private final FloatComparison floatComparison;
    private final RepeatedFieldComparison repeatedFieldComparison;
    private final boolean reportMatches;
    private final FieldComparator fieldComparator;
    private final boolean unpackAny;
    private static final Set<Descriptors.FieldDescriptor> SENTINEL = Collections.singleton(null);

    public static Builder newBuilder() {
        return new Builder();
    }

    private MessageDifferencer(Builder builder) {
        this.setFields = ImmutableSet.copyOf(builder.setFields);
        this.ignoreCriteria = builder.getMergedIgnoreCriteria();
        this.mapKeyComparatorMap = ImmutableMap.copyOf(builder.mapKeyComparatorMap);
        this.messageFieldComparison = builder.messageFieldComparison;
        this.scope = builder.scope;
        this.floatComparison = builder.floatComparison;
        this.repeatedFieldComparison = builder.repeatedFieldComparison;
        this.reportMatches = builder.reportMatches;
        this.fieldComparator = builder.fieldComparator == null ? new DefaultFieldComparator(this.floatComparison) : builder.fieldComparator;
        this.unpackAny = builder.unpackAny;
    }

    public static boolean equals(Message message1, Message message2) {
        return MessageDifferencer.newBuilder().build().compare(message1, message2);
    }

    public static boolean equivalent(Message message1, Message message2) {
        return MessageDifferencer.newBuilder().setMessageFieldComparison(MessageFieldComparison.EQUIVALENT).build().compare(message1, message2);
    }

    public static boolean approximatelyEquals(Message message1, Message message2) {
        return MessageDifferencer.newBuilder().setFloatComparison(FloatComparison.APPROXIMATE).build().compare(message1, message2);
    }

    public static boolean approximatelyEquivalent(Message message1, Message message2) {
        return MessageDifferencer.newBuilder().setMessageFieldComparison(MessageFieldComparison.EQUIVALENT).setFloatComparison(FloatComparison.APPROXIMATE).build().compare(message1, message2);
    }

    private static IgnoreCriteria ignoringFields(final ImmutableCollection<Descriptors.FieldDescriptor> fieldDescriptors) {
        return new IgnoreCriteria(){

            @Override
            public boolean isIgnored(Message message1, Message message2, Descriptors.FieldDescriptor fieldDescriptor, List<SpecificField> fieldPath) {
                return fieldDescriptors.contains(fieldDescriptor);
            }
        };
    }

    static IgnoreCriteria mergeCriteria(final Iterable<IgnoreCriteria> criteria) {
        return new IgnoreCriteria(){

            @Override
            public boolean isIgnored(Message message1, Message message2, Descriptors.FieldDescriptor fieldDescriptor, List<SpecificField> fieldPath) {
                for (IgnoreCriteria criterion : criteria) {
                    if (!criterion.isIgnored(message1, message2, fieldDescriptor, fieldPath)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public boolean compare(Message message1, Message message2) {
        return this.compare(message1, message2, null);
    }

    public boolean compare(Message message1, Message message2, @Nullable Reporter reporter) {
        ArrayList<SpecificField> stack = Lists.newArrayList();
        return this.compare(message1, message2, reporter, stack);
    }

    public boolean compareWithFields(Message message1, Message message2, Set<Descriptors.FieldDescriptor> message1Fields, Set<Descriptors.FieldDescriptor> message2Fields) {
        return this.compareWithFields(message1, message2, message1Fields, message2Fields, null);
    }

    public boolean compareWithFields(Message message1, Message message2, Set<Descriptors.FieldDescriptor> message1Fields, Set<Descriptors.FieldDescriptor> message2Fields, @Nullable Reporter reporter) {
        this.checkSameDescriptor(message1, message2);
        message1Fields = ImmutableSet.copyOf(Ordering.natural().sortedCopy(message1Fields));
        message2Fields = ImmutableSet.copyOf(Ordering.natural().sortedCopy(message2Fields));
        ArrayList<SpecificField> stack = Lists.newArrayList();
        return this.compareRequestedFields(message1, message2, message1Fields, message2Fields, reporter, stack);
    }

    private boolean compare(Message message1, Message message2, @Nullable Reporter reporter, List<SpecificField> stack) {
        Set<Descriptors.FieldDescriptor> message2Fields;
        Set<Descriptors.FieldDescriptor> message1Fields;
        this.checkSameDescriptor(message1, message2);
        if (!(message1 != message2 || reporter != null && this.reportMatches)) {
            return true;
        }
        boolean unknownCompareResult = true;
        if (!this.compareUnknownFields(message1, message2, reporter, stack)) {
            if (reporter == null) {
                return false;
            }
            unknownCompareResult = false;
        }
        if (this.unpackAny && AnyUtil.isAny(message1) && AnyUtil.isAny(message2)) {
            try {
                Any any1 = message1 instanceof Any ? (Any)message1 : Any.parseFrom(message1.toByteString());
                Any any2 = message2 instanceof Any ? (Any)message2 : Any.parseFrom(message2.toByteString());
                return this.compare(AnyUtil.unpack(any1), AnyUtil.unpack(any2), reporter, stack);
            }
            catch (InvalidProtocolBufferException any1) {
                // empty catch block
            }
        }
        return this.compareRequestedFields(message1, message2, message1Fields = message1.getAllFields().keySet(), message2Fields = message2.getAllFields().keySet(), reporter, stack) && unknownCompareResult;
    }

    private void checkSameDescriptor(Message message1, Message message2) {
        Preconditions.checkArgument(message1.getDescriptorForType().equals(message2.getDescriptorForType()), "Comparison between two messages with different descriptors: %s and %s", message1.getClass(), message2.getClass());
    }

    private boolean compareUnknownFields(Message message1, Message message2, @Nullable Reporter reporter, List<SpecificField> stack) {
        UnknownFieldSet unknownFieldSet1 = message1.getUnknownFields();
        UnknownFieldSet unknownFieldSet2 = message2.getUnknownFields();
        return this.compareUnknownFields(message1, message2, unknownFieldSet1, unknownFieldSet2, reporter, stack);
    }

    private boolean compareUnknownFields(Message message1, Message message2, UnknownFieldSet unknownFieldSet1, UnknownFieldSet unknownFieldSet2, @Nullable Reporter reporter, List<SpecificField> stack) {
        if (this.messageFieldComparison == MessageFieldComparison.EQUIVALENT) {
            return true;
        }
        boolean identical = unknownFieldSet1.equals(unknownFieldSet2);
        if (identical && (reporter == null || !this.reportMatches)) {
            return true;
        }
        Set<Integer> numbers1 = unknownFieldSet1.asMap().keySet();
        Set<Integer> numbers2 = unknownFieldSet2.asMap().keySet();
        if (numbers1.isEmpty() && numbers2.isEmpty()) {
            return true;
        }
        boolean match = true;
        for (Integer number : Sets.newTreeSet(Sets.union(numbers1, numbers2))) {
            for (UnknownFieldType fieldType : UnknownFieldType.values()) {
                List<?> values2;
                List<?> values1 = fieldType.getValues(unknownFieldSet1.getField(number));
                if (values1.equals(values2 = fieldType.getValues(unknownFieldSet2.getField(number))) || values1.isEmpty() && this.scope == Scope.PARTIAL) continue;
                UnknownDescriptor unknownDesc = UnknownDescriptor.create(number, fieldType);
                int count = Math.max(values1.size(), values2.size());
                for (int i = 0; i < count; ++i) {
                    Object value1 = i < values1.size() ? values1.get(i) : null;
                    Object value2 = i < values2.size() ? values2.get(i) : null;
                    ReportType reportType = ReportType.MATCHED;
                    SpecificField unknownField = SpecificField.forUnknownDescriptor(unknownDesc, i);
                    if (this.ignoreCriteria.isIgnored(message1, message2, null, MessageDifferencer.immutable(stack, unknownField))) {
                        if (reporter == null || !this.reportMatches) continue;
                        reportType = ReportType.IGNORED;
                    } else if (value1 == null) {
                        reportType = ReportType.ADDED;
                        match = false;
                    } else if (value2 == null) {
                        reportType = ReportType.DELETED;
                        match = false;
                    } else if (fieldType == UnknownFieldType.GROUP) {
                        stack.add(unknownField);
                        if (!this.compareUnknownFields(message1, message2, value1, value2, reporter, stack)) {
                            reportType = ReportType.MODIFIED;
                            match = false;
                        }
                        MessageDifferencer.pop(stack);
                    } else if (!Objects.equals(value1, value2)) {
                        reportType = ReportType.MODIFIED;
                        match = false;
                    }
                    if (reporter != null) {
                        if (reportType == ReportType.MATCHED && !this.reportMatches) continue;
                        reporter.report(reportType, message1, message2, MessageDifferencer.immutable(stack, unknownField));
                        continue;
                    }
                    if (match) continue;
                    return false;
                }
            }
        }
        return match;
    }

    private boolean compareRequestedFields(Message message1, Message message2, Set<Descriptors.FieldDescriptor> message1Fields, Set<Descriptors.FieldDescriptor> message2Fields, @Nullable Reporter reporter, List<SpecificField> stack) {
        if (this.scope == Scope.FULL) {
            if (this.messageFieldComparison == MessageFieldComparison.EQUIVALENT) {
                Sets.SetView<Descriptors.FieldDescriptor> fieldsUnion = Sets.union(message1Fields, message2Fields);
                return this.compareWithFieldsInternal(message1, message2, fieldsUnion, fieldsUnion, reporter, stack);
            }
            return this.compareWithFieldsInternal(message1, message2, message1Fields, message2Fields, reporter, stack);
        }
        if (this.messageFieldComparison == MessageFieldComparison.EQUIVALENT) {
            return this.compareWithFieldsInternal(message1, message2, message1Fields, message1Fields, reporter, stack);
        }
        Sets.SetView<Descriptors.FieldDescriptor> fieldsIntersection = Sets.intersection(message1Fields, message2Fields);
        return this.compareWithFieldsInternal(message1, message2, message1Fields, fieldsIntersection, reporter, stack);
    }

    private boolean compareWithFieldsInternal(Message message1, Message message2, Set<Descriptors.FieldDescriptor> message1Fields, Set<Descriptors.FieldDescriptor> message2Fields, @Nullable Reporter reporter, List<SpecificField> stack) {
        boolean isDifferent = false;
        Iterator<Descriptors.FieldDescriptor> it1 = Iterables.concat(message1Fields, SENTINEL).iterator();
        Iterator<Descriptors.FieldDescriptor> it2 = Iterables.concat(message2Fields, SENTINEL).iterator();
        Descriptors.FieldDescriptor field1 = it1.next();
        Descriptors.FieldDescriptor field2 = it2.next();
        while (field1 != null || field2 != null) {
            if (this.fieldBefore(field1, field2)) {
                if (this.ignoreCriteria.isIgnored(message1, message2, field1, Collections.unmodifiableList(stack))) {
                    if (reporter != null) {
                        this.report(ReportType.IGNORED, message1, message2, field1, message1, reporter, stack);
                    }
                    field1 = it1.next();
                    continue;
                }
                if (reporter == null) {
                    return false;
                }
                this.report(ReportType.DELETED, message1, message2, field1, message1, reporter, stack);
                isDifferent = true;
                field1 = it1.next();
                continue;
            }
            if (this.fieldBefore(field2, field1)) {
                if (this.ignoreCriteria.isIgnored(message1, message2, field2, Collections.unmodifiableList(stack))) {
                    if (reporter != null) {
                        this.report(ReportType.IGNORED, message1, message2, field2, message2, reporter, stack);
                    }
                    field2 = it2.next();
                    continue;
                }
                if (reporter == null) {
                    return false;
                }
                this.report(ReportType.ADDED, message1, message2, field2, message2, reporter, stack);
                isDifferent = true;
                field2 = it2.next();
                continue;
            }
            boolean fieldDifferent = false;
            if (this.ignoreCriteria.isIgnored(message1, message2, field1, Collections.unmodifiableList(stack))) {
                if (reporter != null) {
                    this.report(ReportType.IGNORED, message1, message2, field2, message2, reporter, stack);
                }
            } else if (field1.isRepeated()) {
                boolean bl = fieldDifferent = !this.compareRepeatedField(message1, message2, field1, reporter, stack);
                if (fieldDifferent) {
                    if (reporter == null) {
                        return false;
                    }
                    isDifferent = true;
                }
            } else {
                SpecificField specificField = SpecificField.forField(field1);
                boolean bl = fieldDifferent = !this.compareFieldValueUsingParentFields(message1, message2, field1, -1, -1, reporter, stack);
                if (fieldDifferent) {
                    if (reporter == null) {
                        return false;
                    }
                    reporter.report(ReportType.MODIFIED, message1, message2, MessageDifferencer.immutable(stack, specificField));
                    isDifferent = true;
                } else if (this.reportMatches && reporter != null) {
                    reporter.report(ReportType.MATCHED, message1, message2, MessageDifferencer.immutable(stack, specificField));
                }
            }
            field1 = it1.next();
            field2 = it2.next();
        }
        return !isDifferent;
    }

    boolean compareFieldValueUsingParentFields(Message message1, Message message2, Descriptors.FieldDescriptor field, int index1, int index2, @Nullable Reporter reporter, List<SpecificField> stack) {
        FieldComparator.ComparisonResult result = this.fieldComparator.compare(message1, message2, field, index1, index2, ImmutableList.copyOf(stack));
        if (result == FieldComparator.ComparisonResult.RECURSE) {
            Preconditions.checkArgument(field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE, "FieldComparator should not return RECURSE for fields not being submessages!");
            Message nextMessage1 = field.isRepeated() ? (Message)message1.getRepeatedField(field, index1) : (Message)message1.getField(field);
            Message nextMessage2 = field.isRepeated() ? (Message)message2.getRepeatedField(field, index2) : (Message)message2.getField(field);
            stack.add(field.isRepeated() ? SpecificField.forRepeatedField(field, index1, index2) : SpecificField.forField(field));
            boolean isSame = this.compare(nextMessage1, nextMessage2, reporter, stack);
            MessageDifferencer.pop(stack);
            return isSame;
        }
        return result == FieldComparator.ComparisonResult.SAME;
    }

    private void report(ReportType reportType, Message message1, Message message2, Descriptors.FieldDescriptor field, Message first, Reporter reporter, List<SpecificField> stack) {
        if (field.isRepeated()) {
            int count = first.getRepeatedFieldCount(field);
            for (int i = 0; i < count; ++i) {
                reporter.report(reportType, message1, message2, MessageDifferencer.immutable(stack, SpecificField.forRepeatedField(field, i)));
            }
        } else {
            reporter.report(reportType, message1, message2, MessageDifferencer.immutable(stack, SpecificField.forField(field)));
        }
    }

    private boolean fieldBefore(Descriptors.FieldDescriptor field1, Descriptors.FieldDescriptor field2) {
        if (field1 == null) {
            return false;
        }
        if (field2 == null) {
            return true;
        }
        return field1.getNumber() < field2.getNumber();
    }

    boolean compareRepeatedField(Message message1, Message message2, Descriptors.FieldDescriptor repeatedField, @Nullable Reporter reporter, List<SpecificField> stack) {
        int i;
        int count1 = message1.getRepeatedFieldCount(repeatedField);
        int count2 = message2.getRepeatedFieldCount(repeatedField);
        boolean treatedAsSubset = this.isTreatedAsSubset(repeatedField);
        if (count1 != count2 && reporter == null && !treatedAsSubset) {
            return false;
        }
        int[] matchList1 = new int[count1];
        int[] matchList2 = new int[count2];
        if (!this.matchRepeatedFieldIndices(message1, message2, repeatedField, matchList1, matchList2, stack) && reporter == null) {
            return false;
        }
        boolean fieldDifferent = false;
        for (i = 0; i < count1; ++i) {
            if (matchList1[i] == -1) continue;
            int newIndex = matchList1[i];
            SpecificField specificField = SpecificField.forRepeatedField(repeatedField, i, newIndex);
            boolean result = this.compareFieldValueUsingParentFields(message1, message2, repeatedField, i, newIndex, reporter, stack);
            if (!result) {
                if (reporter == null) {
                    return false;
                }
                fieldDifferent = true;
            }
            if (reporter == null) continue;
            ReportType reportType = null;
            if (!result) {
                reportType = ReportType.MODIFIED;
            } else if (i != newIndex) {
                reportType = ReportType.MOVED;
            } else if (this.reportMatches) {
                reportType = ReportType.MATCHED;
            }
            if (reportType == null) continue;
            reporter.report(reportType, message1, message2, MessageDifferencer.immutable(stack, specificField));
        }
        for (i = 0; i < count2; ++i) {
            if (matchList2[i] != -1) continue;
            if (!treatedAsSubset) {
                fieldDifferent = true;
            }
            if (reporter == null) continue;
            reporter.report(ReportType.ADDED, message1, message2, MessageDifferencer.immutable(stack, SpecificField.forRepeatedField(repeatedField, i)));
        }
        for (i = 0; i < count1; ++i) {
            if (matchList1[i] != -1) continue;
            reporter.report(ReportType.DELETED, message1, message2, MessageDifferencer.immutable(stack, SpecificField.forRepeatedField(repeatedField, i)));
            fieldDifferent = true;
        }
        return !fieldDifferent;
    }

    private boolean matchRepeatedFieldIndices(Message message1, Message message2, Descriptors.FieldDescriptor repeatedField, int[] matchList1, int[] matchList2, List<SpecificField> stack) {
        MapKeyComparator keyComparator = this.mapKeyComparatorMap.get(repeatedField);
        if (repeatedField.isMapField() && keyComparator == null) {
            keyComparator = PROTO_MAP_KEY_COMPARATOR;
        }
        int count1 = matchList1.length;
        int count2 = matchList2.length;
        Arrays.fill(matchList1, -1);
        Arrays.fill(matchList2, -1);
        boolean success = true;
        if (keyComparator != null || this.isTreatedAsSet(repeatedField)) {
            for (int i = 0; i < count1; ++i) {
                boolean match = false;
                int newIndex = i;
                for (int j = 0; j < count2; ++j) {
                    if (matchList2[j] != -1) continue;
                    newIndex = j;
                    match = this.isMatch(repeatedField, keyComparator, message1, message2, i, j, stack);
                    if (!match) continue;
                    matchList1[i] = newIndex;
                    matchList2[newIndex] = i;
                    break;
                }
                success = success && match;
            }
        } else {
            for (int i = 0; i < count1 && i < count2; ++i) {
                matchList1[i] = matchList2[i] = i;
            }
        }
        return success;
    }

    private boolean isMatch(Descriptors.FieldDescriptor repeatedField, @Nullable MapKeyComparator keyComparator, Message message1, Message message2, int index1, int index2, List<SpecificField> stack) {
        if (keyComparator == null) {
            return this.compareFieldValueUsingParentFields(message1, message2, repeatedField, index1, index2, null, stack);
        }
        Message m1 = (Message)message1.getRepeatedField(repeatedField, index1);
        Message m2 = (Message)message2.getRepeatedField(repeatedField, index2);
        stack.add(SpecificField.forRepeatedField(repeatedField, index1, index2));
        boolean isSame = keyComparator.isMatch(this, m1, m2, stack);
        MessageDifferencer.pop(stack);
        return isSame;
    }

    private boolean isTreatedAsSubset(Descriptors.FieldDescriptor field) {
        return this.isTreatedAsSet(field) && this.scope == Scope.PARTIAL;
    }

    private boolean isTreatedAsSet(Descriptors.FieldDescriptor field) {
        if (this.repeatedFieldComparison == RepeatedFieldComparison.AS_SET) {
            return true;
        }
        return this.setFields.contains(field);
    }

    private static <T> ImmutableList<T> immutable(Iterable<T> stack, T extraElement) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(stack)).add(extraElement)).build();
    }

    private static <T> T pop(List<T> stack) {
        return stack.remove(stack.size() - 1);
    }

    private static String wrapDebugString(String debugString) {
        return debugString.isEmpty() ? "{ }" : new StringBuilder(4 + String.valueOf(debugString).length()).append("{ ").append(debugString).append(" }").toString();
    }

    @Immutable
    public static final class DefaultFieldComparator
    implements FieldComparator {
        private final FloatComparison floatComparison;

        public DefaultFieldComparator(FloatComparison floatComparison) {
            this.floatComparison = Preconditions.checkNotNull(floatComparison);
        }

        @VisibleForTesting
        static boolean almostEquals(float x, float y) {
            return DefaultFieldComparator.almostEquals(x, y, 3.2E-4f);
        }

        @VisibleForTesting
        static boolean almostEquals(double x, double y) {
            return DefaultFieldComparator.almostEquals(x, y, 3.2E-8);
        }

        private static boolean almostEquals(double x, double y, double stdErr) {
            if (x == y) {
                return true;
            }
            if (Double.isNaN(x) && Double.isNaN(y)) {
                return true;
            }
            if (Double.isInfinite(x) || Double.isInfinite(y)) {
                return false;
            }
            if (Math.abs(x) <= stdErr && Math.abs(y) <= stdErr) {
                return true;
            }
            double absDiff = x > y ? x - y : y - x;
            return absDiff <= Math.max(stdErr, stdErr * Math.max(Math.abs(x), Math.abs(y)));
        }

        @Override
        public FieldComparator.ComparisonResult compare(Message message1, Message message2, Descriptors.FieldDescriptor field, int index1, int index2, ImmutableList<SpecificField> parentFields) {
            Object value1 = field.isRepeated() ? message1.getRepeatedField(field, index1) : message1.getField(field);
            Object value2 = field.isRepeated() ? message2.getRepeatedField(field, index2) : message2.getField(field);
            switch (field.getJavaType()) {
                case MESSAGE: {
                    return FieldComparator.ComparisonResult.RECURSE;
                }
                case INT: 
                case LONG: 
                case BOOLEAN: 
                case STRING: 
                case BYTE_STRING: 
                case ENUM: {
                    return FieldComparator.ComparisonResult.of(value1.equals(value2));
                }
                case FLOAT: {
                    if (this.floatComparison == FloatComparison.EXACT) {
                        return FieldComparator.ComparisonResult.of(value1.equals(value2));
                    }
                    return FieldComparator.ComparisonResult.of(DefaultFieldComparator.almostEquals(((Number)value1).floatValue(), ((Number)value2).floatValue()));
                }
                case DOUBLE: {
                    if (this.floatComparison == FloatComparison.EXACT) {
                        return FieldComparator.ComparisonResult.of(value1.equals(value2));
                    }
                    return FieldComparator.ComparisonResult.of(DefaultFieldComparator.almostEquals(((Number)value1).doubleValue(), ((Number)value2).doubleValue()));
                }
            }
            String string = String.valueOf((Object)field.getJavaType());
            throw new IllegalArgumentException(new StringBuilder(15 + String.valueOf(string).length()).append("Bad field type ").append(string).toString());
        }
    }

    public static final class StreamReporter
    implements Reporter {
        private final Appendable output;
        private final boolean reportModifiedAggregates;

        public StreamReporter(Appendable output) {
            this(output, false);
        }

        public StreamReporter(Appendable output, boolean reportModifiedAggregates) {
            this.output = Preconditions.checkNotNull(output);
            this.reportModifiedAggregates = reportModifiedAggregates;
        }

        @Override
        public void report(ReportType type, Message message1, Message message2, ImmutableList<SpecificField> fieldPath) {
            try {
                SpecificField specificField;
                if (type == ReportType.MODIFIED && !this.reportModifiedAggregates && ((specificField = Iterables.getLast(fieldPath)).getField() == null ? specificField.getUnknown().getFieldType() == UnknownFieldType.GROUP : specificField.getField().getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                    return;
                }
                this.output.append(type.name().toLowerCase()).append(": ");
                switch (type) {
                    case ADDED: {
                        this.appendPath(fieldPath, false);
                        this.output.append(": ");
                        this.appendValue(message2, fieldPath, false);
                        break;
                    }
                    case DELETED: {
                        this.appendPath(fieldPath, true);
                        this.output.append(": ");
                        this.appendValue(message1, fieldPath, true);
                        break;
                    }
                    case IGNORED: {
                        this.appendPath(fieldPath, false);
                        break;
                    }
                    case MOVED: {
                        this.appendPath(fieldPath, true);
                        this.output.append(" -> ");
                        this.appendPath(fieldPath, false);
                        this.output.append(" : ");
                        this.appendValue(message1, fieldPath, true);
                        break;
                    }
                    case MODIFIED: {
                        this.appendPath(fieldPath, true);
                        if (this.checkPathChanged(fieldPath)) {
                            this.output.append(" -> ");
                            this.appendPath(fieldPath, false);
                        }
                        this.output.append(": ");
                        this.appendValue(message1, fieldPath, true);
                        this.output.append(" -> ");
                        this.appendValue(message2, fieldPath, false);
                        break;
                    }
                    case MATCHED: {
                        this.appendPath(fieldPath, true);
                        if (this.checkPathChanged(fieldPath)) {
                            this.output.append(" -> ");
                            this.appendPath(fieldPath, false);
                        }
                        this.output.append(" : ");
                        this.appendValue(message1, fieldPath, true);
                    }
                }
                this.output.append("\n");
            }
            catch (IOException e) {
                throw new StreamException(e);
            }
        }

        private boolean checkPathChanged(ImmutableList<SpecificField> fieldPath) {
            for (SpecificField specificField : fieldPath) {
                if (specificField.getIndex() == specificField.getNewIndex()) continue;
                return true;
            }
            return false;
        }

        private void appendPath(ImmutableList<SpecificField> fieldPath, boolean leftSide) throws IOException {
            Iterator it = fieldPath.iterator();
            while (it.hasNext()) {
                SpecificField specificField = (SpecificField)it.next();
                Descriptors.FieldDescriptor field = specificField.getField();
                if (field != null) {
                    if (field.isExtension()) {
                        this.output.append("(").append(field.getFullName()).append(")");
                    } else {
                        this.output.append(field.getName());
                    }
                } else {
                    this.output.append(String.valueOf(specificField.getUnknown().getFieldNumber()));
                }
                if (leftSide && specificField.getIndex() >= 0) {
                    this.output.append("[").append(String.valueOf(specificField.getIndex())).append("]");
                }
                if (!leftSide && specificField.getNewIndex() >= 0) {
                    this.output.append("[").append(String.valueOf(specificField.getNewIndex())).append("]");
                }
                if (!it.hasNext()) continue;
                this.output.append(".");
            }
        }

        private void appendValue(Message message, ImmutableList<SpecificField> fieldPath, boolean leftSide) throws IOException {
            SpecificField specificField = Iterables.getLast(fieldPath);
            Descriptors.FieldDescriptor field = specificField.getField();
            if (field != null) {
                Object value;
                int index = leftSide ? specificField.getIndex() : specificField.getNewIndex();
                Object object = value = field.isRepeated() ? message.getRepeatedField(field, index) : message.getField(field);
                if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    this.output.append(MessageDifferencer.wrapDebugString(TextFormat.shortDebugString((Message)value)));
                } else {
                    TextFormat.printFieldValue(field, value, this.output);
                }
            } else {
                UnknownFieldSet unknownFields = message.getUnknownFields();
                UnknownFieldSet.Field unknownField = null;
                UnknownDescriptor unknownDescriptor = null;
                for (SpecificField node : fieldPath) {
                    unknownDescriptor = node.getUnknown();
                    if (unknownDescriptor == null) continue;
                    unknownField = unknownFields.getField(unknownDescriptor.getFieldNumber());
                    if (unknownDescriptor.getFieldType() != UnknownFieldType.GROUP) continue;
                    unknownFields = unknownField.getGroupList().get(node.getIndex());
                }
                UnknownFieldType unknownType = unknownDescriptor.getFieldType();
                Object value = unknownType.getValues(unknownField).get(specificField.getIndex());
                int wireFormat = unknownType.getWireFormat();
                if (wireFormat == 3) {
                    this.output.append(MessageDifferencer.wrapDebugString(TextFormat.shortDebugString((UnknownFieldSet)value)));
                } else {
                    TextFormat.printUnknownFieldValue(wireFormat, value, this.output);
                }
            }
        }

        public static final class StreamException
        extends RuntimeException {
            private StreamException(IOException e) {
                super(e);
            }
        }
    }

    public static enum UnknownFieldType {
        VARINT(0){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getVarintList();
            }
        }
        ,
        FIXED32(5){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getFixed32List();
            }
        }
        ,
        FIXED64(1){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getFixed64List();
            }
        }
        ,
        LENGTH_DELIMITED(2){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getLengthDelimitedList();
            }
        }
        ,
        GROUP(3){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getGroupList();
            }
        };

        final int wireFormat;

        private UnknownFieldType(int wireFormat) {
            this.wireFormat = wireFormat;
        }

        public int getWireFormat() {
            return this.wireFormat;
        }

        public abstract List<?> getValues(UnknownFieldSet.Field var1);
    }

    public static enum RepeatedFieldComparison {
        AS_LIST,
        AS_SET;

    }

    public static enum FloatComparison {
        EXACT,
        APPROXIMATE;

    }

    public static enum Scope {
        FULL,
        PARTIAL;

    }

    public static enum MessageFieldComparison {
        EQUAL,
        EQUIVALENT;

    }

    public static enum ReportType {
        ADDED,
        DELETED,
        IGNORED,
        MODIFIED,
        MOVED,
        MATCHED;

    }

    public static interface Reporter {
        public void report(ReportType var1, Message var2, Message var3, ImmutableList<SpecificField> var4);
    }

    public static interface FieldComparator {
        public ComparisonResult compare(Message var1, Message var2, Descriptors.FieldDescriptor var3, int var4, int var5, ImmutableList<SpecificField> var6);

        public static enum ComparisonResult {
            SAME,
            DIFFERENT,
            RECURSE;


            public static ComparisonResult of(boolean result) {
                return result ? SAME : DIFFERENT;
            }
        }
    }

    @AutoValue
    @Immutable
    public static abstract class UnknownDescriptor {
        private static UnknownDescriptor create(int fieldNumber, UnknownFieldType fieldType) {
            return new AutoValue_MessageDifferencer_UnknownDescriptor(fieldNumber, fieldType);
        }

        public abstract int getFieldNumber();

        public abstract UnknownFieldType getFieldType();
    }

    @AutoValue
    @Immutable
    public static abstract class SpecificField {
        private static SpecificField forField(Descriptors.FieldDescriptor field) {
            Preconditions.checkNotNull(field);
            return new AutoValue_MessageDifferencer_SpecificField(field, null, -1, -1);
        }

        private static SpecificField forRepeatedField(Descriptors.FieldDescriptor field, int index) {
            Preconditions.checkNotNull(field);
            Preconditions.checkArgument(index >= 0);
            return new AutoValue_MessageDifferencer_SpecificField(field, null, index, index);
        }

        private static SpecificField forRepeatedField(Descriptors.FieldDescriptor field, int index, int newIndex) {
            Preconditions.checkNotNull(field);
            Preconditions.checkArgument(index >= 0);
            Preconditions.checkArgument(newIndex >= 0);
            return new AutoValue_MessageDifferencer_SpecificField(field, null, index, newIndex);
        }

        private static SpecificField forUnknownDescriptor(UnknownDescriptor unknown, int index) {
            Preconditions.checkNotNull(unknown);
            return new AutoValue_MessageDifferencer_SpecificField(null, unknown, index, index);
        }

        @Nullable
        public abstract Descriptors.FieldDescriptor getField();

        @Nullable
        public abstract UnknownDescriptor getUnknown();

        public abstract int getIndex();

        public abstract int getNewIndex();
    }

    public static interface IgnoreCriteria {
        public boolean isIgnored(Message var1, Message var2, @Nullable Descriptors.FieldDescriptor var3, List<SpecificField> var4);
    }

    public static final class Builder {
        private final Set<Descriptors.FieldDescriptor> setFields = Sets.newHashSet();
        private final Set<Descriptors.FieldDescriptor> ignoreFields = Sets.newHashSet();
        private final Map<Descriptors.FieldDescriptor, MapKeyComparator> mapKeyComparatorMap = Maps.newHashMap();
        private MessageFieldComparison messageFieldComparison = MessageFieldComparison.EQUAL;
        private Scope scope = Scope.FULL;
        private FloatComparison floatComparison = FloatComparison.EXACT;
        private RepeatedFieldComparison repeatedFieldComparison = RepeatedFieldComparison.AS_LIST;
        private boolean reportMatches;
        private FieldComparator fieldComparator;
        private final List<IgnoreCriteria> ignoreCriterias = Lists.newArrayList();
        private boolean unpackAny;

        private Builder() {
        }

        public Builder treatAsSet(Descriptors.FieldDescriptor field) {
            Preconditions.checkArgument(field.isRepeated(), "Field must be repeated: %s", (Object)field.getFullName());
            Preconditions.checkArgument(!this.mapKeyComparatorMap.containsKey(field), "Cannot treat this repeated field as both Map and Set for comparison: %s", (Object)field.getFullName());
            this.setFields.add(field);
            return this;
        }

        public Builder treatAsMap(Descriptors.FieldDescriptor field, Descriptors.FieldDescriptor key) {
            Preconditions.checkArgument(field.isRepeated(), "Field must be repeated: %s", (Object)field.getFullName());
            Preconditions.checkArgument(field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE, "Field has to be message type: %s", (Object)field.getFullName());
            Preconditions.checkArgument(key.getContainingType().equals(field.getMessageType()), "%s must be a direct subfield within the repeated field: %s", (Object)key.getFullName(), (Object)field.getFullName());
            Preconditions.checkArgument(!this.setFields.contains(field), "Cannot treat this repeated field as both Map and Set for comparison: %s", (Object)key.getFullName());
            MultipleFieldsMapKeyComparator keyComparator = new MultipleFieldsMapKeyComparator(key);
            this.mapKeyComparatorMap.put(field, keyComparator);
            return this;
        }

        public Builder treatAsMapWithMultipleFieldsAsKey(Descriptors.FieldDescriptor field, List<Descriptors.FieldDescriptor> keyFields) {
            String string = String.valueOf(field.getFullName());
            Preconditions.checkArgument(field.isRepeated(), string.length() != 0 ? "Field must be repeated ".concat(string) : new String("Field must be repeated "));
            String string2 = String.valueOf(field.getFullName());
            Preconditions.checkArgument(Descriptors.FieldDescriptor.JavaType.MESSAGE.equals((Object)field.getJavaType()), string2.length() != 0 ? "Field has to be message type.  Field name is: ".concat(string2) : new String("Field has to be message type.  Field name is: "));
            for (int i = 0; i < keyFields.size(); ++i) {
                Descriptors.FieldDescriptor key = keyFields.get(i);
                String string3 = key.getFullName();
                String string4 = field.getFullName();
                Preconditions.checkArgument(key.getContainingType().equals(field.getMessageType()), new StringBuilder(54 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append(" must be a direct subfield within the repeated field: ").append(string4).toString());
            }
            Preconditions.checkArgument(!this.setFields.contains(field), "Cannot treat this repeated field as both Map and Set for comparison.");
            MultipleFieldsMapKeyComparator keyComparator = new MultipleFieldsMapKeyComparator(keyFields);
            this.mapKeyComparatorMap.put(field, keyComparator);
            return this;
        }

        public Builder treatAsMapUsingKeyComparator(Descriptors.FieldDescriptor field, MapKeyComparator keyComparator) {
            String string = String.valueOf(field.getFullName());
            Preconditions.checkArgument(field.isRepeated(), string.length() != 0 ? "Field must be repeated ".concat(string) : new String("Field must be repeated "));
            String string2 = String.valueOf(field.getFullName());
            Preconditions.checkArgument(Descriptors.FieldDescriptor.JavaType.MESSAGE.equals((Object)field.getJavaType()), string2.length() != 0 ? "Field has to be message type.  Field name is: ".concat(string2) : new String("Field has to be message type.  Field name is: "));
            Preconditions.checkArgument(!this.setFields.contains(field), "Cannot treat this repeated field as both Map and Set for comparison.");
            this.mapKeyComparatorMap.put(field, keyComparator);
            return this;
        }

        public Builder ignoreField(Descriptors.FieldDescriptor field) {
            this.ignoreFields.add(field);
            return this;
        }

        public Builder addIgnoreCriteria(IgnoreCriteria criterion) {
            this.ignoreCriterias.add(criterion);
            return this;
        }

        public Builder setMessageFieldComparison(MessageFieldComparison comparison) {
            this.messageFieldComparison = comparison;
            return this;
        }

        public Builder setReportMatches(boolean reportMatches) {
            this.reportMatches = reportMatches;
            return this;
        }

        public Builder setScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder setFloatComparison(FloatComparison comparison) {
            this.floatComparison = Preconditions.checkNotNull(comparison, "FloatComparison should not be null.");
            return this;
        }

        public Builder setFieldComparator(FieldComparator fieldComparator) {
            this.fieldComparator = fieldComparator;
            return this;
        }

        public Builder setRepeatedFieldComparison(RepeatedFieldComparison comparison) {
            this.repeatedFieldComparison = comparison;
            return this;
        }

        public Builder setUnpackAny(boolean unpackAny) {
            this.unpackAny = unpackAny;
            return this;
        }

        IgnoreCriteria getMergedIgnoreCriteria() {
            if (!this.ignoreFields.isEmpty()) {
                IgnoreCriteria criterion = MessageDifferencer.ignoringFields(ImmutableSet.copyOf(this.ignoreFields));
                return MessageDifferencer.mergeCriteria(Iterables.concat(this.ignoreCriterias, Collections.singleton(criterion)));
            }
            return MessageDifferencer.mergeCriteria(this.ignoreCriterias);
        }

        public MessageDifferencer build() {
            return new MessageDifferencer(this);
        }
    }

    private static class MultipleFieldsMapKeyComparator
    implements MapKeyComparator {
        private final List<Descriptors.FieldDescriptor> keyFields;

        public MultipleFieldsMapKeyComparator(List<Descriptors.FieldDescriptor> key) {
            this.keyFields = key;
        }

        public MultipleFieldsMapKeyComparator(Descriptors.FieldDescriptor fieldDescriptor) {
            this.keyFields = new LinkedList<Descriptors.FieldDescriptor>();
            this.keyFields.add(fieldDescriptor);
        }

        @Override
        public boolean isMatch(MessageDifferencer messageDifferencer, Message message1, Message message2, List<SpecificField> parentFields) {
            for (int i = 0; i < this.keyFields.size(); ++i) {
                Descriptors.FieldDescriptor field = this.keyFields.get(i);
                if (!(field.isRepeated() ? !messageDifferencer.compareRepeatedField(message1, message2, field, null, parentFields) : !messageDifferencer.compareFieldValueUsingParentFields(message1, message2, field, -1, -1, null, parentFields))) continue;
                return false;
            }
            return true;
        }
    }

    private static class ProtoMapKeyComparator
    implements MapKeyComparator {
        private ProtoMapKeyComparator() {
        }

        @Override
        public boolean isMatch(MessageDifferencer messageDifferencer, Message message1, Message message2, List<SpecificField> parentFields) {
            Descriptors.FieldDescriptor keyField = message1.getDescriptorForType().findFieldByName("key");
            return messageDifferencer.compareFieldValueUsingParentFields(message1, message2, keyField, -1, -1, null, parentFields);
        }
    }

    public static interface MapKeyComparator {
        public boolean isMatch(MessageDifferencer var1, Message var2, Message var3, List<SpecificField> var4);
    }
}

