/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Primitives;
import com.google.io.protocol.ProtocolMessage;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.AutoValue_MessageReflectorInstance_FieldKey;
import com.google.protobuf.contrib.JavaQualifiedNames;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public final class MessageReflectorInstance {
    private final LoadingCache<FieldKey, Getter> getters;
    private final LoadingCache<FieldKey, Getter> repeatedGetters;
    private final LoadingCache<FieldKey, Getter> proto2BuilderGetters;
    private final LoadingCache<FieldKey, Getter> proto2RepeatedBuilderGetters;
    private final LoadingCache<FieldKey, HasChecker> hasCheckers;
    private final LoadingCache<FieldKey, Setter> setters;
    private final LoadingCache<FieldKey, RepeatedSetter> repeatedSetters;
    private final LoadingCache<FieldKey, Adder> adders;
    private final LoadingCache<FieldKey, Counter> counters;
    private final LoadingCache<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>> builderFactories;
    private final LoadingCache<Class<? extends MessageOrBuilder>, Descriptors.Descriptor> descriptorCaches;
    private final Setter absentSetter = new Setter(this){

        @Override
        public boolean set(MessageLiteOrBuilder builder, Object value) {
            return false;
        }
    };
    private final RepeatedSetter absentRepeatedSetter = new RepeatedSetter(this){

        @Override
        public boolean set(MessageLiteOrBuilder builder, int index, Object value) {
            return false;
        }
    };
    private final Adder absentAdder = new Adder(this){

        @Override
        public boolean add(MessageLiteOrBuilder builder, Object value) {
            return false;
        }
    };
    private final Counter absentCounter = new Counter(this){

        @Override
        public int count(MessageLiteOrBuilder builder) {
            return -1;
        }
    };
    private final Getter absentGetter = new Getter(this){

        @Override
        public Object get(MessageLiteOrBuilder messageOrBuilder) {
            return null;
        }
    };
    private final HasChecker absentHasChecker = new HasChecker(this){

        @Override
        public boolean has(MessageLite message) {
            return false;
        }
    };

    public MessageReflectorInstance() {
        this(CacheBuilderSpec.parse(""));
    }

    public MessageReflectorInstance(CacheBuilderSpec cacheBuilderSpec) {
        this.getters = this.createGetters(cacheBuilderSpec);
        this.repeatedGetters = this.createRepeatedGetters(cacheBuilderSpec);
        this.proto2BuilderGetters = this.createProto2BuilderGetters(cacheBuilderSpec);
        this.proto2RepeatedBuilderGetters = this.createProto2RepeatedBuilderGetters(cacheBuilderSpec);
        this.hasCheckers = this.createHasCheckers(cacheBuilderSpec);
        this.setters = this.createSetters(cacheBuilderSpec);
        this.repeatedSetters = this.createRepeatedSetters(cacheBuilderSpec);
        this.adders = this.createAdders(cacheBuilderSpec);
        this.counters = this.createCounters(cacheBuilderSpec);
        this.builderFactories = MessageReflectorInstance.createBuilderFactories(cacheBuilderSpec);
        this.descriptorCaches = MessageReflectorInstance.createDescriptorCaches(cacheBuilderSpec);
    }

    public <T> boolean hasFieldDeclared(Class<? extends MessageLite> messageType, Class<T> fieldType, String fieldName) {
        return this.getters.getUnchecked(FieldKey.create(messageType, fieldType, fieldName)) != this.absentGetter;
    }

    public <T> boolean hasRepeatedFieldDeclared(Class<? extends MessageLite> messageType, Class<T> fieldType, String fieldName) {
        return this.repeatedGetters.getUnchecked(FieldKey.create(messageType, fieldType, fieldName)) != this.absentGetter;
    }

    public <T> T get(Class<T> fieldType, String fieldName, MessageLite message) {
        Preconditions.checkNotNull(message);
        return fieldType.cast(this.getters.getUnchecked(FieldKey.create(message.getClass(), fieldType, fieldName)).get(message));
    }

    public <T> Collection<T> getRepeated(Class<T> fieldType, String fieldName, MessageLite message) {
        Preconditions.checkNotNull(message);
        return (Collection)this.repeatedGetters.getUnchecked(FieldKey.create(message.getClass(), fieldType, fieldName)).get(message);
    }

    public <T> T get(Class<T> fieldType, List<String> fieldPath, MessageLite message) {
        Preconditions.checkNotNull(message);
        int n = fieldPath.size();
        int i = 0;
        for (String fieldName : fieldPath) {
            if (i < n - 1) {
                if ((message = this.get(MessageLite.class, fieldName, message)) == null) {
                    return null;
                }
            } else {
                return this.get(fieldType, fieldName, message);
            }
            ++i;
        }
        throw new IllegalStateException("never reached");
    }

    public <T> boolean has(Class<T> fieldType, String fieldName, MessageLite message) {
        return this.hasCheckers.getUnchecked(FieldKey.create(message.getClass(), fieldType, fieldName)).has(message);
    }

    public <T> boolean has(Class<T> fieldType, List<String> fieldPath, MessageLite message) {
        Preconditions.checkNotNull(message);
        int n = fieldPath.size();
        int i = 0;
        for (String fieldName : fieldPath) {
            if (i < n - 1) {
                if (!this.has(MessageLite.class, fieldName, message)) {
                    return false;
                }
            } else {
                return this.has(fieldType, fieldName, message);
            }
            message = this.get(MessageLite.class, fieldName, message);
            ++i;
        }
        throw new IllegalStateException("never reached");
    }

    public MessageLiteOrBuilder newBuilder(Class<? extends MessageLite> type) {
        Preconditions.checkNotNull(type);
        return this.builderFactories.getUnchecked(type).get();
    }

    public static MessageLiteOrBuilder toBuilder(MessageLite message) {
        if (MessageReflectorInstance.isProto1(message.getClass())) {
            return ((ProtocolMessage)message).clone();
        }
        return message.toBuilder();
    }

    public MessageLiteOrBuilder getFieldBuilder(MessageLiteOrBuilder builder, String fieldName) {
        if (builder instanceof ProtocolMessage) {
            return this.get(MessageLite.class, fieldName, (MessageLite)((ProtocolMessage)builder));
        }
        return (MessageLite.Builder)this.proto2BuilderGetters.getUnchecked(FieldKey.create(builder.getClass(), MessageLite.Builder.class, fieldName)).get(builder);
    }

    public List<MessageLiteOrBuilder> getRepeatedFieldBuilders(MessageLiteOrBuilder builder, String fieldName) {
        return (List)this.proto2RepeatedBuilderGetters.getUnchecked(FieldKey.create(builder.getClass(), MessageLite.Builder.class, fieldName)).get(builder);
    }

    public <T> boolean set(Class<T> fieldType, String fieldName, MessageLiteOrBuilder messageOrBuilder, T value) {
        Preconditions.checkNotNull(messageOrBuilder);
        return this.setters.getUnchecked(FieldKey.create(messageOrBuilder.getClass(), fieldType, fieldName)).set(messageOrBuilder, value);
    }

    public <T> boolean set(Class<T> fieldType, List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder, T value) {
        if ((messageOrBuilder = this.getMessage(fieldPath, messageOrBuilder)) == null) {
            return false;
        }
        return this.set(fieldType, fieldPath.get(fieldPath.size() - 1), messageOrBuilder, value);
    }

    public <T> boolean set(Class<T> fieldType, String fieldName, MessageLiteOrBuilder messageOrBuilder, int index, T value) {
        Preconditions.checkNotNull(messageOrBuilder);
        return this.repeatedSetters.getUnchecked(FieldKey.create(messageOrBuilder.getClass(), fieldType, fieldName)).set(messageOrBuilder, index, value);
    }

    public <T> boolean set(Class<T> fieldType, List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder, int index, T value) {
        if ((messageOrBuilder = this.getMessage(fieldPath, messageOrBuilder)) == null) {
            return false;
        }
        return this.set(fieldType, fieldPath.get(fieldPath.size() - 1), messageOrBuilder, index, value);
    }

    public <T> boolean add(Class<T> fieldType, List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder, T value) {
        if ((messageOrBuilder = this.getMessage(fieldPath, messageOrBuilder)) == null) {
            return false;
        }
        return this.add(fieldType, fieldPath.get(fieldPath.size() - 1), messageOrBuilder, value);
    }

    @Nullable
    public MessageLiteOrBuilder getMessage(List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder) {
        Preconditions.checkNotNull(messageOrBuilder);
        int n = fieldPath.size();
        int i = 0;
        for (String fieldName : fieldPath) {
            if (i < n - 1) {
                if ((messageOrBuilder = this.getFieldBuilder(messageOrBuilder, fieldName)) == null) {
                    return null;
                }
            } else {
                return messageOrBuilder;
            }
            ++i;
        }
        throw new IllegalStateException("never reached");
    }

    public boolean set(String fieldName, MessageLiteOrBuilder messageOrBuilder, Object value) {
        Method setter = MessageReflectorInstance.findSetterMethod(messageOrBuilder.getClass(), fieldName, value.getClass());
        if (setter == null) {
            return false;
        }
        this.set(messageOrBuilder, value, setter);
        return true;
    }

    public boolean set(List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder, Object value) {
        if ((messageOrBuilder = this.getMessage(fieldPath, messageOrBuilder)) == null) {
            return false;
        }
        return this.set(fieldPath.get(fieldPath.size() - 1), messageOrBuilder, value);
    }

    public <T> boolean add(Class<T> fieldType, String fieldName, MessageLiteOrBuilder messageOrBuilder, T value) {
        Preconditions.checkNotNull(messageOrBuilder);
        return this.adders.getUnchecked(FieldKey.create(messageOrBuilder.getClass(), fieldType, fieldName)).add(messageOrBuilder, value);
    }

    public int count(String fieldName, MessageLiteOrBuilder messageOrBuilder) {
        return this.counters.getUnchecked(FieldKey.create(messageOrBuilder.getClass(), MessageLite.class, fieldName)).count(messageOrBuilder);
    }

    public int count(List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder) {
        if ((messageOrBuilder = this.getMessage(fieldPath, messageOrBuilder)) == null) {
            return -1;
        }
        return this.count(fieldPath.get(fieldPath.size() - 1), messageOrBuilder);
    }

    public static MessageLite build(MessageLiteOrBuilder message) {
        if (message instanceof ProtocolMessage) {
            return (MessageLite)message;
        }
        return ((MessageLite.Builder)message).build();
    }

    public static MessageLite buildPartial(MessageLiteOrBuilder message) {
        if (message instanceof ProtocolMessage) {
            return (MessageLite)message;
        }
        return ((MessageLite.Builder)message).buildPartial();
    }

    public static boolean isProto1(Class<?> type) {
        return ProtocolMessage.class.isAssignableFrom(type);
    }

    public <T extends MessageLite> T convert(Class<T> toType, MessageLite value) {
        return this.convert(toType, value, ExtensionRegistry.getEmptyRegistry());
    }

    public <T extends MessageLite> T convert(Class<T> toType, MessageLite value, ExtensionRegistry registry) {
        if (value.getClass().equals(toType)) {
            return (T)((MessageLite)toType.cast(value));
        }
        MessageLiteOrBuilder builder = this.newBuilder(toType);
        if (builder instanceof ProtocolMessage) {
            ((ProtocolMessage)builder).mergeFrom(value.toByteArray());
        } else {
            try {
                ((MessageLite.Builder)builder).mergeFrom(value.toByteArray(), (ExtensionRegistryLite)registry);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)((MessageLite)toType.cast(MessageReflectorInstance.build(builder)));
    }

    public Descriptors.Descriptor getDescriptor(Class<? extends MessageOrBuilder> type) {
        return this.descriptorCaches.getUnchecked(type);
    }

    private static final <K, V> LoadingCache<K, V> createCacheDisabledLoadingCache(final CacheLoader<K, V> cacheLoader) {
        return new AbstractLoadingCache<K, V>(){

            @Override
            public V get(K key) throws ExecutionException {
                try {
                    return cacheLoader.load(key);
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            @Nullable
            public V getIfPresent(Object key) {
                return this.getUnchecked(key);
            }
        };
    }

    private final CacheLoader<FieldKey, Getter> createGettersCacheLoader() {
        return new CacheLoader<FieldKey, Getter>(){

            @Override
            public Getter load(FieldKey key) throws Exception {
                String fieldName;
                if (MessageReflectorInstance.isProto1(key.messageType())) {
                    if (key.fieldType().equals(Boolean.class)) {
                        String string = String.valueOf(MessageReflectorInstance.proto1UnderscoresToUpperCamel(key.fieldName()));
                        fieldName = string.length() != 0 ? "is".concat(string) : new String("is");
                    } else {
                        String string = String.valueOf(MessageReflectorInstance.proto1UnderscoresToUpperCamel(key.fieldName()));
                        fieldName = string.length() != 0 ? "get".concat(string) : new String("get");
                    }
                } else {
                    String string = String.valueOf(MessageReflectorInstance.proto2UnderscoresToUpperCamel(key.fieldName()));
                    fieldName = string.length() != 0 ? "get".concat(string) : new String("get");
                }
                try {
                    final Method getter = key.messageType().getMethod(fieldName, new Class[0]);
                    Class<?> returnType = Primitives.wrap(getter.getReturnType());
                    if (!key.fieldType().isAssignableFrom(returnType)) {
                        return MessageReflectorInstance.this.absentGetter;
                    }
                    return new Getter(this){

                        @Override
                        public Object get(MessageLiteOrBuilder message) {
                            try {
                                return getter.invoke((Object)message, new Object[0]);
                            }
                            catch (Exception e) {
                                Throwables.throwIfUnchecked(e);
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentGetter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, Getter> createRepeatedGetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createRepeatedGettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createRepeatedGettersCacheLoader());
    }

    private final CacheLoader<FieldKey, Getter> createRepeatedGettersCacheLoader() {
        return new CacheLoader<FieldKey, Getter>(){

            @Override
            public Getter load(FieldKey key) throws Exception {
                if (MessageReflectorInstance.isProto1(key.messageType())) {
                    throw new UnsupportedOperationException("Repeated fields getter is not implemented for proto1 messages");
                }
                String string = String.valueOf(MessageReflectorInstance.proto2UnderscoresToUpperCamel(key.fieldName()));
                String baseFieldName = string.length() != 0 ? "get".concat(string) : new String("get");
                try {
                    Method getter = key.messageType().getMethod(baseFieldName, Integer.TYPE);
                    Class<?> returnType = Primitives.wrap(getter.getReturnType());
                    if (!key.fieldType().isAssignableFrom(returnType)) {
                        return MessageReflectorInstance.this.absentGetter;
                    }
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentGetter;
                }
                String fieldName = String.valueOf(baseFieldName).concat("List");
                try {
                    final Method getter = key.messageType().getMethod(fieldName, new Class[0]);
                    Class<?> returnType = Primitives.wrap(getter.getReturnType());
                    if (!Collection.class.isAssignableFrom(returnType)) {
                        return MessageReflectorInstance.this.absentGetter;
                    }
                    return new Getter(this){

                        @Override
                        public Object get(MessageLiteOrBuilder message) {
                            try {
                                return getter.invoke((Object)message, new Object[0]);
                            }
                            catch (Exception e) {
                                Throwables.throwIfUnchecked(e);
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentGetter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, Getter> createGetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createGettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createGettersCacheLoader());
    }

    private final CacheLoader<FieldKey, Getter> createProto2BuilderGettersCacheLoader() {
        return new CacheLoader<FieldKey, Getter>(){

            @Override
            public Getter load(FieldKey key) throws Exception {
                String string = MessageReflectorInstance.proto2UnderscoresToUpperCamel(key.fieldName());
                String fieldName = new StringBuilder(10 + String.valueOf(string).length()).append("get").append(string).append("Builder").toString();
                try {
                    final Method getter = key.messageType().getMethod(fieldName, new Class[0]);
                    return new Getter(this){

                        @Override
                        public Object get(MessageLiteOrBuilder builder) {
                            try {
                                return getter.invoke((Object)builder, new Object[0]);
                            }
                            catch (Exception e) {
                                Throwables.throwIfUnchecked(e);
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentGetter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, Getter> createProto2BuilderGetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createProto2BuilderGettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createProto2BuilderGettersCacheLoader());
    }

    private final CacheLoader<FieldKey, Getter> createProto2RepeatedBuilderGettersCacheLoader() {
        return new CacheLoader<FieldKey, Getter>(){

            @Override
            public Getter load(FieldKey key) throws Exception {
                if (MessageReflectorInstance.isProto1(key.messageType())) {
                    throw new UnsupportedOperationException("Repeated fields builder getter is not implemented for proto1 messages");
                }
                String string = MessageReflectorInstance.proto2UnderscoresToUpperCamel(key.fieldName());
                String fieldName = new StringBuilder(14 + String.valueOf(string).length()).append("get").append(string).append("BuilderList").toString();
                try {
                    final Method getter = key.messageType().getMethod(fieldName, new Class[0]);
                    Class<?> returnType = Primitives.wrap(getter.getReturnType());
                    if (!Collection.class.isAssignableFrom(returnType)) {
                        return MessageReflectorInstance.this.absentGetter;
                    }
                    return new Getter(this){

                        @Override
                        public Object get(MessageLiteOrBuilder builder) {
                            try {
                                return getter.invoke((Object)builder, new Object[0]);
                            }
                            catch (Exception e) {
                                Throwables.throwIfUnchecked(e);
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentGetter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, Getter> createProto2RepeatedBuilderGetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createProto2RepeatedBuilderGettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createProto2RepeatedBuilderGettersCacheLoader());
    }

    private final CacheLoader<FieldKey, HasChecker> createHasCheckersLoadingCache() {
        return new CacheLoader<FieldKey, HasChecker>(){

            @Override
            public HasChecker load(FieldKey key) throws Exception {
                String string = String.valueOf(MessageReflectorInstance.underscoresToUpperCamel(key.fieldName(), key.messageType()));
                String name = string.length() != 0 ? "has".concat(string) : new String("has");
                try {
                    final Method method = key.messageType().getMethod(name, new Class[0]);
                    return new HasChecker(this){

                        @Override
                        public boolean has(MessageLite message) {
                            try {
                                return (Boolean)method.invoke((Object)message, new Object[0]);
                            }
                            catch (Exception e) {
                                Throwables.throwIfUnchecked(e);
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentHasChecker;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, HasChecker> createHasCheckers(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createHasCheckersLoadingCache());
        }
        return CacheBuilder.from(spec).build(this.createHasCheckersLoadingCache());
    }

    private final CacheLoader<FieldKey, Setter> createSettersCacheLoader() {
        return new CacheLoader<FieldKey, Setter>(){

            @Override
            public Setter load(FieldKey key) throws Exception {
                String fieldName = MessageReflectorInstance.underscoresToUpperCamel(key.fieldName(), key.messageType());
                if (!key.fieldType().equals(MessageLite.class)) {
                    try {
                        String string = String.valueOf(fieldName);
                        final Method setter = key.messageType().getMethod(string.length() != 0 ? "set".concat(string) : new String("set"), Primitives.unwrap(key.fieldType()));
                        return new Setter(this){

                            @Override
                            public boolean set(MessageLiteOrBuilder builder, Object value) {
                                try {
                                    setter.invoke((Object)builder, value);
                                }
                                catch (Exception e) {
                                    Throwables.throwIfUnchecked(e);
                                    throw new RuntimeException(e);
                                }
                                return true;
                            }
                        };
                    }
                    catch (NoSuchMethodException e) {
                        return MessageReflectorInstance.this.absentSetter;
                    }
                }
                return this.weakSetter(key, key.fieldName());
            }

            private Setter weakSetter(FieldKey key, String fieldName) {
                final Method setter = MessageReflectorInstance.findSetterMethod(key.messageType(), fieldName, MessageLite.class);
                if (setter == null) {
                    return MessageReflectorInstance.this.absentSetter;
                }
                return new Setter(){

                    @Override
                    public boolean set(MessageLiteOrBuilder builder, Object value) {
                        if (value != null) {
                            Preconditions.checkState(value instanceof MessageLite);
                        }
                        MessageReflectorInstance.this.set(builder, value, setter);
                        return true;
                    }
                };
            }
        };
    }

    private final CacheLoader<FieldKey, Adder> createAddersCacheLoader() {
        return new CacheLoader<FieldKey, Adder>(){

            @Override
            public Adder load(FieldKey key) throws Exception {
                String fieldName = MessageReflectorInstance.underscoresToUpperCamel(key.fieldName(), key.messageType());
                if (!key.fieldType().equals(MessageLite.class)) {
                    try {
                        String string = String.valueOf(fieldName);
                        final Method adder = key.messageType().getMethod(string.length() != 0 ? "add".concat(string) : new String("add"), Primitives.unwrap(key.fieldType()));
                        return new Adder(this){

                            @Override
                            public boolean add(MessageLiteOrBuilder builder, Object value) {
                                try {
                                    adder.invoke((Object)builder, value);
                                }
                                catch (Exception e) {
                                    Throwables.throwIfUnchecked(e);
                                    throw new RuntimeException(e);
                                }
                                return true;
                            }
                        };
                    }
                    catch (NoSuchMethodException e) {
                        return MessageReflectorInstance.this.absentAdder;
                    }
                }
                return this.weakAdder(key, key.fieldName());
            }

            private Adder weakAdder(FieldKey key, String fieldName) {
                final Method adder = MessageReflectorInstance.findAdderMethod(key.messageType(), fieldName, MessageLite.class);
                if (adder == null) {
                    return MessageReflectorInstance.this.absentAdder;
                }
                return new Adder(){

                    @Override
                    public boolean add(MessageLiteOrBuilder builder, Object value) {
                        if (value != null) {
                            Preconditions.checkState(value instanceof MessageLite);
                        }
                        MessageReflectorInstance.this.set(builder, value, adder);
                        return true;
                    }
                };
            }
        };
    }

    private final LoadingCache<FieldKey, Setter> createSetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createSettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createSettersCacheLoader());
    }

    private final CacheLoader<FieldKey, RepeatedSetter> createRepeatedSettersCacheLoader() {
        return new CacheLoader<FieldKey, RepeatedSetter>(){

            @Override
            public RepeatedSetter load(FieldKey key) throws Exception {
                String fieldName = MessageReflectorInstance.underscoresToUpperCamel(key.fieldName(), key.messageType());
                if (key.fieldType().equals(MessageLite.class)) {
                    return MessageReflectorInstance.this.absentRepeatedSetter;
                }
                try {
                    String string = String.valueOf(fieldName);
                    final Method setter = key.messageType().getMethod(string.length() != 0 ? "set".concat(string) : new String("set"), Integer.TYPE, Primitives.unwrap(key.fieldType()));
                    return new RepeatedSetter(this){

                        @Override
                        public boolean set(MessageLiteOrBuilder builder, int index, Object value) {
                            try {
                                setter.invoke((Object)builder, index, value);
                            }
                            catch (Exception e) {
                                Throwables.throwIfUnchecked(e);
                                throw new RuntimeException(e);
                            }
                            return true;
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentRepeatedSetter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, RepeatedSetter> createRepeatedSetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createRepeatedSettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createRepeatedSettersCacheLoader());
    }

    private final LoadingCache<FieldKey, Adder> createAdders(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createAddersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createAddersCacheLoader());
    }

    private final CacheLoader<FieldKey, Counter> createCountersCacheLoader() {
        return new CacheLoader<FieldKey, Counter>(){

            @Override
            public Counter load(FieldKey key) throws Exception {
                String fieldName;
                if (MessageReflectorInstance.isProto1(key.messageType())) {
                    fieldName = String.valueOf(MessageReflectorInstance.proto1UnderscoresToLowerCamel(key.fieldName())).concat("Size");
                } else {
                    String string = MessageReflectorInstance.proto2UnderscoresToUpperCamel(key.fieldName());
                    fieldName = new StringBuilder(8 + String.valueOf(string).length()).append("get").append(string).append("Count").toString();
                }
                try {
                    final Method counter = key.messageType().getMethod(fieldName, new Class[0]);
                    Class<?> returnType = Primitives.wrap(counter.getReturnType());
                    if (!Integer.class.isAssignableFrom(returnType)) {
                        return MessageReflectorInstance.this.absentCounter;
                    }
                    return new Counter(this){

                        @Override
                        public int count(MessageLiteOrBuilder message) {
                            try {
                                return (Integer)counter.invoke((Object)message, new Object[0]);
                            }
                            catch (Exception e) {
                                Throwables.throwIfUnchecked(e);
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentCounter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, Counter> createCounters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createCountersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createCountersCacheLoader());
    }

    @Nullable
    private static Method findSetterMethod(Class<?> clazz, String fieldName, Class<?> expectedType) {
        String string = String.valueOf(MessageReflectorInstance.underscoresToUpperCamel(fieldName, clazz));
        String setterName = string.length() != 0 ? "set".concat(string) : new String("set");
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(setterName) || m.getParameterTypes().length != 1 || !expectedType.isAssignableFrom(Primitives.wrap(m.getParameterTypes()[0]))) continue;
            return m;
        }
        return null;
    }

    @Nullable
    private static Method findAdderMethod(Class<?> clazz, String fieldName, Class<?> expectedType) {
        String string = String.valueOf(MessageReflectorInstance.underscoresToUpperCamel(fieldName, clazz));
        String adderName = string.length() != 0 ? "add".concat(string) : new String("add");
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(adderName) || m.getParameterTypes().length != 1 || !expectedType.isAssignableFrom(Primitives.wrap(m.getParameterTypes()[0]))) continue;
            return m;
        }
        return null;
    }

    private void set(MessageLiteOrBuilder builder, Object value, Method setter) {
        Class<?> actualFieldType = setter.getParameterTypes()[0];
        try {
            if (value != null && !actualFieldType.isAssignableFrom(value.getClass()) && value instanceof MessageLite) {
                Class<?> actualMessageType = actualFieldType;
                value = this.convert(actualMessageType, (MessageLite)value);
            }
            setter.invoke((Object)builder, value);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    private static final LoadingCache<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>> createBuilderFactories(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(MessageReflectorInstance.createBuilderFactoriesCacheLoader());
        }
        return CacheBuilder.from(spec).build(MessageReflectorInstance.createBuilderFactoriesCacheLoader());
    }

    private static final CacheLoader<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>> createBuilderFactoriesCacheLoader() {
        return new CacheLoader<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>>(){

            @Override
            public Supplier<MessageLiteOrBuilder> load(Class<? extends MessageLite> type) throws Exception {
                final boolean isProto1 = MessageReflectorInstance.isProto1(type);
                final Method builder = isProto1 ? type.getMethod("getDefaultInstance", new Class[0]) : type.getMethod("newBuilder", new Class[0]);
                return new Supplier<MessageLiteOrBuilder>(this){

                    @Override
                    public MessageLiteOrBuilder get() {
                        try {
                            if (isProto1) {
                                return ((ProtocolMessage)builder.invoke(null, new Object[0])).clone();
                            }
                            return (MessageLite.Builder)builder.invoke(null, new Object[0]);
                        }
                        catch (Exception e) {
                            Throwables.throwIfUnchecked(e);
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    private static final LoadingCache<Class<? extends MessageOrBuilder>, Descriptors.Descriptor> createDescriptorCaches(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(MessageReflectorInstance.createDescriptorCachesCacheLoader());
        }
        return CacheBuilder.from(spec).build(MessageReflectorInstance.createDescriptorCachesCacheLoader());
    }

    private static final CacheLoader<Class<? extends MessageOrBuilder>, Descriptors.Descriptor> createDescriptorCachesCacheLoader() {
        return new CacheLoader<Class<? extends MessageOrBuilder>, Descriptors.Descriptor>(){

            @Override
            public Descriptors.Descriptor load(Class<? extends MessageOrBuilder> type) throws Exception {
                Method descriptor = type.getMethod("getDescriptor", new Class[0]);
                try {
                    return (Descriptors.Descriptor)descriptor.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked(e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static String underscoresToUpperCamel(String underscores, Class<?> type) {
        if (MessageReflectorInstance.isProto1(type)) {
            return MessageReflectorInstance.proto1UnderscoresToUpperCamel(underscores);
        }
        return MessageReflectorInstance.proto2UnderscoresToUpperCamel(underscores);
    }

    private static String proto2UnderscoresToUpperCamel(String underscores) {
        return JavaQualifiedNames.underscoresToCamelCase(underscores, true);
    }

    private static String proto1UnderscoresToUpperCamel(String underscores) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, underscores);
    }

    private static String proto1UnderscoresToLowerCamel(String underscores) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, underscores);
    }

    private static interface HasChecker {
        public boolean has(MessageLite var1);
    }

    private static interface Getter {
        public Object get(MessageLiteOrBuilder var1);
    }

    private static interface Counter {
        public int count(MessageLiteOrBuilder var1);
    }

    private static interface Adder {
        public boolean add(MessageLiteOrBuilder var1, Object var2);
    }

    private static interface RepeatedSetter {
        public boolean set(MessageLiteOrBuilder var1, int var2, Object var3);
    }

    private static interface Setter {
        public boolean set(MessageLiteOrBuilder var1, Object var2);
    }

    @AutoValue
    static abstract class FieldKey {
        FieldKey() {
        }

        public static FieldKey create(Class<?> messageType, Class<?> fieldType, String fieldName) {
            return new AutoValue_MessageReflectorInstance_FieldKey(messageType, Primitives.wrap(fieldType), fieldName);
        }

        abstract Class<?> messageType();

        abstract Class<?> fieldType();

        abstract String fieldName();
    }
}

