/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib;

import com.google.auto.value.AutoValue;
import com.google.common.math.IntMath;
import com.google.protobuf.ByteString;
import com.google.protobuf.contrib.AutoValue_Utf8ByteString;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

@AutoValue
public abstract class Utf8ByteString {
    private static final Utf8ByteString EMPTY = new AutoValue_Utf8ByteString(0, ByteString.EMPTY);

    Utf8ByteString() {
    }

    public static Utf8ByteString copyFrom(String text) {
        return text.isEmpty() ? EMPTY : new AutoValue_Utf8ByteString(text.length(), ByteString.copyFromUtf8(text));
    }

    public static Utf8ByteString emptyString() {
        return EMPTY;
    }

    public abstract int length();

    public abstract ByteString bytes();

    public Utf8ByteString concat(Utf8ByteString other) {
        return new AutoValue_Utf8ByteString(IntMath.checkedAdd(this.length(), other.length()), this.bytes().concat(other.bytes()));
    }

    public static Writer newWriter() {
        return new Writer(ByteString.newOutput());
    }

    public static Writer newWriter(int initialCapacity) {
        return new Writer(ByteString.newOutput(initialCapacity));
    }

    public void writeTo(OutputStream out) throws IOException {
        this.bytes().writeTo(out);
    }

    public String toString() {
        return this.bytes().toStringUtf8();
    }

    public static class Writer
    extends FilterWriter {
        private final ByteString.Output out;
        private long length;

        private Writer(ByteString.Output out) {
            super(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            this.out = out;
        }

        public Utf8ByteString toUtf8String() {
            if (this.length == 0L) {
                return EMPTY;
            }
            int len = (int)this.length;
            if (this.length != (long)len) {
                throw new ArithmeticException("overflow");
            }
            try {
                this.flush();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return new AutoValue_Utf8ByteString(len, this.out.toByteString());
        }

        @Override
        public void write(char[] chars, int off, int len) throws IOException {
            super.write(chars, off, len);
            this.length += (long)len;
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
            ++this.length;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            this.length += (long)len;
        }

        public void reset() {
            try {
                this.flush();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.out.reset();
            this.length = 0L;
        }
    }
}

