/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.diff.DiffDetails;
import com.google.protobuf.contrib.diff.Difference;
import com.google.protobuf.contrib.diff.DifferenceReporter;
import com.google.protobuf.contrib.diff.ProtoDiffResult;
import com.google.protobuf.contrib.diff.ReportOptions;
import com.google.protobuf.contrib.diff.ReportType;

final class DetailRecorder<T extends Message>
implements DifferenceReporter<T> {
    private final Table<String, ReportType, DiffDetails.Builder> detailsTable;
    private final ReportOptions reportOptions;

    public DetailRecorder(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
        this.detailsTable = HashBasedTable.create();
    }

    ProtoDiffResult toProtoDiffResult() {
        ImmutableList.Builder detailsList = ImmutableList.builder();
        for (DiffDetails.Builder entry : this.detailsTable.values()) {
            detailsList.add((Object)entry.build());
        }
        return new ProtoDiffResult(detailsList.build());
    }

    @Override
    public final void report(Difference<T> difference) {
        DiffDetails.Builder builder = this.getOrCreate(difference.getIndexlessPath(), difference.getReportType());
        int newCount = builder.incrementAndGetCount();
        if (newCount < this.reportOptions.getNumDetailsPerIndexlessPath()) {
            boolean includeDiffContexts = this.reportOptions.includePayload(difference.getIndexlessPath());
            builder.addDetail(difference.toDetailProto(this.reportOptions, includeDiffContexts));
        }
    }

    private DiffDetails.Builder getOrCreate(String indexlessPath, ReportType reportType) {
        DiffDetails.Builder builder = this.detailsTable.get(indexlessPath, reportType);
        if (builder == null) {
            builder = DiffDetails.newBuilder(indexlessPath, reportType, 0);
            this.detailsTable.put(indexlessPath, reportType, builder);
        }
        return builder;
    }
}

