/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.labs.reflect.ValueType;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.contrib.diff.DiffDetail;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.protopath.FieldSpec;
import javax.annotation.CheckReturnValue;

@Immutable
public final class DiffDetails
extends ValueType {
    private final String indexlessPath;
    private final ReportType reportType;
    private final int count;
    private final ImmutableList<DiffDetail> diffDetails;

    private DiffDetails(String indexlessPath, ReportType reportType, ImmutableList<DiffDetail> diffDetails, int totalCount) {
        this.indexlessPath = indexlessPath;
        this.reportType = reportType;
        this.count = totalCount;
        this.diffDetails = diffDetails;
    }

    public int getCount() {
        return this.count;
    }

    public String getIndexlessPath() {
        return this.indexlessPath;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public ImmutableList<DiffDetail> getDiffDetailList() {
        return this.diffDetails;
    }

    @CheckReturnValue
    public DiffDetails replaceReportType(ReportType newReportType) {
        if (this.reportType == newReportType) {
            return this;
        }
        ImmutableList.Builder newDetails = ImmutableList.builder();
        for (DiffDetail detail : this.diffDetails) {
            newDetails.add(detail.toBuilder().setReportType(newReportType).build());
        }
        return new DiffDetails(this.indexlessPath, newReportType, (ImmutableList<DiffDetail>)newDetails.build(), this.count);
    }

    public String getDiffString() {
        StringBuilder resultString = new StringBuilder();
        for (DiffDetail detail : this.diffDetails) {
            resultString.append(this.generateDiffString(detail));
        }
        return resultString.toString();
    }

    private String generateDiffString(DiffDetail diffDetail) {
        ReportType reportType = diffDetail.getReportType();
        String firstPath = diffDetail.getFirstPath();
        String secondPath = diffDetail.getSecondPath();
        String firstValue = diffDetail.getFirstValue().getHumanReadable();
        String secondValue = diffDetail.getSecondValue().getHumanReadable();
        StringBuilder buf = new StringBuilder(firstPath.length() + secondPath.length() + firstValue.length() + secondValue.length() + 10);
        buf.append(reportType.name().toLowerCase()).append(": ");
        switch (reportType) {
            case ADDED: {
                buf.append(secondPath).append(": ").append(secondValue);
                break;
            }
            case DELETED: {
                buf.append(firstPath).append(": ").append(firstValue);
                break;
            }
            case IGNORED: {
                buf.append(firstPath);
                break;
            }
            case MOVED: {
                buf.append(firstPath).append(" -> ").append(secondPath).append(": ");
                buf.append(firstValue);
                break;
            }
            case MODIFIED: {
                buf.append(firstPath);
                if (!secondPath.equals(firstPath)) {
                    buf.append(" -> ").append(secondPath);
                }
                buf.append(": ").append(firstValue).append(" -> ").append(secondValue);
                break;
            }
            case MATCHED: {
                buf.append(firstPath);
                if (!secondPath.equals(firstPath)) {
                    buf.append(" -> ").append(secondPath);
                }
                buf.append(" : ").append(firstValue);
                break;
            }
            case SKIPPED: 
            case TRANSIENT: {
                if (!firstPath.isEmpty()) {
                    buf.append(firstPath);
                    if (!secondPath.equals(firstPath)) {
                        buf.append(" -> ").append(secondPath);
                    }
                } else {
                    buf.append(" -> ").append(secondPath);
                }
                buf.append(": ").append(firstValue).append(" -> ").append(secondValue);
                break;
            }
        }
        buf.append('\n');
        return buf.toString();
    }

    public static Builder newBuilder(String fieldPath, ReportType reportType) {
        return new Builder(fieldPath, reportType);
    }

    public static Builder newBuilder(String fieldPath, ReportType reportType, int initialCount) {
        Builder builder = DiffDetails.newBuilder(fieldPath, reportType);
        builder.setCount(initialCount);
        return builder;
    }

    public static class Builder
    extends ValueType {
        private int count;
        private ImmutableList.Builder<DiffDetail> diffDetailList;
        private final String indexlessPath;
        private final ReportType reportType;

        private Builder(String indexlessPath, ReportType reportType) {
            this.indexlessPath = indexlessPath;
            this.reportType = reportType;
            this.count = 0;
            this.diffDetailList = ImmutableList.builder();
        }

        private void setCount(int count) {
            this.count = count;
        }

        public Builder addDetail(DiffDetail diffDetail) {
            Preconditions.checkArgument(diffDetail.getReportType() == this.reportType);
            Preconditions.checkArgument(diffDetail.hasFirstPath() || diffDetail.hasSecondPath());
            if (diffDetail.hasFirstPath()) {
                this.checkPath(diffDetail.getFirstPath());
            }
            if (diffDetail.hasSecondPath()) {
                this.checkPath(diffDetail.getSecondPath());
            }
            this.diffDetailList.add((Object)diffDetail);
            return this;
        }

        public int incrementAndGetCount() {
            ++this.count;
            return this.count;
        }

        public DiffDetails build() {
            return new DiffDetails(this.indexlessPath, this.reportType, (ImmutableList)this.diffDetailList.build(), this.count);
        }

        private void checkPath(String pathString) {
            Preconditions.checkArgument(FieldSpec.dropIndicesInFieldPath(pathString).equals(this.indexlessPath));
        }
    }
}

