/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.DoubleMath;
import com.google.protobuf.Descriptors;
import com.google.protobuf.contrib.diff.FieldValueComparator;
import com.google.protobuf.contrib.diff.NumberComparison;

final class FieldValueComparators {
    private static final ImmutableMap<Descriptors.FieldDescriptor.JavaType, Double> TOLERANCE = ImmutableMap.of(Descriptors.FieldDescriptor.JavaType.INT, 0.4, Descriptors.FieldDescriptor.JavaType.LONG, 0.4, Descriptors.FieldDescriptor.JavaType.FLOAT, 3.2E-4, Descriptors.FieldDescriptor.JavaType.DOUBLE, 3.2E-8);

    private FieldValueComparators() {
    }

    static FieldValueComparator<Number> newNumericComparator(Descriptors.FieldDescriptor fieldDescriptor, NumberComparison numberComparison) {
        Double tolerance = TOLERANCE.get((Object)fieldDescriptor.getJavaType());
        if (tolerance == null) {
            String string = String.valueOf((Object)fieldDescriptor.getJavaType());
            throw new IllegalArgumentException(new StringBuilder(43 + String.valueOf(string).length()).append("Cannot apply numeric comparator to a ").append(string).append(" field").toString());
        }
        if (!numberComparison.hasMaximumDiff() || numberComparison.getMaximumDiff() < 0.0) {
            String string = String.valueOf(numberComparison);
            throw new IllegalArgumentException(new StringBuilder(62 + String.valueOf(string).length()).append("maxmimum_diff must be specified and non-negative. bounds. Got ").append(string).toString());
        }
        return new NumericValueComparator(tolerance, numberComparison.getMaximumDiff());
    }

    private static final class NumericValueComparator
    implements FieldValueComparator<Number> {
        private final double maximumDiff;
        private final double tolerance;

        private NumericValueComparator(double tolerance, double maximumDiff) {
            this.tolerance = tolerance;
            this.maximumDiff = maximumDiff;
        }

        @Override
        public FieldValueComparator.ComparisonResult compare(Number first, Number second, Descriptors.FieldDescriptor fieldDescriptor) {
            double difference = Math.abs(second.doubleValue() - first.doubleValue());
            if (DoubleMath.fuzzyCompare(difference, this.maximumDiff, this.tolerance) <= 0) {
                return FieldValueComparator.ComparisonResult.SAME;
            }
            return FieldValueComparator.ComparisonResult.DIFFERENT;
        }
    }
}

