/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.ContextGenerator;
import com.google.protobuf.contrib.diff.Difference;
import com.google.protobuf.contrib.diff.DifferenceProcessor;
import com.google.protobuf.contrib.diff.DifferenceReporter;
import com.google.protobuf.contrib.diff.DiffingContext;
import com.google.protobuf.contrib.diff.ProcessorResult;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.diff.ReportTypeOverrides;

final class FilteringReporter<T extends Message>
implements MessageDifferencer.Reporter {
    private final T firstMessage;
    private final T secondMessage;
    private final ImmutableList<DifferenceProcessor<T>> differenceProcessors;
    private final ImmutableList<DifferenceReporter<T>> delegateReporters;
    private final ReportTypeOverrides reportTypeOverrides;
    private final ContextGenerator contextGenerator;
    private final ImmutableSet<ReportType> ignoredReportTypes;
    private final DiffingContext diffingContext;

    FilteringReporter(ImmutableSet<ReportType> ignoredReportTypes, Iterable<DifferenceProcessor<T>> differenceProcessors, T firstMessage, T secondMessage, Iterable<DifferenceReporter<T>> delegates, ReportTypeOverrides reportTypeOverrides, ContextGenerator contextGenerator, DiffingContext diffingContext) {
        this.ignoredReportTypes = ignoredReportTypes;
        this.firstMessage = firstMessage;
        this.secondMessage = secondMessage;
        this.reportTypeOverrides = reportTypeOverrides;
        this.contextGenerator = contextGenerator;
        this.differenceProcessors = ImmutableList.copyOf(differenceProcessors);
        this.delegateReporters = ImmutableList.copyOf(delegates);
        this.diffingContext = diffingContext;
    }

    @Override
    public void report(MessageDifferencer.ReportType type, Message firstValueContainer, Message secondValueContainer, ImmutableList<MessageDifferencer.SpecificField> fieldPath) {
        Difference<T> difference = this.newDifference(type, firstValueContainer, secondValueContainer, fieldPath);
        ReportType effectiveReportType = this.processAndGetEffectiveReportType(difference);
        if (effectiveReportType == null || this.ignoredReportTypes.contains(effectiveReportType)) {
            return;
        }
        for (DifferenceReporter differenceReporter : this.delegateReporters) {
            differenceReporter.report(difference.replaceReportType(effectiveReportType));
        }
    }

    private Difference<T> newDifference(MessageDifferencer.ReportType msgDifferencerReportType, Message firstValueContainer, Message secondValueContainer, ImmutableList<MessageDifferencer.SpecificField> fieldPath) {
        ReportType initialReportType = ReportType.valueOf(msgDifferencerReportType.name());
        Difference<T> difference = new Difference<T>(initialReportType, this.firstMessage, this.secondMessage, fieldPath, firstValueContainer, secondValueContainer, this.contextGenerator, this.diffingContext);
        ReportType overriddenReportType = this.reportTypeOverrides.getOverride(difference.getFirstPath());
        return overriddenReportType == null ? difference : difference.replaceReportType(overriddenReportType);
    }

    private ReportType processAndGetEffectiveReportType(Difference<T> difference) {
        DifferenceProcessor differenceProcessor;
        ProcessorResult processorResult = ProcessorResult.PUNT;
        Object object = this.differenceProcessors.iterator();
        while (object.hasNext() && (processorResult = (differenceProcessor = (DifferenceProcessor)object.next()).process(difference)) == ProcessorResult.PUNT) {
        }
        switch (processorResult) {
            case PUNT: {
                return difference.getReportType();
            }
            case DONT_REPORT: {
                return null;
            }
            case REPORT_AS_SKIPPED: {
                return ReportType.SKIPPED;
            }
            case REPORT_AS_TRANSIENT: {
                return ReportType.TRANSIENT;
            }
        }
        object = String.valueOf(processorResult);
        throw new AssertionError((Object)new StringBuilder(19 + String.valueOf(object).length()).append("Unsupported result ").append((String)object).toString());
    }
}

